/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.javafilesync.config;

import com.kdgcsoft.javafilesync.bean.FileSyncProperties;
import com.kdgcsoft.javafilesync.service.FileAlterationListenerRepository;
import com.kdgcsoft.javafilesync.service.FileAlterationObserverRepository;
import com.kdgcsoft.javafilesync.service.impl.JdbcFileAlterationListenerRepository;
import com.kdgcsoft.javafilesync.service.impl.JdbcFileAlterationObserverRepository;
import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="file.sync", name={"store-type"}, havingValue="jdbc")
@EnableConfigurationProperties(value={FileSyncProperties.class})
public class JdbcFileSyncRepositoryConfig {
    @Bean
    FileAlterationObserverRepository observerRepository(DataSource dataSource, FileSyncProperties fileSyncProperties) {
        return new JdbcFileAlterationObserverRepository(dataSource, fileSyncProperties.getServerId(), fileSyncProperties.getAesKey());
    }

    @Bean
    FileAlterationListenerRepository fileAlterationListenerRepository(DataSource dataSource, FileAlterationObserverRepository observerRepository, FileSyncProperties fileSyncProperties) {
        JdbcFileAlterationListenerRepository listenerRepository = new JdbcFileAlterationListenerRepository(dataSource, fileSyncProperties.getServerId(), fileSyncProperties.getAesKey());
        listenerRepository.setObserverRepository(observerRepository);
        return listenerRepository;
    }
}

