/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.javafilesync.config;

import com.kdgcsoft.javafilesync.service.FileAlterationListenerRepository;
import com.kdgcsoft.javafilesync.service.FileAlterationMonitorService;
import com.kdgcsoft.javafilesync.service.FileAlterationObserverRepository;
import com.kdgcsoft.javafilesync.service.impl.FileAlterationMonitorServiceImpl;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.util.StringUtils;

@Configuration
@DependsOn(value={"observerRepository", "fileAlterationListenerRepository"})
public class JavaFileSyncConfig {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Bean
    FileAlterationMonitorService fileAlterationMonitorService(FileAlterationObserverRepository observerRepository, FileAlterationListenerRepository fileAlterationListenerRepository) {
        FileAlterationMonitorServiceImpl fileAlterationMonitorService = new FileAlterationMonitorServiceImpl();
        fileAlterationMonitorService.setFileAlterationObserverRepository(observerRepository);
        fileAlterationMonitorService.setListenerRepository(fileAlterationListenerRepository);
        Map<String, FileAlterationObserver> allObserver = observerRepository.getAllObserver();
        for (Map.Entry<String, FileAlterationObserver> observerEntry : allObserver.entrySet()) {
            Map<String, FileAlterationListener> allListener = fileAlterationListenerRepository.getAllListener(observerEntry.getKey());
            for (Map.Entry<String, FileAlterationListener> listenerEntry : allListener.entrySet()) {
                observerEntry.getValue().addListener(listenerEntry.getValue());
            }
        }
        for (Map.Entry<String, FileAlterationObserver> observerEntry : allObserver.entrySet()) {
            fileAlterationMonitorService.getMonitor().addObserver(observerEntry.getValue());
        }
        String collect = allObserver.values().stream().map(s -> s.getDirectory().getAbsolutePath()).collect(Collectors.joining(","));
        if (StringUtils.hasText((String)collect)) {
            this.logger.info("\u672c\u673a\u76d1\u63a7\u670d\u52a1\u5df2\u7ecf\u5f00\u542f\uff0c\u76d1\u63a7\u4ee5\u4e0b\u76ee\u5f55\u3010{}\u3011\u3002", (Object)collect);
        } else {
            this.logger.info("\u672c\u673a\u76d1\u63a7\u670d\u52a1\u5df2\u7ecf\u5f00\u542f\uff0c\u6682\u65f6\u6ca1\u6709\u88ab\u76d1\u63a7\u7684\u76ee\u5f55\u3002");
        }
        return fileAlterationMonitorService;
    }
}

