/*==============================================================*/
/* Table: jimu_dict                                             */
/*==============================================================*/
create table if not exists jimu_dict (
    id                   varchar(64)          not null,
    dict_name            varchar(128)         null,
    dict_code            varchar(128)         null,
    type                 int4                 null,
    description          varchar(256)         null,
    del_flag             int2                 null,
    tenant_id            varchar(16)          null,
    create_by            varchar(32)          null,
    create_time          timestamp            null,
    update_by            varchar(32)          null,
    update_time          timestamp            null,
    constraint jimu_dict_pk primary key (id)
    );

comment on table jimu_dict is
'积木-数据字典';

comment on column jimu_dict.id is
'主键id';

comment on column jimu_dict.dict_name is
'字典名称';

comment on column jimu_dict.dict_code is
'字典编码';

comment on column jimu_dict.type is
'字典类型';

comment on column jimu_dict.description is
'描述';

comment on column jimu_dict.del_flag is
'删除状态';

comment on column jimu_dict.tenant_id is
'多租户标识';

comment on column jimu_dict.create_by is
'创建人';

comment on column jimu_dict.create_time is
'创建时间';

comment on column jimu_dict.update_by is
'更新人';

comment on column jimu_dict.update_time is
'更新时间';

/*==============================================================*/
/* Index: idx_sdi_dict_code                                     */
/*==============================================================*/
create index if not exists idx_sdi_dict_code on jimu_dict using btree (
    dict_code
    );

/*==============================================================*/
/* Table: jimu_dict_item                                        */
/*==============================================================*/
create table if not exists jimu_dict_item (
    id                   varchar(64)          not null,
    dict_id              varchar(64)          null,
    item_text            varchar(128)         null,
    item_value           varchar(128)         null,
    description          varchar(256)         null,
    sort_order           int8                 null,
    status               int2                 null,
    create_by            varchar(32)          null,
    create_time          timestamp            null,
    update_by            varchar(32)          null,
    update_time          timestamp            null,
    constraint jimu_dict_item_pk primary key (id)
    );

comment on table jimu_dict_item is
'积木-数据字典项';

comment on column jimu_dict_item.id is
'主键id';

comment on column jimu_dict_item.dict_id is
'字典id';

comment on column jimu_dict_item.item_text is
'字典项文本';

comment on column jimu_dict_item.item_value is
'字典项值';

comment on column jimu_dict_item.description is
'描述';

comment on column jimu_dict_item.sort_order is
'排序';

comment on column jimu_dict_item.status is
'状态';

comment on column jimu_dict_item.create_by is
'创建人';

comment on column jimu_dict_item.create_time is
'创建时间';

comment on column jimu_dict_item.update_by is
'更新人';

comment on column jimu_dict_item.update_time is
'更新时间';

/*==============================================================*/
/* Index: idx_sdi_dict_val                                      */
/*==============================================================*/
create  index if not exists idx_sdi_dict_val on jimu_dict_item using btree (
    dict_id,
    item_value
    );

/*==============================================================*/
/* Index: idx_sdi_role_dict_id                                  */
/*==============================================================*/
create  index if not exists idx_sdi_role_dict_id on jimu_dict_item using btree (
    dict_id
    );

/*==============================================================*/
/* Index: idx_sdi_role_sort_order                               */
/*==============================================================*/
create  index if not exists idx_sdi_role_sort_order on jimu_dict_item using btree (
    sort_order
    );

/*==============================================================*/
/* Index: idx_sdi_status                                        */
/*==============================================================*/
create  index if not exists idx_sdi_status on jimu_dict_item using btree (
    status
    );

/*==============================================================*/
/* Table: jimu_report                                           */
/*==============================================================*/
create table if not exists jimu_report (
    id                   varchar(64)          not null,
    code                 varchar(64)          null,
    name                 varchar(64)          null,
    note                 varchar(256)         null,
    status               varchar(16)          null,
    type                 varchar(16)          null,
    json_str             text                 null,
    api_url              varchar(256)         null,
    api_method           varchar(16)          null,
    api_code             varchar(256)         null,
    thumb                text                 null,
    template             int2                 null,
    css_str              text                 null,
    js_str               text                 null,
    view_count           int8                 null,
    del_flag             int2                 null,
    tenant_id            varchar(16)          null,
    create_by            varchar(32)          null,
    create_time          timestamp            null,
    update_by            varchar(32)          null,
    update_time          timestamp            null,
    constraint jimu_report_pk primary key (id)
    );

comment on table jimu_report is
'积木-excel设计器';

comment on column jimu_report.id is
'主键';

comment on column jimu_report.code is
'编码';

comment on column jimu_report.name is
'名称';

comment on column jimu_report.note is
'说明';

comment on column jimu_report.status is
'状态';

comment on column jimu_report.type is
'类型';

comment on column jimu_report.json_str is
'json字符串';

comment on column jimu_report.api_url is
'请求地址';

comment on column jimu_report.api_method is
'请求方法';

comment on column jimu_report.api_code is
'请求编码';

comment on column jimu_report.thumb is
'缩略图';

comment on column jimu_report.template is
'是否是模板';

comment on column jimu_report.css_str is
'css增强';

comment on column jimu_report.js_str is
'js增强';

comment on column jimu_report.view_count is
'浏览次数';

comment on column jimu_report.del_flag is
'删除状态';

comment on column jimu_report.tenant_id is
'多租户标识';

comment on column jimu_report.create_by is
'创建人';

comment on column jimu_report.create_time is
'创建时间';

comment on column jimu_report.update_by is
'修改人';

comment on column jimu_report.update_time is
'修改时间';

/*==============================================================*/
/* Index: uniq_jmreport_code                                    */
/*==============================================================*/
create  index if not exists uniq_jmreport_code on jimu_report using btree (
    code
    );

/*==============================================================*/
/* Index: uniq_jmreport_createby                                */
/*==============================================================*/
create  index if not exists uniq_jmreport_createby on jimu_report using btree (
    create_by
    );

/*==============================================================*/
/* Index: uniq_jmreport_delflag                                 */
/*==============================================================*/
create  index if not exists uniq_jmreport_delflag on jimu_report using btree (
    del_flag
    );

/*==============================================================*/
/* Table: jimu_report_data_source                               */
/*==============================================================*/
create table if not exists jimu_report_data_source (
    id                   varchar(64)          not null,
    report_id            varchar(100)         null,
    code                 varchar(100)         null,
    name                 varchar(100)         null,
    db_type              varchar(10)          null,
    db_driver            varchar(100)         null,
    db_url               varchar(500)         null,
    db_username          varchar(100)         null,
    db_password          varchar(100)         null,
    type                 varchar(10)          null,
    connect_times        int4                 null,
    remark               varchar(200)         null,
    tenant_id            varchar(16)          null,
    create_by            varchar(32)          null,
    create_time          timestamp            null,
    update_by            varchar(32)          null,
    update_time          timestamp            null,
    constraint jimu_report_data_source_pk primary key (id)
    );

comment on table jimu_report_data_source is
'积木-数据源';

comment on column jimu_report_data_source.id is
'主键id';

comment on column jimu_report_data_source.report_id is
'excel设计器id';

comment on column jimu_report_data_source.code is
'编码';

comment on column jimu_report_data_source.name is
'数据源名称';

comment on column jimu_report_data_source.db_type is
'数据库类型';

comment on column jimu_report_data_source.db_driver is
'驱动类';

comment on column jimu_report_data_source.db_url is
'数据源地址';

comment on column jimu_report_data_source.db_username is
'用户名';

comment on column jimu_report_data_source.db_password is
'密码';

comment on column jimu_report_data_source.type is
'类型';

comment on column jimu_report_data_source.connect_times is
'连接失败次数';

comment on column jimu_report_data_source.remark is
'备注';

comment on column jimu_report_data_source.tenant_id is
'多租户标识';

comment on column jimu_report_data_source.create_by is
'创建人';

comment on column jimu_report_data_source.create_time is
'创建时间';

comment on column jimu_report_data_source.update_by is
'更新人';

comment on column jimu_report_data_source.update_time is
'更新时间';

/*==============================================================*/
/* Index: idx_jmdatasource_code                                 */
/*==============================================================*/
create  index if not exists idx_jmdatasource_code on jimu_report_data_source using btree (
    code
    );

/*==============================================================*/
/* Index: idx_jmdatasource_report_id                            */
/*==============================================================*/
create  index if not exists idx_jmdatasource_report_id on jimu_report_data_source using btree (
    report_id
    );

/*==============================================================*/
/* Table: jimu_report_db                                        */
/*==============================================================*/
create table if not exists jimu_report_db (
    id                   varchar(64)          not null,
    jimu_report_id       varchar(64)          null,
    db_code              varchar(64)          null,
    db_ch_name           varchar(128)         null,
    db_type              varchar(32)          null,
    db_table_name        varchar(32)          null,
    db_dyn_sql           text                 null,
    db_key               varchar(32)          null,
    tb_db_key            varchar(32)          null,
    tb_db_table_name     varchar(32)          null,
    java_type            varchar(32)          null,
    java_value           varchar(256)         null,
    api_url              varchar(256)         null,
    api_method           varchar(16)          null,
    is_list              varchar(16)          null,
    is_page              varchar(16)          null,
    db_source            varchar(256)         null,
    db_source_type       varchar(64)          null,
    json_data            text                 null,
    api_convert          varchar(256)         null,
    create_by            varchar(32)          null,
    create_time          timestamp            null,
    update_by            varchar(32)          null,
    update_time          timestamp            null,
    constraint jimu_report_db_pk primary key (id)
    );

comment on table jimu_report_db is
'积木-db';

comment on column jimu_report_db.id is
'主键id';

comment on column jimu_report_db.jimu_report_id is
'主键字段';

comment on column jimu_report_db.db_code is
'数据集编码';

comment on column jimu_report_db.db_ch_name is
'数据集名字';

comment on column jimu_report_db.db_type is
'数据源类型';

comment on column jimu_report_db.db_table_name is
'数据库表名';

comment on column jimu_report_db.db_dyn_sql is
'动态查询sql';

comment on column jimu_report_db.db_key is
'数据源key';

comment on column jimu_report_db.tb_db_key is
'填报数据源';

comment on column jimu_report_db.tb_db_table_name is
'填报数据表';

comment on column jimu_report_db.java_type is
'java类数据集';

comment on column jimu_report_db.java_value is
'java类数据源';

comment on column jimu_report_db.api_url is
'请求地址';

comment on column jimu_report_db.api_method is
'请求方法';

comment on column jimu_report_db.is_list is
'是否是列表';

comment on column jimu_report_db.is_page is
'是否作为分页';

comment on column jimu_report_db.db_source is
'数据源';

comment on column jimu_report_db.db_source_type is
'数据库类型';

comment on column jimu_report_db.json_data is
'json数据';

comment on column jimu_report_db.api_convert is
'api转换器';

comment on column jimu_report_db.create_by is
'创建人';

comment on column jimu_report_db.create_time is
'创建时间';

comment on column jimu_report_db.update_by is
'修改人';

comment on column jimu_report_db.update_time is
'修改时间';

/*==============================================================*/
/* Index: idx_db_source_id                                      */
/*==============================================================*/
create  index if not exists idx_db_source_id on jimu_report_db using btree (
    db_source
    );

/*==============================================================*/
/* Index: idx_jimu_report_id                                    */
/*==============================================================*/
create  index if not exists idx_jimu_report_id on jimu_report_db using btree (
    jimu_report_id
    );

/*==============================================================*/
/* Index: idx_jmreportdb_db_key                                 */
/*==============================================================*/
create  index if not exists idx_jmreportdb_db_key on jimu_report_db using btree (
    db_key
    );

/*==============================================================*/
/* Table: jimu_report_db_field                                  */
/*==============================================================*/
create table if not exists jimu_report_db_field (
    id                   varchar(64)          not null,
    jimu_report_db_id    varchar(64)          null,
    field_name           varchar(128)         null,
    field_text           varchar(64)          null,
    widget_type          varchar(64)          null,
    widget_width         int4                 null,
    order_num            int4                 null,
    search_flag          int4                 null,
    search_mode          int4                 null,
    dict_code            varchar(256)         null,
    search_value         varchar(128)         null,
    search_format        varchar(64)          null,
    ext_json             text                 null,
    create_by            varchar(32)          null,
    create_time          timestamp            null,
    update_by            varchar(32)          null,
    update_time          timestamp            null,
    constraint jimu_report_db_field_pk primary key (id)
    );

comment on table jimu_report_db_field is
'积木-db字段';

comment on column jimu_report_db_field.id is
'主键id';

comment on column jimu_report_db_field.jimu_report_db_id is
'数据源id';

comment on column jimu_report_db_field.field_name is
'字段名';

comment on column jimu_report_db_field.field_text is
'字段文本';

comment on column jimu_report_db_field.widget_type is
'控件类型';

comment on column jimu_report_db_field.widget_width is
'控件宽度';

comment on column jimu_report_db_field.order_num is
'排序';

comment on column jimu_report_db_field.search_flag is
'查询标识';

comment on column jimu_report_db_field.search_mode is
'查询模式';

comment on column jimu_report_db_field.dict_code is
'字典编码支持从表中取数据';

comment on column jimu_report_db_field.search_value is
'查询默认值';

comment on column jimu_report_db_field.search_format is
'查询时间格式化表达式';

comment on column jimu_report_db_field.ext_json is
'参数配置';

comment on column jimu_report_db_field.create_by is
'创建人';

comment on column jimu_report_db_field.create_time is
'创建时间';

comment on column jimu_report_db_field.update_by is
'更新人';

comment on column jimu_report_db_field.update_time is
'更新时间';

/*==============================================================*/
/* Index: idx_dbfield_order_num                                 */
/*==============================================================*/
create  index if not exists idx_dbfield_order_num on jimu_report_db_field using btree (
    order_num
    );

/*==============================================================*/
/* Index: idx_jrdf_jimu_report_db_id                            */
/*==============================================================*/
create  index if not exists idx_jrdf_jimu_report_db_id on jimu_report_db_field using btree (
    jimu_report_db_id
    );

/*==============================================================*/
/* Table: jimu_report_db_param                                  */
/*==============================================================*/
create table if not exists jimu_report_db_param (
    id                   varchar(64)          not null,
    jimu_report_head_id  varchar(64)          not null,
    param_name           varchar(32)          not null,
    param_txt            varchar(32)          null,
    param_value          varchar(1024)        null,
    order_num            int4                 null,
    search_flag          int4                 null,
    widget_type          varchar(64)          null,
    search_mode          int4                 null,
    dict_code            varchar(256)         null,
    search_format        varchar(64)          null,
    ext_json             text                 null,
    create_by            varchar(32)          null,
    create_time          timestamp            null,
    update_by            varchar(32)          null,
    update_time          timestamp            null,
    constraint jimu_report_db_param_pk primary key (id)
    );

comment on table jimu_report_db_param is
'积木-db参数';

comment on column jimu_report_db_param.id is
'主键id';

comment on column jimu_report_db_param.jimu_report_head_id is
'动态报表id';

comment on column jimu_report_db_param.param_name is
'参数字段';

comment on column jimu_report_db_param.param_txt is
'参数文本';

comment on column jimu_report_db_param.param_value is
'参数默认值';

comment on column jimu_report_db_param.order_num is
'排序';

comment on column jimu_report_db_param.search_flag is
'查询标识';

comment on column jimu_report_db_param.widget_type is
'查询控件类型';

comment on column jimu_report_db_param.search_mode is
'查询模式';

comment on column jimu_report_db_param.dict_code is
'字典';

comment on column jimu_report_db_param.search_format is
'查询时间格式化表达式';

comment on column jimu_report_db_param.ext_json is
'参数配置';

comment on column jimu_report_db_param.create_by is
'创建人';

comment on column jimu_report_db_param.create_time is
'创建时间';

comment on column jimu_report_db_param.update_by is
'更新人';

comment on column jimu_report_db_param.update_time is
'更新时间';

/*==============================================================*/
/* Index: idx_jmrheadid                                         */
/*==============================================================*/
create  index if not exists idx_jmrheadid on jimu_report_db_param using btree (
    jimu_report_head_id
    );

/*==============================================================*/
/* Index: idx_jrdp_jimu_report_head_id                          */
/*==============================================================*/
create  index if not exists idx_jrdp_jimu_report_head_id on jimu_report_db_param using btree (
    jimu_report_head_id
    );

/*==============================================================*/
/* Table: jimu_report_link                                      */
/*==============================================================*/
create table if not exists jimu_report_link (
    id                   varchar(64)          not null,
    report_id            varchar(64)          null,
    parameter            text                 null,
    eject_type           varchar(16)          null,
    link_name            varchar(256)         null,
    api_method           varchar(16)          null,
    link_type            varchar(16)          null,
    api_url              varchar(1024)        null,
    link_chart_id        varchar(64)          null,
    expression           varchar(256)         null,
    requirement          varchar(256)         null,
    constraint jimu_report_link_pkey primary key (id)
    );

comment on table jimu_report_link is
'积木-超链接配置表';

comment on column jimu_report_link.id is
'主键id';

comment on column jimu_report_link.report_id is
'excel设计器id';

comment on column jimu_report_link.parameter is
'参数';

comment on column jimu_report_link.eject_type is
'弹出方式';

comment on column jimu_report_link.link_name is
'链接名称';

comment on column jimu_report_link.api_method is
'请求方法';

comment on column jimu_report_link.link_type is
'链接方式';

comment on column jimu_report_link.api_url is
'外网api';

comment on column jimu_report_link.link_chart_id is
'联动图表的id';

comment on column jimu_report_link.expression is
'表达式';

comment on column jimu_report_link.requirement is
'条件';

/*==============================================================*/
/* Index: uniq_link_reportid                                    */
/*==============================================================*/
create  index if not exists uniq_link_reportid on jimu_report_link using btree (
    report_id
    );

/*==============================================================*/
/* Table: jimu_report_map                                       */
/*==============================================================*/
create table if not exists jimu_report_map (
    id                   varchar(64)          not null,
    name                 varchar(128)         null,
    label                varchar(128)         null,
    data                 text                 null,
    sys_org_code         varchar(64)          null,
    del_flag             varchar(16)          null,
    create_by            varchar(32)          null,
    create_time          timestamp            null,
    update_by            varchar(32)          null,
    update_time          timestamp            null,
    constraint jimu_report_map_pk primary key (id)
    );

comment on table jimu_report_map is
'积木-地图配置表';

comment on column jimu_report_map.id is
'主键id';

comment on column jimu_report_map.name is
'地图编码';

comment on column jimu_report_map.label is
'地图名称';

comment on column jimu_report_map.data is
'地图数据';

comment on column jimu_report_map.sys_org_code is
'所属部门';

comment on column jimu_report_map.del_flag is
'删除状态';

comment on column jimu_report_map.create_by is
'创建人';

comment on column jimu_report_map.create_time is
'创建时间';

comment on column jimu_report_map.update_by is
'更新人';

comment on column jimu_report_map.update_time is
'更新时间';

/*==============================================================*/
/* Index: uniq_jmreport_map_name                                */
/*==============================================================*/
create  index if not exists uniq_jmreport_map_name on jimu_report_map using btree (
    name
    );

/*==============================================================*/
/* Table: jimu_report_share                                     */
/*==============================================================*/
create table if not exists jimu_report_share (
    id                   varchar(64)          not null,
    report_id            varchar(64)          null,
    preview_url          varchar(1024)        null,
    preview_lock         varchar(16)          null,
    last_update_time     timestamp            null,
    term_of_validity     varchar(16)          null,
    status               varchar(16)          null,
    constraint jimu_report_share_pk primary key (id)
    );

comment on table jimu_report_share is
'积木-报表预览权限表';

comment on column jimu_report_share.id is
'主键id';

comment on column jimu_report_share.report_id is
'excel设计器id';

comment on column jimu_report_share.preview_url is
'预览地址';

comment on column jimu_report_share.preview_lock is
'密码锁';

comment on column jimu_report_share.last_update_time is
'最后更新时间';

comment on column jimu_report_share.term_of_validity is
'有效期';

comment on column jimu_report_share.status is
'是否过期';