/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.iframe.web.report.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.druid.spring.boot.autoconfigure.DruidDataSourceWrapper;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.github.yulichang.base.MPJBaseServiceImpl;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import com.kdgcsoft.iframe.web.base.embed.dict.DicType;
import com.kdgcsoft.iframe.web.base.entity.BaseDict;
import com.kdgcsoft.iframe.web.base.entity.BaseDictItem;
import com.kdgcsoft.iframe.web.base.service.BaseModuleService;
import com.kdgcsoft.iframe.web.common.pojo.PageRequest;
import com.kdgcsoft.iframe.web.report.entity.DesReport;
import com.kdgcsoft.iframe.web.report.entity.JimuDict;
import com.kdgcsoft.iframe.web.report.entity.JimuDictItem;
import com.kdgcsoft.iframe.web.report.mapper.DesReportMapper;
import com.kdgcsoft.iframe.web.report.service.JimuDictItemService;
import com.kdgcsoft.iframe.web.report.service.JimuDictService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.jeecg.modules.jmreport.desreport.dao.JimuReportDao;
import org.jeecg.modules.jmreport.desreport.dao.JimuReportDataSourceDao;
import org.jeecg.modules.jmreport.desreport.entity.JimuReport;
import org.jeecg.modules.jmreport.desreport.entity.JmReportDataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class DesReportService
extends MPJBaseServiceImpl<DesReportMapper, DesReport> {
    @Autowired
    JimuReportDao jimuReportDao;
    @Autowired
    JimuReportDataSourceDao jimuReportDataSourceDao;
    @Autowired
    BaseModuleService baseModuleService;
    @Autowired
    DataSource dataSource;
    @Resource
    private JimuDictService jimuDictService;
    @Resource
    private JimuDictItemService jimuDictItemService;
    @Value(value="${spring.datasource.url}")
    private String dataSourceUrl;
    @Value(value="${spring.datasource.username}")
    private String dataSourceUserName;
    @Value(value="${spring.datasource.password}")
    private String dataSourcePassword;

    public PageRequest pageDesReport(PageRequest pageRequest, DesReport desReport, List<Long> childrenIds) {
        MPJLambdaWrapper wrapper = new MPJLambdaWrapper();
        wrapper.in(CollUtil.isNotEmpty(childrenIds), DesReport::getGroupId, childrenIds);
        wrapper.eq(desReport.getReportType() != null, DesReport::getReportType, (Object)desReport.getReportType());
        wrapper.like(StrUtil.isNotEmpty((CharSequence)desReport.getReportName()), DesReport::getReportName, (Object)desReport.getReportName());
        wrapper.orderByAsc(DesReport::getOrdNo);
        ((DesReportMapper)this.baseMapper).selectPage((IPage)pageRequest, (Wrapper)wrapper);
        return pageRequest;
    }

    public boolean hasRepeat(DesReport entity) {
        return false;
    }

    @CacheEvict(value={"jmreport:cache:dict", "jmreport:cache:dictTxt"}, allEntries=true)
    @Transactional
    public void syncDictToReport() {
        List dictList = this.baseModuleService.listBaseDic();
        List dictItemList = this.baseModuleService.listBaseDicItem();
        ArrayList<JimuDict> jimuDicts = new ArrayList<JimuDict>();
        ArrayList<String> jimuDictItemsDelete = new ArrayList<String>();
        ArrayList<JimuDictItem> jimuDictItems = new ArrayList<JimuDictItem>();
        for (BaseDict baseDict : dictList) {
            if (DicType.TREE.equals((Object)baseDict.getDictType())) continue;
            JimuDict jimuDict = (JimuDict)this.jimuDictService.getById((Serializable)((Object)baseDict.getDictId().toString()));
            if (jimuDict != null) {
                if (!StrUtil.equals((CharSequence)(baseDict.getDictCode() + baseDict.getDictName() + baseDict.getRmk()), (CharSequence)(jimuDict.getDictCode() + jimuDict.getDictCode() + jimuDict.getDescription()))) {
                    jimuDict.setDictCode(baseDict.getDictCode());
                    jimuDict.setDictName(baseDict.getDictName());
                    jimuDict.setDescription(baseDict.getRmk());
                    jimuDicts.add(jimuDict);
                }
            } else {
                jimuDict = new JimuDict();
                jimuDict.setDictCode(baseDict.getDictCode());
                jimuDict.setDictName(baseDict.getDictName());
                jimuDict.setDescription(baseDict.getRmk());
                jimuDict.setId(baseDict.getDictId().toString());
                jimuDicts.add(jimuDict);
            }
            jimuDictItemsDelete.add(baseDict.getDictId().toString());
            List baseDictItems = dictItemList.stream().filter(baseDictItem -> baseDictItem.getDictId().equals(baseDict.getDictId())).collect(Collectors.toList());
            for (BaseDictItem dictItem : baseDictItems) {
                JimuDictItem jimuItem = new JimuDictItem();
                jimuItem.setId(dictItem.getDictItemId().toString());
                jimuItem.setDictId(baseDict.getDictId().toString());
                jimuItem.setItemText(dictItem.getText());
                jimuItem.setItemValue(dictItem.getValue());
                jimuItem.setDescription(dictItem.getRmk());
                jimuItem.setSortOrder(dictItem.getOrdNo());
                jimuItem.setStatus(1);
                jimuDictItems.add(jimuItem);
            }
        }
        this.jimuDictService.saveOrUpdateBatch(jimuDicts);
        MPJLambdaWrapper wrapper = (MPJLambdaWrapper)new MPJLambdaWrapper().in(CollUtil.isNotEmpty(jimuDictItemsDelete), JimuDictItem::getDictId, jimuDictItemsDelete);
        this.jimuDictItemService.remove((Wrapper)wrapper);
        this.jimuDictItemService.saveOrUpdateBatch(jimuDictItems);
    }

    private void updateJmReport(DesReport desReport) {
        Assert.notNull((Object)desReport, (String)"desReport\u5bf9\u8c61\u4e3a\u7a7a");
        Assert.notNull((Object)desReport.getReportId(), (String)"desReport\u5bf9\u8c61\u8fd8\u672a\u4fdd\u5b58,\u8bf7\u4fdd\u5b58\u540e\u518d\u8c03\u7528\u6b64\u65b9\u6cd5");
        JimuReport jimuReport = this.jimuReportDao.get(desReport.getReportId().toString());
        if (jimuReport != null) {
            jimuReport.setCode(desReport.getReportId().toString());
            jimuReport.setName(desReport.getReportName());
            jimuReport.setType(desReport.getReportType().getJmReportType());
            this.jimuReportDao.update(jimuReport);
        } else {
            this.createJmReport(desReport);
        }
    }

    private void createJmReport(DesReport desReport) {
        JimuReport jimuReport = new JimuReport();
        jimuReport.setId(desReport.getReportId().toString());
        jimuReport.setCode(desReport.getReportId().toString());
        jimuReport.setName(desReport.getReportName());
        jimuReport.setType(desReport.getReportType().getJmReportType());
        jimuReport.setDelFlag(Integer.valueOf(0));
        this.jimuReportDao.insert(jimuReport);
        this.createDefaultReportDataSource(desReport.getReportId().toString());
    }

    private JmReportDataSource createDefaultReportDataSource(String reportId) {
        JmReportDataSource existDs = this.jimuReportDataSourceDao.get("default");
        if (existDs != null) {
            return existDs;
        }
        DruidDataSourceWrapper druidDataSource = (DruidDataSourceWrapper)this.dataSource;
        String driverClass = druidDataSource.getDriverClassName();
        JmReportDataSource defaultDataSource = new JmReportDataSource();
        defaultDataSource.setCode("default");
        defaultDataSource.setName("\u9ed8\u8ba4\u6570\u636e\u6e90");
        defaultDataSource.setDbUrl(this.dataSourceUrl);
        defaultDataSource.setDbUsername(this.dataSourceUserName);
        defaultDataSource.setDbPassword(this.dataSourcePassword);
        defaultDataSource.setDbDriver(driverClass);
        defaultDataSource.setDbType(druidDataSource.getDbType());
        defaultDataSource.setType("report");
        defaultDataSource.setReportId(reportId);
        defaultDataSource.setId("default");
        this.jimuReportDataSourceDao.insert(defaultDataSource);
        return defaultDataSource;
    }

    public List<DesReport> getReportList() {
        MPJLambdaWrapper wrapper = new MPJLambdaWrapper();
        wrapper.select(new SFunction[]{DesReport::getReportId, DesReport::getReportName});
        wrapper.orderByAsc(DesReport::getOrdNo);
        return this.list((Wrapper)wrapper);
    }

    @Transactional
    public void saveOrUpdateDate(DesReport entity) {
        this.saveOrUpdate(entity);
        entity.setJimuReportId(String.valueOf(entity.getReportId()));
        this.saveOrUpdate(entity);
        this.updateJmReport(entity);
    }
}

