/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.iframe.web.report.service;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.github.yulichang.base.MPJBaseServiceImpl;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import com.kdgcsoft.iframe.web.common.exception.BizException;
import com.kdgcsoft.iframe.web.common.utils.TreeUtil;
import com.kdgcsoft.iframe.web.report.entity.DesReport;
import com.kdgcsoft.iframe.web.report.entity.DesReportGroup;
import com.kdgcsoft.iframe.web.report.mapper.DesReportGroupMapper;
import com.kdgcsoft.iframe.web.report.mapper.DesReportMapper;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class DesReportGroupService
extends MPJBaseServiceImpl<DesReportGroupMapper, DesReportGroup> {
    @Resource
    private DesReportMapper desReportMapper;
    public static final String CACHE_NAME = "DesReportGroup";

    public List<DesReportGroup> listAllByOrder() {
        MPJLambdaWrapper wrapper = new MPJLambdaWrapper();
        wrapper.orderByAsc(DesReportGroup::getOrdNo);
        return ((DesReportGroupMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }

    public List<DesReportGroup> tree() {
        return TreeUtil.buildTree(this.listAllByOrder());
    }

    public List<Long> getChildrenIds(Long groupId, boolean includeSelf) {
        List<DesReportGroup> tree = this.tree();
        return TreeUtil.getChildIds(tree, (Object)groupId, (boolean)includeSelf);
    }

    public boolean hasRepeat(DesReportGroup entity) {
        return false;
    }

    public int removeAllChildById(Long groupId) {
        DesReportGroup entity = (DesReportGroup)((DesReportGroupMapper)this.baseMapper).selectById(groupId);
        if (entity != null) {
            List<Long> ids = this.getChildrenIds(groupId, true);
            MPJLambdaWrapper wrapper = new MPJLambdaWrapper();
            wrapper.in(CollUtil.isNotEmpty(ids), DesReport::getGroupId, ids);
            Long count = this.desReportMapper.selectCount((Wrapper)wrapper);
            if (count > 0L) {
                throw new BizException("\u8bf7\u5148\u5220\u9664\u8be5\u5206\u7ec4\u4e0b\u7684\u62a5\u8868\uff0c\u518d\u5220\u9664\u5206\u7ec4\uff01");
            }
            return ((DesReportGroupMapper)this.baseMapper).deleteBatchIds(ids);
        }
        throw new BizException("\u62a5\u8868\u5206\u7ec4\u4e0d\u80fd\u4e3a\u7a7a\uff01");
    }
}

