/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.iframe.web.report.provider;

import cn.dev33.satoken.stp.StpUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.kdgcsoft.iframe.web.common.pojo.LoginUser;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.jeecg.modules.jmreport.api.JmReportTokenServiceI;
import org.springframework.stereotype.Component;

@Component
public class JimuReportTokenService
implements JmReportTokenServiceI {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    public String getToken(HttpServletRequest request) {
        String tokenName = StpUtil.getTokenInfo().tokenName;
        String token = request.getParameter(tokenName);
        if (StrUtil.isBlank((CharSequence)token) && StrUtil.isBlank((CharSequence)(token = request.getHeader(tokenName)))) {
            token = request.getHeader("X-Access-Token");
        }
        return token;
    }

    public String getUsername(String token) {
        LoginUser loginUser = this.getLoginUser(token);
        if (ObjectUtil.isNotNull((Object)loginUser)) {
            return loginUser.getUserName();
        }
        return "";
    }

    public String[] getRoles(String s) {
        return new String[0];
    }

    private LoginUser getLoginUser(String token) {
        Object o = StpUtil.getTokenSessionByToken((String)token).get("LOGIN_USER");
        if (ObjectUtil.isNotNull((Object)o)) {
            return (LoginUser)o;
        }
        return null;
    }

    public Boolean verifyToken(String token) {
        Object loginId = StpUtil.getLoginIdByToken((String)token);
        if (ObjectUtil.isNull((Object)loginId)) {
            return false;
        }
        return true;
    }

    public Map<String, Object> getUserInfo(String token) {
        HashMap<String, Object> map = new HashMap<String, Object>(20);
        LoginUser loginUser = this.getLoginUser(token);
        if (ObjectUtil.isNotNull((Object)loginUser)) {
            map.put("sysUserCode", loginUser.getUserName());
            map.put("sysUserName", loginUser.getNickName());
            map.put("deptId", loginUser.getDeptId());
            map.put("orgId", loginUser.getOrgId());
        }
        map.put("sysData", LocalDate.now().format(DATE_TIME_FORMATTER));
        map.put("sysYesterDay", LocalDate.now().plusDays(-1L).format(DATE_TIME_FORMATTER));
        return map;
    }
}

