/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.iframe.web.report.controller;

import com.kdgcsoft.iframe.web.common.anno.OptLog;
import com.kdgcsoft.iframe.web.common.embed.dict.OptType;
import com.kdgcsoft.iframe.web.common.pojo.JsonResult;
import com.kdgcsoft.iframe.web.common.pojo.PageRequest;
import com.kdgcsoft.iframe.web.report.entity.DesReport;
import com.kdgcsoft.iframe.web.report.service.DesReportGroupService;
import com.kdgcsoft.iframe.web.report.service.DesReportService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u62a5\u8868-\u62a5\u8868\u914d\u7f6e\u63a7\u5236\u5668"})
@RestController
@Validated
@RequestMapping(value={"/des/desReport"})
public class DesReportController {
    @Resource
    private DesReportService desReportService;
    @Resource
    private DesReportGroupService desReportGroupService;

    @ApiOperation(value="\u83b7\u53d6\u62a5\u8868-\u62a5\u8868\u914d\u7f6e\u5206\u9875")
    @GetMapping(value={"/page"})
    @OptLog(type=OptType.SELECT, title="\u5206\u9875\u83b7\u53d6\u62a5\u8868-\u62a5\u8868\u914d\u7f6e")
    public JsonResult<PageRequest> page(PageRequest pageRequest, DesReport desReport) {
        List<Long> childrenIds = new ArrayList<Long>();
        if (desReport.getGroupId() != null) {
            childrenIds = this.desReportGroupService.getChildrenIds(desReport.getGroupId(), true);
        }
        this.desReportService.pageDesReport(pageRequest, desReport, childrenIds);
        return JsonResult.OK().data((Object)pageRequest);
    }

    @ApiOperation(value="\u83b7\u53d6\u62a5\u8868-\u62a5\u8868\u914d\u7f6e\u4fe1\u606f")
    @GetMapping(value={"/getById"})
    @OptLog(type=OptType.SELECT, title="\u83b7\u53d6\u62a5\u8868-\u62a5\u8868\u914d\u7f6e\u4fe1\u606f")
    public JsonResult<DesReport> getById(@ApiParam(value="\u62a5\u8868-\u62a5\u8868\u914d\u7f6ereportId", required=true) @NotNull(message="\u62a5\u8868-\u62a5\u8868\u914d\u7f6ereportId\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u62a5\u8868-\u62a5\u8868\u914d\u7f6ereportId\u4e0d\u80fd\u4e3a\u7a7a") Long reportId) {
        DesReport entity = (DesReport)this.desReportService.getById(reportId);
        return JsonResult.OK().data((Object)entity);
    }

    @ApiOperation(value="\u4fdd\u5b58")
    @PostMapping(value={"/save"})
    @OptLog(type=OptType.SAVE, title="\u4fdd\u5b58\u62a5\u8868-\u62a5\u8868\u914d\u7f6e\u4fe1\u606f")
    public JsonResult<DesReport> save(@Validated @RequestBody DesReport entity) {
        if (this.desReportService.hasRepeat(entity)) {
            return JsonResult.ERROR((String)"\u62a5\u8868-\u62a5\u8868\u914d\u7f6e\u91cd\u590d");
        }
        this.desReportService.saveOrUpdateDate(entity);
        return JsonResult.OK((String)"\u4fdd\u5b58\u6210\u529f").data((Object)entity);
    }

    @ApiOperation(value="\u6839\u636ereportId\u5220\u9664\u62a5\u8868-\u62a5\u8868\u914d\u7f6e")
    @GetMapping(value={"/deleteById"})
    @OptLog(type=OptType.DELETE, title="\u6839\u636ereportId\u5220\u9664\u62a5\u8868-\u62a5\u8868\u914d\u7f6e")
    public JsonResult deleteById(@ApiParam(value="\u62a5\u8868-\u62a5\u8868\u914d\u7f6ereportId", required=true) @NotNull(message="\u62a5\u8868-\u62a5\u8868\u914d\u7f6ereportId\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u62a5\u8868-\u62a5\u8868\u914d\u7f6ereportId\u4e0d\u80fd\u4e3a\u7a7a") Long reportId) {
        this.desReportService.removeById(reportId);
        return JsonResult.OK();
    }

    @ApiOperation(value="\u540c\u6b65\u7cfb\u7edf\u5b57\u5178\u6570\u636e\u5230\u62a5\u8868\u5b57\u5178\u6570\u636e")
    @GetMapping(value={"syncDict"})
    @OptLog(type=OptType.SYNC, title="\u540c\u6b65\u7cfb\u7edf\u5b57\u5178\u6570\u636e\u5230\u62a5\u8868\u5b57\u5178\u6570\u636e")
    public JsonResult syncDict() {
        this.desReportService.syncDictToReport();
        return JsonResult.OK();
    }

    @ApiOperation(value="\u83b7\u53d6\u62a5\u8868\u5217\u8868(\u4e0d\u5206\u9875)")
    @GetMapping(value={"/getReportList"})
    @OptLog(type=OptType.SELECT, title="\u83b7\u53d6\u62a5\u8868\u5217\u8868(\u4e0d\u5206\u9875)")
    public JsonResult<List<DesReport>> getReportList() {
        return JsonResult.OK().data(this.desReportService.getReportList());
    }
}

