/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.iframe.web.report.service;

import cn.dev33.satoken.stp.StpUtil;
import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bstek.ureport.provider.report.classpath.ClasspathReportProvider;
import com.github.yulichang.base.MPJBaseServiceImpl;
import com.kdgcsoft.iframe.web.common.pojo.PageRequest;
import com.kdgcsoft.iframe.web.report.entity.DesUreportXml;
import com.kdgcsoft.iframe.web.report.mapper.DesUreportXmlMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DesUreportXmlService
extends MPJBaseServiceImpl<DesUreportXmlMapper, DesUreportXml> {
    private static final Logger log = LoggerFactory.getLogger(DesUreportXmlService.class);
    @Autowired
    private ClasspathReportProvider classpathReportProvider;
    @Value(value="${server.port:8080}")
    private String port;

    public void removeByUreportXmlId(Long id) {
        ((DesUreportXmlMapper)this.baseMapper).deleteById(id);
    }

    public void saveUreportXml(DesUreportXml ureport) {
        ureport.setXmlCode(ureport.getXmlName() + ".ureport.xml");
        if (null == ureport.getXmlId()) {
            try (InputStream inputStream = this.classpathReportProvider.loadReport("classpath:template/template.ureport.xml");
                 ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                int num;
                byte[] buffer = new byte[1024];
                while ((num = inputStream.read(buffer)) != -1) {
                    byteArrayOutputStream.write(buffer, 0, num);
                }
                byteArrayOutputStream.flush();
                ureport.setXmlContent(byteArrayOutputStream.toString());
            }
            catch (IOException e) {
                log.error("\u8bfb\u53d6\u62a5\u8868\u9ed8\u8ba4\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            }
            ((DesUreportXmlMapper)this.baseMapper).insert(ureport);
        } else {
            ((DesUreportXmlMapper)this.baseMapper).updateById(ureport);
        }
    }

    public DesUreportXml findDesUreportXmlByName(String xmlName) {
        return (DesUreportXml)((DesUreportXmlMapper)this.baseMapper).selectOne((Wrapper)new QueryWrapper().lambda().eq(DesUreportXml::getXmlName, (Object)xmlName));
    }

    public PageRequest pageUreportXml(PageRequest pageRequest, String search, List<String> dictItemIds) {
        LambdaQueryWrapper desUreportXmlLambdaQueryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().select(new SFunction[]{DesUreportXml::getXmlId, DesUreportXml::getXmlCode, DesUreportXml::getXmlName, DesUreportXml::getModelGroup, DesUreportXml::getOrdNo, DesUreportXml::getRmk}).like(search != null, DesUreportXml::getXmlName, (Object)search)).in(!dictItemIds.isEmpty(), DesUreportXml::getModelGroup, dictItemIds)).orderByAsc(DesUreportXml::getOrdNo);
        ((DesUreportXmlMapper)this.baseMapper).selectPage((IPage)pageRequest, (Wrapper)desUreportXmlLambdaQueryWrapper);
        List records = pageRequest.getRecords();
        InetAddress localHost = null;
        try {
            localHost = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        String token = StpUtil.getTokenValue();
        if (CollUtil.isNotEmpty((Collection)records)) {
            for (DesUreportXml record : records) {
                record.setDesignUrl("http://" + localHost.getHostAddress() + ":" + this.port + "/ureport/designer?_u=db:" + record.getXmlCode() + "&token=" + token);
                record.setPreviewUrl("http://" + localHost.getHostAddress() + ":" + this.port + "/ureport/preview?_u=db:" + record.getXmlCode() + "&token=" + token);
            }
        }
        return pageRequest;
    }

    public DesUreportXml selectReportByCode(String xmlCode) {
        return (DesUreportXml)((DesUreportXmlMapper)this.baseMapper).selectOne((Wrapper)new QueryWrapper().lambda().eq(DesUreportXml::getXmlCode, (Object)xmlCode));
    }
}

