/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.iframe.web.report.provider;

import com.bstek.ureport.provider.report.ReportFile;
import com.bstek.ureport.provider.report.ReportProvider;
import com.kdgcsoft.iframe.web.report.entity.DesUreportXml;
import com.kdgcsoft.iframe.web.report.service.DesUreportXmlService;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DbProvider
implements ReportProvider {
    private final String prefix = "db:";
    private boolean disabled;
    @Autowired
    private DesUreportXmlService desUreportXmlService;

    public InputStream loadReport(String file) {
        DesUreportXml desUreportXml = this.desUreportXmlService.selectReportByCode(this.getReportFileName(file));
        byte[] content = desUreportXml.getXmlContent().getBytes();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(content);
        return inputStream;
    }

    public void deleteReport(String file) {
        DesUreportXml desUreportXml = this.desUreportXmlService.selectReportByCode(this.getReportFileName(file));
        this.desUreportXmlService.removeById(desUreportXml);
    }

    public List<ReportFile> getReportFiles() {
        List list = this.desUreportXmlService.list();
        ArrayList<ReportFile> reportList = new ArrayList<ReportFile>();
        for (DesUreportXml desUreportXml : list) {
            reportList.add(new ReportFile(desUreportXml.getXmlCode(), desUreportXml.getCreateTime()));
        }
        return reportList;
    }

    public void saveReport(String file, String content) {
        DesUreportXml desUreportXml = this.desUreportXmlService.selectReportByCode(file = this.getReportFileName(file));
        if (Objects.isNull(desUreportXml)) {
            desUreportXml = new DesUreportXml();
            desUreportXml.setXmlCode(file);
            desUreportXml.setXmlContent(content);
            this.desUreportXmlService.save(desUreportXml);
        } else {
            desUreportXml.setXmlContent(content);
            this.desUreportXmlService.updateById(desUreportXml);
        }
    }

    public String getName() {
        return "\u6570\u636e\u5e93\u5b58\u50a8";
    }

    public boolean disabled() {
        return this.disabled;
    }

    public String getPrefix() {
        return "db:";
    }

    private String getReportFileName(String name) {
        if (name.startsWith("db:")) {
            name = name.substring("db:".length());
        }
        return name;
    }
}

