/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.iframe.web.report.filter;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UReportHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private static final Logger log = LoggerFactory.getLogger(UReportHttpServletRequestWrapper.class);
    public String body;
    private boolean isFile;

    public UReportHttpServletRequestWrapper(HttpServletRequest request) throws IOException {
        super(request);
        String uri = request.getRequestURI();
        if (!uri.contains("import")) {
            String line;
            StringBuilder sb = new StringBuilder();
            BufferedReader br = request.getReader();
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            this.body = sb.toString();
            this.isFile = false;
        } else {
            this.isFile = true;
        }
    }

    public String getParameter(String name) {
        String value = super.getParameter(name);
        if (null == value && StrUtil.isNotBlank((CharSequence)this.body)) {
            if (JSONUtil.isTypeJSONObject((String)this.body)) {
                JSONObject json = JSONObject.parseObject((String)this.body);
                value = json.getString(name);
            } else if (JSONUtil.isTypeJSONArray((String)this.body)) {
                JSONArray arr = JSONArray.parseArray((String)this.body, (JSONReader.Feature[])new JSONReader.Feature[0]);
                for (int i = 0; i < arr.size(); ++i) {
                    JSONObject obj = arr.getJSONObject(i);
                    if (!obj.containsKey(name)) continue;
                    value = obj.getString(name);
                    break;
                }
            } else {
                String[] parts;
                for (String part : parts = this.body.split("&")) {
                    if (!part.startsWith(name + "=")) continue;
                    value = part.replace(name + "=", "");
                }
            }
        }
        if (StrUtil.isNotBlank((CharSequence)value)) {
            try {
                value = URLDecoder.decode(value, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return value;
    }

    public ServletInputStream getInputStream() {
        if (!this.isFile) {
            final ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.body.getBytes());
            return new ServletInputStream(){

                public int read() {
                    return byteArrayInputStream.read();
                }

                public boolean isFinished() {
                    return false;
                }

                public boolean isReady() {
                    return false;
                }

                public void setReadListener(ReadListener listener) {
                }
            };
        }
        try {
            return super.getInputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public BufferedReader getReader() {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }
}

