/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.iframe.web.report.controller;

import cn.hutool.core.util.StrUtil;
import com.kdgcsoft.iframe.web.base.entity.BaseDict;
import com.kdgcsoft.iframe.web.base.service.BaseDictService;
import com.kdgcsoft.iframe.web.common.anno.OptLog;
import com.kdgcsoft.iframe.web.common.embed.dict.OptType;
import com.kdgcsoft.iframe.web.common.pojo.JsonResult;
import com.kdgcsoft.iframe.web.common.pojo.PageRequest;
import com.kdgcsoft.iframe.web.report.entity.DesUreportXml;
import com.kdgcsoft.iframe.web.report.service.DesUreportXmlService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u62a5\u8868\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/report"})
public class ReportController {
    private static final Logger log = LoggerFactory.getLogger(ReportController.class);
    @Autowired
    DesUreportXmlService desUreportXmlService;
    @Autowired
    BaseDictService baseDictService;

    @ApiOperation(value="\u6839\u636eID\u5220\u9664\u62a5\u8868")
    @GetMapping(value={"/deleteById"})
    @OptLog(type=OptType.DELETE, title="\u6839\u636eID\u5220\u9664\u62a5\u8868")
    public JsonResult deleteById(@ApiParam(value="\u62a5\u8868ID", required=true) @NotNull(message="\u62a5\u8868ID\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u62a5\u8868ID\u4e0d\u80fd\u4e3a\u7a7a") Long xmlId) {
        this.desUreportXmlService.removeByUreportXmlId(xmlId);
        return JsonResult.OK((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u6dfb\u52a0\u62a5\u8868")
    @PostMapping(value={"/add"})
    @OptLog(type=OptType.SAVE, title="\u6dfb\u52a0\u62a5\u8868")
    public JsonResult<?> add(@RequestBody DesUreportXml desUreportXml) {
        try {
            this.desUreportXmlService.saveUreportXml(desUreportXml);
            return JsonResult.OK((String)"\u4fdd\u5b58\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return JsonResult.ERROR((String)("\u4fdd\u5b58\u62a5\u8868\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a" + e.getMessage()));
        }
    }

    @ApiOperation(value="\u5206\u9875\u83b7\u53d6\u62a5\u8868\u5217\u8868")
    @GetMapping(value={"/page"})
    @OptLog(type=OptType.SELECT, title="\u5206\u9875\u83b7\u53d6\u62a5\u8868\u5217\u8868")
    public JsonResult page(PageRequest pageRequest, @ApiParam(value="\u6a21\u7cca\u641c\u7d22") String search, @ApiParam(value="\u6a21\u578b\u5206\u7ec4id") String modelGroup) {
        BaseDict baseDict = this.baseDictService.getDictByCode("DesReportGroup");
        ArrayList<String> childrenValues = new ArrayList();
        if (StrUtil.isNotEmpty((CharSequence)modelGroup)) {
            childrenValues = baseDict.getChildrenValues(modelGroup, true);
        }
        return JsonResult.OK().data((Object)this.desUreportXmlService.pageUreportXml(pageRequest, search, childrenValues));
    }
}

