-- liquibase formatted sql
-- changeset fyin:iframe-web-designer-0.0.1
-- comment: iframe-web-designer初始化脚本


/*==============================================================*/
/* Table: des_biz_sn                                            */
/*==============================================================*/
create table if not exists des_biz_sn (
                                          biz_sn_id            int8                 not null,
                                          template_code        varchar(32)          null,
    template_name        varchar(128)         null,
    sn_rule              varchar(64)          null,
    sn_prefix            varchar(256)          null,
    sn_time_format       varchar(64)          null,
    sn_digit             int2                 null,
    deleted              int2                 null,
    create_by            int8                 null,
    create_time          timestamp            null,
    modify_by            int8                 null,
    modify_time          timestamp            null,
    constraint des_biz_sn_pk primary key (biz_sn_id)
    );

comment on table des_biz_sn is
'流水号模板表';

comment on column des_biz_sn.biz_sn_id is
'模版id';

comment on column des_biz_sn.template_code is
'模板编码';

comment on column des_biz_sn.template_name is
'模板名称';

comment on column des_biz_sn.sn_rule is
'流水号规则';

comment on column des_biz_sn.sn_prefix is
'流水号前缀';

comment on column des_biz_sn.sn_time_format is
'流水号时间格式';

comment on column des_biz_sn.sn_digit is
'流水位数';

comment on column des_biz_sn.deleted is
'是否删除';

comment on column des_biz_sn.create_by is
'创建人';

comment on column des_biz_sn.create_time is
'创建时间';

comment on column des_biz_sn.modify_by is
'修改人';

comment on column des_biz_sn.modify_time is
'修改时间';

/*==============================================================*/
/* Table: des_biz_sn_record                                     */
/*==============================================================*/
create table if not exists des_biz_sn_record (
                                                 biz_sn_record_id     int8                 not null,
                                                 biz_sn_id            int8                 null,
                                                 sn                   varchar(64)          null,
    deleted              int2                 null,
    create_by            int8                 null,
    create_time          timestamp            null,
    modify_by            int8                 null,
    modify_time          timestamp            null,
    constraint des_biz_sn_record_pk primary key (biz_sn_record_id)
    );

comment on table des_biz_sn_record is
'流水号记录表';

comment on column des_biz_sn_record.biz_sn_record_id is
'记录表id';

comment on column des_biz_sn_record.biz_sn_id is
'模版id';

comment on column des_biz_sn_record.sn is
'业务流水号';

comment on column des_biz_sn_record.deleted is
'是否删除';

comment on column des_biz_sn_record.create_by is
'创建人';

comment on column des_biz_sn_record.create_time is
'创建时间';

comment on column des_biz_sn_record.modify_by is
'修改人';

comment on column des_biz_sn_record.modify_time is
'修改时间';


/*==============================================================*/
/* Table: des_biz_sn_ref                                        */
/*==============================================================*/
create table if not exists des_biz_sn_ref (
                                              biz_sn_ref_id        int8                 not null,
                                              biz_sn_id            int8                 null,
                                              sn_time              varchar(16)          null,
    cur_sn               int4                 null,
    sn_prefix_value      varchar(64)          null,
    reset_info           text                 null,
    deleted              int2                 null,
    create_by            int8                 null,
    create_time          timestamp            null,
    modify_by            int8                 null,
    modify_time          timestamp            null,
    constraint des_biz_sn_ref_pk primary key (biz_sn_ref_id)
    );

comment on table des_biz_sn_ref is
'流水号参照表';

comment on column des_biz_sn_ref.biz_sn_ref_id is
'参照表id';

comment on column des_biz_sn_ref.biz_sn_id is
'模版id';

comment on column des_biz_sn_ref.sn_time is
'时间周期';

comment on column des_biz_sn_ref.cur_sn is
'当前流水号';

comment on column des_biz_sn_ref.sn_prefix_value is
'流水号前缀值';

comment on column des_biz_sn_ref.reset_info is
'重置信息';

comment on column des_biz_sn_ref.deleted is
'是否删除';

comment on column des_biz_sn_ref.create_by is
'创建人';

comment on column des_biz_sn_ref.create_time is
'创建时间';

comment on column des_biz_sn_ref.modify_by is
'修改人';

comment on column des_biz_sn_ref.modify_time is
'修改时间';

/*==============================================================*/
/* Table: des_data_model                                        */
/*==============================================================*/
create table if not exists des_data_model (
                                              model_id             int8                 not null,
                                              model_code           varchar(32)          null,
    model_name           varchar(128)         null,
    db_table             varchar(64)          null,
    old_db_table         varchar(64)          null,
    model_type           varchar(32)          null,
    column_json          text                 null,
    embed                int2                 null,
    model_group          varchar(32)          null,
    description          varchar(256)         null,
    cache_json           text                 null,
    synced               int2                 null,
    deleted              int2                 null,
    create_by            int8                 null,
    create_time          timestamp            null,
    modify_by            int8                 null,
    modify_time          timestamp            null,
    constraint des_data_model_pk primary key (model_id)
    );

comment on table des_data_model is
'数据模型';

comment on column des_data_model.model_id is
'模型id';

comment on column des_data_model.model_code is
'模型编码';

comment on column des_data_model.model_name is
'模型名称';

comment on column des_data_model.db_table is
'表名';

comment on column des_data_model.old_db_table is
'原表名';

comment on column des_data_model.model_type is
'模型类型';

comment on column des_data_model.column_json is
'模型列';

comment on column des_data_model.embed is
'内置模型';

comment on column des_data_model.model_group is
'模型分组';

comment on column des_data_model.description is
'描述信息';

comment on column des_data_model.cache_json is
'缓存配置';

comment on column des_data_model.synced is
'是否同步';

comment on column des_data_model.deleted is
'是否删除';

comment on column des_data_model.create_by is
'创建人';

comment on column des_data_model.create_time is
'创建时间';

comment on column des_data_model.modify_by is
'修改人';

comment on column des_data_model.modify_time is
'修改时间';

/*==============================================================*/
/* Table: des_data_model_his                                    */
/*==============================================================*/
create table if not exists des_data_model_his (
                                                  model_his_id         int8                 not null,
                                                  model_id             int8                 null,
                                                  db_table             varchar(64)          null,
    old_db_table         varchar(64)          null,
    model_type           varchar(32)          null,
    column_json          text                 null,
    embed                int2                 null,
    model_group          varchar(32)          null,
    description          varchar(256)         null,
    deleted              int2                 null,
    create_by            int8                 null,
    create_time          timestamp            null,
    modify_by            int8                 null,
    modify_time          timestamp            null,
    constraint des_data_model_his_pk primary key (model_his_id)
    );

comment on table des_data_model_his is
'数据模型历史表';

comment on column des_data_model_his.model_his_id is
'模型历史id';

comment on column des_data_model_his.model_id is
'模型id';

comment on column des_data_model_his.db_table is
'表名';

comment on column des_data_model_his.old_db_table is
'原表名';

comment on column des_data_model_his.model_type is
'模型类型';

comment on column des_data_model_his.column_json is
'模型列';

comment on column des_data_model_his.embed is
'内置模型';

comment on column des_data_model_his.model_group is
'模型分组';

comment on column des_data_model_his.description is
'描述信息';

comment on column des_data_model_his.deleted is
'是否删除';

comment on column des_data_model_his.create_by is
'创建人';

comment on column des_data_model_his.create_time is
'创建时间';

comment on column des_data_model_his.modify_by is
'修改人';

comment on column des_data_model_his.modify_time is
'修改时间';

/*==============================================================*/
/* Table: des_data_model_sync                                   */
/*==============================================================*/
create table if not exists des_data_model_sync (
                                                   model_sync_id        int8                 not null,
                                                   model_id             int8                 null,
                                                   sync_sql             text                 null,
                                                   deleted              int2                 null,
                                                   create_by            int8                 null,
                                                   create_time          timestamp            null,
                                                   modify_by            int8                 null,
                                                   modify_time          timestamp            null,
                                                   constraint des_data_model_sync_pk primary key (model_sync_id)
    );

comment on table des_data_model_sync is
'数据模型同步';

comment on column des_data_model_sync.model_sync_id is
'模型同步id';

comment on column des_data_model_sync.model_id is
'模型id';

comment on column des_data_model_sync.sync_sql is
'同步sql';

comment on column des_data_model_sync.deleted is
'是否删除';

comment on column des_data_model_sync.create_by is
'创建人';

comment on column des_data_model_sync.create_time is
'创建时间';

comment on column des_data_model_sync.modify_by is
'修改人';

comment on column des_data_model_sync.modify_time is
'修改时间';


/*==============================================================*/
/* Table: des_model_rel                                         */
/*==============================================================*/
create table if not exists des_model_rel (
    model_rel_id         int8                 not null,
    model_id             int8                 null,
    model_col_code       varchar(32)          null,
    rel_model_id         int8                 null,
    rel_model_col_code   varchar(64)          null,
    rel_type             varchar(32)          null,
    cascade_delete       int2                 null,
    deleted              int2                 null,
    create_by            int8                 null,
    create_time          timestamp            null,
    modify_by            int8                 null,
    modify_time          timestamp            null,
    constraint des_model_rel_pk primary key (model_rel_id)
    );

comment on table des_model_rel is
'数据模型关系表';

comment on column des_model_rel.model_rel_id is
'模型关系id';

comment on column des_model_rel.model_id is
'模型id';

comment on column des_model_rel.model_col_code is
'模型列编码';

comment on column des_model_rel.rel_model_id is
'关联模型id';

comment on column des_model_rel.rel_model_col_code is
'关联模型列';

comment on column des_model_rel.rel_type is
'关联类型';

comment on column des_model_rel.cascade_delete is
'级联删除';

comment on column des_model_rel.deleted is
'是否删除';

comment on column des_model_rel.create_by is
'创建人';

comment on column des_model_rel.create_time is
'创建时间';

comment on column des_model_rel.modify_by is
'修改人';

comment on column des_model_rel.modify_time is
'修改时间';


/*==============================================================*/
/* Table: des_form_model                                        */
/*==============================================================*/
create table if not exists des_form_model (
                                              form_id              int8                 not null,
                                              model_id             int8                 null,
                                              form_code            varchar(32)          null,
    form_name            varchar(128)         null,
    custom               int2                 null,
    custom_path          varchar(256)         null,
    config_json          text                 null,
    model_group          varchar(32)          null,
    embed                int2                 null,
    description          varchar(256)         null,
    flow_code            varchar(32)          null,
    deleted              int2                 null,
    create_by            int8                 null,
    create_time          timestamp            null,
    modify_by            int8                 null,
    modify_time          timestamp            null,
    constraint des_form_model_pk primary key (form_id)
    );

comment on table des_form_model is
'表单模型';

comment on column des_form_model.form_id is
'表单id';

comment on column des_form_model.model_id is
'模型id';

comment on column des_form_model.form_code is
'表单编码';

comment on column des_form_model.form_name is
'表单名称';

comment on column des_form_model.custom is
'自定义表单';

comment on column des_form_model.custom_path is
'表单路径';

comment on column des_form_model.config_json is
'json配置';

comment on column des_form_model.model_group is
'模型分组';

comment on column des_form_model.embed is
'内置模块';

comment on column des_form_model.description is
'描述信息';

comment on column des_form_model.flow_code is
'流程编码';

comment on column des_form_model.deleted is
'是否删除';

comment on column des_form_model.create_by is
'创建人';

comment on column des_form_model.create_time is
'创建时间';

comment on column des_form_model.modify_by is
'修改人';

comment on column des_form_model.modify_time is
'修改时间';

/*==============================================================*/
/* Table: des_magic_api                                         */
/*==============================================================*/
create table if not exists des_magic_api (
    file_path            varchar(256)         not null,
    file_content         text                 null,
    constraint des_magic_api_pk primary key (file_path)
    );

comment on table des_magic_api is
'des_magic_api';

comment on column des_magic_api.file_path is
'文件路径';

comment on column des_magic_api.file_content is
'文件内容';

/*==============================================================*/
/* Table: des_magic_api_backup                                  */
/*==============================================================*/
create table if not exists des_magic_api_backup (
    id                   varchar(32)          not null,
    create_date          int8                 not null,
    tag                  varchar(32)          null,
    type                 varchar(32)          null,
    name                 varchar(64)          null,
    content              text                 null,
    create_by            varchar(64)          null,
    constraint des_magic_api_backup_pk primary key (id, create_date)
    );

comment on table des_magic_api_backup is
'des_magic_api_backup';

comment on column des_magic_api_backup.id is
'原对象id';

comment on column des_magic_api_backup.create_date is
'备份时间';

comment on column des_magic_api_backup.tag is
'标签';

comment on column des_magic_api_backup.type is
'类型';

comment on column des_magic_api_backup.name is
'原名称';

comment on column des_magic_api_backup.content is
'备份内容';

comment on column des_magic_api_backup.create_by is
'操作人';

/*==============================================================*/
/* Table: des_page_model                                        */
/*==============================================================*/
create table if not exists des_page_model (
                                              page_id              int8                 not null,
                                              model_id             int8                 null,
                                              page_code            varchar(32)          null,
    page_name            varchar(128)         null,
    page_type            varchar(32)          null,
    custom               int2                 null,
    custom_path          varchar(256)         null,
    config_json          text                 null,
    model_group          varchar(32)          null,
    menu_id              int8                 null,
    embed                int2                 null,
    description          varchar(256)         null,
    deleted              int2                 null,
    create_by            int8                 null,
    create_time          timestamp            null,
    modify_by            int8                 null,
    modify_time          timestamp            null,
    constraint des_page_model_pk primary key (page_id)
    );

comment on table des_page_model is
'页面模型';

comment on column des_page_model.page_id is
'页面id';

comment on column des_page_model.model_id is
'模型id';

comment on column des_page_model.page_code is
'页面编码';

comment on column des_page_model.page_name is
'页面名称';

comment on column des_page_model.page_type is
'页面类型';

comment on column des_page_model.custom is
'自定义页面';

comment on column des_page_model.custom_path is
'页面路径';

comment on column des_page_model.config_json is
'json配置';

comment on column des_page_model.model_group is
'模型分组';

comment on column des_page_model.menu_id is
'菜单id';

comment on column des_page_model.embed is
'内置模块';

comment on column des_page_model.description is
'描述信息';

comment on column des_page_model.deleted is
'是否删除';

comment on column des_page_model.create_by is
'创建人';

comment on column des_page_model.create_time is
'创建时间';

comment on column des_page_model.modify_by is
'修改人';

comment on column des_page_model.modify_time is
'修改时间';

/*==============================================================*/
/* Table: des_report                                            */
/*==============================================================*/
create table if not exists des_report (
                                          report_id            int8                 not null,
                                          group_id             int8                 null,
                                          report_type          varchar(32)          null,
    report_name          varchar(128)         null,
    jimu_report_id       varchar(32)          null,
    ord_no               int8                 null,
    rmk                  varchar(256)         null,
    deleted              int2                 null,
    create_by            int8                 null,
    create_time          timestamp            null,
    modify_by            int8                 null,
    modify_time          timestamp            null,
    constraint des_report_pk primary key (report_id)
    );

comment on table des_report is
'报表-报表配置';

comment on column des_report.report_id is
'报表id';

comment on column des_report.group_id is
'分组id';

comment on column des_report.report_type is
'报表类型';

comment on column des_report.report_name is
'报表名称';

comment on column des_report.jimu_report_id is
'积木报表id';

comment on column des_report.ord_no is
'排序';

comment on column des_report.rmk is
'备注';

comment on column des_report.deleted is
'是否删除';

comment on column des_report.create_by is
'创建人';

comment on column des_report.create_time is
'创建时间';

comment on column des_report.modify_by is
'修改人';

comment on column des_report.modify_time is
'修改时间';

/*==============================================================*/
/* Table: des_report_group                                      */
/*==============================================================*/
create table if not exists des_report_group (
                                                group_id             int8                 not null,
                                                group_pid            int8                 not null,
                                                group_name           varchar(128)         null,
    ord_no               int8                 null,
    rmk                  varchar(256)         null,
    deleted              int2                 null,
    create_by            int8                 null,
    create_time          timestamp            null,
    modify_by            int8                 null,
    modify_time          timestamp            null,
    constraint des_report_group_pk primary key (group_id)
    );

comment on table des_report_group is
'报表-报表分组';

comment on column des_report_group.group_id is
'分组id';

comment on column des_report_group.group_pid is
'上级分组id';

comment on column des_report_group.group_name is
'分组名称';

comment on column des_report_group.ord_no is
'排序';

comment on column des_report_group.rmk is
'备注';

comment on column des_report_group.deleted is
'是否删除';

comment on column des_report_group.create_by is
'创建人';

comment on column des_report_group.create_time is
'创建时间';

comment on column des_report_group.modify_by is
'修改人';

comment on column des_report_group.modify_time is
'修改时间';

/*==============================================================*/
/* Table: des_datagrid_model                                    */
/*==============================================================*/
create table if not exists des_datagrid_model (
                                                  datagrid_id          int8                 not null,
                                                  model_id             int8                 null,
                                                  form_id              int8                 null,
                                                  datagrid_code        varchar(32)          null,
    datagrid_name        varchar(128)         null,
    model_group          varchar(32)          null,
    config_json          text                 null,
    deleted              int2                 null,
    create_by            int8                 null,
    create_time          timestamp            null,
    modify_by            int8                 null,
    modify_time          timestamp            null,
    constraint des_datagrid_model_pk primary key (datagrid_id)
    );

comment on table des_datagrid_model is
'数据表格模型管理';

comment on column des_datagrid_model.datagrid_id is
'数据表格id';

comment on column des_datagrid_model.model_id is
'模型id';

comment on column des_datagrid_model.form_id is
'表单id';

comment on column des_datagrid_model.datagrid_code is
'数据表格编码';

comment on column des_datagrid_model.datagrid_name is
'数据表格名称';

comment on column des_datagrid_model.model_group is
'模型分组';

comment on column des_datagrid_model.config_json is
'json配置';

comment on column des_datagrid_model.deleted is
'是否删除';

comment on column des_datagrid_model.create_by is
'创建人';

comment on column des_datagrid_model.create_time is
'创建时间';

comment on column des_datagrid_model.modify_by is
'修改人';

comment on column des_datagrid_model.modify_time is
'修改时间';


------插入默认的模型分组树形字典数据

INSERT INTO base_dict ("dict_id", "dict_code", "dict_name", "dict_type", "embed", "ord_no", "rmk", "deleted", "create_by", "create_time", "modify_by", "modify_time")
SELECT 238776151375873, 'DesModelGroup', '模型分组', 'TREE', 0, NULL, NULL, 0, 0, '2023-08-10 19:02:21.6', 0, '2023-08-15 10:21:02.64'
WHERE NOT EXISTS (SELECT 1 FROM base_dict WHERE dict_code = 'DesModelGroup');

INSERT INTO base_dict_item("dict_item_id", "dict_item_pid", "dict_id", "dict_code", "value", "text", "embed", "enabled", "ord_no", "rmk", "deleted", "create_by", "create_time", "modify_by", "modify_time")
SELECT 238776151375874, 0, 238776151375873, 'DesModelGroup', 'DEFAULT', '默认分组', 0, 1, 1, NULL, 0, 0, '2023-08-10 19:02:21.6', 0, '2023-08-15 10:21:02.64'
WHERE NOT EXISTS (SELECT 1 FROM base_dict_item WHERE dict_code = 'DesModelGroup' AND value = 'DEFAULT');

INSERT INTO base_dict_item("dict_item_id", "dict_item_pid", "dict_id", "dict_code", "value", "text", "embed", "enabled", "ord_no", "rmk", "deleted", "create_by", "create_time", "modify_by", "modify_time")
SELECT 238776151375875, 238776151375874, 238776151375873, 'DesModelGroup', 'BASE', '系统基础信息', 0, 1, 1, NULL, 0, 0, '2023-08-14 14:37:26.971', 0, '2023-08-19 09:07:47.363'
WHERE NOT EXISTS (SELECT 1 FROM base_dict_item WHERE dict_code = 'DesModelGroup' AND value = 'BASE');


----插入默认的内置的数据模型

INSERT INTO des_data_model ("model_id", "model_code", "model_name", "db_table", "old_db_table", "model_type","model_group", "synced", "description", "column_json", "deleted", "create_by", "modify_by", "create_time", "modify_time", "embed", "cache_json")
SELECT 236412249309185, 'BaseDept', '部门管理', 'base_dept', 'base_dept', 'TABLE', 'base',1, '部门管理', '[{"columnCode":"DeptId","columnName":"部门ID","columnType":"ID","dbColumn":"dept_id","embed":0,"isPk":1,"linkModel":"","linkModelColumn":"","modelCode":"BaseDept","notNull":1,"oldColumnType":"ID","oldDbColumn":"dept_id","orderNo":0},{"columnCode":"DeptPid","columnName":"上级部门ID","columnType":"BIGINT","dbColumn":"dept_pid","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseDept","notNull":0,"oldColumnType":"BIGINT","oldDbColumn":"dept_pid","orderNo":1},{"columnCode":"OrgId","columnName":"组织机构ID","columnType":"BIGINT","dbColumn":"org_id","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseDept","notNull":0,"oldColumnType":"BIGINT","oldDbColumn":"org_id","orderNo":2},{"columnCode":"DeptName","columnName":"部门名称","columnType":"VARCHAR","dbColumn":"dept_name","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseDept","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"dept_name","orderNo":3},{"columnCode":"DeptCode","columnName":"部门编码","columnType":"VARCHAR","dbColumn":"dept_code","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseDept","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"dept_code","orderNo":4},{"columnCode":"DeptFullName","columnName":"部门全称","columnType":"VARCHAR","dbColumn":"dept_full_name","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseDept","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"dept_full_name","orderNo":5},{"columnCode":"Virtual","columnName":"是否虚拟部门","columnType":"VARCHAR","dbColumn":"virtual","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseDept","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"virtual","orderNo":6},{"columnCode":"Enabled","columnName":"启用","columnType":"VARCHAR","dbColumn":"enabled","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseDept","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"enabled","orderNo":7},{"columnCode":"Manager","columnName":"部门主管","columnType":"BIGINT","dbColumn":"manager","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseDept","notNull":0,"oldColumnType":"BIGINT","oldDbColumn":"manager","orderNo":8},{"columnCode":"OrderNo","columnName":"顺序号","columnType":"BIGINT","dbColumn":"ord_no","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseDept","notNull":0,"oldColumnType":"BIGINT","oldDbColumn":"ord_no","orderNo":9},{"columnCode":"Deleted","columnName":"逻辑删除","columnType":"LOGIC_DELETE","dbColumn":"deleted","embed":1,"linkModel":"","linkModelColumn":"","modelCode":"BaseDept","oldColumnType":"LOGIC_DELETE","oldDbColumn":"deleted","orderNo":999},{"columnCode":"CreateBy","columnName":"创建人","columnType":"BIGINT","dbColumn":"create_by","embed":1,"linkModel":"","linkModelColumn":"","modelCode":"BaseDept","oldColumnType":"BIGINT","oldDbColumn":"create_by","orderNo":1000},{"columnCode":"ModifyBy","columnName":"修改人","columnType":"BIGINT","dbColumn":"modify_by","embed":1,"linkModel":"","linkModelColumn":"","modelCode":"BaseDept","oldColumnType":"BIGINT","oldDbColumn":"modify_by","orderNo":1001},{"columnCode":"CreateTime","columnName":"创建时间","columnType":"DATETIME","dbColumn":"create_time","embed":1,"linkModel":"","linkModelColumn":"","modelCode":"BaseDept","oldColumnType":"DATETIME","oldDbColumn":"create_time","orderNo":1002},{"columnCode":"ModifyTime","columnName":"修改时间","columnType":"DATETIME","dbColumn":"modify_time","embed":1,"linkModel":"","linkModelColumn":"","modelCode":"BaseDept","oldColumnType":"DATETIME","oldDbColumn":"modify_time","orderNo":1003}]', 0, 0, 0, '2023-07-28 17:55:45.489', '2023-07-28 17:55:45.489', 1, '{"list":{"enable":true,"key":"dept_id","text":"dept_name"},"cascade":{"enable":true,"key":"dept_id","parentKey":"dept_pid","text":"dept_name"}}'
    WHERE NOT EXISTS (SELECT 1 FROM des_data_model WHERE model_code = 'BaseDept');

INSERT INTO des_data_model ("model_id", "model_code", "model_name", "db_table", "old_db_table", "model_type", "model_group", "synced", "description", "column_json", "deleted", "create_by", "modify_by", "create_time", "modify_time", "embed", "cache_json")
SELECT 236935234977793, 'BaseOrg', '组织机构', 'base_org', 'base_org', 'TABLE', 'base',1, '组织机构', '[{"columnCode":"OrgId","columnName":"组织机构ID","columnType":"ID","dbColumn":"org_id","embed":0,"isPk":1,"linkModel":"","linkModelColumn":"","modelCode":"BaseOrg","notNull":1,"oldColumnType":"ID","oldDbColumn":"org_id","orderNo":0},{"columnCode":"OrgPid","columnName":"上级组织ID","columnType":"BIGINT","dbColumn":"org_pid","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseOrg","notNull":0,"oldColumnType":"BIGINT","oldDbColumn":"org_pid","orderNo":1},{"columnCode":"OrgName","columnName":"组织机构名称","columnType":"VARCHAR","dbColumn":"org_name","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseOrg","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"org_name","orderNo":2},{"columnCode":"OrgCode","columnName":"组织机构编码","columnType":"VARCHAR","dbColumn":"org_code","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseOrg","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"org_code","orderNo":3},{"columnCode":"OrgFullName","columnName":"组织机构全称","columnType":"VARCHAR","dbColumn":"org_full_name","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseOrg","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"org_full_name","orderNo":4},{"columnCode":"Enabled","columnName":"启用","columnType":"VARCHAR","dbColumn":"enabled","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseOrg","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"enabled","orderNo":5},{"columnCode":"OrderNo","columnName":"顺序号","columnType":"BIGINT","dbColumn":"ord_no","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseOrg","notNull":0,"oldColumnType":"BIGINT","oldDbColumn":"ord_no","orderNo":6},{"columnCode":"Deleted","columnName":"逻辑删除","columnType":"LOGIC_DELETE","dbColumn":"deleted","embed":1,"linkModel":"","linkModelColumn":"","modelCode":"BaseOrg","oldColumnType":"LOGIC_DELETE","oldDbColumn":"deleted","orderNo":999},{"columnCode":"CreateBy","columnName":"创建人","columnType":"BIGINT","dbColumn":"create_by","embed":1,"linkModel":"","linkModelColumn":"","modelCode":"BaseOrg","oldColumnType":"BIGINT","oldDbColumn":"create_by","orderNo":1000},{"columnCode":"ModifyBy","columnName":"修改人","columnType":"BIGINT","dbColumn":"modify_by","embed":1,"linkModel":"","linkModelColumn":"","modelCode":"BaseOrg","oldColumnType":"BIGINT","oldDbColumn":"modify_by","orderNo":1001},{"columnCode":"CreateTime","columnName":"创建时间","columnType":"DATETIME","dbColumn":"create_time","embed":1,"linkModel":"","linkModelColumn":"","modelCode":"BaseOrg","oldColumnType":"DATETIME","oldDbColumn":"create_time","orderNo":1002},{"columnCode":"ModifyTime","columnName":"修改时间","columnType":"DATETIME","dbColumn":"modify_time","embed":1,"linkModel":"","linkModelColumn":"","modelCode":"BaseOrg","oldColumnType":"DATETIME","oldDbColumn":"modify_time","orderNo":1003}]', 0, 0, 0, '2023-07-31 15:12:04.851', '2023-07-31 15:12:04.851', 1, '{"list":{"enable":true,"key":"org_id","text":"org_name"},"cascade":{"enable":true,"key":"org_id","parentKey":"org_pid","text":"org_name"}}'
    WHERE NOT EXISTS (SELECT 1 FROM des_data_model WHERE model_code = 'BaseOrg');

INSERT INTO des_data_model ("model_id", "model_code", "model_name", "db_table", "old_db_table", "model_type","model_group", "synced", "description", "column_json", "deleted", "create_by", "modify_by", "create_time", "modify_time", "embed", "cache_json")
SELECT 236937344712705, 'BaseRole', '角色', 'base_role', 'base_role', 'TABLE', 'base',1, '角色', '[{"columnCode":"RoleId","columnName":"角色ID","columnType":"ID","dbColumn":"role_id","embed":0,"isPk":1,"linkModel":"","linkModelColumn":"","modelCode":"BaseRole","notNull":1,"oldColumnType":"ID","oldDbColumn":"role_id","orderNo":0},{"columnCode":"OrgId","columnName":"所属组织机构ID","columnType":"FK","dbColumn":"org_id","embed":0,"isPk":0,"linkModel":"BaseOrg","linkModelColumn":"OrgId","modelCode":"BaseRole","notNull":0,"oldColumnType":"FK","oldDbColumn":"org_id","orderNo":1},{"columnCode":"RoleName","columnName":"角色名称","columnType":"VARCHAR","dbColumn":"role_name","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseRole","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"role_name","orderNo":2},{"columnCode":"RoleType","columnName":"角色类型","columnType":"VARCHAR","dbColumn":"role_type","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseRole","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"role_type","orderNo":3},{"columnCode":"Enabled","columnName":"启用状态","columnType":"VARCHAR","dbColumn":"enabled","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseRole","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"enabled","orderNo":4},{"columnCode":"Deleted","columnName":"逻辑删除","columnType":"LOGIC_DELETE","dbColumn":"deleted","embed":1,"linkModel":"","linkModelColumn":"","modelCode":"BaseRole","oldColumnType":"LOGIC_DELETE","oldDbColumn":"deleted","orderNo":999},{"columnCode":"CreateBy","columnName":"创建人","columnType":"BIGINT","dbColumn":"create_by","embed":1,"linkModel":"","linkModelColumn":"","modelCode":"BaseRole","oldColumnType":"BIGINT","oldDbColumn":"create_by","orderNo":1000},{"columnCode":"ModifyBy","columnName":"修改人","columnType":"BIGINT","dbColumn":"modify_by","embed":1,"linkModel":"","linkModelColumn":"","modelCode":"BaseRole","oldColumnType":"BIGINT","oldDbColumn":"modify_by","orderNo":1001},{"columnCode":"CreateTime","columnName":"创建时间","columnType":"DATETIME","dbColumn":"create_time","embed":1,"linkModel":"","linkModelColumn":"","modelCode":"BaseRole","oldColumnType":"DATETIME","oldDbColumn":"create_time","orderNo":1002},{"columnCode":"ModifyTime","columnName":"修改时间","columnType":"DATETIME","dbColumn":"modify_time","embed":1,"linkModel":"","linkModelColumn":"","modelCode":"BaseRole","oldColumnType":"DATETIME","oldDbColumn":"modify_time","orderNo":1003}]', 0, 0, 0, '2023-07-31 15:28:50.349', '2023-07-31 15:28:50.349', 1, '{"list":{"enable":true,"key":"role_id","text":"role_name"},"cascade":{"enable":false}}'
    WHERE NOT EXISTS (SELECT 1 FROM des_data_model WHERE model_code = 'BaseRole');

INSERT INTO des_data_model ("model_id", "model_code", "model_name", "db_table", "old_db_table", "model_type", "model_group", "synced", "description", "column_json", "deleted", "create_by", "modify_by", "create_time", "modify_time", "embed", "cache_json")
SELECT 236939473321985, 'BaseUser', '用户信息', 'base_user', 'base_user', 'TABLE','base', 1, '用户信息', '[{"columnCode":"UserId","columnName":"用户ID","columnType":"BIGINT","dbColumn":"user_id","embed":0,"isPk":1,"modelCode":"BaseUserCopy1","notNull":1,"oldColumnType":"BIGINT","oldDbColumn":"user_id","orderNo":1},{"columnCode":"OrgId","columnName":"机构ID","columnType":"BIGINT","dbColumn":"org_id","embed":0,"isPk":0,"modelCode":"BaseUserCopy1","notNull":0,"oldColumnType":"BIGINT","oldDbColumn":"org_id","orderNo":2},{"columnCode":"DeptId","columnName":"部门id","columnType":"BIGINT","dbColumn":"dept_id","embed":0,"isPk":0,"modelCode":"BaseUserCopy1","notNull":0,"oldColumnType":"BIGINT","oldDbColumn":"dept_id","orderNo":3},{"columnCode":"UserName","columnName":"用户名","columnType":"VARCHAR","dbColumn":"user_name","embed":0,"isPk":0,"modelCode":"BaseUserCopy1","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"user_name","orderNo":4},{"columnCode":"UserPassword","columnName":"密码","columnType":"VARCHAR","dbColumn":"user_password","embed":0,"isPk":0,"modelCode":"BaseUserCopy1","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"user_password","orderNo":5},{"columnCode":"EmpCode","columnName":"工号","columnType":"VARCHAR","dbColumn":"emp_code","embed":0,"isPk":0,"modelCode":"BaseUserCopy1","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"emp_code","orderNo":6},{"columnCode":"EmpName","columnName":"姓名","columnType":"VARCHAR","dbColumn":"emp_name","embed":0,"isPk":0,"modelCode":"BaseUserCopy1","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"emp_name","orderNo":7},{"columnCode":"Birthday","columnName":"生日","columnType":"DATE","dbColumn":"birthday","embed":0,"isPk":0,"modelCode":"BaseUserCopy1","notNull":0,"oldColumnType":"DATE","oldDbColumn":"birthday","orderNo":8},{"columnCode":"Gender","columnName":"性别","columnType":"VARCHAR","dbColumn":"gender","embed":0,"isPk":0,"modelCode":"BaseUserCopy1","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"gender","orderNo":9},{"columnCode":"Mobile","columnName":"手机","columnType":"VARCHAR","dbColumn":"mobile","embed":0,"isPk":0,"modelCode":"BaseUserCopy1","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"mobile","orderNo":10},{"columnCode":"Phone","columnName":"电话","columnType":"VARCHAR","dbColumn":"phone","embed":0,"isPk":0,"modelCode":"BaseUserCopy1","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"phone","orderNo":11},{"columnCode":"Email","columnName":"邮箱","columnType":"VARCHAR","dbColumn":"email","embed":0,"isPk":0,"modelCode":"BaseUserCopy1","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"email","orderNo":12},{"columnCode":"NickName","columnName":"昵称","columnType":"VARCHAR","dbColumn":"nick_name","embed":0,"isPk":0,"modelCode":"BaseUserCopy1","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"nick_name","orderNo":13},{"columnCode":"UserAvatar","columnName":"头像","columnType":"VARCHAR","dbColumn":"user_avatar","embed":0,"isPk":0,"modelCode":"BaseUserCopy1","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"user_avatar","orderNo":14},{"columnCode":"UserType","columnName":"用户类型","columnType":"VARCHAR","dbColumn":"user_type","embed":0,"isPk":0,"modelCode":"BaseUserCopy1","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"user_type","orderNo":15},{"columnCode":"UserStatus","columnName":"用户状态","columnType":"VARCHAR","dbColumn":"user_status","embed":0,"isPk":0,"modelCode":"BaseUserCopy1","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"user_status","orderNo":16},{"columnCode":"ValidTime","columnName":"生效时间","columnType":"DATE","dbColumn":"valid_time","embed":0,"isPk":0,"modelCode":"BaseUserCopy1","notNull":0,"oldColumnType":"DATE","oldDbColumn":"valid_time","orderNo":17},{"columnCode":"InvalidTime","columnName":"失效时间","columnType":"DATE","dbColumn":"invalid_time","embed":0,"isPk":0,"modelCode":"BaseUserCopy1","notNull":0,"oldColumnType":"DATE","oldDbColumn":"invalid_time","orderNo":18},{"columnCode":"Enabled","columnName":"是否启用","columnType":"BIGINT","dbColumn":"enabled","embed":0,"isPk":0,"modelCode":"BaseUserCopy1","notNull":0,"oldColumnType":"BIGINT","oldDbColumn":"enabled","orderNo":19},{"columnCode":"ExtInfo","columnName":"扩展信息","columnType":"VARCHAR","dbColumn":"ext_info","embed":0,"isPk":0,"modelCode":"BaseUserCopy1","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"ext_info","orderNo":20},{"columnCode":"OrdNo","columnName":"排序","columnType":"BIGINT","dbColumn":"ord_no","embed":0,"isPk":0,"modelCode":"BaseUserCopy1","notNull":0,"oldColumnType":"BIGINT","oldDbColumn":"ord_no","orderNo":21},{"columnCode":"Rmk","columnName":"备注","columnType":"VARCHAR","dbColumn":"rmk","embed":0,"isPk":0,"modelCode":"BaseUserCopy1","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"rmk","orderNo":22},{"columnCode":"LastLoginTime","columnName":"最后登录时间","columnType":"DATETIME","dbColumn":"last_login_time","embed":0,"isPk":0,"modelCode":"BaseUserCopy1","notNull":0,"oldColumnType":"DATETIME","oldDbColumn":"last_login_time","orderNo":23},{"columnCode":"PasswordModifyTime","columnName":"密码修改时间","columnType":"DATETIME","dbColumn":"password_modify_time","embed":0,"isPk":0,"modelCode":"BaseUserCopy1","notNull":0,"oldColumnType":"DATETIME","oldDbColumn":"password_modify_time","orderNo":24},{"columnCode":"Deleted","columnName":"是否删除","columnType":"BIGINT","dbColumn":"deleted","embed":1,"isPk":0,"modelCode":"BaseUserCopy1","notNull":0,"oldColumnType":"BIGINT","oldDbColumn":"deleted","orderNo":25},{"columnCode":"CreateBy","columnName":"创建人","columnType":"BIGINT","dbColumn":"create_by","embed":1,"isPk":0,"modelCode":"BaseUserCopy1","notNull":0,"oldColumnType":"BIGINT","oldDbColumn":"create_by","orderNo":26},{"columnCode":"CreateTime","columnName":"创建时间","columnType":"DATETIME","dbColumn":"create_time","embed":1,"isPk":0,"modelCode":"BaseUserCopy1","notNull":0,"oldColumnType":"DATETIME","oldDbColumn":"create_time","orderNo":27},{"columnCode":"ModifyBy","columnName":"修改人","columnType":"BIGINT","dbColumn":"modify_by","embed":1,"isPk":0,"modelCode":"BaseUserCopy1","notNull":0,"oldColumnType":"BIGINT","oldDbColumn":"modify_by","orderNo":28},{"columnCode":"ModifyTime","columnName":"修改时间","columnType":"DATETIME","dbColumn":"modify_time","embed":1,"isPk":0,"modelCode":"BaseUserCopy1","notNull":0,"oldColumnType":"DATETIME","oldDbColumn":"modify_time","orderNo":29}]', 0, 0, 0, '2023-07-31 15:45:45.781', '2023-07-31 15:45:45.781', 1, '{"list":{"enable":true,"key":"user_id","text":"emp_name"},"cascade":{"enable":false}}'
    WHERE NOT EXISTS (SELECT 1 FROM des_data_model WHERE model_code = 'BaseUser');

INSERT INTO des_data_model ("model_id", "model_code", "model_name", "db_table", "old_db_table", "model_type", "model_group", "synced", "description", "column_json", "deleted", "create_by", "modify_by", "create_time", "modify_time", "embed", "cache_json")
SELECT 237118802886657, 'BaseDict', '数据字典', 'base_dict', 'base_dict', 'TABLE', 'base',1, '数据字典', '[{"columnCode":"DictId","columnName":"字典ID","columnType":"ID","dbColumn":"dict_id","embed":0,"isPk":1,"linkModel":"","linkModelColumn":"","modelCode":"BaseDict","notNull":1,"oldColumnType":"ID","oldDbColumn":"id","orderNo":0},{"columnCode":"Code","columnName":"字典编码","columnType":"VARCHAR","dbColumn":"code","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseDict","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"code","orderNo":1},{"columnCode":"Name","columnName":"字典名称","columnType":"VARCHAR","dbColumn":"name","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseDict","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"name","orderNo":2},{"columnCode":"DictType","columnName":"字典类型","columnType":"VARCHAR","dbColumn":"dict_type","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseDict","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"dict_type","orderNo":3},{"columnCode":"Embed","columnName":"是否内置字典","columnType":"VARCHAR","dbColumn":"embed","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseDict","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"embed","orderNo":4},{"columnCode":"Memo","columnName":"备注","columnType":"VARCHAR","dbColumn":"memo","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseDict","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"memo","orderNo":5},{"columnCode":"Deleted","columnName":"逻辑删除","columnType":"LOGIC_DELETE","dbColumn":"deleted","embed":1,"linkModel":"","linkModelColumn":"","modelCode":"BaseDict","oldColumnType":"LOGIC_DELETE","oldDbColumn":"deleted","orderNo":999},{"columnCode":"CreateBy","columnName":"创建人","columnType":"BIGINT","dbColumn":"create_by","embed":1,"linkModel":"","linkModelColumn":"","modelCode":"BaseDict","oldColumnType":"BIGINT","oldDbColumn":"create_by","orderNo":1000},{"columnCode":"ModifyBy","columnName":"修改人","columnType":"BIGINT","dbColumn":"modify_by","embed":1,"linkModel":"","linkModelColumn":"","modelCode":"BaseDict","oldColumnType":"BIGINT","oldDbColumn":"modify_by","orderNo":1001},{"columnCode":"CreateTime","columnName":"创建时间","columnType":"DATETIME","dbColumn":"create_time","embed":1,"linkModel":"","linkModelColumn":"","modelCode":"BaseDict","oldColumnType":"DATETIME","oldDbColumn":"create_time","orderNo":1002},{"columnCode":"ModifyTime","columnName":"修改时间","columnType":"DATETIME","dbColumn":"modify_time","embed":1,"linkModel":"","linkModelColumn":"","modelCode":"BaseDict","oldColumnType":"DATETIME","oldDbColumn":"modify_time","orderNo":1003}]', 0, 0, 0, '2023-08-01 15:30:56.941', '2023-08-01 15:30:56.941', 1, '{"list":{"enable":false},"cascade":{"enable":false}}'
    WHERE NOT EXISTS (SELECT 1 FROM des_data_model WHERE model_code = 'BaseDict');

INSERT INTO des_data_model ("model_id", "model_code", "model_name", "db_table", "old_db_table", "model_type","model_group",  "synced", "description", "column_json", "deleted", "create_by", "modify_by", "create_time", "modify_time", "embed", "cache_json")
SELECT 237120178618369, 'BaseDictItem', '数据字典项', 'base_dict_item', 'base_dict_item', 'TABLE', 'base',1, '数据字典项', '[{"columnCode":"DictItemId","columnName":"字典项ID","columnType":"ID","dbColumn":"dict_item_id","embed":0,"isPk":1,"linkModel":"","linkModelColumn":"","modelCode":"BaseDictItem","notNull":1,"oldColumnType":"ID","oldDbColumn":"dict_item_id","orderNo":0},{"columnCode":"DictItemPid","columnName":"上级ID","columnType":"BIGINT","dbColumn":"dict_item_pid","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseDictItem","notNull":0,"oldColumnType":"BIGINT","oldDbColumn":"dict_item_pid","orderNo":1},{"columnCode":"DictId","columnName":"字典ID","columnType":"VARCHAR","dbColumn":"dict_id","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseDictItem","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"dict_id","orderNo":2},{"columnCode":"DictCode","columnName":"字典编码","columnType":"VARCHAR","dbColumn":"dict_code","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseDictItem","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"dict_code","orderNo":2},{"columnCode":"Value","columnName":"字典值","columnType":"VARCHAR","dbColumn":"value","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseDictItem","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"value","orderNo":3},{"columnCode":"Text","columnName":"字典文字","columnType":"VARCHAR","dbColumn":"text","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseDictItem","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"text","orderNo":4},{"columnCode":"OrderNo","columnName":"顺序号","columnType":"BIGINT","dbColumn":"ord_no","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseDictItem","notNull":0,"oldColumnType":"BIGINT","oldDbColumn":"ord_no","orderNo":5},{"columnCode":"Embed","columnName":"是否内置字典项","columnType":"VARCHAR","dbColumn":"embed","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseDictItem","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"embed","orderNo":6},{"columnCode":"Memo","columnName":"备注","columnType":"VARCHAR","dbColumn":"memo","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseDictItem","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"memo","orderNo":7},{"columnCode":"Deleted","columnName":"逻辑删除","columnType":"LOGIC_DELETE","dbColumn":"deleted","embed":1,"linkModel":"","linkModelColumn":"","modelCode":"BaseDictItem","oldColumnType":"LOGIC_DELETE","oldDbColumn":"deleted","orderNo":999},{"columnCode":"CreateBy","columnName":"创建人","columnType":"BIGINT","dbColumn":"create_by","embed":1,"linkModel":"","linkModelColumn":"","modelCode":"BaseDictItem","oldColumnType":"BIGINT","oldDbColumn":"create_by","orderNo":1000},{"columnCode":"ModifyBy","columnName":"修改人","columnType":"BIGINT","dbColumn":"modify_by","embed":1,"linkModel":"","linkModelColumn":"","modelCode":"BaseDictItem","oldColumnType":"BIGINT","oldDbColumn":"modify_by","orderNo":1001},{"columnCode":"CreateTime","columnName":"创建时间","columnType":"DATETIME","dbColumn":"create_time","embed":1,"linkModel":"","linkModelColumn":"","modelCode":"BaseDictItem","oldColumnType":"DATETIME","oldDbColumn":"create_time","orderNo":1002},{"columnCode":"ModifyTime","columnName":"修改时间","columnType":"DATETIME","dbColumn":"modify_time","embed":1,"linkModel":"","linkModelColumn":"","modelCode":"BaseDictItem","oldColumnType":"DATETIME","oldDbColumn":"modify_time","orderNo":1003}]', 0, 0, 0, '2023-08-01 15:41:52.39', '2023-08-01 15:41:52.39', 1, '{"list":{"enable":false},"cascade":{"enable":false}}'
    WHERE NOT EXISTS (SELECT 1 FROM des_data_model WHERE model_code = 'BaseDictItem');

INSERT INTO des_data_model ("model_id", "model_code", "model_name", "db_table", "old_db_table", "model_type","model_group",  "synced", "description", "column_json", "deleted", "create_by", "modify_by", "create_time", "modify_time", "embed", "cache_json")
SELECT 237121044742145, 'BaseLogLogin', '登录日志', 'base_log_login', 'base_log_login', 'TABLE', 'base',1, '登录日志', '[{"columnCode":"LogLoginId","columnName":"日志ID","columnType":"ID","dbColumn":"log_login_id","embed":0,"isPk":1,"linkModel":"","linkModelColumn":"","modelCode":"BaseLoginLog","notNull":1,"oldColumnType":"ID","oldDbColumn":"log_login_id","orderNo":0},{"columnCode":"LoginName","columnName":"登录用户名","columnType":"VARCHAR","dbColumn":"login_name","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseLoginLog","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"login_name","orderNo":1},{"columnCode":"LoginType","columnName":"登录日志类型","columnType":"VARCHAR","dbColumn":"login_type","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseLoginLog","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"login_type","orderNo":2},{"columnCode":"LogTime","columnName":"日志时间","columnType":"DATE","dbColumn":"log_time","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseLoginLog","notNull":0,"oldColumnType":"DATE","oldDbColumn":"log_time","orderNo":3},{"columnCode":"LogIp","columnName":"登录/退出的IP","columnType":"VARCHAR","dbColumn":"log_ip","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseLoginLog","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"log_ip","orderNo":4},{"columnCode":"LogOs","columnName":"操作系统","columnType":"VARCHAR","dbColumn":"log_os","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseLoginLog","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"log_os","orderNo":5},{"columnCode":"LogBrowser","columnName":"浏览器","columnType":"VARCHAR","dbColumn":"log_browser","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseLoginLog","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"log_browser","orderNo":6},{"columnCode":"LogSuccess","columnName":"操作是否成功","columnType":"VARCHAR","dbColumn":"log_success","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseLoginLog","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"log_success","orderNo":7},{"columnCode":"LogResult","columnName":"登录结果信息","columnType":"VARCHAR","dbColumn":"log_result","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseLoginLog","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"log_result","orderNo":8},{"columnCode":"Deleted","columnName":"逻辑删除","columnType":"LOGIC_DELETE","dbColumn":"deleted","embed":1,"linkModel":"","linkModelColumn":"","modelCode":"BaseLoginLog","oldColumnType":"LOGIC_DELETE","oldDbColumn":"deleted","orderNo":999},{"columnCode":"CreateBy","columnName":"创建人","columnType":"BIGINT","dbColumn":"create_by","embed":1,"linkModel":"","linkModelColumn":"","modelCode":"BaseLoginLog","oldColumnType":"BIGINT","oldDbColumn":"create_by","orderNo":1000},{"columnCode":"ModifyBy","columnName":"修改人","columnType":"BIGINT","dbColumn":"modify_by","embed":1,"linkModel":"","linkModelColumn":"","modelCode":"BaseLoginLog","oldColumnType":"BIGINT","oldDbColumn":"modify_by","orderNo":1001},{"columnCode":"CreateTime","columnName":"创建时间","columnType":"DATETIME","dbColumn":"create_time","embed":1,"linkModel":"","linkModelColumn":"","modelCode":"BaseLoginLog","oldColumnType":"DATETIME","oldDbColumn":"create_time","orderNo":1002},{"columnCode":"ModifyTime","columnName":"修改时间","columnType":"DATETIME","dbColumn":"modify_time","embed":1,"linkModel":"","linkModelColumn":"","modelCode":"BaseLoginLog","oldColumnType":"DATETIME","oldDbColumn":"modify_time","orderNo":1003}]', 0, 0, 0, '2023-08-01 15:48:45.488', '2023-08-01 15:48:45.488', 1, '{"list":{"enable":false},"cascade":{"enable":false}}'
    WHERE NOT EXISTS (SELECT 1 FROM des_data_model WHERE model_code = 'BaseLogLogin');

INSERT INTO des_data_model ("model_id", "model_code", "model_name", "db_table", "old_db_table", "model_type","model_group",  "synced", "description", "column_json", "deleted", "create_by", "modify_by", "create_time", "modify_time", "embed", "cache_json")
SELECT 237121977974785, 'BaseLogOpt', '操作日志', 'base_log_opt', 'base_log_opt', 'TABLE', 'base',1, '操作日志', '[{"columnCode":"LogOptId","columnName":"日志ID","columnType":"ID","dbColumn":"log_opt_id","embed":0,"isPk":1,"linkModel":"","linkModelColumn":"","modelCode":"BaseOptLog","notNull":1,"oldColumnType":"ID","oldDbColumn":"log_opt_id","orderNo":0},{"columnCode":"LogTitle","columnName":"操作标题","columnType":"VARCHAR","dbColumn":"log_title","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseOptLog","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"log_title","orderNo":1},{"columnCode":"LogUrl","columnName":"日志请求地址","columnType":"VARCHAR","dbColumn":"log_url","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseOptLog","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"log_url","orderNo":2},{"columnCode":"HttpMethod","columnName":"请求方式","columnType":"VARCHAR","dbColumn":"http_method","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseOptLog","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"http_method","orderNo":3},{"columnCode":"JavaMethod","columnName":"java方法调用","columnType":"VARCHAR","dbColumn":"java_method","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseOptLog","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"java_method","orderNo":4},{"columnCode":"OptType","columnName":"操作类型","columnType":"VARCHAR","dbColumn":"opt_type","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseOptLog","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"opt_type","orderNo":5},{"columnCode":"OptTime","columnName":"操作时间","columnType":"DATE","dbColumn":"opt_time","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseOptLog","notNull":0,"oldColumnType":"DATE","oldDbColumn":"opt_time","orderNo":6},{"columnCode":"OptIp","columnName":"操作的IP地址","columnType":"VARCHAR","dbColumn":"opt_ip","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseOptLog","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"opt_ip","orderNo":7},{"columnCode":"TimeCost","columnName":"操作耗时","columnType":"BIGINT","dbColumn":"time_cost","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseOptLog","notNull":0,"oldColumnType":"BIGINT","oldDbColumn":"time_cost","orderNo":8},{"columnCode":"Success","columnName":"响应是否成功","columnType":"VARCHAR","dbColumn":"success","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseOptLog","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"success","orderNo":9},{"columnCode":"Response","columnName":"响应结果","columnType":"VARCHAR","dbColumn":"response","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseOptLog","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"response","orderNo":10},{"columnCode":"Request","columnName":"请求内容","columnType":"VARCHAR","dbColumn":"request","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseOptLog","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"request","orderNo":11},{"columnCode":"OptDescription","columnName":"操作的文字描述,使用SpEL表达式解析后的文字内容","columnType":"VARCHAR","dbColumn":"opt_description","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseOptLog","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"opt_description","orderNo":12},{"columnCode":"OperatorId","columnName":"操作人ID","columnType":"BIGINT","dbColumn":"operator_id","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseOptLog","notNull":0,"oldColumnType":"BIGINT","oldDbColumn":"operator_id","orderNo":13},{"columnCode":"OperatorName","columnName":"操作人姓名","columnType":"VARCHAR","dbColumn":"operator_name","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseOptLog","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"operator_name","orderNo":14},{"columnCode":"Deleted","columnName":"逻辑删除","columnType":"LOGIC_DELETE","dbColumn":"deleted","embed":1,"linkModel":"","linkModelColumn":"","modelCode":"BaseOptLog","oldColumnType":"LOGIC_DELETE","oldDbColumn":"deleted","orderNo":999},{"columnCode":"CreateBy","columnName":"创建人","columnType":"BIGINT","dbColumn":"create_by","embed":1,"linkModel":"","linkModelColumn":"","modelCode":"BaseOptLog","oldColumnType":"BIGINT","oldDbColumn":"create_by","orderNo":1000},{"columnCode":"ModifyBy","columnName":"修改人","columnType":"BIGINT","dbColumn":"modify_by","embed":1,"linkModel":"","linkModelColumn":"","modelCode":"BaseOptLog","oldColumnType":"BIGINT","oldDbColumn":"modify_by","orderNo":1001},{"columnCode":"CreateTime","columnName":"创建时间","columnType":"DATETIME","dbColumn":"create_time","embed":1,"linkModel":"","linkModelColumn":"","modelCode":"BaseOptLog","oldColumnType":"DATETIME","oldDbColumn":"create_time","orderNo":1002},{"columnCode":"ModifyTime","columnName":"修改时间","columnType":"DATETIME","dbColumn":"modify_time","embed":1,"linkModel":"","linkModelColumn":"","modelCode":"BaseOptLog","oldColumnType":"DATETIME","oldDbColumn":"modify_time","orderNo":1003}]', 0, 0, 0, '2023-08-01 15:56:10.201', '2023-08-01 15:56:10.201', 1, '{"list":{"enable":false},"cascade":{"enable":false}}'
    WHERE NOT EXISTS (SELECT 1 FROM des_data_model WHERE model_code = 'BaseLogOpt');

INSERT INTO des_data_model ("model_id", "model_code", "model_name", "db_table", "old_db_table", "model_type","model_group",  "synced", "description", "column_json", "deleted", "create_by", "modify_by", "create_time", "modify_time", "embed", "cache_json")
SELECT 237123213197313, 'BaseMenu', '菜单表', 'base_menu', 'base_menu', 'TABLE', 'base',1, '菜单表', '[{"columnCode":"MenuId","columnName":"菜单ID","columnType":"ID","dbColumn":"menu_id","embed":0,"isPk":1,"linkModel":"","linkModelColumn":"","modelCode":"BaseMenu","notNull":1,"oldColumnType":"ID","oldDbColumn":"menu_id","orderNo":0},{"columnCode":"MenuCode","columnName":"菜单编码","columnType":"VARCHAR","dbColumn":"menu_code","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseMenu","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"menu_code","orderNo":1},{"columnCode":"MenuPid","columnName":"上级菜单id","columnType":"VARCHAR","dbColumn":"menu_pid","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseMenu","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"menu_pid","orderNo":2},{"columnCode":"Name","columnName":"菜单名称","columnType":"VARCHAR","dbColumn":"name","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseMenu","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"name","orderNo":3},{"columnCode":"Path","columnName":"菜单地址","columnType":"VARCHAR","dbColumn":"path","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseMenu","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"path","orderNo":4},{"columnCode":"Icon","columnName":"菜单图表","columnType":"VARCHAR","dbColumn":"icon","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseMenu","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"icon","orderNo":5},{"columnCode":"Embed","columnName":"是否内置","columnType":"VARCHAR","dbColumn":"embed","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseMenu","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"embed","orderNo":6},{"columnCode":"OpenType","columnName":"菜单打开方式","columnType":"VARCHAR","dbColumn":"open_type","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseMenu","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"open_type","orderNo":7},{"columnCode":"Enabled","columnName":"是否启用","columnType":"VARCHAR","dbColumn":"enabled","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseMenu","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"enabled","orderNo":8},{"columnCode":"OrderNo","columnName":"顺序号","columnType":"BIGINT","dbColumn":"ord_no","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseMenu","notNull":0,"oldColumnType":"BIGINT","oldDbColumn":"ord_no","orderNo":9},{"columnCode":"Deleted","columnName":"逻辑删除","columnType":"LOGIC_DELETE","dbColumn":"deleted","embed":1,"linkModel":"","linkModelColumn":"","modelCode":"BaseMenu","oldColumnType":"LOGIC_DELETE","oldDbColumn":"deleted","orderNo":999},{"columnCode":"CreateBy","columnName":"创建人","columnType":"BIGINT","dbColumn":"create_by","embed":1,"linkModel":"","linkModelColumn":"","modelCode":"BaseMenu","oldColumnType":"BIGINT","oldDbColumn":"create_by","orderNo":1000},{"columnCode":"ModifyBy","columnName":"修改人","columnType":"BIGINT","dbColumn":"modify_by","embed":1,"linkModel":"","linkModelColumn":"","modelCode":"BaseMenu","oldColumnType":"BIGINT","oldDbColumn":"modify_by","orderNo":1001},{"columnCode":"CreateTime","columnName":"创建时间","columnType":"DATETIME","dbColumn":"create_time","embed":1,"linkModel":"","linkModelColumn":"","modelCode":"BaseMenu","oldColumnType":"DATETIME","oldDbColumn":"create_time","orderNo":1002},{"columnCode":"ModifyTime","columnName":"修改时间","columnType":"DATETIME","dbColumn":"modify_time","embed":1,"linkModel":"","linkModelColumn":"","modelCode":"BaseMenu","oldColumnType":"DATETIME","oldDbColumn":"modify_time","orderNo":1003}]', 0, 0, 0, '2023-08-01 16:05:59.611', '2023-08-01 16:05:59.611', 1, '{"list":{"enable":false},"cascade":{"enable":false}}'
    WHERE NOT EXISTS (SELECT 1 FROM des_data_model WHERE model_code = 'BaseMenu');

INSERT INTO des_data_model ("model_id", "model_code", "model_name", "db_table", "old_db_table", "model_type", "model_group", "synced", "description", "column_json", "deleted", "create_by", "modify_by", "create_time", "modify_time", "embed", "cache_json")
SELECT 237124010115073, 'BaseParam', '参数表', 'base_param', 'base_param', 'TABLE', 'base',1, '参数表', '[{"columnCode":"ParamId","columnName":"参数ID","columnType":"ID","dbColumn":"param_id","embed":0,"isPk":1,"linkModel":"","linkModelColumn":"","modelCode":"BaseParam","notNull":1,"oldColumnType":"ID","oldDbColumn":"param_id","orderNo":0},{"columnCode":"ParamCode","columnName":"参数编码","columnType":"VARCHAR","dbColumn":"param_code","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseParam","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"param_code","orderNo":1},{"columnCode":"ParamName","columnName":"名称","columnType":"VARCHAR","dbColumn":"param_name","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseParam","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"param_name","orderNo":2},{"columnCode":"ParamGroup","columnName":"参数分组","columnType":"VARCHAR","dbColumn":"param_group","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseParam","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"param_group","orderNo":3},{"columnCode":"Value","columnName":"参数值","columnType":"VARCHAR","dbColumn":"value","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseParam","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"value","orderNo":4},{"columnCode":"DefaultValue","columnName":"默认值","columnType":"VARCHAR","dbColumn":"default_value","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseParam","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"default_value","orderNo":5},{"columnCode":"ParamType","columnName":"参数类型","columnType":"VARCHAR","dbColumn":"param_type","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseParam","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"param_type","orderNo":6},{"columnCode":"Embed","columnName":"是否内置参数","columnType":"VARCHAR","dbColumn":"embed","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseParam","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"embed","orderNo":7},{"columnCode":"AnonAccess","columnName":"是否可以匿名访问","columnType":"VARCHAR","dbColumn":"anon_access","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseParam","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"anon_access","orderNo":8},{"columnCode":"Options","columnName":"附加项","columnType":"VARCHAR","dbColumn":"options","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseParam","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"options","orderNo":9},{"columnCode":"Description","columnName":"描述","columnType":"VARCHAR","dbColumn":"description","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseParam","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"description","orderNo":10},{"columnCode":"Deleted","columnName":"逻辑删除","columnType":"LOGIC_DELETE","dbColumn":"deleted","embed":1,"linkModel":"","linkModelColumn":"","modelCode":"BaseParam","oldColumnType":"LOGIC_DELETE","oldDbColumn":"deleted","orderNo":999},{"columnCode":"CreateBy","columnName":"创建人","columnType":"BIGINT","dbColumn":"create_by","embed":1,"linkModel":"","linkModelColumn":"","modelCode":"BaseParam","oldColumnType":"BIGINT","oldDbColumn":"create_by","orderNo":1000},{"columnCode":"ModifyBy","columnName":"修改人","columnType":"BIGINT","dbColumn":"modify_by","embed":1,"linkModel":"","linkModelColumn":"","modelCode":"BaseParam","oldColumnType":"BIGINT","oldDbColumn":"modify_by","orderNo":1001},{"columnCode":"CreateTime","columnName":"创建时间","columnType":"DATETIME","dbColumn":"create_time","embed":1,"linkModel":"","linkModelColumn":"","modelCode":"BaseParam","oldColumnType":"DATETIME","oldDbColumn":"create_time","orderNo":1002},{"columnCode":"ModifyTime","columnName":"修改时间","columnType":"DATETIME","dbColumn":"modify_time","embed":1,"linkModel":"","linkModelColumn":"","modelCode":"BaseParam","oldColumnType":"DATETIME","oldDbColumn":"modify_time","orderNo":1003}]', 0, 0, 0, '2023-08-01 16:12:19.975', '2023-08-01 16:12:19.975', 1, '{"list":{"enable":false},"cascade":{"enable":false}}'
    WHERE NOT EXISTS (SELECT 1 FROM des_data_model WHERE model_code = 'BaseParam');

INSERT INTO des_data_model ("model_id", "model_code", "model_name", "db_table", "old_db_table", "model_type", "model_group", "synced", "description", "column_json", "deleted", "create_by", "modify_by", "create_time", "modify_time", "embed", "cache_json")
SELECT 237124427448321, 'BaseRoleAuth', '角色权限', 'base_role_auth', 'base_role_auth', 'TABLE', 'base',1, '角色权限', '[{"columnCode":"RoleAuthId","columnName":"映射ID","columnType":"ID","dbColumn":"role_auth_id","embed":0,"isPk":1,"linkModel":"","linkModelColumn":"","modelCode":"BaseRoleAuth","notNull":1,"oldColumnType":"ID","oldDbColumn":"role_auth_id","orderNo":0},{"columnCode":"RoleId","columnName":"角色ID","columnType":"FK","dbColumn":"role_id","embed":0,"isPk":0,"linkModel":"BaseRole","linkModelColumn":"RoleId","modelCode":"BaseRoleAuth","notNull":0,"oldColumnType":"FK","oldDbColumn":"role_id","orderNo":1},{"columnCode":"AuthCode","columnName":"权限编码","columnType":"VARCHAR","dbColumn":"auth_code","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseRoleAuth","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"auth_code","orderNo":2},{"columnCode":"AuthType","columnName":"权限类型","columnType":"VARCHAR","dbColumn":"auth_type","embed":0,"isPk":0,"linkModel":"","linkModelColumn":"","modelCode":"BaseRoleAuth","notNull":0,"oldColumnType":"VARCHAR","oldDbColumn":"auth_type","orderNo":3},{"columnCode":"CreateBy","columnName":"创建人","columnType":"BIGINT","dbColumn":"create_by","embed":1,"linkModel":"","linkModelColumn":"","modelCode":"BaseRoleAuth","oldColumnType":"BIGINT","oldDbColumn":"create_by","orderNo":1000},{"columnCode":"ModifyBy","columnName":"修改人","columnType":"BIGINT","dbColumn":"modify_by","embed":1,"linkModel":"","linkModelColumn":"","modelCode":"BaseRoleAuth","oldColumnType":"BIGINT","oldDbColumn":"modify_by","orderNo":1001},{"columnCode":"CreateTime","columnName":"创建时间","columnType":"DATETIME","dbColumn":"create_time","embed":1,"linkModel":"","linkModelColumn":"","modelCode":"BaseRoleAuth","oldColumnType":"DATETIME","oldDbColumn":"create_time","orderNo":1002},{"columnCode":"ModifyTime","columnName":"修改时间","columnType":"DATETIME","dbColumn":"modify_time","embed":1,"linkModel":"","linkModelColumn":"","modelCode":"BaseRoleAuth","oldColumnType":"DATETIME","oldDbColumn":"modify_time","orderNo":1003}]', 0, 0, 0, '2023-08-01 16:15:38.959', '2023-08-01 16:15:38.959', 1, '{"list":{"enable":false},"cascade":{"enable":false}}'
    WHERE NOT EXISTS (SELECT 1 FROM des_data_model WHERE model_code = 'BaseRoleAuth');

INSERT INTO des_data_model ("model_id", "model_code", "model_name", "db_table", "old_db_table", "model_type","model_group",  "synced", "description", "column_json", "deleted", "create_by", "modify_by", "create_time", "modify_time", "embed", "cache_json")
SELECT 237124903501825, 'BaseRoleUser', '角色用户', 'base_role_user', 'base_role_user', 'TABLE', 'base',1, '角色用户', '[{"columnCode":"RoleUserId","columnName":"映射ID","columnType":"ID","dbColumn":"role_user_id","embed":0,"isPk":1,"linkModel":"","linkModelColumn":"","modelCode":"BaseRoleUser","notNull":1,"oldColumnType":"ID","oldDbColumn":"role_user_id","orderNo":0},{"columnCode":"RoleId","columnName":"角色id","columnType":"FK","dbColumn":"role_id","embed":0,"isPk":0,"linkModel":"BaseRole","linkModelColumn":"RoleId","modelCode":"BaseRoleUser","notNull":0,"oldColumnType":"FK","oldDbColumn":"role_id","orderNo":1},{"columnCode":"UserId","columnName":"用户ID","columnType":"FK","dbColumn":"user_id","embed":0,"isPk":0,"linkModel":"BaseUser","linkModelColumn":"UserId","modelCode":"BaseRoleUser","notNull":0,"oldColumnType":"FK","oldDbColumn":"user_id","orderNo":2}]', 0, 0, 0, '2023-08-01 16:19:25.96', '2023-08-01 16:19:25.96', 1, '{"list":{"enable":false},"cascade":{"enable":false}}'
    WHERE NOT EXISTS (SELECT 1 FROM des_data_model WHERE model_code = 'BaseRoleUser');