/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.modules.db.util;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson2.JSONObject;
import com.kdgcsoft.iframe.web.common.exception.BizException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class TreeBuilder4Magic {
    private static final String KEY_LABEL = "key";
    private static final String PARENT_KEY_LABEL = "parentKey";
    private static final String CHILDREN_LABEL = "children";
    private String keyLabel = "key";
    private String parentKeyLabel = "parentKey";
    private String childrenLabel = "children";
    private String keyMap;
    private String parentKeyMap;
    private List<Map<String, Object>> data;
    private RootNodeParentKeyType rootNodeParentKeyType = RootNodeParentKeyType.ZERO;
    private boolean isNotRewriteAttrNames;

    public static TreeBuilder4Magic builder() {
        return new TreeBuilder4Magic();
    }

    public List<Map<String, Object>> tree() {
        if (this.isNotRewriteAttrNames) {
            this.keyLabel = this.keyMap;
            this.parentKeyLabel = this.parentKeyMap;
        }
        if (CollUtil.isEmpty(this.data)) {
            return Collections.emptyList();
        }
        HashMap<Object, JSONObject> map = new HashMap<Object, JSONObject>();
        try {
            for (Map<String, Object> row : this.data) {
                JSONObject parent;
                JSONObject item = new JSONObject(row);
                if (row.containsKey(this.keyMap)) {
                    item.put((Object)this.keyLabel, row.get(this.keyMap));
                }
                if (row.containsKey(this.parentKeyMap)) {
                    item.put((Object)this.parentKeyLabel, row.get(this.parentKeyMap));
                }
                if (!item.containsKey(this.keyLabel)) continue;
                Object key = item.get(this.keyLabel);
                if (map.containsKey(key)) {
                    JSONObject exists = (JSONObject)map.get(key);
                    item.put((Object)this.childrenLabel, exists.get(this.childrenLabel));
                }
                map.put(key, item);
                Object parentKey = item.get(this.parentKeyLabel);
                if (this.isRootNode(parentKey)) continue;
                if (!map.containsKey(parentKey)) {
                    map.put(parentKey, new JSONObject());
                }
                if (!(parent = (JSONObject)map.get(parentKey)).containsKey(this.childrenLabel)) {
                    parent.put((Object)this.childrenLabel, new ArrayList());
                }
                List children = (List)parent.get(this.childrenLabel);
                children.add(item);
            }
            return map.values().stream().filter(jsonObject -> !map.containsKey(jsonObject.get(this.parentKeyLabel))).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new BizException(e.getMessage(), (Throwable)e);
        }
    }

    public TreeBuilder4Magic useData(List<Map<String, Object>> data) {
        this.data = data;
        return this;
    }

    public TreeBuilder4Magic keyMap(String keyMap) {
        this.keyMap = keyMap;
        return this;
    }

    public TreeBuilder4Magic parentKeyMap(String parentKeyMap) {
        this.parentKeyMap = parentKeyMap;
        return this;
    }

    public TreeBuilder4Magic keyLabel(String keyLabel) {
        this.keyLabel = keyLabel;
        return this;
    }

    public TreeBuilder4Magic parentKeyLabel(String parentKeyLabel) {
        this.parentKeyLabel = parentKeyLabel;
        return this;
    }

    public TreeBuilder4Magic childrenLabel(String childrenLabel) {
        this.childrenLabel = childrenLabel;
        return this;
    }

    public TreeBuilder4Magic rootNodeParentKeyType(RootNodeParentKeyType type) {
        this.rootNodeParentKeyType = type;
        return this;
    }

    public TreeBuilder4Magic notRewriteAttrName() {
        this.isNotRewriteAttrNames = true;
        return this;
    }

    private boolean isRootNode(Object parentValue) {
        if (null == parentValue) {
            return true;
        }
        if (this.rootNodeParentKeyType == RootNodeParentKeyType.ZERO) {
            return Long.parseLong(parentValue.toString()) == 0L;
        }
        return false;
    }

    public static enum RootNodeParentKeyType {
        NULL,
        ZERO;

    }
}

