/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.iframe.web.design.util;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.db.DbRuntimeException;
import cn.hutool.db.meta.Column;
import cn.hutool.db.meta.ColumnIndexInfo;
import cn.hutool.db.meta.IndexInfo;
import cn.hutool.db.meta.MetaUtil;
import cn.hutool.db.meta.Table;
import cn.hutool.db.meta.TableType;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.List;
import javax.sql.DataSource;

public class DbMetaUtil
extends MetaUtil {
    public static Table getTableMeta(DataSource ds, TableType tableType, String tableName) {
        if (tableType == TableType.TABLE) {
            return DbMetaUtil.getTableMeta((DataSource)ds, (String)tableName);
        }
        if (tableType == TableType.VIEW) {
            Table table = Table.create((String)tableName);
            try (Connection conn = ds.getConnection();){
                String catalog = DbMetaUtil.getCatalog((Connection)conn);
                table.setCatalog(catalog);
                String schema = DbMetaUtil.getSchema((Connection)conn);
                table.setSchema(schema);
                DatabaseMetaData metaData = conn.getMetaData();
                try (ResultSet rs = metaData.getTables(catalog, schema, tableName, new String[]{TableType.VIEW.value()});){
                    if (null != rs && rs.next()) {
                        table.setComment(rs.getString("REMARKS"));
                    }
                }
                rs = metaData.getPrimaryKeys(catalog, schema, tableName);
                try {
                    if (null != rs) {
                        while (rs.next()) {
                            table.addPk(rs.getString("COLUMN_NAME"));
                        }
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
                rs = metaData.getColumns(catalog, schema, tableName, null);
                try {
                    if (null != rs) {
                        while (rs.next()) {
                            table.setColumn(Column.create((Table)table, (ResultSet)rs));
                        }
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
                rs = metaData.getIndexInfo(catalog, schema, tableName, false, false);
                try {
                    LinkedHashMap<String, IndexInfo> indexInfoMap = new LinkedHashMap<String, IndexInfo>();
                    if (null != rs) {
                        while (rs.next()) {
                            if (0 == rs.getShort("TYPE")) continue;
                            String indexName = rs.getString("INDEX_NAME");
                            String key = StrUtil.join((CharSequence)"&", (Object[])new Object[]{tableName, indexName});
                            IndexInfo indexInfo = (IndexInfo)indexInfoMap.get(key);
                            if (null == indexInfo) {
                                indexInfo = new IndexInfo(rs.getBoolean("NON_UNIQUE"), indexName, tableName, schema, catalog);
                                indexInfoMap.put(key, indexInfo);
                            }
                            indexInfo.getColumnIndexInfoList().add(ColumnIndexInfo.create((ResultSet)rs));
                        }
                    }
                    table.setIndexInfoList((List)ListUtil.toList(indexInfoMap.values()));
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            catch (SQLException e) {
                throw new DbRuntimeException("Get columns error!", (Throwable)e);
            }
            return table;
        }
        return null;
    }
}

