/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.iframe.web.design.trans;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.fhs.core.trans.vo.TransPojo;
import com.kdgcsoft.iframe.web.common.utils.id.ShortId;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ConstPool;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.StringMemberValue;

public class DynamicTransPojoClassGenerator {
    private final Map<String, String> transMap;
    private final Map<String, String> transNameMap;
    private final boolean needSetTransName;
    private Class<?> dynamicClass;

    public DynamicTransPojoClassGenerator(Map<String, String> transMap, Map<String, String> transNameMap) {
        this.transMap = transMap;
        this.transNameMap = transNameMap;
        this.needSetTransName = CollUtil.isNotEmpty(transNameMap);
    }

    public TransPojo instance(Map<String, Object> fieldValues) throws Exception {
        Object instance = this.dynamicClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        if (CollUtil.isEmpty(fieldValues) || CollUtil.isEmpty(this.transMap)) {
            return (TransPojo)instance;
        }
        for (String key : this.transMap.keySet()) {
            if (!fieldValues.containsKey(key)) continue;
            Object fieldValue = fieldValues.get(key);
            Field field = this.dynamicClass.getDeclaredField(key);
            field.setAccessible(true);
            field.set(instance, String.valueOf(fieldValue));
        }
        return (TransPojo)instance;
    }

    public List<Field> getAnnoFields() {
        Field[] fields = this.dynamicClass.getDeclaredFields();
        ArrayList<Field> annoFields = new ArrayList<Field>();
        for (Field field : fields) {
            if (!this.transMap.containsKey(field.getName())) continue;
            annoFields.add(field);
        }
        return annoFields;
    }

    public void generate() throws Exception {
        ClassPool pool = ClassPool.getDefault();
        String id = ShortId.getId();
        CtClass ctClass = pool.makeClass("com.kdgcsoft.iframe.web.design.trans.DynamicTransPojo" + id);
        ctClass.setInterfaces(new CtClass[]{pool.get("com.fhs.core.trans.vo.TransPojo")});
        CtField idField = new CtField(pool.get("java.lang.Long"), "idColumn" + id, ctClass);
        ConstPool idCP = idField.getFieldInfo().getConstPool();
        FieldInfo idFieldInfo = idField.getFieldInfo();
        AnnotationsAttribute idAttrInfo = (AnnotationsAttribute)idFieldInfo.getAttribute("RuntimeVisibleAnnotations");
        if (null == idAttrInfo) {
            List attributeInfos = idFieldInfo.getAttributes();
            idAttrInfo = !attributeInfos.isEmpty() ? (AnnotationsAttribute)attributeInfos.get(0) : new AnnotationsAttribute(idFieldInfo.getConstPool(), "RuntimeVisibleAnnotations");
        }
        idAttrInfo.addAnnotation(new Annotation("com.baomidou.mybatisplus.annotation.TableId", idCP));
        idFieldInfo.addAttribute((AttributeInfo)idAttrInfo);
        ctClass.addField(idField);
        if (CollUtil.isNotEmpty(this.transMap)) {
            for (Map.Entry<String, String> entry : this.transMap.entrySet()) {
                String targetField;
                String fieldName = entry.getKey();
                String dictCode = entry.getValue();
                CtField ctField = new CtField(pool.get("java.lang.String"), fieldName, ctClass);
                ConstPool cp = ctField.getFieldInfo().getConstPool();
                FieldInfo fieldInfo = ctField.getFieldInfo();
                AnnotationsAttribute attributeInfo = (AnnotationsAttribute)fieldInfo.getAttribute("RuntimeVisibleAnnotations");
                if (null == attributeInfo) {
                    List attributeInfos = fieldInfo.getAttributes();
                    attributeInfo = !attributeInfos.isEmpty() ? (AnnotationsAttribute)attributeInfos.get(0) : new AnnotationsAttribute(fieldInfo.getConstPool(), "RuntimeVisibleAnnotations");
                }
                Annotation annotation = new Annotation("com.fhs.core.trans.anno.Trans", cp);
                annotation.addMemberValue("type", (MemberValue)new StringMemberValue("dictionary", cp));
                annotation.addMemberValue("key", (MemberValue)new StringMemberValue(dictCode, cp));
                if (this.needSetTransName && this.transNameMap.containsKey(fieldName) && StrUtil.isNotBlank((CharSequence)(targetField = this.transNameMap.get(fieldName)))) {
                    annotation.addMemberValue("ref", (MemberValue)new StringMemberValue(targetField, cp));
                }
                attributeInfo.addAnnotation(annotation);
                fieldInfo.addAttribute((AttributeInfo)attributeInfo);
                ctClass.addField(ctField);
            }
        }
        this.dynamicClass = ctClass.toClass(DynamicTransPojoClassGenerator.class.getClassLoader(), DynamicTransPojoClassGenerator.class.getProtectionDomain());
    }
}

