/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.iframe.web.design.trans;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson2.JSON;
import com.kdgcsoft.iframe.web.common.utils.CascadeUtil;
import com.kdgcsoft.iframe.web.config.trans.TransCache;
import com.kdgcsoft.iframe.web.config.trans.TransCacheServiceProvider;
import com.kdgcsoft.iframe.web.design.entity.DesDataModel;
import com.kdgcsoft.iframe.web.design.pojo.DataModelCacheCascadeConfig;
import com.kdgcsoft.iframe.web.design.pojo.DataModelCacheListConfig;
import com.kdgcsoft.iframe.web.design.pojo.DesDataModelCacheConfig;
import com.kdgcsoft.iframe.web.design.service.DesDataModelService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.service.AnylineService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DesignTransCacheServiceProvider
implements TransCacheServiceProvider {
    @Autowired
    private DesDataModelService dataModelService;
    @Autowired
    private AnylineService<?> anylineService;

    public List<TransCache> provides() {
        List modelList = this.dataModelService.list();
        ArrayList<TransCache> transCaches = new ArrayList<TransCache>();
        if (CollUtil.isEmpty((Collection)modelList)) {
            return transCaches;
        }
        for (DesDataModel model : modelList) {
            TransCache transCache = this.buildTransCache(model);
            if (null == transCache) continue;
            transCaches.add(transCache);
        }
        return transCaches;
    }

    public TransCache buildTransCache(DesDataModel model) {
        final String tableName = model.getDbTable();
        final String modelCode = model.getModelCode();
        if (StrUtil.isNotBlank((CharSequence)model.getCacheJson())) {
            DesDataModelCacheConfig cacheConfig = (DesDataModelCacheConfig)JSON.parseObject((String)model.getCacheJson(), DesDataModelCacheConfig.class);
            final DataModelCacheListConfig listConfig = cacheConfig.getList();
            final DataModelCacheCascadeConfig cascadeConfig = cacheConfig.getCascade();
            return new TransCache(){

                public String groupCode() {
                    return modelCode;
                }

                public boolean listCacheEnabled() {
                    return listConfig.isEnable();
                }

                public boolean cascadeCacheEnabled() {
                    return cascadeConfig.isEnable();
                }

                public Map<String, String> listCache() {
                    HashMap<String, String> transMap = new HashMap<String, String>();
                    String keyColumn = listConfig.getKey();
                    String textColumn = listConfig.getText();
                    DataSet ds = DesignTransCacheServiceProvider.this.anylineService.querys(tableName + "(" + keyColumn + "," + textColumn + ")", new String[]{"deleted = 0"});
                    for (DataRow row : ds) {
                        transMap.put(String.valueOf(row.get(keyColumn)), String.valueOf(row.get(textColumn)));
                    }
                    return transMap;
                }

                public Map<String, String> cascadeCache() {
                    HashMap<String, String> transMap = new HashMap<String, String>();
                    String keyColumn = cascadeConfig.getKey();
                    String parentKeyColumn = cascadeConfig.getParentKey();
                    String textColumn = cascadeConfig.getText();
                    DataSet ds = DesignTransCacheServiceProvider.this.anylineService.querys(tableName + "(" + keyColumn + "," + parentKeyColumn + "," + textColumn + ")", new String[]{"deleted = 0"});
                    ArrayList<CascadeUtil.CascadeItem> data = new ArrayList<CascadeUtil.CascadeItem>();
                    for (DataRow dataRow : ds) {
                        data.add(new CascadeUtil.CascadeItem(dataRow.get(keyColumn), dataRow.get(parentKeyColumn), String.valueOf(dataRow.get(textColumn))));
                    }
                    CascadeUtil.cascade(data, (String)"/");
                    for (CascadeUtil.CascadeItem cascadeItem : data) {
                        transMap.put(String.valueOf(cascadeItem.getKey()), cascadeItem.getCascadeText());
                    }
                    return transMap;
                }
            };
        }
        return null;
    }
}

