/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.iframe.web.design.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.github.yulichang.base.MPJBaseServiceImpl;
import com.kdgcsoft.iframe.web.common.interfaces.IDesPageModelService;
import com.kdgcsoft.iframe.web.common.pojo.PageRequest;
import com.kdgcsoft.iframe.web.design.embed.dict.DesPageType;
import com.kdgcsoft.iframe.web.design.entity.DesPageModel;
import com.kdgcsoft.iframe.web.design.mapper.DesPageModelMapper;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
@CacheConfig(cacheNames={"DesPageModel"})
public class DesPageModelService
extends MPJBaseServiceImpl<DesPageModelMapper, DesPageModel>
implements IDesPageModelService {
    public static final String CACHE_NAME = "DesPageModel";

    public PageRequest pagePageModel(PageRequest pageRequest, String searchKey) {
        return (PageRequest)((DesPageModelMapper)this.baseMapper).selectPage((IPage)pageRequest, (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().like(StrUtil.isNotBlank((CharSequence)searchKey), DesPageModel::getPageCode, (Object)searchKey)).or()).like(StrUtil.isNotBlank((CharSequence)searchKey), DesPageModel::getPageName, (Object)searchKey)).orderByDesc(DesPageModel::getPageId));
    }

    public boolean hasRepeat(DesPageModel entity) {
        return ((DesPageModelMapper)this.baseMapper).exists((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DesPageModel::getPageName, (Object)entity.getPageName())).ne(entity.getPageId() != null, DesPageModel::getPageId, (Object)entity.getPageId()));
    }

    @Cacheable(key="#root.methodName+'.'+#pageCode")
    public DesPageModel getByPageCode(String pageCode) {
        return (DesPageModel)((Object)((DesPageModelMapper)this.baseMapper).selectOne((Wrapper)new QueryWrapper().lambda().eq(DesPageModel::getPageCode, (Object)pageCode)));
    }

    @Cacheable(key="#root.methodName+'.'+#pageId")
    public DesPageModel getByPageId(Long pageId) {
        return (DesPageModel)((Object)this.getById(pageId));
    }

    @CacheEvict(allEntries=true)
    public DesPageModel saveEntity(DesPageModel entity) {
        if (ObjectUtils.isNotEmpty((Object)entity.getPageId()) && DesPageType.MODAL.equals((Object)entity.getPageType())) {
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.eq(DesPageModel::getPageId, (Object)entity.getPageId())).set(DesPageModel::getMenuId, null)).set(DesPageModel::getPageType, (Object)entity.getPageType())).set(DesPageModel::getPageName, (Object)entity.getPageName())).set(DesPageModel::getModelId, (Object)entity.getModelId())).set(DesPageModel::getModelGroup, (Object)entity.getModelGroup())).set(DesPageModel::getCustom, (Object)entity.getCustom())).set(DesPageModel::getCustomPath, (Object)entity.getCustomPath());
            this.update((Wrapper)updateWrapper);
        } else {
            this.saveOrUpdate((Object)entity);
        }
        return entity;
    }

    @CacheEvict(allEntries=true)
    public void removeByPageId(Long id) {
        ((DesPageModelMapper)this.baseMapper).deleteById(id);
    }

    public boolean isRepeat(DesPageModel entity) {
        return ((DesPageModelMapper)this.baseMapper).exists((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DesPageModel::getPageName, (Object)entity.getPageName())).or()).eq(entity.getPageId() != null, DesPageModel::getPageId, (Object)entity.getPageId()));
    }

    public Map<Long, Long> listHasMenu() {
        List pageList = this.list((Wrapper)new LambdaQueryWrapper().isNotNull(DesPageModel::getMenuId));
        HashMap<Long, Long> pageMap = CollUtil.isNotEmpty((Collection)pageList) ? pageList.stream().collect(Collectors.toMap(DesPageModel::getMenuId, DesPageModel::getPageId, (p1, p2) -> p1)) : new HashMap<Long, Long>();
        return pageMap;
    }
}

