/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.iframe.web.design.service;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.github.yulichang.base.MPJBaseServiceImpl;
import com.kdgcsoft.iframe.web.common.exception.BizException;
import com.kdgcsoft.iframe.web.common.pojo.PageRequest;
import com.kdgcsoft.iframe.web.design.entity.DesModuleConfig;
import com.kdgcsoft.iframe.web.design.mapper.DesModuleConfigMapper;
import java.util.List;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.stereotype.Service;

@Service
@CacheConfig(cacheNames={"DesModuleConfig"})
public class DesModuleConfigService
extends MPJBaseServiceImpl<DesModuleConfigMapper, DesModuleConfig> {
    public static final String CACHE_NAME = "DesModuleConfig";

    public void saveDesModuleConfig(DesModuleConfig entity) {
        String moduleCode = entity.getMainModelCode();
        DesModuleConfig exists = this.getByModuleCode(moduleCode);
        if (exists != null) {
            throw new BizException("\u6a21\u5757\u7f16\u7801 [ " + moduleCode + " ] \u5df2\u7ecf\u5b58\u5728!");
        }
        entity.setModuleCode(moduleCode);
        entity.setEmbed(0);
        this.save((Object)entity);
    }

    private DesModuleConfig getByModuleCode(String moduleCode) {
        return (DesModuleConfig)((Object)((DesModuleConfigMapper)this.baseMapper).selectOne((Wrapper)new QueryWrapper().lambda().eq(DesModuleConfig::getModuleCode, (Object)moduleCode)));
    }

    public void updateDesModuleConfig(DesModuleConfig entity) {
        this.updateById((Object)entity);
    }

    public PageRequest pageModuleConfig(PageRequest pageRequest, String searchKey) {
        return (PageRequest)((DesModuleConfigMapper)this.baseMapper).selectPage((IPage)pageRequest, this.getQueryWrapperBySearchKey(searchKey));
    }

    public List<DesModuleConfig> listModuleConfig(String searchKey) {
        return ((DesModuleConfigMapper)this.baseMapper).selectList(this.getQueryWrapperBySearchKey(searchKey));
    }

    private Wrapper getQueryWrapperBySearchKey(String searchKey) {
        return (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().like(StrUtil.isNotBlank((CharSequence)searchKey), DesModuleConfig::getModuleCode, (Object)searchKey)).or()).like(StrUtil.isNotBlank((CharSequence)searchKey), DesModuleConfig::getModuleName, (Object)searchKey)).or()).like(StrUtil.isNotBlank((CharSequence)searchKey), DesModuleConfig::getMainModelCode, (Object)searchKey)).orderByDesc(DesModuleConfig::getId);
    }
}

