/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.iframe.web.design.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.github.yulichang.base.MPJBaseServiceImpl;
import com.kdgcsoft.iframe.web.common.pojo.PageRequest;
import com.kdgcsoft.iframe.web.common.utils.TreeBuilder;
import com.kdgcsoft.iframe.web.design.entity.DesMagicApi;
import com.kdgcsoft.iframe.web.design.mapper.DesMagicApiMapper;
import com.kdgcsoft.iframe.web.design.pojo.MagicApiInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class DesMagicApiService
extends MPJBaseServiceImpl<DesMagicApiMapper, DesMagicApi> {
    public MagicApiInfo getById(String id) {
        DesMagicApi api = (DesMagicApi)((DesMagicApiMapper)this.baseMapper).selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().likeRight(DesMagicApi::getFilePath, (Object)"magic-api/api/")).ne(DesMagicApi::getFilePath, (Object)"magic-api/api/")).ne(DesMagicApi::getFileContent, (Object)"this is directory")).like(DesMagicApi::getFileContent, (Object)id));
        if (null != api) {
            return MagicApiInfo.of(api);
        }
        return null;
    }

    public PageRequest<MagicApiInfo> pageQuery(PageRequest<MagicApiInfo> page, String search) {
        List<MagicApiInfo> allApis = this.buildApiInfo0(search);
        if (CollUtil.isNotEmpty(allApis = allApis.stream().filter(info -> !info.isDir()).collect(Collectors.toList()))) {
            page.setTotal((long)allApis.size());
            int fromIndex = (int)((page.getCurrent() - 1L) * page.getSize());
            int toIndex = Math.min((int)((long)fromIndex + page.getSize()), allApis.size());
            if (fromIndex < allApis.size() - 1) {
                page.setRecords(allApis.subList(fromIndex, toIndex));
            }
        } else {
            page.setTotal(0L);
        }
        return page;
    }

    public List<?> list(String search) {
        List<DesMagicApi> list = this.queryAllApiData();
        if (CollUtil.isNotEmpty(list)) {
            return list.stream().map(MagicApiInfo::of).filter(info -> !info.isDir()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private List<MagicApiInfo> buildApiInfo0(String search) {
        List<DesMagicApi> allApis = this.queryAllApiData();
        if (CollUtil.isNotEmpty(allApis)) {
            ArrayList<MagicApiInfo> dataList = new ArrayList<MagicApiInfo>();
            HashMap<String, MagicApiInfo> map = new HashMap<String, MagicApiInfo>();
            for (DesMagicApi api : allApis) {
                MagicApiInfo info2 = MagicApiInfo.of(api);
                dataList.add(info2);
                map.put(info2.getName(), info2);
            }
            dataList.forEach(info -> {
                if (null != info.getParentName()) {
                    info.setParentId(((MagicApiInfo)map.get(info.getParentName())).getId());
                    List<String> allParentNames = info.getAllParentNames();
                    String parentUrl = allParentNames.stream().map(map::get).filter(Objects::nonNull).map(MagicApiInfo::getPath).collect(Collectors.joining("/"));
                    info.setUrl("/" + parentUrl + "/" + info.getPath());
                } else {
                    info.setUrl("/" + info.getPath());
                }
            });
            return StrUtil.isBlank((CharSequence)search) ? dataList : dataList.stream().filter(info -> {
                if (StrUtil.isNotBlank((CharSequence)info.getName()) && info.getName().contains(search)) {
                    return true;
                }
                return StrUtil.isNotBlank((CharSequence)info.getFullParentName()) && info.getFullParentName().contains(search);
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public List<?> tree(String search) {
        List<MagicApiInfo> dataList = this.buildApiInfo0(search);
        if (CollUtil.isNotEmpty(dataList)) {
            return TreeBuilder.builder().keyMap("id").parentKeyMap("parentId").titleMap("name").rootNodeParentKeyType(TreeBuilder.RootNodeParentKeyType.NULL).useData(dataList).tree();
        }
        return null;
    }

    private List<DesMagicApi> queryAllApiData() {
        return ((DesMagicApiMapper)this.baseMapper).selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().likeRight(DesMagicApi::getFilePath, (Object)"magic-api/api/")).ne(DesMagicApi::getFilePath, (Object)"magic-api/api/")).ne(DesMagicApi::getFileContent, (Object)"this is directory"));
    }

    public List<DesMagicApi> queryAllApiCategories() {
        return ((DesMagicApiMapper)this.baseMapper).selectList((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().likeRight(DesMagicApi::getFilePath, (Object)"magic-api/api/")).like(DesMagicApi::getFileContent, (Object)"this is directory"));
    }

    public List<DesMagicApi> queryAllCategoriesApis(String category) {
        return ((DesMagicApiMapper)this.baseMapper).selectList((Wrapper)new QueryWrapper().lambda().likeRight(DesMagicApi::getFilePath, (Object)category));
    }
}

