/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.iframe.web.design.service;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.ZipUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.kdgcsoft.iframe.web.common.exception.BizException;
import com.kdgcsoft.iframe.web.common.utils.CommonDownloadUtil;
import com.kdgcsoft.iframe.web.design.entity.DesDataModel;
import com.kdgcsoft.iframe.web.design.entity.DesDataModelColumn;
import com.kdgcsoft.iframe.web.design.entity.DesGeneratePage;
import com.kdgcsoft.iframe.web.design.entity.GenBasicPreviewResult;
import com.kdgcsoft.iframe.web.design.service.DesDataModelService;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.beetl.core.Configuration;
import org.beetl.core.GroupTemplate;
import org.beetl.core.ResourceLoader;
import org.beetl.core.Template;
import org.beetl.core.resource.ClasspathResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DesGeneratePageService {
    private static final Logger log = LoggerFactory.getLogger(DesGeneratePageService.class);
    @Autowired
    DesDataModelService desDataModelService;
    private static final List<JSONObject> GEN_FRONT_FILE_LIST = CollectionUtil.newArrayList((Object[])new JSONObject[]{JSONUtil.createObj().set("name", (Object)"Api.js.btl").set("path", (Object)"api"), JSONUtil.createObj().set("name", (Object)"form.vue.btl").set("path", (Object)"views"), JSONUtil.createObj().set("name", (Object)"index.vue.btl").set("path", (Object)"views")});
    private static final List<JSONObject> GEN_BACKEND_FILE_LIST = CollectionUtil.newArrayList((Object[])new JSONObject[]{JSONUtil.createObj().set("name", (Object)"Controller.java.btl").set("path", (Object)"controller"), JSONUtil.createObj().set("name", (Object)"Service.java.btl").set("path", (Object)"service"), JSONUtil.createObj().set("name", (Object)"Entity.java.btl").set("path", (Object)"entity"), JSONUtil.createObj().set("name", (Object)"Mapper.java.btl").set("path", (Object)"mapper"), JSONUtil.createObj().set("name", (Object)"Mapper.xml.btl").set("path", (Object)("mapper" + File.separator + "mapping"))});

    @Transactional(rollbackFor={Exception.class})
    public void generateZip(DesGeneratePage desGeneratePage, HttpServletResponse response) throws IOException {
        try {
            File tempFolder = this.genTempFolder(desGeneratePage, response);
            if (tempFolder == null) {
                throw new BizException("\u4ee3\u7801\u751f\u6210\u57fa\u7840\u4e0d\u5b58\u5728");
            }
            File zip = ZipUtil.zip((File)tempFolder);
            FileUtil.del((File)tempFolder);
            CommonDownloadUtil.download((File)zip, (HttpServletResponse)response);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new BizException(e.getMessage());
        }
    }

    private File genTempFolder(DesGeneratePage desGeneratePage, HttpServletResponse response) throws IOException {
        DesDataModel desDataModel = this.desDataModelService.getByModelCode(desGeneratePage.getModelCode());
        GenBasicPreviewResult genBasicPreviewResult = this.previewGen(desGeneratePage, desDataModel);
        FileUtil.del((String)(FileUtil.getTmpDirPath() + File.separator + desDataModel.getModelCode() + ".zip"));
        File tempFolder = FileUtil.file((String)(FileUtil.getTmpDirPath() + File.separator + desDataModel.getModelCode()));
        genBasicPreviewResult.getGenBasicCodeFrontendResultList().forEach(genBasicCodeResult -> FileUtil.writeUtf8String((String)genBasicCodeResult.getCodeFileContent(), (File)FileUtil.file((String)(tempFolder + File.separator + "frontend" + File.separator + genBasicCodeResult.getCodeFileWithPathName()))));
        genBasicPreviewResult.getGenBasicCodeBackendResultList().forEach(genBasicCodeResult -> FileUtil.writeUtf8String((String)genBasicCodeResult.getCodeFileContent(), (File)FileUtil.file((String)(tempFolder + File.separator + "backend" + File.separator + genBasicCodeResult.getCodeFileWithPathName()))));
        return tempFolder;
    }

    public GenBasicPreviewResult previewGen(DesGeneratePage desGeneratePage, DesDataModel desDataModel) {
        JSONObject bindingJsonObject = this.getBindingJsonObject(desGeneratePage, desDataModel);
        GenBasicPreviewResult genBasicPreviewResult = new GenBasicPreviewResult();
        try {
            String genFrontBasicPath = "";
            GroupTemplate groupTemplateFront = new GroupTemplate((ResourceLoader)new ClasspathResourceLoader("gen/" + desGeneratePage.getGenPageType().getTemplateDir() + "/frontend"), Configuration.defaultConfiguration());
            ArrayList genBasicCodeFrontendResultList = CollectionUtil.newArrayList((Object[])new GenBasicPreviewResult.GenBasicCodeResult[0]);
            GEN_FRONT_FILE_LIST.forEach(fileJsonObject -> {
                String fileTemplateName = fileJsonObject.getStr((Object)"name");
                String fileTemplatePath = fileJsonObject.getStr((Object)"path");
                GenBasicPreviewResult.GenBasicCodeResult genBasicCodeFrontResult = new GenBasicPreviewResult.GenBasicCodeResult();
                Template templateFront = groupTemplateFront.getTemplate((Object)fileTemplateName);
                templateFront.binding((Map)bindingJsonObject);
                String resultName = StrUtil.removeSuffix((CharSequence)fileTemplateName, (CharSequence)".btl");
                if (fileTemplateName.equalsIgnoreCase("Api.js.btl")) {
                    resultName = StrUtil.lowerFirst((CharSequence)desDataModel.getModelCode()) + resultName;
                    genBasicCodeFrontResult.setCodeFileName(resultName);
                    genBasicCodeFrontResult.setCodeFileWithPathName(genFrontBasicPath + fileTemplatePath + File.separator + desGeneratePage.getFrontPath() + File.separator + desGeneratePage.getModuleName() + File.separator + resultName);
                } else {
                    genBasicCodeFrontResult.setCodeFileName(resultName);
                    genBasicCodeFrontResult.setCodeFileWithPathName(genFrontBasicPath + fileTemplatePath + File.separator + desGeneratePage.getFrontPath() + File.separator + desGeneratePage.getModuleName() + File.separator + bindingJsonObject.get((Object)"classNameFirstLower") + File.separator + resultName);
                }
                genBasicCodeFrontResult.setCodeFileContent(templateFront.render());
                genBasicCodeFrontendResultList.add(genBasicCodeFrontResult);
            });
            genBasicPreviewResult.setGenBasicCodeFrontendResultList(genBasicCodeFrontendResultList);
            String genBackendBasicPath = StrUtil.replace((CharSequence)desGeneratePage.getPackageName(), (CharSequence)".", (CharSequence)File.separator) + File.separator + desGeneratePage.getModuleName() + File.separator;
            GroupTemplate groupTemplateBackEnd = new GroupTemplate((ResourceLoader)new ClasspathResourceLoader("gen/" + desGeneratePage.getGenPageType().getTemplateDir() + "/backend"), Configuration.defaultConfiguration());
            ArrayList genBasicCodeBackendResultList = CollectionUtil.newArrayList((Object[])new GenBasicPreviewResult.GenBasicCodeResult[0]);
            GEN_BACKEND_FILE_LIST.forEach(fileJsonObject -> {
                String fileTemplateName = fileJsonObject.getStr((Object)"name");
                String fileTemplatePath = fileJsonObject.getStr((Object)"path");
                GenBasicPreviewResult.GenBasicCodeResult genBasicCodeBackendResult = new GenBasicPreviewResult.GenBasicCodeResult();
                Template templateBackend = groupTemplateBackEnd.getTemplate((Object)fileTemplateName);
                templateBackend.binding((Map)bindingJsonObject);
                String resultName = StrUtil.removeSuffix((CharSequence)fileTemplateName, (CharSequence)".btl");
                if (fileTemplateName.equalsIgnoreCase("Entity.java.btl")) {
                    resultName = ".java";
                }
                genBasicCodeBackendResult.setCodeFileName(desDataModel.getModelCode() + resultName);
                genBasicCodeBackendResult.setCodeFileWithPathName(genBackendBasicPath + fileTemplatePath + File.separator + desDataModel.getModelCode() + resultName);
                genBasicCodeBackendResult.setCodeFileContent(templateBackend.render());
                genBasicCodeBackendResultList.add(genBasicCodeBackendResult);
            });
            genBasicPreviewResult.setGenBasicCodeBackendResultList(genBasicCodeBackendResultList);
        }
        catch (Exception e) {
            log.error(">>> \u4ee3\u7801\u751f\u6210\u5f02\u5e38\uff1a", (Throwable)e);
            throw new BizException("\u4ee3\u7801\u751f\u6210\u5f02\u5e38");
        }
        return genBasicPreviewResult;
    }

    public JSONObject getBindingJsonObject(DesGeneratePage desGeneratePage, DesDataModel desDataModel) {
        DesDataModelColumn desDataModelColumn = desDataModel.getPkColumn();
        if (desDataModelColumn == null) {
            throw new BizException(StrUtil.format((CharSequence)(desDataModel.getModelName() + "[" + desDataModel.getDbTable() + "]\u6ca1\u627e\u5230\u4e3b\u952e"), (Object[])new Object[0]));
        }
        JSONObject bindingJsonObject = JSONUtil.createObj();
        bindingJsonObject.set("packageName", (Object)desGeneratePage.getPackageName());
        bindingJsonObject.set("moduleName", (Object)desGeneratePage.getModuleName());
        bindingJsonObject.set("frontPath", (Object)desGeneratePage.getFrontPath());
        bindingJsonObject.set("functionName", (Object)desDataModel.getModelName());
        bindingJsonObject.set("extendsBaseEntity", (Object)desGeneratePage.getExtendsBaseEntity());
        bindingJsonObject.set("dbTable", (Object)desDataModel.getDbTable());
        bindingJsonObject.set("className", (Object)desDataModel.getModelCode());
        bindingJsonObject.set("classNameFirstLower", (Object)StrUtil.lowerFirst((CharSequence)desDataModel.getModelCode()));
        bindingJsonObject.set("dbTableKey", (Object)desDataModelColumn.getColumnCode());
        bindingJsonObject.set("dbTableKeyJavaType", (Object)desDataModelColumn.getColumnType().type());
        bindingJsonObject.set("dbTableKeyCamelCase", (Object)StrUtil.lowerFirst((CharSequence)desDataModelColumn.getColumnCode()));
        bindingJsonObject.set("dbTableKeyRemark", (Object)desDataModelColumn.getColumnName());
        bindingJsonObject.set("authorName", (Object)desGeneratePage.getAuthorName());
        bindingJsonObject.set("genTime", (Object)DateUtil.format((Date)DateTime.now(), (String)" yyyy/MM/dd HH:mm"));
        ArrayList configList = CollectionUtil.newArrayList((Object[])new JSONObject[0]);
        desDataModel.getColumns().forEach(item -> {
            JSONObject configItem = JSONUtil.createObj();
            if (item.getColumnType().text().equals("\u4e3b\u952e")) {
                configItem.set("needTableId", (Object)true);
            } else {
                configItem.set("needTableId", (Object)false);
            }
            configItem.set("linkModel", (Object)item.getLinkModel());
            if (item.getColumnType().text().equals("\u5916\u952e")) {
                if (item.getModelCode().equals(item.getLinkModel())) {
                    configItem.set("fieldParent", (Object)StrUtil.lowerFirst((CharSequence)item.getColumnCode()));
                    configItem.set("fieldChildren", (Object)StrUtil.lowerFirst((CharSequence)item.getLinkModelColumn()));
                } else {
                    configItem.set("fieldParent", (Object)"");
                    configItem.set("fieldChildren", (Object)"");
                }
            } else {
                configItem.set("fieldParent", (Object)"");
                configItem.set("fieldChildren", (Object)"");
            }
            configItem.set("embed", (Object)(item.getEmbed() == 1 ? 1 : 0));
            configItem.set("effectType", (Object)item.getColumnType().text());
            configItem.set("dictTypeCode", (Object)item.getDictCode());
            configItem.set("fieldJavaType", (Object)item.getColumnType().type());
            configItem.set("fieldNameCamelCase", (Object)StrUtil.lowerFirst((CharSequence)item.getColumnCode()));
            configItem.set("fieldNameCamelCaseFirstUpper", (Object)item.getColumnCode());
            configItem.set("scale", (Object)item.getScale());
            configItem.set("fieldRemark", (Object)item.getColumnName());
            configList.add(configItem);
        });
        bindingJsonObject.set("configList", (Object)configList);
        return bindingJsonObject;
    }
}

