/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.iframe.web.design.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.kdgcsoft.iframe.web.base.enums.HideColumns;
import com.kdgcsoft.iframe.web.common.exception.BizException;
import com.kdgcsoft.iframe.web.common.pojo.JsonResult;
import com.kdgcsoft.iframe.web.config.trans.EasyTransDicCacheService;
import com.kdgcsoft.iframe.web.design.entity.DesDataModel;
import com.kdgcsoft.iframe.web.design.entity.DesDataModelColumn;
import com.kdgcsoft.iframe.web.design.entity.DesFormModel;
import com.kdgcsoft.iframe.web.design.form.config.obj.BizForm;
import com.kdgcsoft.iframe.web.design.form.config.obj.FileEntity;
import com.kdgcsoft.iframe.web.design.form.config.obj.FormEntity;
import com.kdgcsoft.iframe.web.design.form.config.obj.FormEntityAttr;
import com.kdgcsoft.iframe.web.design.form.config.obj.FormRegion;
import com.kdgcsoft.iframe.web.design.form.config.obj.FormRegionAttr;
import com.kdgcsoft.iframe.web.design.form.config.obj.dto.FormRegionComponentDTO;
import com.kdgcsoft.iframe.web.design.form.config.obj.dto.FormRegionDTO;
import com.kdgcsoft.iframe.web.design.interfaces.FormExecutionListener;
import com.kdgcsoft.iframe.web.design.service.DesDataModelService;
import com.kdgcsoft.iframe.web.design.service.DesFormModelService;
import com.kdgcsoft.iframe.web.doc.dto.DocFileDTO;
import com.kdgcsoft.iframe.web.doc.service.DocFileService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.service.AnylineService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DesFormService {
    private static final Logger log = LoggerFactory.getLogger(DesFormService.class);
    @Autowired
    private AnylineService<?> anylineService;
    @Autowired
    private DesDataModelService dataModelService;
    @Autowired
    private DocFileService docFileService;
    @Autowired
    private EasyTransDicCacheService easyTransDicCacheService;
    @Autowired
    private DesFormModelService formModelService;

    public JsonResult<?> validateForm(DesFormModel formModel, JSONObject fromData) {
        JsonResult validateResult;
        FormExecutionListener formExecutionListener = formModel.getFormExecutionListener();
        if (formExecutionListener != null) {
            formExecutionListener.beforeValidate();
        }
        if (formExecutionListener != null && !(validateResult = formExecutionListener.onFormValidate()).getSuccess().booleanValue()) {
            return validateResult;
        }
        return JsonResult.OK();
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveForm(DesFormModel formModel, JSONObject formData) {
        FormExecutionListener formExecutionListener = formModel.getFormExecutionListener();
        if (formExecutionListener != null) {
            formExecutionListener.beforeFormSave();
        }
        if (StrUtil.isBlank((CharSequence)formModel.getConfigJson())) {
            throw new BizException("\u8868\u5355\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        DesDataModel mainDataModel = (DesDataModel)((Object)this.dataModelService.getById(formModel.getModelId()));
        if (null == mainDataModel) {
            throw new BizException("\u6570\u636e\u6a21\u578b[" + formModel.getModelId() + "]\u4e0d\u5b58\u5728\uff01");
        }
        BizForm form = (BizForm)JSON.parseObject((String)formModel.getConfigJson(), BizForm.class);
        form.setMainDataModel(mainDataModel.getModelCode());
        form.splitRegions();
        Long mainModelDataId = form.generateMainModelDataId();
        FormEntity mainFormEntity = form.getMainFormEntity(mainDataModel);
        form.saveFormEntity(mainFormEntity, formData);
        List<FormEntity> subFormEntities = form.getSubFormEntity();
        form.saveFormEntities(subFormEntities, formData);
        List<FormEntity> subTableEntities = form.getSubTableEntity();
        form.saveFormEntities(subTableEntities, formData);
        List<FileEntity> fileListEntities = form.getFileListEntity();
        if (CollUtil.isNotEmpty(fileListEntities)) {
            ArrayList<DocFileDTO> dtos = new ArrayList<DocFileDTO>();
            for (FileEntity fileEntity : fileListEntities) {
                String name = fileEntity.getName();
                JSONArray array = formData.getJSONArray(name);
                if (null != array) {
                    for (int i = 0; i < array.size(); ++i) {
                        JSONObject item = array.getJSONObject(i);
                        if (!item.containsKey("fileId")) continue;
                        DocFileDTO dto = new DocFileDTO();
                        dto.setFileId(item.getLong("fileId"));
                        dto.setStdFileId(item.getLong("stdFileId"));
                        dto.setStdFileCode(item.getString("stdFileCode"));
                        dtos.add(dto);
                    }
                }
                this.docFileService.saveDocFileList(dtos, mainModelDataId, mainDataModel.getModelCode(), name);
            }
        }
        if (formExecutionListener != null) {
            formExecutionListener.afterFormSave();
        }
        if (formExecutionListener != null) {
            formExecutionListener.beforeFlowCreate();
        }
        if (formExecutionListener != null) {
            formExecutionListener.afterFlowCreate();
        }
    }

    private void queryFormData(DesDataModel dataModel) {
        String tableName = dataModel.getDbTable();
        List<DesDataModelColumn> columns = dataModel.getColumns();
        Optional<DesDataModelColumn> op = columns.stream().filter(col -> col.getIsPk() == 1).findFirst();
    }

    public JSONObject queryDataModelData(String formCode, Object pkId) {
        DesFormModel formModel = this.formModelService.getByFormCode(formCode);
        if (null == formCode || null == pkId) {
            return null;
        }
        DesDataModel dataModel = (DesDataModel)((Object)this.dataModelService.getById(formModel.getModelId()));
        if (null == dataModel) {
            return null;
        }
        String tableName = dataModel.getDbTable();
        List<DesDataModelColumn> columns = dataModel.getColumnsWithoutEmbedCols();
        if (CollUtil.isNotEmpty(columns)) {
            String idColumn = null;
            LinkedHashMap<String, String> columnMap = new LinkedHashMap<String, String>();
            for (DesDataModelColumn column : columns) {
                if (column.getIsPk() == 1) {
                    idColumn = column.getDbColumn();
                }
                columnMap.put(column.getColumnCode(), column.getDbColumn());
            }
            if (null != idColumn) {
                DataRow dataRow = this.anylineService.query(tableName, new String[]{idColumn + " = '" + pkId + "'"});
                JSONObject result = new JSONObject();
                for (Map.Entry entry : columnMap.entrySet()) {
                    result.put((Object)((String)entry.getKey()), dataRow.get((String)entry.getValue()));
                }
                return result;
            }
        }
        return null;
    }

    private JSONObject queryFromPk(DesDataModel dataModel, Long pkId, FormEntity formEntity) {
        String tableName = dataModel.getDbTable();
        List<DesDataModelColumn> columns = dataModel.getColumnsWithoutEmbedCols();
        HashMap<String, String> columnMap = new HashMap<String, String>();
        DesDataModelColumn pkColumn = null;
        JSONObject data = new JSONObject();
        if (CollUtil.isNotEmpty(columns)) {
            for (DesDataModelColumn column : columns) {
                columnMap.put(column.getColumnCode(), column.getDbColumn());
                if (column.getIsPk() != 1) continue;
                pkColumn = column;
            }
        }
        if (null != pkColumn) {
            Map<String, FormEntityAttr> attrs = formEntity.getAttrs();
            StringJoiner joiner = new StringJoiner(",", "(", ")");
            if (CollUtil.isNotEmpty(attrs)) {
                for (String key : attrs.keySet()) {
                    if (!columnMap.containsKey(key)) continue;
                    joiner.add((CharSequence)columnMap.get(key));
                }
                DataRow dataRow = this.anylineService.query(tableName + joiner, new String[]{pkColumn.getDbColumn() + " = " + pkId});
                for (Map.Entry entry : columnMap.entrySet()) {
                    data.put((Object)((String)entry.getKey()), dataRow.get((String)entry.getValue()));
                }
            }
        }
        return data;
    }

    public List<JSONObject> queryFromFk(DesDataModel dataModel, Long fkId, FormEntity formEntity, boolean multi, List<Long> notInIds) {
        String tableName = dataModel.getDbTable();
        List<DesDataModelColumn> columns = dataModel.getColumnsWithoutEmbedCols();
        HashMap<String, String> columnMap = new HashMap<String, String>();
        DesDataModelColumn fkColumn = null;
        DesDataModelColumn pkColumn = null;
        ArrayList<JSONObject> data = new ArrayList<JSONObject>();
        if (CollUtil.isNotEmpty(columns)) {
            for (DesDataModelColumn column : columns) {
                columnMap.put(column.getColumnCode(), column.getDbColumn());
                if (StrUtil.isNotBlank((CharSequence)column.getLinkModel()) && StrUtil.isNotBlank((CharSequence)column.getLinkModelColumn())) {
                    fkColumn = column;
                }
                if (column.getIsPk() != 1) continue;
                pkColumn = column;
            }
        }
        if (null != fkColumn && pkColumn != null) {
            Map<String, FormEntityAttr> attrs = formEntity.getAttrs();
            StringJoiner joiner = new StringJoiner(",", "(", ")");
            if (CollUtil.isNotEmpty(attrs)) {
                for (String key : attrs.keySet()) {
                    if (!columnMap.containsKey(key)) continue;
                    joiner.add((CharSequence)columnMap.get(key));
                }
                String condition = fkColumn.getDbColumn() + " = " + fkId;
                if (CollUtil.isNotEmpty(notInIds)) {
                    condition = condition + " AND " + pkColumn.getDbColumn() + " NOT IN " + CollUtil.join(notInIds, (CharSequence)",", (String)"(", (String)")");
                }
                if (multi) {
                    DataSet dataSet = this.anylineService.querys(tableName + joiner, new String[]{condition, "ORDER BY " + pkColumn.getDbColumn()});
                    for (DataRow dataRow : dataSet) {
                        JSONObject rowObj = new JSONObject();
                        for (Map.Entry entry : columnMap.entrySet()) {
                            rowObj.put((Object)((String)entry.getKey()), dataRow.get((String)entry.getValue()));
                        }
                        data.add(rowObj);
                    }
                } else {
                    DataRow dataRow = this.anylineService.query(tableName + joiner, new String[]{condition});
                    JSONObject rowObj = new JSONObject();
                    for (Map.Entry entry : columnMap.entrySet()) {
                        rowObj.put((Object)((String)entry.getKey()), dataRow.get((String)entry.getValue()));
                    }
                    data.add(rowObj);
                }
            }
        }
        return data;
    }

    public JSONObject queryForm(DesFormModel formModel, Long id) {
        List<FormEntity> subTableEntities;
        JSONObject result = new JSONObject();
        DesDataModel mainDataModel = (DesDataModel)((Object)this.dataModelService.getById(formModel.getModelId()));
        BizForm form = (BizForm)JSON.parseObject((String)formModel.getConfigJson(), BizForm.class);
        form.setMainDataModel(mainDataModel.getModelCode());
        form.splitRegions();
        FormEntity mainFormEntity = form.getMainFormEntity(mainDataModel);
        JSONObject mainFormData = this.queryFromPk(mainDataModel, id, mainFormEntity);
        result.put((Object)mainFormEntity.getName(), (Object)mainFormData);
        ArrayList<Long> notInIds = new ArrayList<Long>();
        List<FormEntity> subFormEntities = form.getSubFormEntity();
        if (CollUtil.isNotEmpty(subFormEntities)) {
            for (FormEntity subFormEntity : subFormEntities) {
                DesDataModel subDataModel = this.dataModelService.getByModelCode(subFormEntity.getDataModelCode());
                List<JSONObject> list = this.queryFromFk(subDataModel, id, subFormEntity, false, notInIds);
                if (list.size() <= 0) continue;
                JSONObject data = list.get(0);
                result.put((Object)subFormEntity.getName(), (Object)data);
                notInIds.add(data.getLong(subFormEntity.getPkColumnCode()));
            }
        }
        if (CollUtil.isNotEmpty(subTableEntities = form.getSubTableEntity())) {
            for (FormEntity subTableEntity : subTableEntities) {
                DesDataModel subDataModel = this.dataModelService.getByModelCode(subTableEntity.getDataModelCode());
                List<JSONObject> list = this.queryFromFk(subDataModel, id, subTableEntity, true, notInIds);
                result.put((Object)subTableEntity.getName(), list);
                for (JSONObject obj : list) {
                    notInIds.add(obj.getLong(subTableEntity.getPkColumnCode()));
                }
            }
        }
        return result;
    }

    public String transItem(String echoCode, String value, boolean transCascade) {
        if (StrUtil.isBlank((CharSequence)value)) {
            return value;
        }
        return this.easyTransDicCacheService.transOne(echoCode, value, transCascade);
    }

    public List<FormRegionDTO> getFormItems(DesFormModel formModel, boolean mainForm) {
        BizForm form = (BizForm)JSON.parseObject((String)formModel.getConfigJson(), BizForm.class);
        form.splitRegions();
        List<FormRegion> regions = mainForm ? form.getMainFormRegions() : form.getItems();
        if (CollUtil.isNotEmpty(regions)) {
            return regions.stream().filter(FormRegion::isDataItem).map(formRegion -> {
                List<DesDataModelColumn> columns;
                DesDataModel dataModel;
                HashMap<String, DesDataModelColumn> columnMap = new HashMap<String, DesDataModelColumn>();
                FormRegionAttr attr = formRegion.getAttr();
                if (null != attr && StrUtil.isNotBlank((CharSequence)attr.getDataModelCode()) && null != (dataModel = this.dataModelService.getByModelCode(attr.getDataModelCode())) && CollUtil.isNotEmpty(columns = dataModel.getColumns())) {
                    for (DesDataModelColumn col : columns) {
                        columnMap.put(col.getColumnCode(), col);
                    }
                }
                return FormRegionDTO.of(formRegion, columnMap);
            }).filter(dto -> CollUtil.isNotEmpty(dto.getItems())).collect(Collectors.toList());
        }
        return null;
    }

    public List<FormRegionDTO> getFormItems(DesFormModel formModel) {
        List<DesDataModelColumn> columns0;
        DesDataModel dataModel = (DesDataModel)((Object)this.dataModelService.getById(formModel.getModelId()));
        List<Object> columns = new ArrayList();
        if (null != dataModel && CollUtil.isNotEmpty(columns0 = dataModel.getColumns())) {
            columns = columns0;
        }
        List<FormRegionComponentDTO> items = columns.stream().filter(col -> !HideColumns.isHideColumn((String)col.getColumnCode())).map(col -> {
            FormRegionComponentDTO component = new FormRegionComponentDTO();
            component.setId(col.getColumnCode());
            component.setName(col.getColumnCode());
            component.setLabel(col.getColumnName());
            component.setType(col.getColumnType());
            return component;
        }).collect(Collectors.toList());
        FormRegionDTO dto = new FormRegionDTO();
        dto.setId("mainForm");
        dto.setName("mainForm");
        dto.setItems(items);
        return Collections.singletonList(dto);
    }
}

