/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.iframe.web.design.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.github.yulichang.base.MPJBaseServiceImpl;
import com.github.yulichang.toolkit.MPJStringUtils;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import com.kdgcsoft.iframe.web.common.exception.BizException;
import com.kdgcsoft.iframe.web.common.pojo.PageRequest;
import com.kdgcsoft.iframe.web.design.entity.DesDataModel;
import com.kdgcsoft.iframe.web.design.entity.DesFormModel;
import com.kdgcsoft.iframe.web.design.entity.DesModelRelation;
import com.kdgcsoft.iframe.web.design.mapper.DesFormModelMapper;
import com.kdgcsoft.iframe.web.design.service.DesDataModelService;
import com.kdgcsoft.iframe.web.design.service.DesModelRelationService;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@CacheConfig(cacheNames={"DesFormModel"})
public class DesFormModelService
extends MPJBaseServiceImpl<DesFormModelMapper, DesFormModel> {
    public static final String CACHE_NAME = "DesFormModel";
    @Resource
    DesModelRelationService relationService;
    @Resource
    DesDataModelService desDataModelService;

    public PageRequest pageFormModel(PageRequest pageRequest, Integer custom, String searchKey, List<String> dictItemIds) {
        return (PageRequest)((DesFormModelMapper)this.baseMapper).selectPage((IPage)pageRequest, (Wrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)new MPJLambdaWrapper().select(new SFunction[]{DesDataModel::getModelName}).selectAs(DesDataModel::getModelCode, DesFormModel::getDataModel)).selectAll(DesFormModel.class)).leftJoin(DesDataModel.class, DesDataModel::getModelId, DesFormModel::getModelId)).in(!dictItemIds.isEmpty(), DesFormModel::getModelGroup, dictItemIds)).eq(custom != null, DesFormModel::getCustom, (Object)custom)).like(StrUtil.isNotBlank((CharSequence)searchKey), DesFormModel::getFormCode, (Object)searchKey)).or()).like(StrUtil.isNotBlank((CharSequence)searchKey), DesFormModel::getFormName, (Object)searchKey)).orderByDesc(DesFormModel::getFormId));
    }

    public boolean hasRepeat(DesFormModel entity) {
        return ((DesFormModelMapper)this.baseMapper).exists((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DesFormModel::getFormName, (Object)entity.getFormName())).ne(entity.getFormId() != null, DesFormModel::getFormId, (Object)entity.getFormId()));
    }

    @Cacheable(key="#root.methodName+'.'+#formCode")
    public DesFormModel getByFormCode(String formCode) {
        return (DesFormModel)((Object)((DesFormModelMapper)this.baseMapper).selectOne((Wrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)new MPJLambdaWrapper().selectAll(DesFormModel.class)).selectAs(DesDataModel::getModelCode, DesFormModel::getDataModel)).selectAs(DesDataModel::getModelName, DesFormModel::getModelName)).leftJoin(DesDataModel.class, DesDataModel::getModelId, DesFormModel::getModelId)).eq(DesFormModel::getFormCode, (Object)formCode)));
    }

    @Cacheable(key="#root.methodName+'.'+#formId")
    public DesFormModel getByFormId(Long formId) {
        return (DesFormModel)((Object)this.getById(formId));
    }

    @CacheEvict(allEntries=true)
    public DesFormModel saveEntity(DesFormModel entity) {
        this.saveOrUpdate((Object)entity);
        return entity;
    }

    @CacheEvict(allEntries=true)
    public void removeByFormId(Long id) {
        ((DesFormModelMapper)this.baseMapper).deleteById(id);
    }

    public boolean isRepeat(DesFormModel entity) {
        return ((DesFormModelMapper)this.baseMapper).exists((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DesFormModel::getFormName, (Object)entity.getFormName())).or()).eq(entity.getFormId() != null, DesFormModel::getFormId, (Object)entity.getFormId()));
    }

    @Transactional(rollbackFor={Throwable.class})
    public void removeByBusinessKey(Long businessKey, Long modelId) {
        DesDataModel dataModel = (DesDataModel)((Object)this.desDataModelService.getById(modelId));
        if (ObjectUtil.isNotNull((Object)((Object)dataModel))) {
            String keyName = this.desDataModelService.getPrimaryKey(dataModel.getColumns());
            String tableName = dataModel.getDbTable();
            ((DesFormModelMapper)this.baseMapper).deleteByBusinessKey(businessKey, tableName, keyName);
            List<DesModelRelation> refList = this.relationService.listCasDel(modelId);
            if (CollUtil.isNotEmpty(refList)) {
                refList.forEach(ref -> {
                    Long relModelId = ref.getRelModelId();
                    DesDataModel refDataModel = (DesDataModel)((Object)((Object)this.desDataModelService.getById(relModelId)));
                    String refTblName = refDataModel.getDbTable();
                    String refColCode = MPJStringUtils.camelToUnderline((String)ref.getRelModelColCode());
                    String modelColCode = MPJStringUtils.camelToUnderline((String)ref.getModelColCode());
                    ((DesFormModelMapper)this.baseMapper).deleteRelByBusinessKey(businessKey, refTblName, refColCode);
                });
            }
        } else {
            throw new BizException("\u4e0d\u5b58\u5728\u8be5\u6570\u636e\u6a21\u578b");
        }
    }
}

