/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.iframe.web.design.service;

import cn.afterturn.easypoi.entity.ImageEntity;
import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.TemplateExportParams;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.ZipUtil;
import cn.hutool.db.Db;
import cn.hutool.db.DbUtil;
import cn.hutool.db.Entity;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.config.Configure;
import com.deepoove.poi.config.ConfigureBuilder;
import com.deepoove.poi.data.AttachmentType;
import com.deepoove.poi.data.Attachments;
import com.deepoove.poi.data.Pictures;
import com.deepoove.poi.plugin.table.LoopColumnTableRenderPolicy;
import com.deepoove.poi.plugin.table.LoopRowTableRenderPolicy;
import com.deepoove.poi.policy.AttachmentRenderPolicy;
import com.deepoove.poi.policy.RenderPolicy;
import com.github.yulichang.base.MPJBaseServiceImpl;
import com.kdgcsoft.iframe.web.common.exception.BizException;
import com.kdgcsoft.iframe.web.common.pojo.PageRequest;
import com.kdgcsoft.iframe.web.common.utils.CommonDownloadUtil;
import com.kdgcsoft.iframe.web.design.entity.DesExportTemplate;
import com.kdgcsoft.iframe.web.design.entity.DesFormModel;
import com.kdgcsoft.iframe.web.design.mapper.DesExportTemplateMapper;
import com.kdgcsoft.iframe.web.design.service.DesFormModelService;
import com.kdgcsoft.iframe.web.design.util.WordToPdf;
import com.kdgcsoft.iframe.web.design.vo.FlowProcessCommentVo;
import com.kdgcsoft.iframe.web.design.vo.FlowTaskAttachmentVo;
import com.kdgcsoft.iframe.web.doc.service.DocumentService;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.apache.poi.ss.usermodel.Workbook;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.history.HistoricTaskInstanceQuery;
import org.camunda.bpm.engine.task.Comment;
import org.dromara.x.file.storage.core.FileInfo;
import org.dromara.x.file.storage.core.FileStorageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
@CacheConfig(cacheNames={"DesExportTemplate"})
public class DesExportTemplateService
extends MPJBaseServiceImpl<DesExportTemplateMapper, DesExportTemplate> {
    public static final String CACHE_NAME = "DesExportTemplate";
    @Autowired
    DocumentService documentService;
    @Autowired
    DesFormModelService desFormModelService;
    @Autowired
    private FileStorageService fileStorageService;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private TaskService taskService;
    @Autowired
    DataSource dataSource;

    public PageRequest pageExportTemplate(PageRequest pageRequest, String searchKey, List<String> childrenValues) {
        return (PageRequest)((DesExportTemplateMapper)this.baseMapper).selectPage((IPage)pageRequest, (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().in(CollUtil.isNotEmpty(childrenValues), DesExportTemplate::getModelGroup, childrenValues)).and(StrUtil.isNotEmpty((CharSequence)searchKey), w -> ((LambdaQueryWrapper)((LambdaQueryWrapper)w.like(DesExportTemplate::getTemplateCode, (Object)searchKey)).or()).like(DesExportTemplate::getTemplateName, (Object)searchKey))).orderByDesc(DesExportTemplate::getTemplateId));
    }

    public boolean hasRepeat(DesExportTemplate entity) {
        return ((DesExportTemplateMapper)this.baseMapper).exists((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DesExportTemplate::getTemplateName, (Object)entity.getTemplateName())).ne(entity.getTemplateId() != null, DesExportTemplate::getTemplateId, (Object)entity.getTemplateId()));
    }

    @Cacheable(key="#root.methodName+'.'+#templateCode")
    public DesExportTemplate getByTemplateCode(String templateCode) {
        return (DesExportTemplate)((Object)((DesExportTemplateMapper)this.baseMapper).selectOne((Wrapper)new QueryWrapper().lambda().eq(DesExportTemplate::getTemplateCode, (Object)templateCode)));
    }

    @Cacheable(key="#root.methodName+'.'+#templateId")
    public DesExportTemplate getByTemplateId(Long templateId) {
        return (DesExportTemplate)((Object)this.getById(templateId));
    }

    @CacheEvict(allEntries=true)
    public void removeByTemplateId(Long id) {
        ((DesExportTemplateMapper)this.baseMapper).deleteById(id);
    }

    public boolean isRepeat(DesExportTemplate entity) {
        return ((DesExportTemplateMapper)this.baseMapper).exists((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DesExportTemplate::getTemplateName, (Object)entity.getTemplateName())).or()).eq(entity.getTemplateId() != null, DesExportTemplate::getTemplateId, (Object)entity.getTemplateId()));
    }

    public void exportTemplate(Long primaryKey, String formCode, HttpServletResponse resp) {
        HashMap<String, Object> dataSourceResultMap = new HashMap<String, Object>();
        DesFormModel desFormModel = this.desFormModelService.getByFormCode(formCode);
        DesExportTemplate desExportTemplate = this.getByTemplateId(desFormModel.getTemplateId());
        FileInfo fileInfo = this.documentService.getFileByFileId(desExportTemplate.getTemplateFile());
        ByteArrayInputStream inputStream = new ByteArrayInputStream(this.fileStorageService.download(fileInfo).bytes());
        LoopRowTableRenderPolicy policy = new LoopRowTableRenderPolicy();
        LoopColumnTableRenderPolicy columnPolicy = new LoopColumnTableRenderPolicy();
        ConfigureBuilder builder = Configure.newBuilder();
        builder.useSpringEL(false);
        Path tempDir = null;
        Path tempFile = null;
        HashMap<String, FlowProcessCommentVo> workFlowMap = new HashMap<String, FlowProcessCommentVo>();
        String procInstId = null;
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(primaryKey.toString()).singleResult();
        if (historicProcessInstance != null) {
            procInstId = historicProcessInstance.getRootProcessInstanceId();
        }
        if (procInstId != null) {
            List<FlowProcessCommentVo> commentList = this.getFlwProcessDetailComment(procInstId);
            Integer i = 0;
            while (i < commentList.size()) {
                workFlowMap.put(String.valueOf(i + 1), commentList.get(i));
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
        }
        dataSourceResultMap.put("workFlowData", workFlowMap);
        List dataSourceList = JSONArray.parseArray((String)desExportTemplate.getDataSource(), JSONObject.class);
        Db db = DbUtil.use((DataSource)this.dataSource);
        for (JSONObject dataSource : dataSourceList) {
            if ("SQL".equals(dataSource.get("type"))) {
                String stringSql = JSONObject.parseObject((String)JSONObject.toJSONString((Object)dataSource.get("config"), (JSONWriter.Feature[])new JSONWriter.Feature[0])).get("sql").toString();
                String replaceSql = StrUtil.replace((CharSequence)stringSql, (CharSequence)"#{primaryKey}", (CharSequence)primaryKey.toString());
                try {
                    List sqlResultList = db.query(replaceSql, new Object[0]);
                    if (sqlResultList.size() == 0) {
                        HashMap singleEntityMap = new HashMap();
                        ArrayList singleMapList = new ArrayList();
                        builder.bind(dataSource.getString("code") + "List", (RenderPolicy)policy);
                        dataSourceResultMap.put(dataSource.getString("code") + "List", singleMapList);
                        builder.bind(dataSource.getString("code") + "ColumnList", (RenderPolicy)columnPolicy);
                        dataSourceResultMap.put(dataSource.getString("code") + "ColumnList", singleMapList);
                        dataSourceResultMap.put(dataSource.getString("code") + "Map", singleEntityMap);
                    }
                    if (sqlResultList.size() == 1) {
                        Entity entity2 = (Entity)sqlResultList.get(0);
                        HashMap<String, Object> singleEntityMap = new HashMap<String, Object>();
                        ArrayList<HashMap<String, Object>> singleMapList = new ArrayList<HashMap<String, Object>>();
                        entity2.getFieldNames().stream().forEach(fieldName -> singleEntityMap.put((String)fieldName, entity2.get(fieldName)));
                        if (singleEntityMap.containsKey("file_id") && singleEntityMap.get("file_id") != null) {
                            Long fileId = Long.valueOf(singleEntityMap.get("file_id").toString());
                            FileInfo attachmentInfo = this.documentService.getFileByFileId(fileId);
                            String fileType = attachmentInfo.getOriginalFilename().substring(attachmentInfo.getOriginalFilename().lastIndexOf(".") + 1);
                            ByteArrayInputStream attachmentInputStream = new ByteArrayInputStream(this.fileStorageService.download(attachmentInfo).bytes());
                            builder.bind(dataSource.getString("code") + "Attachment", (RenderPolicy)new AttachmentRenderPolicy());
                            if ("docx".equals(fileType)) {
                                dataSourceResultMap.put(dataSource.getString("code") + "Attachment", Attachments.ofStream((InputStream)attachmentInputStream, (AttachmentType)AttachmentType.DOCX).create());
                            } else if ("xlsx".equals(fileType)) {
                                dataSourceResultMap.put(dataSource.getString("code") + "Attachment", Attachments.ofStream((InputStream)attachmentInputStream, (AttachmentType)AttachmentType.XLSX).create());
                            }
                        }
                        for (String key : singleEntityMap.keySet()) {
                            byte[] imageBytes;
                            if (!key.startsWith("image_id")) continue;
                            FileInfo imageInfo = null;
                            if (singleEntityMap.get(key) != null && !"".equals(singleEntityMap.get(key))) {
                                imageInfo = this.documentService.getFileByFileId(Long.valueOf(singleEntityMap.get(key).toString()));
                            }
                            if (imageInfo == null || (imageBytes = this.fileStorageService.download(imageInfo).bytes()) == null || imageBytes.length <= 0) continue;
                            if ("Word".equals(desExportTemplate.getTemplateType())) {
                                ByteArrayInputStream imageInputStream = new ByteArrayInputStream(imageBytes);
                                singleEntityMap.put(key + "Image", Pictures.ofStream((InputStream)imageInputStream).size(120, 80).create());
                                continue;
                            }
                            if (!"Excel".equals(desExportTemplate.getTemplateType())) continue;
                            ImageEntity imageEntity = new ImageEntity();
                            imageEntity.setData(imageBytes);
                            imageEntity.setWidth(120);
                            imageEntity.setHeight(80);
                            singleEntityMap.put(key + "Image", imageEntity);
                        }
                        singleMapList.add(singleEntityMap);
                        builder.bind(dataSource.getString("code") + "List", (RenderPolicy)policy);
                        dataSourceResultMap.put(dataSource.getString("code") + "List", singleMapList);
                        builder.bind(dataSource.getString("code") + "ColumnList", (RenderPolicy)columnPolicy);
                        dataSourceResultMap.put(dataSource.getString("code") + "ColumnList", singleMapList);
                        dataSourceResultMap.put(dataSource.getString("code") + "Map", singleEntityMap);
                        continue;
                    }
                    List multipleMapList = sqlResultList.stream().map(entity -> {
                        HashMap<String, Object> singleEntityMap = new HashMap<String, Object>();
                        entity.getFieldNames().stream().forEach(fieldName -> singleEntityMap.put((String)fieldName, entity.get(fieldName)));
                        for (String key : singleEntityMap.keySet()) {
                            byte[] imageBytes;
                            if (!key.startsWith("image_id")) continue;
                            FileInfo imageInfo = null;
                            if (singleEntityMap.get(key) != null && !"".equals(singleEntityMap.get(key))) {
                                imageInfo = this.documentService.getFileByFileId(Long.valueOf(singleEntityMap.get(key).toString()));
                            }
                            if (imageInfo == null || (imageBytes = this.fileStorageService.download(imageInfo).bytes()) == null || imageBytes.length <= 0) continue;
                            if ("Word".equals(desExportTemplate.getTemplateType())) {
                                ByteArrayInputStream imageInputStream = new ByteArrayInputStream(imageBytes);
                                singleEntityMap.put(key + "Image", Pictures.ofStream((InputStream)imageInputStream).size(120, 80).create());
                                continue;
                            }
                            if (!"Excel".equals(desExportTemplate.getTemplateType())) continue;
                            ImageEntity imageEntity = new ImageEntity();
                            imageEntity.setData(imageBytes);
                            imageEntity.setWidth(120);
                            imageEntity.setHeight(80);
                            singleEntityMap.put(key + "Image", imageEntity);
                        }
                        return singleEntityMap;
                    }).collect(Collectors.toList());
                    builder.bind(dataSource.getString("code") + "List", (RenderPolicy)policy);
                    dataSourceResultMap.put(dataSource.getString("code") + "List", multipleMapList);
                    builder.bind(dataSource.getString("code") + "ColumnList", (RenderPolicy)columnPolicy);
                    dataSourceResultMap.put(dataSource.getString("code") + "ColumnList", multipleMapList);
                    continue;
                }
                catch (SQLException e) {
                    throw new BizException(StrUtil.format((CharSequence)"\u6570\u636e\u6e90\u6267\u884c\u51fa\u9519,\u540d\u79f0:[{}],\u9519\u8bef:{}", (Object[])new Object[]{dataSource.get("name"), e.getMessage()}));
                }
            }
            if (!"JavaBean".equals(dataSource.get("type"))) continue;
        }
        Configure config = builder.build();
        XWPFTemplate compile = null;
        try {
            resp.reset();
            resp.setCharacterEncoding(StandardCharsets.UTF_8.name());
            resp.addHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode("\u5bfc\u51fa\u6570\u636e" + fileInfo.getOriginalFilename(), StandardCharsets.UTF_8.name()));
            resp.setContentType("application/octet-stream");
            if ("Word".equals(desExportTemplate.getTemplateType())) {
                compile = XWPFTemplate.compile((InputStream)inputStream, (Configure)config).render(dataSourceResultMap);
                compile.write((OutputStream)resp.getOutputStream());
                compile.close();
            } else if ("Excel".equals(desExportTemplate.getTemplateType())) {
                tempDir = Files.createTempDirectory("tempDir", new FileAttribute[0]);
                tempFile = Paths.get(tempDir.toString(), fileInfo.getOriginalFilename());
                Files.copy(inputStream, tempFile, new CopyOption[0]);
                TemplateExportParams templateExportParams = new TemplateExportParams(tempFile.toFile().getPath(), true, new String[0]);
                Workbook workbook = ExcelExportUtil.exportExcel((TemplateExportParams)templateExportParams, dataSourceResultMap);
                workbook.write((OutputStream)resp.getOutputStream());
                workbook.close();
            }
            resp.getOutputStream().flush();
            resp.getOutputStream().close();
            if ("Excel".equals(desExportTemplate.getTemplateType())) {
                Files.delete(tempFile);
                Files.delete(tempDir);
            }
        }
        catch (Exception e) {
            throw new BizException("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a" + e.getMessage(), (Throwable)e);
        }
    }

    public void exportTemplateByTemplateCode(Long primaryKey, String templateCode, HttpServletResponse resp) {
        HashMap<String, Object> dataSourceResultMap = new HashMap<String, Object>();
        DesExportTemplate desExportTemplate = this.getByTemplateCode(templateCode);
        FileInfo fileInfo = this.documentService.getFileByFileId(desExportTemplate.getTemplateFile());
        ByteArrayInputStream inputStream = new ByteArrayInputStream(this.fileStorageService.download(fileInfo).bytes());
        LoopRowTableRenderPolicy policy = new LoopRowTableRenderPolicy();
        LoopColumnTableRenderPolicy columnPolicy = new LoopColumnTableRenderPolicy();
        ConfigureBuilder builder = Configure.newBuilder();
        builder.useSpringEL(false);
        Path tempDir = null;
        Path tempFile = null;
        HashMap<String, FlowProcessCommentVo> workFlowMap = new HashMap<String, FlowProcessCommentVo>();
        String procInstId = null;
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(primaryKey.toString()).singleResult();
        if (historicProcessInstance != null) {
            procInstId = historicProcessInstance.getRootProcessInstanceId();
        }
        if (procInstId != null) {
            List<FlowProcessCommentVo> commentList = this.getFlwProcessDetailComment(procInstId);
            Integer i = 0;
            while (i < commentList.size()) {
                workFlowMap.put(String.valueOf(i + 1), commentList.get(i));
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
        }
        dataSourceResultMap.put("workFlowData", workFlowMap);
        List dataSourceList = JSONArray.parseArray((String)desExportTemplate.getDataSource(), JSONObject.class);
        Db db = DbUtil.use((DataSource)this.dataSource);
        for (JSONObject dataSource : dataSourceList) {
            if ("SQL".equals(dataSource.get("type"))) {
                String stringSql = JSONObject.parseObject((String)JSONObject.toJSONString((Object)dataSource.get("config"), (JSONWriter.Feature[])new JSONWriter.Feature[0])).get("sql").toString();
                String replaceSql = StrUtil.replace((CharSequence)stringSql, (CharSequence)"#{primaryKey}", (CharSequence)primaryKey.toString());
                try {
                    List sqlResultList = db.query(replaceSql, new Object[0]);
                    if (sqlResultList.size() == 0) {
                        HashMap singleEntityMap = new HashMap();
                        ArrayList singleMapList = new ArrayList();
                        builder.bind(dataSource.getString("code") + "List", (RenderPolicy)policy);
                        dataSourceResultMap.put(dataSource.getString("code") + "List", singleMapList);
                        builder.bind(dataSource.getString("code") + "ColumnList", (RenderPolicy)columnPolicy);
                        dataSourceResultMap.put(dataSource.getString("code") + "ColumnList", singleMapList);
                        dataSourceResultMap.put(dataSource.getString("code") + "Map", singleEntityMap);
                    }
                    if (sqlResultList.size() == 1) {
                        Entity entity2 = (Entity)sqlResultList.get(0);
                        HashMap<String, Object> singleEntityMap = new HashMap<String, Object>();
                        ArrayList<HashMap<String, Object>> singleMapList = new ArrayList<HashMap<String, Object>>();
                        entity2.getFieldNames().stream().forEach(fieldName -> singleEntityMap.put((String)fieldName, entity2.get(fieldName)));
                        if (singleEntityMap.containsKey("file_id") && singleEntityMap.get("file_id") != null) {
                            Long fileId = Long.valueOf(singleEntityMap.get("file_id").toString());
                            FileInfo attachmentInfo = this.documentService.getFileByFileId(fileId);
                            String fileType = attachmentInfo.getOriginalFilename().substring(attachmentInfo.getOriginalFilename().lastIndexOf(".") + 1);
                            ByteArrayInputStream attachmentInputStream = new ByteArrayInputStream(this.fileStorageService.download(attachmentInfo).bytes());
                            builder.bind(dataSource.getString("code") + "Attachment", (RenderPolicy)new AttachmentRenderPolicy());
                            if ("docx".equals(fileType)) {
                                dataSourceResultMap.put(dataSource.getString("code") + "Attachment", Attachments.ofStream((InputStream)attachmentInputStream, (AttachmentType)AttachmentType.DOCX).create());
                            } else if ("xlsx".equals(fileType)) {
                                dataSourceResultMap.put(dataSource.getString("code") + "Attachment", Attachments.ofStream((InputStream)attachmentInputStream, (AttachmentType)AttachmentType.XLSX).create());
                            }
                        }
                        for (String key : singleEntityMap.keySet()) {
                            if (!key.startsWith("image_id")) continue;
                            FileInfo imageInfo = null;
                            if (singleEntityMap.get(key) != null && !"".equals(singleEntityMap.get(key))) {
                                imageInfo = this.documentService.getFileByFileId(Long.valueOf(singleEntityMap.get(key).toString()));
                            }
                            if (imageInfo != null) {
                                byte[] imageBytes = this.fileStorageService.download(imageInfo).bytes();
                                if (imageBytes == null || imageBytes.length <= 0) continue;
                                if ("Word".equals(desExportTemplate.getTemplateType())) {
                                    ByteArrayInputStream imageInputStream = new ByteArrayInputStream(imageBytes);
                                    singleEntityMap.put(key + "Image", Pictures.ofStream((InputStream)imageInputStream).size(120, 80).create());
                                    continue;
                                }
                                if (!"Excel".equals(desExportTemplate.getTemplateType())) continue;
                                ImageEntity imageEntity = new ImageEntity();
                                imageEntity.setData(imageBytes);
                                imageEntity.setWidth(120);
                                imageEntity.setHeight(80);
                                singleEntityMap.put(key + "Image", imageEntity);
                                continue;
                            }
                            if ("Word".equals(desExportTemplate.getTemplateType())) {
                                singleEntityMap.put(key + "Image", Pictures.ofBytes((byte[])new byte[0]).create());
                                continue;
                            }
                            if (!"Excel".equals(desExportTemplate.getTemplateType())) continue;
                            ImageEntity imageEntity = new ImageEntity();
                            imageEntity.setData(new byte[0]);
                            imageEntity.setWidth(120);
                            imageEntity.setHeight(80);
                            singleEntityMap.put(key + "Image", imageEntity);
                        }
                        singleMapList.add(singleEntityMap);
                        builder.bind(dataSource.getString("code") + "List", (RenderPolicy)policy);
                        dataSourceResultMap.put(dataSource.getString("code") + "List", singleMapList);
                        builder.bind(dataSource.getString("code") + "ColumnList", (RenderPolicy)columnPolicy);
                        dataSourceResultMap.put(dataSource.getString("code") + "ColumnList", singleMapList);
                        dataSourceResultMap.put(dataSource.getString("code") + "Map", singleEntityMap);
                        continue;
                    }
                    List multipleMapList = sqlResultList.stream().map(entity -> {
                        HashMap<String, Object> singleEntityMap = new HashMap<String, Object>();
                        entity.getFieldNames().stream().forEach(fieldName -> singleEntityMap.put((String)fieldName, entity.get(fieldName)));
                        for (String key : singleEntityMap.keySet()) {
                            if (!key.startsWith("image_id")) continue;
                            FileInfo imageInfo = null;
                            if (singleEntityMap.get(key) != null && !"".equals(singleEntityMap.get(key))) {
                                imageInfo = this.documentService.getFileByFileId(Long.valueOf(singleEntityMap.get(key).toString()));
                            }
                            if (imageInfo != null) {
                                byte[] imageBytes = this.fileStorageService.download(imageInfo).bytes();
                                if (imageBytes == null || imageBytes.length <= 0) continue;
                                if ("Word".equals(desExportTemplate.getTemplateType())) {
                                    ByteArrayInputStream imageInputStream = new ByteArrayInputStream(imageBytes);
                                    singleEntityMap.put(key + "Image", Pictures.ofStream((InputStream)imageInputStream).size(120, 80).create());
                                    continue;
                                }
                                if (!"Excel".equals(desExportTemplate.getTemplateType())) continue;
                                ImageEntity imageEntity = new ImageEntity();
                                imageEntity.setData(imageBytes);
                                imageEntity.setWidth(120);
                                imageEntity.setHeight(80);
                                singleEntityMap.put(key + "Image", imageEntity);
                                continue;
                            }
                            if ("Word".equals(desExportTemplate.getTemplateType())) {
                                singleEntityMap.put(key + "Image", Pictures.ofBytes((byte[])new byte[0]).create());
                                continue;
                            }
                            if (!"Excel".equals(desExportTemplate.getTemplateType())) continue;
                            ImageEntity imageEntity = new ImageEntity();
                            imageEntity.setData(new byte[0]);
                            imageEntity.setWidth(120);
                            imageEntity.setHeight(80);
                            singleEntityMap.put(key + "Image", imageEntity);
                        }
                        return singleEntityMap;
                    }).collect(Collectors.toList());
                    builder.bind(dataSource.getString("code") + "List", (RenderPolicy)policy);
                    dataSourceResultMap.put(dataSource.getString("code") + "List", multipleMapList);
                    builder.bind(dataSource.getString("code") + "ColumnList", (RenderPolicy)columnPolicy);
                    dataSourceResultMap.put(dataSource.getString("code") + "ColumnList", multipleMapList);
                    continue;
                }
                catch (SQLException e) {
                    throw new BizException(StrUtil.format((CharSequence)"\u6570\u636e\u6e90\u6267\u884c\u51fa\u9519,\u540d\u79f0:[{}],\u9519\u8bef:{}", (Object[])new Object[]{dataSource.get("name"), e.getMessage()}));
                }
            }
            if (!"JavaBean".equals(dataSource.get("type"))) continue;
        }
        Configure config = builder.build();
        XWPFTemplate compile = null;
        try {
            resp.reset();
            resp.setCharacterEncoding(StandardCharsets.UTF_8.name());
            resp.addHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode("\u5bfc\u51fa\u6570\u636e" + fileInfo.getOriginalFilename(), StandardCharsets.UTF_8.name()));
            resp.setContentType("application/octet-stream");
            if ("Word".equals(desExportTemplate.getTemplateType())) {
                compile = XWPFTemplate.compile((InputStream)inputStream, (Configure)config).render(dataSourceResultMap);
                compile.write((OutputStream)resp.getOutputStream());
                compile.close();
            } else if ("Excel".equals(desExportTemplate.getTemplateType())) {
                tempDir = Files.createTempDirectory("tempDir", new FileAttribute[0]);
                tempFile = Paths.get(tempDir.toString(), fileInfo.getOriginalFilename());
                Files.copy(inputStream, tempFile, new CopyOption[0]);
                TemplateExportParams templateExportParams = new TemplateExportParams(tempFile.toFile().getPath(), true, new String[0]);
                Workbook workbook = ExcelExportUtil.exportExcel((TemplateExportParams)templateExportParams, dataSourceResultMap);
                workbook.write((OutputStream)resp.getOutputStream());
                workbook.close();
            }
            resp.getOutputStream().flush();
            resp.getOutputStream().close();
            if ("Excel".equals(desExportTemplate.getTemplateType())) {
                Files.delete(tempFile);
                Files.delete(tempDir);
            }
        }
        catch (Exception e) {
            throw new BizException("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a" + e.getMessage(), (Throwable)e);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void exportZipByTemplateCode(List<Map<String, Object>> list, String fileName, HttpServletResponse response) throws IOException {
        try {
            FileUtil.del((String)(FileUtil.getTmpDirPath() + File.separator + fileName + ".zip"));
            File tempFolder = Files.createTempDirectory(fileName, new FileAttribute[0]).toFile();
            for (int index = 0; index < list.size(); ++index) {
                Map<String, Object> map = list.get(index);
                String templateCode = map.get("templateCode").toString();
                String primaryKey = map.get("primaryKey").toString();
                DesExportTemplate desExportTemplate = this.getByTemplateCode(templateCode);
                FileInfo fileInfo = this.documentService.getFileByFileId(desExportTemplate.getTemplateFile());
                ByteArrayInputStream inputStream = new ByteArrayInputStream(this.fileStorageService.download(fileInfo).bytes());
                File file = FileUtil.file((String)(tempFolder + File.separator + "\u5bfc\u51fa\u6a21\u677f" + (index + 1) + fileInfo.getOriginalFilename()));
                FileOutputStream outputStream = new FileOutputStream(file);
                HashMap<String, Object> dataSourceResultMap = new HashMap<String, Object>();
                LoopRowTableRenderPolicy policy = new LoopRowTableRenderPolicy();
                LoopColumnTableRenderPolicy columnPolicy = new LoopColumnTableRenderPolicy();
                ConfigureBuilder builder = Configure.newBuilder();
                builder.useSpringEL(false);
                Path tempDir = null;
                Path tempFile = null;
                HashMap<String, FlowProcessCommentVo> workFlowMap = new HashMap<String, FlowProcessCommentVo>();
                String procInstId = null;
                HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(primaryKey.toString()).singleResult();
                if (historicProcessInstance != null) {
                    procInstId = historicProcessInstance.getRootProcessInstanceId();
                }
                if (procInstId != null) {
                    List<FlowProcessCommentVo> commentList = this.getFlwProcessDetailComment(procInstId);
                    Integer i = 0;
                    while (i < commentList.size()) {
                        workFlowMap.put(String.valueOf(i + 1), commentList.get(i));
                        Integer n = i;
                        Integer n2 = i = Integer.valueOf(i + 1);
                    }
                }
                dataSourceResultMap.put("workFlowData", workFlowMap);
                List dataSourceList = JSONArray.parseArray((String)desExportTemplate.getDataSource(), JSONObject.class);
                Db db = DbUtil.use((DataSource)this.dataSource);
                for (JSONObject dataSource : dataSourceList) {
                    if ("SQL".equals(dataSource.get("type"))) {
                        String stringSql = JSONObject.parseObject((String)JSONObject.toJSONString((Object)dataSource.get("config"), (JSONWriter.Feature[])new JSONWriter.Feature[0])).get("sql").toString();
                        String replaceSql = StrUtil.replace((CharSequence)stringSql, (CharSequence)"#{primaryKey}", (CharSequence)primaryKey.toString());
                        try {
                            List sqlResultList = db.query(replaceSql, new Object[0]);
                            if (sqlResultList.size() == 0) {
                                HashMap singleEntityMap = new HashMap();
                                ArrayList singleMapList = new ArrayList();
                                builder.bind(dataSource.getString("code") + "List", (RenderPolicy)policy);
                                dataSourceResultMap.put(dataSource.getString("code") + "List", singleMapList);
                                builder.bind(dataSource.getString("code") + "ColumnList", (RenderPolicy)columnPolicy);
                                dataSourceResultMap.put(dataSource.getString("code") + "ColumnList", singleMapList);
                                dataSourceResultMap.put(dataSource.getString("code") + "Map", singleEntityMap);
                            }
                            if (sqlResultList.size() == 1) {
                                Entity entity2 = (Entity)sqlResultList.get(0);
                                HashMap<String, Object> singleEntityMap = new HashMap<String, Object>();
                                ArrayList<HashMap<String, Object>> singleMapList = new ArrayList<HashMap<String, Object>>();
                                entity2.getFieldNames().stream().forEach(fieldName -> singleEntityMap.put((String)fieldName, entity2.get(fieldName)));
                                if (singleEntityMap.containsKey("file_id") && singleEntityMap.get("file_id") != null) {
                                    Long fileId = Long.valueOf(singleEntityMap.get("file_id").toString());
                                    FileInfo attachmentInfo = this.documentService.getFileByFileId(fileId);
                                    String fileType = attachmentInfo.getOriginalFilename().substring(attachmentInfo.getOriginalFilename().lastIndexOf(".") + 1);
                                    ByteArrayInputStream attachmentInputStream = new ByteArrayInputStream(this.fileStorageService.download(attachmentInfo).bytes());
                                    builder.bind(dataSource.getString("code") + "Attachment", (RenderPolicy)new AttachmentRenderPolicy());
                                    if ("docx".equals(fileType)) {
                                        dataSourceResultMap.put(dataSource.getString("code") + "Attachment", Attachments.ofStream((InputStream)attachmentInputStream, (AttachmentType)AttachmentType.DOCX).create());
                                    } else if ("xlsx".equals(fileType)) {
                                        dataSourceResultMap.put(dataSource.getString("code") + "Attachment", Attachments.ofStream((InputStream)attachmentInputStream, (AttachmentType)AttachmentType.XLSX).create());
                                    }
                                }
                                for (String key : singleEntityMap.keySet()) {
                                    byte[] imageBytes;
                                    if (!key.startsWith("image_id")) continue;
                                    FileInfo imageInfo = null;
                                    if (singleEntityMap.get(key) != null && !"".equals(singleEntityMap.get(key))) {
                                        imageInfo = this.documentService.getFileByFileId(Long.valueOf(singleEntityMap.get(key).toString()));
                                    }
                                    if (imageInfo == null || (imageBytes = this.fileStorageService.download(imageInfo).bytes()) == null || imageBytes.length <= 0) continue;
                                    if ("Word".equals(desExportTemplate.getTemplateType())) {
                                        ByteArrayInputStream imageInputStream = new ByteArrayInputStream(imageBytes);
                                        singleEntityMap.put(key + "Image", Pictures.ofStream((InputStream)imageInputStream).size(120, 80).create());
                                        continue;
                                    }
                                    if (!"Excel".equals(desExportTemplate.getTemplateType())) continue;
                                    ImageEntity imageEntity = new ImageEntity();
                                    imageEntity.setData(imageBytes);
                                    imageEntity.setWidth(120);
                                    imageEntity.setHeight(80);
                                    singleEntityMap.put(key + "Image", imageEntity);
                                }
                                singleMapList.add(singleEntityMap);
                                builder.bind(dataSource.getString("code") + "List", (RenderPolicy)policy);
                                dataSourceResultMap.put(dataSource.getString("code") + "List", singleMapList);
                                builder.bind(dataSource.getString("code") + "ColumnList", (RenderPolicy)columnPolicy);
                                dataSourceResultMap.put(dataSource.getString("code") + "ColumnList", singleMapList);
                                dataSourceResultMap.put(dataSource.getString("code") + "Map", singleEntityMap);
                                continue;
                            }
                            List multipleMapList = sqlResultList.stream().map(entity -> {
                                HashMap<String, Object> singleEntityMap = new HashMap<String, Object>();
                                entity.getFieldNames().stream().forEach(fieldName -> singleEntityMap.put((String)fieldName, entity.get(fieldName)));
                                for (String key : singleEntityMap.keySet()) {
                                    byte[] imageBytes;
                                    if (!key.startsWith("image_id")) continue;
                                    FileInfo imageInfo = null;
                                    if (singleEntityMap.get(key) != null && !"".equals(singleEntityMap.get(key))) {
                                        imageInfo = this.documentService.getFileByFileId(Long.valueOf(singleEntityMap.get(key).toString()));
                                    }
                                    if (imageInfo == null || (imageBytes = this.fileStorageService.download(imageInfo).bytes()) == null || imageBytes.length <= 0) continue;
                                    if ("Word".equals(desExportTemplate.getTemplateType())) {
                                        ByteArrayInputStream imageInputStream = new ByteArrayInputStream(imageBytes);
                                        singleEntityMap.put(key + "Image", Pictures.ofStream((InputStream)imageInputStream).size(120, 80).create());
                                        continue;
                                    }
                                    if (!"Excel".equals(desExportTemplate.getTemplateType())) continue;
                                    ImageEntity imageEntity = new ImageEntity();
                                    imageEntity.setData(imageBytes);
                                    imageEntity.setWidth(120);
                                    imageEntity.setHeight(80);
                                    singleEntityMap.put(key + "Image", imageEntity);
                                }
                                return singleEntityMap;
                            }).collect(Collectors.toList());
                            builder.bind(dataSource.getString("code") + "List", (RenderPolicy)policy);
                            dataSourceResultMap.put(dataSource.getString("code") + "List", multipleMapList);
                            builder.bind(dataSource.getString("code") + "ColumnList", (RenderPolicy)columnPolicy);
                            dataSourceResultMap.put(dataSource.getString("code") + "ColumnList", multipleMapList);
                            continue;
                        }
                        catch (SQLException e) {
                            throw new BizException(StrUtil.format((CharSequence)"\u6570\u636e\u6e90\u6267\u884c\u51fa\u9519,\u540d\u79f0:[{}],\u9519\u8bef:{}", (Object[])new Object[]{dataSource.get("name"), e.getMessage()}));
                        }
                    }
                    if (!"JavaBean".equals(dataSource.get("type"))) continue;
                }
                Configure config = builder.build();
                XWPFTemplate compile = null;
                try {
                    if ("Word".equals(desExportTemplate.getTemplateType())) {
                        compile = XWPFTemplate.compile((InputStream)inputStream, (Configure)config).render(dataSourceResultMap);
                        compile.write((OutputStream)outputStream);
                        compile.close();
                    } else if ("Excel".equals(desExportTemplate.getTemplateType())) {
                        tempDir = Files.createTempDirectory("tempDir", new FileAttribute[0]);
                        tempFile = Paths.get(tempDir.toString(), fileInfo.getOriginalFilename());
                        Files.copy(inputStream, tempFile, new CopyOption[0]);
                        TemplateExportParams templateExportParams = new TemplateExportParams(tempFile.toFile().getPath(), true, new String[0]);
                        Workbook workbook = ExcelExportUtil.exportExcel((TemplateExportParams)templateExportParams, dataSourceResultMap);
                        workbook.write((OutputStream)outputStream);
                        workbook.close();
                    }
                    if (!"Excel".equals(desExportTemplate.getTemplateType())) continue;
                    Files.delete(tempFile);
                    Files.delete(tempDir);
                    continue;
                }
                catch (Exception e) {
                    throw new BizException("\u6587\u4ef6\u5bfc\u51fa\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a" + e.getMessage(), (Throwable)e);
                }
                finally {
                    outputStream.flush();
                    ((OutputStream)outputStream).close();
                }
            }
            if (tempFolder == null) {
                throw new BizException("\u5bfc\u51fa\u6587\u4ef6\u4e3a\u7a7a");
            }
            File zip = ZipUtil.zip((File)tempFolder);
            FileUtil.del((File)tempFolder);
            CommonDownloadUtil.download((File)zip, (HttpServletResponse)response);
        }
        catch (Exception e) {
            throw new BizException("\u6587\u4ef6\u5bfc\u51fa\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a" + e.getMessage(), (Throwable)e);
        }
    }

    public void exportTemplateByDataSource(Map<String, Object> dataMap, String templateCode, Boolean pdfMode, HttpServletResponse resp) {
        HashMap<String, Object> dataSourceResultMap = new HashMap<String, Object>();
        DesExportTemplate desExportTemplate = this.getByTemplateCode(templateCode);
        FileInfo fileInfo = this.documentService.getFileByFileId(desExportTemplate.getTemplateFile());
        ByteArrayInputStream inputStream = new ByteArrayInputStream(this.fileStorageService.download(fileInfo).bytes());
        LoopRowTableRenderPolicy policy = new LoopRowTableRenderPolicy();
        LoopColumnTableRenderPolicy columnPolicy = new LoopColumnTableRenderPolicy();
        ConfigureBuilder builder = Configure.newBuilder();
        builder.useSpringEL(false);
        Path tempDir = null;
        Path tempFile = null;
        try {
            for (String key : dataMap.keySet()) {
                HashMap<Object, Object> singleEntityMap;
                ArrayList singleMapList;
                Object object = dataMap.get(key);
                if (object instanceof List) {
                    List list = (List)object;
                    List multipleMapList = list.stream().map(item -> {
                        HashMap<String, Object> singleEntityMap = new HashMap<String, Object>();
                        Class<?> clazz = item.getClass();
                        for (Field field : clazz.getDeclaredFields()) {
                            field.setAccessible(true);
                            try {
                                singleEntityMap.put(field.getName(), field.get(item));
                            }
                            catch (IllegalAccessException e) {
                                throw new BizException(StrUtil.format((CharSequence)"\u6570\u636e\u6e90\u8f6c\u6362\u51fa\u9519,\u9519\u8bef:{}", (Object[])new Object[]{e.getMessage()}));
                            }
                        }
                        for (String singleKey : singleEntityMap.keySet()) {
                            byte[] imageBytes;
                            if (singleKey.startsWith("image_id") && !singleKey.contains("width") && !singleKey.contains("height")) {
                                byte[] imageBytes2;
                                FileInfo imageInfo = null;
                                if (singleEntityMap.get(singleKey) != null && !"".equals(singleEntityMap.get(singleKey))) {
                                    imageInfo = this.documentService.getFileByFileId(Long.valueOf(singleEntityMap.get(singleKey).toString()));
                                }
                                if (imageInfo == null || (imageBytes2 = this.fileStorageService.download(imageInfo).bytes()) == null || imageBytes2.length <= 0) continue;
                                Integer width = 0;
                                Integer height = 0;
                                if (singleEntityMap.containsKey(singleKey + "_width")) {
                                    width = Integer.valueOf(singleEntityMap.get(singleKey + "_width").toString());
                                }
                                if (singleEntityMap.containsKey(singleKey + "_height")) {
                                    height = Integer.valueOf(singleEntityMap.get(singleKey + "_height").toString());
                                }
                                if ("Word".equals(desExportTemplate.getTemplateType())) {
                                    ByteArrayInputStream imageInputStream = new ByteArrayInputStream(imageBytes2);
                                    singleEntityMap.put(singleKey, Pictures.ofStream((InputStream)imageInputStream).size(width > 0 ? width : 120, height > 0 ? height : 80).create());
                                    continue;
                                }
                                if (!"Excel".equals(desExportTemplate.getTemplateType())) continue;
                                ImageEntity imageEntity = new ImageEntity();
                                imageEntity.setData(imageBytes2);
                                imageEntity.setWidth(width > 0 ? width : 120);
                                imageEntity.setHeight(height > 0 ? height : 80);
                                singleEntityMap.put(singleKey, imageEntity);
                                continue;
                            }
                            if (!singleKey.startsWith("image_bytes") || (imageBytes = (byte[])singleEntityMap.get(singleKey)) == null || imageBytes.length <= 0) continue;
                            if ("Word".equals(desExportTemplate.getTemplateType())) {
                                ByteArrayInputStream imageInputStream = new ByteArrayInputStream(imageBytes);
                                singleEntityMap.put(singleKey, Pictures.ofStream((InputStream)imageInputStream).size(120, 80).create());
                                continue;
                            }
                            if (!"Excel".equals(desExportTemplate.getTemplateType())) continue;
                            ImageEntity imageEntity = new ImageEntity();
                            imageEntity.setData(imageBytes);
                            imageEntity.setWidth(120);
                            imageEntity.setHeight(80);
                            singleEntityMap.put(singleKey, imageEntity);
                        }
                        return singleEntityMap;
                    }).collect(Collectors.toList());
                    builder.bind(key + "List", (RenderPolicy)policy);
                    dataSourceResultMap.put(key + "List", multipleMapList);
                    builder.bind(key + "ColumnList", (RenderPolicy)columnPolicy);
                    dataSourceResultMap.put(key + "ColumnList", multipleMapList);
                    continue;
                }
                if (object instanceof Map) {
                    singleMapList = new ArrayList();
                    singleEntityMap = (HashMap<Object, Object>)object;
                    if (singleEntityMap.containsKey("file_id") && singleEntityMap.get("file_id") != null) {
                        Long fileId = Long.valueOf(singleEntityMap.get("file_id").toString());
                        FileInfo attachmentInfo = this.documentService.getFileByFileId(fileId);
                        String fileType = attachmentInfo.getOriginalFilename().substring(attachmentInfo.getOriginalFilename().lastIndexOf(".") + 1);
                        ByteArrayInputStream attachmentInputStream = new ByteArrayInputStream(this.fileStorageService.download(attachmentInfo).bytes());
                        builder.bind(key + "Attachment", (RenderPolicy)new AttachmentRenderPolicy());
                        if ("docx".equals(fileType)) {
                            dataSourceResultMap.put(key + "Attachment", Attachments.ofStream((InputStream)attachmentInputStream, (AttachmentType)AttachmentType.DOCX).create());
                        } else if ("xlsx".equals(fileType)) {
                            dataSourceResultMap.put(key + "Attachment", Attachments.ofStream((InputStream)attachmentInputStream, (AttachmentType)AttachmentType.XLSX).create());
                        }
                    }
                    for (Object singleKey : singleEntityMap.keySet()) {
                        byte[] imageBytes;
                        if (((String)singleKey).startsWith("image_id") && !((String)singleKey).contains("width") && !((String)singleKey).contains("height")) {
                            byte[] imageBytes2;
                            FileInfo imageInfo = null;
                            if (singleEntityMap.get(singleKey) != null && !"".equals(singleEntityMap.get(singleKey))) {
                                imageInfo = this.documentService.getFileByFileId(Long.valueOf(singleEntityMap.get(singleKey).toString()));
                            }
                            if (imageInfo == null || (imageBytes2 = this.fileStorageService.download(imageInfo).bytes()) == null || imageBytes2.length <= 0) continue;
                            Integer width = 0;
                            Integer height = 0;
                            if (singleEntityMap.containsKey((String)singleKey + "_width")) {
                                width = Integer.valueOf(singleEntityMap.get((String)singleKey + "_width").toString());
                            }
                            if (singleEntityMap.containsKey((String)singleKey + "_height")) {
                                height = Integer.valueOf(singleEntityMap.get((String)singleKey + "_height").toString());
                            }
                            if ("Word".equals(desExportTemplate.getTemplateType())) {
                                ByteArrayInputStream imageInputStream = new ByteArrayInputStream(imageBytes2);
                                singleEntityMap.put(singleKey, Pictures.ofStream((InputStream)imageInputStream).size(width > 0 ? width : 120, height > 0 ? height : 80).create());
                                continue;
                            }
                            if (!"Excel".equals(desExportTemplate.getTemplateType())) continue;
                            ImageEntity imageEntity = new ImageEntity();
                            imageEntity.setData(imageBytes2);
                            imageEntity.setWidth(width > 0 ? width : 120);
                            imageEntity.setHeight(height > 0 ? height : 80);
                            singleEntityMap.put(singleKey, imageEntity);
                            continue;
                        }
                        if (!((String)singleKey).startsWith("image_bytes") || (imageBytes = (byte[])singleEntityMap.get(singleKey)) == null || imageBytes.length <= 0) continue;
                        if ("Word".equals(desExportTemplate.getTemplateType())) {
                            ByteArrayInputStream imageInputStream = new ByteArrayInputStream(imageBytes);
                            singleEntityMap.put(singleKey, Pictures.ofStream((InputStream)imageInputStream).size(120, 80).create());
                            continue;
                        }
                        if (!"Excel".equals(desExportTemplate.getTemplateType())) continue;
                        ImageEntity imageEntity = new ImageEntity();
                        imageEntity.setData(imageBytes);
                        imageEntity.setWidth(120);
                        imageEntity.setHeight(80);
                        singleEntityMap.put(singleKey, imageEntity);
                    }
                    singleMapList.add(singleEntityMap);
                    builder.bind(key + "List", (RenderPolicy)policy);
                    dataSourceResultMap.put(key + "List", singleMapList);
                    builder.bind(key + "ColumnList", (RenderPolicy)columnPolicy);
                    dataSourceResultMap.put(key + "ColumnList", singleMapList);
                    dataSourceResultMap.put(key + "Map", singleEntityMap);
                    continue;
                }
                singleMapList = new ArrayList();
                singleEntityMap = new HashMap<Object, Object>();
                Class<?> clazz = object.getClass();
                for (Field field : clazz.getDeclaredFields()) {
                    field.setAccessible(true);
                    singleEntityMap.put(field.getName(), field.get(object));
                }
                if (singleEntityMap.containsKey("file_id") && singleEntityMap.get("file_id") != null) {
                    Long fileId = Long.valueOf(singleEntityMap.get("file_id").toString());
                    FileInfo attachmentInfo = this.documentService.getFileByFileId(fileId);
                    String fileType = attachmentInfo.getOriginalFilename().substring(attachmentInfo.getOriginalFilename().lastIndexOf(".") + 1);
                    ByteArrayInputStream attachmentInputStream = new ByteArrayInputStream(this.fileStorageService.download(attachmentInfo).bytes());
                    builder.bind(key + "Attachment", (RenderPolicy)new AttachmentRenderPolicy());
                    if ("docx".equals(fileType)) {
                        dataSourceResultMap.put(key + "Attachment", Attachments.ofStream((InputStream)attachmentInputStream, (AttachmentType)AttachmentType.DOCX).create());
                    } else if ("xlsx".equals(fileType)) {
                        dataSourceResultMap.put(key + "Attachment", Attachments.ofStream((InputStream)attachmentInputStream, (AttachmentType)AttachmentType.XLSX).create());
                    }
                }
                for (String singleKey : singleEntityMap.keySet()) {
                    byte[] imageBytes;
                    if (singleKey.startsWith("image_id") && !singleKey.contains("width") && !singleKey.contains("height")) {
                        byte[] imageBytes3;
                        FileInfo imageInfo = null;
                        if (singleEntityMap.get(singleKey) != null && !"".equals(singleEntityMap.get(singleKey))) {
                            imageInfo = this.documentService.getFileByFileId(Long.valueOf(singleEntityMap.get(singleKey).toString()));
                        }
                        if (imageInfo == null || (imageBytes3 = this.fileStorageService.download(imageInfo).bytes()) == null || imageBytes3.length <= 0) continue;
                        Integer width = 0;
                        Integer height = 0;
                        if (singleEntityMap.containsKey(singleKey + "_width")) {
                            width = Integer.valueOf(singleEntityMap.get(singleKey + "_width").toString());
                        }
                        if (singleEntityMap.containsKey(singleKey + "_height")) {
                            height = Integer.valueOf(singleEntityMap.get(singleKey + "_height").toString());
                        }
                        if ("Word".equals(desExportTemplate.getTemplateType())) {
                            ByteArrayInputStream imageInputStream = new ByteArrayInputStream(imageBytes3);
                            singleEntityMap.put(singleKey, Pictures.ofStream((InputStream)imageInputStream).size(width > 0 ? width : 120, height > 0 ? height : 80).create());
                            continue;
                        }
                        if (!"Excel".equals(desExportTemplate.getTemplateType())) continue;
                        ImageEntity imageEntity = new ImageEntity();
                        imageEntity.setData(imageBytes3);
                        imageEntity.setWidth(width > 0 ? width : 120);
                        imageEntity.setHeight(height > 0 ? height : 80);
                        singleEntityMap.put(singleKey, imageEntity);
                        continue;
                    }
                    if (!singleKey.startsWith("image_bytes") || (imageBytes = (byte[])singleEntityMap.get(singleKey)) == null || imageBytes.length <= 0) continue;
                    if ("Word".equals(desExportTemplate.getTemplateType())) {
                        ByteArrayInputStream imageInputStream = new ByteArrayInputStream(imageBytes);
                        singleEntityMap.put(singleKey, Pictures.ofStream((InputStream)imageInputStream).size(120, 80).create());
                        continue;
                    }
                    if (!"Excel".equals(desExportTemplate.getTemplateType())) continue;
                    ImageEntity imageEntity = new ImageEntity();
                    imageEntity.setData(imageBytes);
                    imageEntity.setWidth(120);
                    imageEntity.setHeight(80);
                    singleEntityMap.put(singleKey, imageEntity);
                }
                singleMapList.add(singleEntityMap);
                builder.bind(key + "List", (RenderPolicy)policy);
                dataSourceResultMap.put(key + "List", singleMapList);
                builder.bind(key + "ColumnList", (RenderPolicy)columnPolicy);
                dataSourceResultMap.put(key + "ColumnList", singleMapList);
                dataSourceResultMap.put(key + "Map", singleEntityMap);
            }
        }
        catch (Exception e) {
            throw new BizException(StrUtil.format((CharSequence)"\u6570\u636e\u6e90\u8f6c\u6362\u51fa\u9519,\u9519\u8bef:{}", (Object[])new Object[]{e.getMessage()}));
        }
        Configure config = builder.build();
        XWPFTemplate compile = null;
        try {
            resp.reset();
            resp.setCharacterEncoding(StandardCharsets.UTF_8.name());
            if (pdfMode.booleanValue()) {
                resp.addHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode("\u5bfc\u51fa\u6570\u636e" + fileInfo.getOriginalFilename().substring(0, fileInfo.getOriginalFilename().lastIndexOf(".")) + ".pdf", StandardCharsets.UTF_8.name()));
            } else {
                resp.addHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode("\u5bfc\u51fa\u6570\u636e" + fileInfo.getOriginalFilename(), StandardCharsets.UTF_8.name()));
            }
            resp.setContentType("application/octet-stream");
            if ("Word".equals(desExportTemplate.getTemplateType())) {
                if (pdfMode.booleanValue()) {
                    ByteArrayOutputStream wordOutputStream = new ByteArrayOutputStream();
                    compile = XWPFTemplate.compile((InputStream)inputStream, (Configure)config).render(dataSourceResultMap);
                    compile.write((OutputStream)wordOutputStream);
                    WordToPdf.wordToPdf(wordOutputStream.toByteArray(), (OutputStream)resp.getOutputStream());
                    compile.close();
                } else {
                    compile = XWPFTemplate.compile((InputStream)inputStream, (Configure)config).render(dataSourceResultMap);
                    compile.write((OutputStream)resp.getOutputStream());
                    compile.close();
                }
            } else if ("Excel".equals(desExportTemplate.getTemplateType())) {
                tempDir = Files.createTempDirectory("tempDir", new FileAttribute[0]);
                tempFile = Paths.get(tempDir.toString(), fileInfo.getOriginalFilename());
                Files.copy(inputStream, tempFile, new CopyOption[0]);
                TemplateExportParams templateExportParams = new TemplateExportParams(tempFile.toFile().getPath(), true, new String[0]);
                Workbook workbook = ExcelExportUtil.exportExcel((TemplateExportParams)templateExportParams, dataSourceResultMap);
                workbook.write((OutputStream)resp.getOutputStream());
                workbook.close();
            }
            resp.getOutputStream().flush();
            resp.getOutputStream().close();
            if ("Excel".equals(desExportTemplate.getTemplateType())) {
                Files.delete(tempFile);
                Files.delete(tempDir);
            }
        }
        catch (Exception e) {
            throw new BizException("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a" + e.getMessage(), (Throwable)e);
        }
    }

    public void exportTemplateByDataSource(Map<String, Object> dataMap, String templateCode, HttpServletResponse resp) {
        this.exportTemplateByDataSource(dataMap, templateCode, false, resp);
    }

    @Transactional(rollbackFor={Exception.class})
    public void exportZipByFormCode(List<Long> primaryKeyList, String formCode, String fileName, HttpServletResponse response) throws IOException {
        try {
            FileUtil.del((String)(FileUtil.getTmpDirPath() + File.separator + fileName + ".zip"));
            File tempFolder = Files.createTempDirectory(fileName, new FileAttribute[0]).toFile();
            DesFormModel desFormModel = this.desFormModelService.getByFormCode(formCode);
            DesExportTemplate desExportTemplate = this.getByTemplateId(desFormModel.getTemplateId());
            FileInfo fileInfo = this.documentService.getFileByFileId(desExportTemplate.getTemplateFile());
            for (int index = 0; index < primaryKeyList.size(); ++index) {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(this.fileStorageService.download(fileInfo).bytes());
                Long primaryKey = primaryKeyList.get(index);
                File file = FileUtil.file((String)(tempFolder + File.separator + "\u5bfc\u51fa\u6a21\u677f" + (index + 1) + fileInfo.getOriginalFilename()));
                FileOutputStream outputStream = new FileOutputStream(file);
                HashMap<String, Object> dataSourceResultMap = new HashMap<String, Object>();
                LoopRowTableRenderPolicy policy = new LoopRowTableRenderPolicy();
                LoopColumnTableRenderPolicy columnPolicy = new LoopColumnTableRenderPolicy();
                ConfigureBuilder builder = Configure.newBuilder();
                builder.useSpringEL(false);
                Path tempDir = null;
                Path tempFile = null;
                HashMap<String, FlowProcessCommentVo> workFlowMap = new HashMap<String, FlowProcessCommentVo>();
                String procInstId = null;
                HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(primaryKey.toString()).singleResult();
                if (historicProcessInstance != null) {
                    procInstId = historicProcessInstance.getRootProcessInstanceId();
                }
                if (procInstId != null) {
                    List<FlowProcessCommentVo> commentList = this.getFlwProcessDetailComment(procInstId);
                    Integer i = 0;
                    while (i < commentList.size()) {
                        workFlowMap.put(String.valueOf(i + 1), commentList.get(i));
                        Integer n = i;
                        Integer n2 = i = Integer.valueOf(i + 1);
                    }
                }
                dataSourceResultMap.put("workFlowData", workFlowMap);
                List dataSourceList = JSONArray.parseArray((String)desExportTemplate.getDataSource(), JSONObject.class);
                Db db = DbUtil.use((DataSource)this.dataSource);
                for (JSONObject dataSource : dataSourceList) {
                    if ("SQL".equals(dataSource.get("type"))) {
                        String stringSql = JSONObject.parseObject((String)JSONObject.toJSONString((Object)dataSource.get("config"), (JSONWriter.Feature[])new JSONWriter.Feature[0])).get("sql").toString();
                        String replaceSql = StrUtil.replace((CharSequence)stringSql, (CharSequence)"#{primaryKey}", (CharSequence)primaryKey.toString());
                        try {
                            List sqlResultList = db.query(replaceSql, new Object[0]);
                            if (sqlResultList.size() == 0) {
                                HashMap singleEntityMap = new HashMap();
                                ArrayList singleMapList = new ArrayList();
                                builder.bind(dataSource.getString("code") + "List", (RenderPolicy)policy);
                                dataSourceResultMap.put(dataSource.getString("code") + "List", singleMapList);
                                builder.bind(dataSource.getString("code") + "ColumnList", (RenderPolicy)columnPolicy);
                                dataSourceResultMap.put(dataSource.getString("code") + "ColumnList", singleMapList);
                                dataSourceResultMap.put(dataSource.getString("code") + "Map", singleEntityMap);
                            }
                            if (sqlResultList.size() == 1) {
                                Entity entity2 = (Entity)sqlResultList.get(0);
                                HashMap<String, Object> singleEntityMap = new HashMap<String, Object>();
                                ArrayList<HashMap<String, Object>> singleMapList = new ArrayList<HashMap<String, Object>>();
                                entity2.getFieldNames().stream().forEach(fieldName -> singleEntityMap.put((String)fieldName, entity2.get(fieldName)));
                                if (singleEntityMap.containsKey("file_id") && singleEntityMap.get("file_id") != null) {
                                    Long fileId = Long.valueOf(singleEntityMap.get("file_id").toString());
                                    FileInfo attachmentInfo = this.documentService.getFileByFileId(fileId);
                                    String fileType = attachmentInfo.getOriginalFilename().substring(attachmentInfo.getOriginalFilename().lastIndexOf(".") + 1);
                                    ByteArrayInputStream attachmentInputStream = new ByteArrayInputStream(this.fileStorageService.download(attachmentInfo).bytes());
                                    builder.bind(dataSource.getString("code") + "Attachment", (RenderPolicy)new AttachmentRenderPolicy());
                                    if ("docx".equals(fileType)) {
                                        dataSourceResultMap.put(dataSource.getString("code") + "Attachment", Attachments.ofStream((InputStream)attachmentInputStream, (AttachmentType)AttachmentType.DOCX).create());
                                    } else if ("xlsx".equals(fileType)) {
                                        dataSourceResultMap.put(dataSource.getString("code") + "Attachment", Attachments.ofStream((InputStream)attachmentInputStream, (AttachmentType)AttachmentType.XLSX).create());
                                    }
                                }
                                for (String key : singleEntityMap.keySet()) {
                                    byte[] imageBytes;
                                    if (!key.startsWith("image_id")) continue;
                                    FileInfo imageInfo = null;
                                    if (singleEntityMap.get(key) != null && !"".equals(singleEntityMap.get(key))) {
                                        imageInfo = this.documentService.getFileByFileId(Long.valueOf(singleEntityMap.get(key).toString()));
                                    }
                                    if (imageInfo == null || (imageBytes = this.fileStorageService.download(imageInfo).bytes()) == null || imageBytes.length <= 0) continue;
                                    if ("Word".equals(desExportTemplate.getTemplateType())) {
                                        ByteArrayInputStream imageInputStream = new ByteArrayInputStream(imageBytes);
                                        singleEntityMap.put(key + "Image", Pictures.ofStream((InputStream)imageInputStream).size(120, 80).create());
                                        continue;
                                    }
                                    if (!"Excel".equals(desExportTemplate.getTemplateType())) continue;
                                    ImageEntity imageEntity = new ImageEntity();
                                    imageEntity.setData(imageBytes);
                                    imageEntity.setWidth(120);
                                    imageEntity.setHeight(80);
                                    singleEntityMap.put(key + "Image", imageEntity);
                                }
                                singleMapList.add(singleEntityMap);
                                builder.bind(dataSource.getString("code") + "List", (RenderPolicy)policy);
                                dataSourceResultMap.put(dataSource.getString("code") + "List", singleMapList);
                                builder.bind(dataSource.getString("code") + "ColumnList", (RenderPolicy)columnPolicy);
                                dataSourceResultMap.put(dataSource.getString("code") + "ColumnList", singleMapList);
                                dataSourceResultMap.put(dataSource.getString("code") + "Map", singleEntityMap);
                                continue;
                            }
                            List multipleMapList = sqlResultList.stream().map(entity -> {
                                HashMap<String, Object> singleEntityMap = new HashMap<String, Object>();
                                entity.getFieldNames().stream().forEach(fieldName -> singleEntityMap.put((String)fieldName, entity.get(fieldName)));
                                for (String key : singleEntityMap.keySet()) {
                                    byte[] imageBytes;
                                    if (!key.startsWith("image_id")) continue;
                                    FileInfo imageInfo = null;
                                    if (singleEntityMap.get(key) != null && !"".equals(singleEntityMap.get(key))) {
                                        imageInfo = this.documentService.getFileByFileId(Long.valueOf(singleEntityMap.get(key).toString()));
                                    }
                                    if (imageInfo == null || (imageBytes = this.fileStorageService.download(imageInfo).bytes()) == null || imageBytes.length <= 0) continue;
                                    if ("Word".equals(desExportTemplate.getTemplateType())) {
                                        ByteArrayInputStream imageInputStream = new ByteArrayInputStream(imageBytes);
                                        singleEntityMap.put(key + "Image", Pictures.ofStream((InputStream)imageInputStream).size(120, 80).create());
                                        continue;
                                    }
                                    if (!"Excel".equals(desExportTemplate.getTemplateType())) continue;
                                    ImageEntity imageEntity = new ImageEntity();
                                    imageEntity.setData(imageBytes);
                                    imageEntity.setWidth(120);
                                    imageEntity.setHeight(80);
                                    singleEntityMap.put(key + "Image", imageEntity);
                                }
                                return singleEntityMap;
                            }).collect(Collectors.toList());
                            builder.bind(dataSource.getString("code") + "List", (RenderPolicy)policy);
                            dataSourceResultMap.put(dataSource.getString("code") + "List", multipleMapList);
                            builder.bind(dataSource.getString("code") + "ColumnList", (RenderPolicy)columnPolicy);
                            dataSourceResultMap.put(dataSource.getString("code") + "ColumnList", multipleMapList);
                            continue;
                        }
                        catch (SQLException e) {
                            throw new BizException(StrUtil.format((CharSequence)"\u6570\u636e\u6e90\u6267\u884c\u51fa\u9519,\u540d\u79f0:[{}],\u9519\u8bef:{}", (Object[])new Object[]{dataSource.get("name"), e.getMessage()}));
                        }
                    }
                    if (!"JavaBean".equals(dataSource.get("type"))) continue;
                }
                Configure config = builder.build();
                XWPFTemplate compile = null;
                try {
                    if ("Word".equals(desExportTemplate.getTemplateType())) {
                        compile = XWPFTemplate.compile((InputStream)inputStream, (Configure)config).render(dataSourceResultMap);
                        compile.write((OutputStream)outputStream);
                        compile.close();
                        continue;
                    }
                    if ("Excel".equals(desExportTemplate.getTemplateType())) {
                        tempDir = Files.createTempDirectory("tempDir", new FileAttribute[0]);
                        tempFile = Paths.get(tempDir.toString(), fileInfo.getOriginalFilename());
                        Files.copy(inputStream, tempFile, new CopyOption[0]);
                        TemplateExportParams templateExportParams = new TemplateExportParams(tempFile.toFile().getPath(), true, new String[0]);
                        Workbook workbook = ExcelExportUtil.exportExcel((TemplateExportParams)templateExportParams, dataSourceResultMap);
                        workbook.write((OutputStream)outputStream);
                        workbook.close();
                        continue;
                    }
                    if (!"Excel".equals(desExportTemplate.getTemplateType())) continue;
                    Files.delete(tempFile);
                    Files.delete(tempDir);
                    continue;
                }
                catch (Exception e) {
                    throw new BizException("\u6587\u4ef6\u5bfc\u51fa\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a" + e.getMessage(), (Throwable)e);
                }
                finally {
                    outputStream.flush();
                    ((OutputStream)outputStream).close();
                }
            }
            if (tempFolder == null) {
                throw new BizException("\u5bfc\u51fa\u6587\u4ef6\u4e3a\u7a7a");
            }
            File zip = ZipUtil.zip((File)tempFolder);
            FileUtil.del((File)tempFolder);
            CommonDownloadUtil.download((File)zip, (HttpServletResponse)response);
        }
        catch (Exception e) {
            throw new BizException("\u6587\u4ef6\u5bfc\u51fa\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a" + e.getMessage(), (Throwable)e);
        }
    }

    public Long generateExportFileByTemplateCode(Long primaryKey, String templateCode, Long dirId, String bizCode, Long bizId, Long stdFileId, String stdFileCode) {
        HashMap<String, Object> dataSourceResultMap = new HashMap<String, Object>();
        DesExportTemplate desExportTemplate = this.getByTemplateCode(templateCode);
        FileInfo fileInfo = this.documentService.getFileByFileId(desExportTemplate.getTemplateFile());
        ByteArrayInputStream inputStream = new ByteArrayInputStream(this.fileStorageService.download(fileInfo).bytes());
        LoopRowTableRenderPolicy policy = new LoopRowTableRenderPolicy();
        LoopColumnTableRenderPolicy columnPolicy = new LoopColumnTableRenderPolicy();
        ConfigureBuilder builder = Configure.newBuilder();
        builder.useSpringEL(false);
        Path tempDir = null;
        Path tempFile = null;
        HashMap<String, FlowProcessCommentVo> workFlowMap = new HashMap<String, FlowProcessCommentVo>();
        String procInstId = null;
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(primaryKey.toString()).singleResult();
        if (historicProcessInstance != null) {
            procInstId = historicProcessInstance.getRootProcessInstanceId();
        }
        if (procInstId != null) {
            List<FlowProcessCommentVo> commentList = this.getFlwProcessDetailComment(procInstId);
            Integer i = 0;
            while (i < commentList.size()) {
                workFlowMap.put(String.valueOf(i + 1), commentList.get(i));
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
        }
        dataSourceResultMap.put("workFlowData", workFlowMap);
        List dataSourceList = JSONArray.parseArray((String)desExportTemplate.getDataSource(), JSONObject.class);
        Db db = DbUtil.use((DataSource)this.dataSource);
        for (JSONObject dataSource : dataSourceList) {
            if ("SQL".equals(dataSource.get("type"))) {
                String stringSql = JSONObject.parseObject((String)JSONObject.toJSONString((Object)dataSource.get("config"), (JSONWriter.Feature[])new JSONWriter.Feature[0])).get("sql").toString();
                String replaceSql = StrUtil.replace((CharSequence)stringSql, (CharSequence)"#{primaryKey}", (CharSequence)primaryKey.toString());
                try {
                    List sqlResultList = db.query(replaceSql, new Object[0]);
                    if (sqlResultList.size() == 0) {
                        HashMap singleEntityMap = new HashMap();
                        ArrayList singleMapList = new ArrayList();
                        builder.bind(dataSource.getString("code") + "List", (RenderPolicy)policy);
                        dataSourceResultMap.put(dataSource.getString("code") + "List", singleMapList);
                        builder.bind(dataSource.getString("code") + "ColumnList", (RenderPolicy)columnPolicy);
                        dataSourceResultMap.put(dataSource.getString("code") + "ColumnList", singleMapList);
                        dataSourceResultMap.put(dataSource.getString("code") + "Map", singleEntityMap);
                    }
                    if (sqlResultList.size() == 1) {
                        Entity entity2 = (Entity)sqlResultList.get(0);
                        HashMap<String, Object> singleEntityMap = new HashMap<String, Object>();
                        ArrayList<HashMap<String, Object>> singleMapList = new ArrayList<HashMap<String, Object>>();
                        entity2.getFieldNames().stream().forEach(fieldName -> singleEntityMap.put((String)fieldName, entity2.get(fieldName)));
                        if (singleEntityMap.containsKey("file_id") && singleEntityMap.get("file_id") != null) {
                            Long fileId = Long.valueOf(singleEntityMap.get("file_id").toString());
                            FileInfo attachmentInfo = this.documentService.getFileByFileId(fileId);
                            String fileType = attachmentInfo.getOriginalFilename().substring(attachmentInfo.getOriginalFilename().lastIndexOf(".") + 1);
                            ByteArrayInputStream attachmentInputStream = new ByteArrayInputStream(this.fileStorageService.download(attachmentInfo).bytes());
                            builder.bind(dataSource.getString("code") + "Attachment", (RenderPolicy)new AttachmentRenderPolicy());
                            if ("docx".equals(fileType)) {
                                dataSourceResultMap.put(dataSource.getString("code") + "Attachment", Attachments.ofStream((InputStream)attachmentInputStream, (AttachmentType)AttachmentType.DOCX).create());
                            } else if ("xlsx".equals(fileType)) {
                                dataSourceResultMap.put(dataSource.getString("code") + "Attachment", Attachments.ofStream((InputStream)attachmentInputStream, (AttachmentType)AttachmentType.XLSX).create());
                            }
                        }
                        for (String key : singleEntityMap.keySet()) {
                            byte[] imageBytes;
                            if (!key.startsWith("image_id")) continue;
                            FileInfo imageInfo = null;
                            if (singleEntityMap.get(key) != null && !"".equals(singleEntityMap.get(key))) {
                                imageInfo = this.documentService.getFileByFileId(Long.valueOf(singleEntityMap.get(key).toString()));
                            }
                            if (imageInfo == null || (imageBytes = this.fileStorageService.download(imageInfo).bytes()) == null || imageBytes.length <= 0) continue;
                            if ("Word".equals(desExportTemplate.getTemplateType())) {
                                ByteArrayInputStream imageInputStream = new ByteArrayInputStream(imageBytes);
                                singleEntityMap.put(key + "Image", Pictures.ofStream((InputStream)imageInputStream).size(120, 80).create());
                                continue;
                            }
                            if (!"Excel".equals(desExportTemplate.getTemplateType())) continue;
                            ImageEntity imageEntity = new ImageEntity();
                            imageEntity.setData(imageBytes);
                            imageEntity.setWidth(120);
                            imageEntity.setHeight(80);
                            singleEntityMap.put(key + "Image", imageEntity);
                        }
                        singleMapList.add(singleEntityMap);
                        builder.bind(dataSource.getString("code") + "List", (RenderPolicy)policy);
                        dataSourceResultMap.put(dataSource.getString("code") + "List", singleMapList);
                        builder.bind(dataSource.getString("code") + "ColumnList", (RenderPolicy)columnPolicy);
                        dataSourceResultMap.put(dataSource.getString("code") + "ColumnList", singleMapList);
                        dataSourceResultMap.put(dataSource.getString("code") + "Map", singleEntityMap);
                        continue;
                    }
                    List multipleMapList = sqlResultList.stream().map(entity -> {
                        HashMap<String, Object> singleEntityMap = new HashMap<String, Object>();
                        entity.getFieldNames().stream().forEach(fieldName -> singleEntityMap.put((String)fieldName, entity.get(fieldName)));
                        for (String key : singleEntityMap.keySet()) {
                            byte[] imageBytes;
                            if (!key.startsWith("image_id")) continue;
                            FileInfo imageInfo = null;
                            if (singleEntityMap.get(key) != null && !"".equals(singleEntityMap.get(key))) {
                                imageInfo = this.documentService.getFileByFileId(Long.valueOf(singleEntityMap.get(key).toString()));
                            }
                            if (imageInfo == null || (imageBytes = this.fileStorageService.download(imageInfo).bytes()) == null || imageBytes.length <= 0) continue;
                            if ("Word".equals(desExportTemplate.getTemplateType())) {
                                ByteArrayInputStream imageInputStream = new ByteArrayInputStream(imageBytes);
                                singleEntityMap.put(key + "Image", Pictures.ofStream((InputStream)imageInputStream).size(120, 80).create());
                                continue;
                            }
                            if (!"Excel".equals(desExportTemplate.getTemplateType())) continue;
                            ImageEntity imageEntity = new ImageEntity();
                            imageEntity.setData(imageBytes);
                            imageEntity.setWidth(120);
                            imageEntity.setHeight(80);
                            singleEntityMap.put(key + "Image", imageEntity);
                        }
                        return singleEntityMap;
                    }).collect(Collectors.toList());
                    builder.bind(dataSource.getString("code") + "List", (RenderPolicy)policy);
                    dataSourceResultMap.put(dataSource.getString("code") + "List", multipleMapList);
                    builder.bind(dataSource.getString("code") + "ColumnList", (RenderPolicy)columnPolicy);
                    dataSourceResultMap.put(dataSource.getString("code") + "ColumnList", multipleMapList);
                    continue;
                }
                catch (SQLException e) {
                    throw new BizException(StrUtil.format((CharSequence)"\u6570\u636e\u6e90\u6267\u884c\u51fa\u9519,\u540d\u79f0:[{}],\u9519\u8bef:{}", (Object[])new Object[]{dataSource.get("name"), e.getMessage()}));
                }
            }
            if (!"JavaBean".equals(dataSource.get("type"))) continue;
        }
        Configure config = builder.build();
        XWPFTemplate compile = null;
        try {
            Path tempFolder = Files.createTempDirectory("tmp", new FileAttribute[0]);
            File file = Paths.get(tempFolder.toString(), "\u5bfc\u51fa\u6570\u636e" + fileInfo.getOriginalFilename()).toFile();
            FileOutputStream outputStream = new FileOutputStream(file);
            if ("Word".equals(desExportTemplate.getTemplateType())) {
                compile = XWPFTemplate.compile((InputStream)inputStream, (Configure)config).render(dataSourceResultMap);
                compile.write((OutputStream)outputStream);
                compile.close();
            } else if ("Excel".equals(desExportTemplate.getTemplateType())) {
                tempDir = Files.createTempDirectory("tempDir", new FileAttribute[0]);
                tempFile = Paths.get(tempDir.toString(), fileInfo.getOriginalFilename());
                Files.copy(inputStream, tempFile, new CopyOption[0]);
                TemplateExportParams templateExportParams = new TemplateExportParams(tempFile.toFile().getPath(), true, new String[0]);
                Workbook workbook = ExcelExportUtil.exportExcel((TemplateExportParams)templateExportParams, dataSourceResultMap);
                workbook.write((OutputStream)outputStream);
                workbook.close();
            }
            if ("Excel".equals(desExportTemplate.getTemplateType())) {
                Files.delete(tempFile);
                Files.delete(tempDir);
            }
            MultipartFile tempMultipartFile = this.convertToMultipartFile(file);
            return this.documentService.upload(tempMultipartFile, dirId, bizCode, bizId, stdFileId, stdFileCode);
        }
        catch (Exception e) {
            throw new BizException("\u6587\u4ef6\u4fdd\u5b58\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a" + e.getMessage(), (Throwable)e);
        }
    }

    public List<JSONObject> previewSql(String sql) {
        Db db = DbUtil.use((DataSource)this.dataSource);
        try {
            List sqlResultList = db.query(sql, new Object[0]);
            List<JSONObject> list = sqlResultList.stream().map(entity -> JSON.parseObject((String)JSON.toJSONString((Object)entity))).collect(Collectors.toList());
            return list;
        }
        catch (SQLException e) {
            throw new BizException(StrUtil.format((CharSequence)"\u6570\u636e\u6e90\u6267\u884c\u51fa\u9519,\u9519\u8bef:{}", (Object[])new Object[]{e.getMessage()}));
        }
    }

    public List<FlowProcessCommentVo> getFlwProcessDetailComment(String processInstanceId) {
        List historicTaskInstanceList = ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId).orderByHistoricActivityInstanceStartTime().asc()).list();
        List processInstanceCommentList = this.taskService.getProcessInstanceComments(processInstanceId);
        ArrayList commonList = CollectionUtil.newArrayList((Object[])new FlowProcessCommentVo[0]);
        historicTaskInstanceList.forEach(historicTaskInstance -> this.getTaskCommentList(processInstanceCommentList, historicTaskInstance.getId()).forEach(taskComment -> {
            FlowProcessCommentVo flwProcessComment = new FlowProcessCommentVo();
            flwProcessComment.setTaskId(historicTaskInstance.getId());
            flwProcessComment.setTaskName(historicTaskInstance.getName());
            JSONObject commonObject = JSONObject.parseObject((String)taskComment.getFullMessage());
            flwProcessComment.setActivityId(historicTaskInstance.getTaskDefinitionKey());
            flwProcessComment.setUserId(taskComment.getUserId());
            flwProcessComment.setUserName(commonObject.getString("USER_NAME"));
            flwProcessComment.setOperateType(commonObject.getString("OPERATE_TYPE"));
            flwProcessComment.setOperateText(commonObject.getString("OPERATE_TEXT"));
            flwProcessComment.setComment(ObjectUtil.isNotEmpty((Object)commonObject.getString("COMMENT")) ? commonObject.getString("COMMENT") : "\u65e0");
            flwProcessComment.setApproveTime(DateUtil.formatDateTime((Date)taskComment.getTime()));
            flwProcessComment.setApproveTimeFormat(new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5").format(taskComment.getTime()));
            flwProcessComment.setAttachmentList(this.taskService.getTaskAttachments(historicTaskInstance.getId()).stream().map(attachment -> {
                FlowTaskAttachmentVo flwTaskAttachmentResult = new FlowTaskAttachmentVo();
                flwTaskAttachmentResult.setAttachmentName(attachment.getName());
                flwTaskAttachmentResult.setAttachmentUrl(attachment.getUrl());
                return flwTaskAttachmentResult;
            }).collect(Collectors.toList()));
            commonList.add(flwProcessComment);
        }));
        CollectionUtil.sort((List)commonList, Comparator.comparing(FlowProcessCommentVo::getApproveTime));
        return commonList;
    }

    public List<Comment> getTaskCommentList(List<Comment> originDataList, String taskId) {
        return originDataList.stream().filter(comment -> comment.getTaskId().equals(taskId)).collect(Collectors.toList());
    }

    public MultipartFile convertToMultipartFile(File file) throws IOException {
        String fileName = file.getName();
        String contentType = "application/octet-stream";
        FileInputStream inputStream = new FileInputStream(file);
        return new MockMultipartFile(fileName, fileName, contentType, (InputStream)inputStream);
    }
}

