/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.iframe.web.design.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.db.meta.JdbcType;
import cn.hutool.db.meta.MetaUtil;
import cn.hutool.db.meta.TableType;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONWriter;
import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.toolkit.JdbcUtils;
import com.github.yulichang.base.MPJBaseServiceImpl;
import com.kdgcsoft.iframe.web.base.enums.HideColumns;
import com.kdgcsoft.iframe.web.common.embed.dict.DataModelColumnType;
import com.kdgcsoft.iframe.web.common.embed.dict.DataModelType;
import com.kdgcsoft.iframe.web.common.exception.BizException;
import com.kdgcsoft.iframe.web.common.pojo.PageRequest;
import com.kdgcsoft.iframe.web.design.adapter.DbColumnTypeAdapter;
import com.kdgcsoft.iframe.web.design.adapter.DefaultSqlColumnTypeAdapter;
import com.kdgcsoft.iframe.web.design.adapter.MySqlColumnTypeAdapter;
import com.kdgcsoft.iframe.web.design.adapter.PostgreSqlColumnTypeAdapter;
import com.kdgcsoft.iframe.web.design.entity.DesDataModel;
import com.kdgcsoft.iframe.web.design.entity.DesDataModelColumn;
import com.kdgcsoft.iframe.web.design.entity.DesDataModelHis;
import com.kdgcsoft.iframe.web.design.entity.DesDataModelSync;
import com.kdgcsoft.iframe.web.design.interceptor.DesDataModelSyncInterceptor;
import com.kdgcsoft.iframe.web.design.mapper.DesDataModelMapper;
import com.kdgcsoft.iframe.web.design.pojo.TableInfo;
import com.kdgcsoft.iframe.web.design.service.DataModelSyncCallback;
import com.kdgcsoft.iframe.web.design.service.DesDataModelHisService;
import com.kdgcsoft.iframe.web.design.service.DesDataModelSyncService;
import com.kdgcsoft.iframe.web.design.util.DbMetaUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import org.anyline.metadata.Column;
import org.anyline.metadata.PrimaryKey;
import org.anyline.metadata.Table;
import org.anyline.service.AnylineService;
import org.anyline.util.ConfigTable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@CacheConfig(cacheNames={"DesDataModel"})
public class DesDataModelService
extends MPJBaseServiceImpl<DesDataModelMapper, DesDataModel> {
    public static final String CACHE_NAME = "DesDataModel";
    @Value(value="${spring.datasource.url}")
    private String jdbcUrl;
    @Autowired
    private AnylineService<?> anylineService;
    @Autowired
    private DesDataModelHisService dataModelHisService;
    @Autowired
    private DesDataModelSyncService modelSyncService;
    @Autowired
    private DesDataModelSyncInterceptor syncInterceptor;
    @Autowired
    private DataSource dataSource;
    private DbColumnTypeAdapter columnTypeAdapter;

    public List<DesDataModelHis> listDataModelHis(Long modelId) {
        return this.dataModelHisService.listDataModelHis(modelId);
    }

    public List<DesDataModelSync> listDataModelSync(Long modelId) {
        return this.modelSyncService.listDataModelSync(modelId);
    }

    @PostConstruct
    public void setDBType() {
        ConfigTable.IS_SHOW_SQL = false;
        ConfigTable.IS_DEBUG = false;
        DbType dbType = JdbcUtils.getDbType((String)this.jdbcUrl);
        this.columnTypeAdapter = dbType == DbType.POSTGRE_SQL ? new PostgreSqlColumnTypeAdapter() : (dbType == DbType.MYSQL ? new MySqlColumnTypeAdapter() : new DefaultSqlColumnTypeAdapter());
    }

    @Transactional(rollbackFor={Throwable.class})
    public void updateDesDataModel(DesDataModel model) {
        DesDataModel old = (DesDataModel)((Object)this.getById(model.getModelId()));
        DesDataModelHis his = DesDataModelHis.from(old);
        this.dataModelHisService.save(his);
        model.setSynced(0);
        this.checkModelColumn(model);
        this.updateById((Object)model);
    }

    public void saveEntity(DesDataModel model) {
        String modelCode = StrUtil.upperFirst((CharSequence)StrUtil.toCamelCase((CharSequence)model.getDbTable()));
        DesDataModel exists = this.getByModelCode(modelCode);
        if (exists != null) {
            throw new BizException("\u6a21\u578b\u7f16\u7801 [ " + modelCode + " ] \u5df2\u7ecf\u5b58\u5728!");
        }
        model.setModelCode(modelCode);
        model.setOldDbTable(model.getDbTable());
        if (model.getSynced() != 1) {
            model.setSynced(0);
        }
        model.setEmbed(0);
        this.checkModelColumn(model);
        this.save((Object)model);
    }

    private void checkModelColumn(DesDataModel model) {
        List<DesDataModelColumn> columns = model.getColumns();
        if (CollUtil.isEmpty(columns)) {
            throw new BizException("\u6a21\u578b[" + model.getDbTable() + "]\u7f3a\u5c11\u5b57\u6bb5\u4fe1\u606f");
        }
        for (DesDataModelColumn col : columns) {
            if (col.getColumnType() == DataModelColumnType.ID) {
                col.setIsPk(1);
                col.setNotNull(1);
            }
            if (StrUtil.isBlank((CharSequence)col.getModelCode())) {
                col.setModelCode(model.getModelCode());
            }
            String colCode = StrUtil.upperFirst((CharSequence)StrUtil.toCamelCase((CharSequence)col.getDbColumn()));
            if (StrUtil.isBlank((CharSequence)col.getColumnCode())) {
                col.setColumnCode(colCode);
            } else if (!col.getColumnCode().equals(colCode)) {
                col.setColumnCode(colCode);
            }
            if (StrUtil.isBlank((CharSequence)col.getOldDbColumn())) {
                col.setOldDbColumn(col.getDbColumn());
            }
            if (null == col.getOldColumnType()) {
                col.setOldColumnType(col.getColumnType());
            }
            if (null == col.getOldDefValue()) {
                col.setOldDefValue(col.getDefValue());
            }
            if (col.getColumnType() == DataModelColumnType.VARCHAR && col.getSize() < 1) {
                col.setSize(32);
            }
            if (col.getColumnType() == DataModelColumnType.BIGINT && col.getSize() < 1) {
                col.setSize(10);
            }
            if (col.getColumnType() != DataModelColumnType.DOUBLE || col.getScale() >= 1) continue;
            col.setScale(0);
        }
        model.setColumnJson(JSONArray.toJSONString(columns, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.IgnoreNonFieldGetter}));
    }

    public void delete(DesDataModel model) {
        String tableName = model.getDbTable();
        Table table = this.anylineService.metadata().table(tableName);
        if (null != table) {
            try {
                this.anylineService.ddl().drop(table);
            }
            catch (Exception e) {
                throw new BizException("\u8868[" + tableName + "]\u5220\u9664\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a" + e.getMessage(), (Throwable)e);
            }
        }
    }

    public void sync(DesDataModel model, DataModelSyncCallback callback) throws Exception {
        String tableName = model.getDbTable();
        List<DesDataModelColumn> columns = model.getColumns();
        if (CollUtil.isEmpty(columns)) {
            throw new BizException("\u8868\u6a21\u578b[" + tableName + "]\u7f3a\u5c11\u5b57\u6bb5\u4fe1\u606f");
        }
        columns.forEach(column -> {
            if (column.getNotNull() == null) {
                column.setNotNull(0);
            }
        });
        Table table = this.anylineService.metadata().table(tableName);
        this.syncInterceptor.startSync();
        try {
            if (null != table) {
                this.updateTable(model);
            } else {
                this.createNewTable(model);
            }
        }
        catch (Exception e) {
            throw new BizException(e.getMessage(), (Throwable)e);
        }
        finally {
            List<String> sqls = this.syncInterceptor.endSync();
            if (CollUtil.isNotEmpty(sqls)) {
                DesDataModelSync sync = new DesDataModelSync();
                sync.setModelId(model.getModelId());
                sync.setSyncSql(JSON.toJSONString(sqls));
                this.modelSyncService.save((Object)sync);
            }
        }
        model.setOldDbTable(model.getDbTable());
        for (DesDataModelColumn col : columns) {
            col.setOldDbColumn(col.getDbColumn());
            col.setOldColumnType(col.getColumnType());
        }
        this.checkModelColumn(model);
        model.setColumnJson(JSONArray.toJSONString(columns, (JSONWriter.Feature[])new JSONWriter.Feature[0]));
        callback.afterSyncSuccess(model);
    }

    public PageRequest pageDataModel(PageRequest page, String searchKey, List<String> dictValues) {
        LambdaQueryWrapper desDataModelLambdaQueryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().in(!dictValues.isEmpty(), DesDataModel::getModelGroup, dictValues)).and(StrUtil.isNotEmpty((CharSequence)searchKey), wr -> ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wr.like(DesDataModel::getModelCode, (Object)searchKey)).or()).like(DesDataModel::getModelName, (Object)searchKey)).or()).like(DesDataModel::getDbTable, (Object)searchKey))).orderByDesc(DesDataModel::getModelId);
        page = (PageRequest)((DesDataModelMapper)this.baseMapper).selectPage((IPage)page, (Wrapper)desDataModelLambdaQueryWrapper);
        return page;
    }

    public DesDataModel getByModelCode(String modelCode) {
        return (DesDataModel)((Object)((DesDataModelMapper)this.baseMapper).selectOne((Wrapper)new QueryWrapper().lambda().eq(DesDataModel::getModelCode, (Object)modelCode)));
    }

    private void createNewTable(DesDataModel model) {
        String tableName = model.getDbTable();
        Table table = new Table(tableName);
        table.setComment(model.getModelName());
        List<DesDataModelColumn> columns = model.getColumns();
        for (DesDataModelColumn column : columns) {
            try {
                int size = 0;
                int scale = 0;
                if (column.getColumnType() == DataModelColumnType.DOUBLE) {
                    size = null == column.getSize() ? 0 : column.getSize();
                    scale = null == column.getScale() ? 0 : column.getScale();
                }
                String columnName = column.getDbColumn();
                String columnTypeDef = this.columnTypeAdapter.toDbColumnType(column.getColumnType(), size, scale);
                boolean isPk = column.getIsPk() == 1;
                boolean nullable = column.getNotNull() == 0;
                Column columnDB = new Column();
                columnDB.setName(columnName);
                columnDB.setNullable(Boolean.valueOf(nullable));
                columnDB.setDefaultValue((Object)column.getDefValue());
                columnDB.setTypeName(columnTypeDef);
                columnDB.setComment(column.getColumnName());
                columnDB.setPrimaryKey(Boolean.valueOf(isPk));
                table.addColumn(columnDB);
            }
            catch (Exception e) {
                throw new BizException("\u521b\u5efa\u8868[" + tableName + "]\u6dfb\u52a0\u5217[" + column.getDbColumn() + "]\u5931\u8d25\uff0c\u539f\u56e0\u662f:" + e.getMessage(), (Throwable)e);
            }
        }
        try {
            this.anylineService.ddl().create(table);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new BizException("\u8868[" + tableName + "]\u7ed3\u6784\u521b\u5efa\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a" + e.getMessage(), (Throwable)e);
        }
    }

    private void updateTable(DesDataModel model) {
        String oldTableName;
        String curTableName;
        String tableName = model.getOldDbTable();
        List<DesDataModelColumn> columns = model.getColumns();
        Table table = this.anylineService.metadata().table(tableName);
        PrimaryKey oldPk = table.getPrimaryKey();
        ArrayList<Column> pkCols = new ArrayList<Column>();
        List allColNames = table.getColumns().values().stream().map(Column::getName).collect(Collectors.toList());
        boolean pkChanged = false;
        for (DesDataModelColumn column : columns) {
            Column curColumn;
            boolean nullable;
            String curColName = column.getDbColumn();
            String oldColName = column.getOldDbColumn();
            boolean isPk = column.getIsPk() == 1;
            boolean bl = nullable = column.getNotNull() == 0;
            if (allColNames.contains(oldColName)) {
                boolean oldNullable;
                boolean same;
                boolean needAlter = false;
                curColumn = table.getColumn(oldColName);
                if (!curColName.equals(oldColName)) {
                    curColumn.setNewName(curColName);
                    needAlter = true;
                    if (isPk) {
                        pkChanged = true;
                    }
                }
                if (curColumn.isPrimaryKey() == 1 && !isPk) {
                    pkChanged = true;
                }
                if (curColumn.isPrimaryKey() != 1 && isPk) {
                    pkChanged = true;
                }
                DataModelColumnType oldColType = column.getOldColumnType();
                DataModelColumnType curColType = column.getColumnType();
                if (curColType != oldColType) {
                    curColumn.setTypeName(this.columnTypeAdapter.toDbColumnType(curColType, column.getSize(), column.getScale()));
                    needAlter = true;
                }
                if (!(same = StrUtil.equals((CharSequence)column.getOldDefValue(), (CharSequence)column.getDefValue()))) {
                    curColumn.setDefaultValue((Object)column.getDefValue());
                    needAlter = true;
                }
                boolean bl2 = oldNullable = curColumn.isNullable() == 1;
                if (oldNullable != nullable) {
                    curColumn.setNullable(Boolean.valueOf(nullable));
                    needAlter = true;
                }
                if (!StrUtil.equals((CharSequence)curColumn.getComment(), (CharSequence)column.getColumnName())) {
                    curColumn.setComment(column.getColumnName());
                    needAlter = true;
                }
                if (needAlter) {
                    try {
                        this.anylineService.ddl().alter(curColumn);
                    }
                    catch (Exception e) {
                        throw new BizException("\u8868[" + tableName + "]\u5b57\u6bb5[" + oldColName + "]\u4fee\u6539\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a" + e.getMessage(), (Throwable)e);
                    }
                }
                allColNames.remove(oldColName);
            } else {
                Column columnDB = new Column();
                columnDB.setName(oldColName);
                columnDB.setNullable(Boolean.valueOf(nullable));
                columnDB.setDefaultValue((Object)column.getDefValue());
                columnDB.setTypeName(column.getDefValue());
                columnDB.setComment(column.getColumnName());
                columnDB.setPrimaryKey(Boolean.valueOf(isPk));
                try {
                    this.anylineService.ddl().add(columnDB);
                }
                catch (Exception e) {
                    throw new BizException("\u8868[" + tableName + "]\u5b57\u6bb5[" + oldColName + "]\u65b0\u589e\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a" + e.getMessage(), (Throwable)e);
                }
                curColumn = columnDB;
            }
            curColumn.setPrimaryKey(Boolean.valueOf(isPk));
            if (!isPk) continue;
            pkCols.add(curColumn);
        }
        if (allColNames.size() > 0) {
            for (String col : allColNames) {
                Column removeCol = table.getColumn(col);
                if (removeCol.isPrimaryKey() == 1) {
                    pkChanged = true;
                }
                try {
                    this.anylineService.ddl().drop(removeCol);
                }
                catch (Exception e) {
                    throw new BizException("\u8868[" + tableName + "]\u5b57\u6bb5[" + col + "]\u5220\u9664\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a" + e.getMessage(), (Throwable)e);
                }
            }
        }
        if (pkChanged) {
            PrimaryKey newPk = new PrimaryKey();
            newPk.setTable(table);
            pkCols.forEach(arg_0 -> ((PrimaryKey)newPk).addColumn(arg_0));
            try {
                if (null != oldPk) {
                    this.anylineService.ddl().drop(oldPk);
                }
                this.anylineService.ddl().add(newPk);
            }
            catch (Exception e) {
                throw new BizException("\u8868[" + tableName + "]\u4e3b\u952e\u4fee\u6539\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a" + e.getMessage(), (Throwable)e);
            }
            table.setPrimaryKey(newPk);
        }
        if (!StrUtil.equals((CharSequence)table.getComment(), (CharSequence)model.getModelName())) {
            table.setComment(model.getModelName());
            try {
                this.anylineService.ddl().alter(table);
            }
            catch (Exception e) {
                throw new BizException("\u8868[" + tableName + "]\u6ce8\u91ca\u4fee\u6539\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a" + e.getMessage(), (Throwable)e);
            }
        }
        if (!(curTableName = model.getDbTable()).equals(oldTableName = model.getOldDbTable())) {
            table.setNewName(curTableName);
        }
        try {
            this.anylineService.ddl().alter(table);
        }
        catch (Exception e) {
            throw new BizException("\u8868[" + tableName + "]\u4fe1\u606f\u4fee\u6539\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a" + e.getMessage(), (Throwable)e);
        }
    }

    public List<DesDataModel> listDataModel(String searchKey) {
        return ((DesDataModelMapper)this.baseMapper).selectList((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().and(StrUtil.isNotEmpty((CharSequence)searchKey), wr -> ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wr.like(DesDataModel::getModelCode, (Object)searchKey)).or()).like(DesDataModel::getModelName, (Object)searchKey)).or()).like(DesDataModel::getDbTable, (Object)searchKey))).orderByDesc(DesDataModel::getModelId));
    }

    public List<DesDataModel> getLinkModelByModelCode(String modelCode) {
        ArrayList<DesDataModel> linkList = new ArrayList<DesDataModel>();
        List<DesDataModel> list = this.listDataModel("");
        block0: for (DesDataModel desDataModel : list) {
            for (DesDataModelColumn desDataModelColumn : desDataModel.getColumns()) {
                if (!desDataModelColumn.getColumnType().text().equals("\u5916\u952e") || !modelCode.equals(desDataModelColumn.getLinkModel())) continue;
                linkList.add(desDataModel);
                continue block0;
            }
        }
        return linkList;
    }

    public List<TableInfo> listQueryDBTableAndView() {
        List views;
        List existsModels = this.list();
        Map<Object, Object> existsModelNames = CollUtil.isNotEmpty((Collection)existsModels) ? existsModels.stream().collect(Collectors.toMap(DesDataModel::getDbTable, DesDataModel::getModelCode)) : new HashMap(1);
        ArrayList<TableInfo> list = new ArrayList<TableInfo>();
        List tableNames = MetaUtil.getTables((DataSource)this.dataSource);
        if (CollUtil.isNotEmpty((Collection)tableNames)) {
            tableNames.forEach(name -> {
                if (existsModelNames.containsKey(name)) {
                    list.add(new TableInfo(TableType.TABLE.value(), (String)name, (String)existsModelNames.get(name)));
                } else {
                    list.add(new TableInfo(TableType.TABLE.value(), (String)name));
                }
            });
        }
        if (CollUtil.isNotEmpty((Collection)(views = MetaUtil.getTables((DataSource)this.dataSource, (TableType[])new TableType[]{TableType.VIEW})))) {
            views.forEach(name -> list.add(new TableInfo(TableType.VIEW.value(), (String)name)));
        }
        return list;
    }

    public void importDataModel(String type, String name, String modelName, String modelGroup) {
        cn.hutool.db.meta.Table table = null;
        if (TableType.TABLE.value().equals(type)) {
            table = DbMetaUtil.getTableMeta(this.dataSource, TableType.TABLE, name);
        }
        if (TableType.VIEW.value().equals(type)) {
            table = DbMetaUtil.getTableMeta(this.dataSource, TableType.VIEW, name);
        }
        if (null != table) {
            DesDataModel model = new DesDataModel();
            model.setModelName(modelName);
            model.setDbTable(table.getTableName());
            model.setOldDbTable(table.getTableName());
            model.setModelType(DataModelType.TABLE);
            model.setSynced(1);
            model.setDescription(table.getComment());
            model.setModelGroup(modelGroup);
            int orderNo = 1;
            ArrayList<DesDataModelColumn> cols = new ArrayList<DesDataModelColumn>();
            for (cn.hutool.db.meta.Column column : table.getColumns()) {
                DesDataModelColumn col = new DesDataModelColumn();
                col.setColumnName(StrUtil.isBlank((CharSequence)column.getComment()) ? column.getName() : column.getComment());
                col.setDbColumn(column.getName());
                String columnInDB = StrUtil.toCamelCase((CharSequence)column.getName()).toLowerCase();
                if (HideColumns.isHideColumnUsName((String)columnInDB)) {
                    col.setEmbed(1);
                }
                col.setColumnType(this.ofDataModelColumnType(column.getTypeEnum()));
                if (col.getColumnType() == DataModelColumnType.DOUBLE) {
                    col.setSize((int)column.getSize());
                    col.setScale(column.getDigit());
                }
                col.setIsPk(column.isPk() ? 1 : 0);
                col.setNotNull(column.isNullable() ? 0 : 1);
                col.setDefValue(column.getColumnDef());
                col.setOrderNo(orderNo++);
                cols.add(col);
            }
            String columnJson = JSONArray.toJSONString(cols, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.IgnoreNonFieldGetter});
            model.setColumnJson(columnJson);
            this.saveEntity(model);
        }
    }

    private DataModelColumnType ofDataModelColumnType(JdbcType jdbcType) {
        switch (jdbcType) {
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: {
                return DataModelColumnType.BIGINT;
            }
            case FLOAT: 
            case REAL: 
            case DOUBLE: 
            case NUMERIC: 
            case DECIMAL: {
                return DataModelColumnType.DOUBLE;
            }
            case CHAR: 
            case VARCHAR: 
            case NVARCHAR: 
            case NCHAR: 
            case NCLOB: {
                return DataModelColumnType.VARCHAR;
            }
            case LONGVARCHAR: 
            case LONGNVARCHAR: 
            case CLOB: {
                return DataModelColumnType.TEXT;
            }
            case DATE: 
            case TIME: 
            case TIME_WITH_TIMEZONE: {
                return DataModelColumnType.DATE;
            }
            case TIMESTAMP: 
            case TIMESTAMP_WITH_TIMEZONE: {
                return DataModelColumnType.DATETIME;
            }
        }
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u5217\u7c7b\u578b:" + jdbcType + " code:" + jdbcType.typeCode);
    }

    public boolean isRepeat(DesDataModel entity) {
        return ((DesDataModelMapper)this.baseMapper).exists((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DesDataModel::getModelCode, (Object)entity.getModelCode())).or()).eq(entity.getModelId() != null, DesDataModel::getModelId, (Object)entity.getModelId()));
    }

    public DesDataModel saveDataModel(DesDataModel entity) {
        String modelCode = StrUtil.upperFirst((CharSequence)StrUtil.toCamelCase((CharSequence)entity.getDbTable()));
        DesDataModel exists = this.getByModelCode(modelCode);
        if (exists != null) {
            this.update((Object)entity, (Wrapper)new LambdaQueryWrapper().eq(DesDataModel::getModelCode, (Object)modelCode));
        } else {
            entity.setModelCode(modelCode);
            entity.setOldDbTable(entity.getDbTable());
            this.save((Object)entity);
        }
        return entity;
    }

    public String getPrimaryKey(List<DesDataModelColumn> columns) {
        if (CollUtil.isNotEmpty(columns)) {
            Optional<DesDataModelColumn> first = columns.stream().filter(e -> e.isPrimary()).findFirst();
            if (!first.isPresent()) {
                throw new BizException("\u6570\u636e\u6a21\u578b\u6ca1\u6709\u7ed1\u5b9a\u4e3b\u952e");
            }
            return first.get().getDbColumn();
        }
        throw new BizException("\u672a\u914d\u7f6e\u6570\u636e\u6a21\u578b");
    }

    public String getPrimaryKey(Long modelId) {
        DesDataModel dataModel = (DesDataModel)((Object)this.getById(modelId));
        Optional<DesDataModelColumn> first = dataModel.getColumns().stream().filter(e -> e.isPrimary()).findFirst();
        return first.isPresent() ? first.get().getDbColumn() : null;
    }
}

