/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.iframe.web.design.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.github.yulichang.base.MPJBaseServiceImpl;
import com.kdgcsoft.iframe.web.common.exception.BizException;
import com.kdgcsoft.iframe.web.common.pojo.LoginUser;
import com.kdgcsoft.iframe.web.common.pojo.PageRequest;
import com.kdgcsoft.iframe.web.common.utils.SecurityUtil;
import com.kdgcsoft.iframe.web.common.utils.id.ShortId;
import com.kdgcsoft.iframe.web.design.entity.DesBizSn;
import com.kdgcsoft.iframe.web.design.entity.DesBizSnRecord;
import com.kdgcsoft.iframe.web.design.entity.DesBizSnRef;
import com.kdgcsoft.iframe.web.design.enums.SNRule;
import com.kdgcsoft.iframe.web.design.mapper.DesBizSnMapper;
import com.kdgcsoft.iframe.web.design.service.DesBizSnRecordService;
import com.kdgcsoft.iframe.web.design.service.DesBizSnRefService;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class DesBizSnService
extends MPJBaseServiceImpl<DesBizSnMapper, DesBizSn> {
    private static final Integer DEFAULT_START_SN = 1;
    @Autowired
    private DesBizSnRefService snRefService;
    @Autowired
    private DesBizSnRecordService recordService;

    public void saveBizSN(DesBizSn bizSN) {
        if (bizSN.getBizSnId() != null) {
            DesBizSn snInDB = (DesBizSn)((DesBizSnMapper)this.baseMapper).selectById(bizSN.getBizSnId());
            if (null == snInDB) {
                throw new BizException("\u4e1a\u52a1\u6d41\u6c34\u53f7\u914d\u7f6e[" + bizSN.getBizSnId() + "]\u4e0d\u5b58\u5728");
            }
            bizSN.setTemplateCode(snInDB.getTemplateCode());
            this.updateById(bizSN);
        } else {
            bizSN.setTemplateCode(ShortId.getId((String)"SN"));
            if (bizSN.getSnDigit() < 1 || bizSN.getSnDigit() > 10) {
                throw new BizException("\u975e\u6cd5\u7684\u6d41\u6c34\u4f4d\u6570:" + bizSN.getSnDigit());
            }
            ((DesBizSnMapper)this.baseMapper).insert(bizSN);
        }
    }

    public PageRequest<DesBizSn> pageQuery(PageRequest<DesBizSn> pageReq, String search) {
        return (PageRequest)((DesBizSnMapper)this.baseMapper).selectPage((IPage)pageReq, (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().like(StrUtil.isNotBlank((CharSequence)search), DesBizSn::getTemplateName, (Object)search)).or()).like(StrUtil.isNotBlank((CharSequence)search), DesBizSn::getSnPrefix, (Object)search)).orderByDesc(DesBizSn::getBizSnId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={Throwable.class})
    public String generateBizSN(String templateCode, Map<String, Object> params) {
        DesBizSn bizSN = ((DesBizSnMapper)this.baseMapper).selectForLock(templateCode);
        if (null == bizSN) {
            throw new BizException("\u4e1a\u52a1\u6d41\u6c34\u53f7\u914d\u7f6e[" + templateCode + "]\u4e0d\u5b58\u5728");
        }
        String monitor = "GENERATE_BIZ_SN_MONITOR_" + templateCode;
        String string = monitor.intern();
        synchronized (string) {
            int curSN;
            SNRule snRule = bizSN.getSnRule();
            String prefix = CollUtil.isEmpty(params) ? bizSN.getSnPrefix() : StrUtil.format((CharSequence)bizSN.getSnPrefix(), params);
            String timeFormat = bizSN.getSnTimeFormat().getCurPeriodTimeFormat();
            DesBizSnRef snRef = SNRule.PREFIX_TIME == snRule ? this.snRefService.findBySnPrefixAndTime(bizSN.getBizSnId(), prefix, timeFormat) : this.snRefService.findBySnTime(bizSN.getBizSnId(), timeFormat);
            if (null == snRef) {
                snRef = new DesBizSnRef();
                snRef.setBizSnId(bizSN.getBizSnId());
                snRef.setSnPrefixValue(prefix);
                snRef.setSnTime(timeFormat);
                snRef.setCurSn(DEFAULT_START_SN);
                curSN = DEFAULT_START_SN;
                this.snRefService.save(snRef);
            } else {
                curSN = snRef.getCurSn() + 1;
                snRef.setCurSn(curSN);
                this.snRefService.updateById(snRef);
            }
            String strCurSN = String.valueOf(curSN);
            if (strCurSN.length() > bizSN.getSnDigit()) {
                throw new BizException("\u6d41\u6c34\u53f7\u5df2\u8fbe\u5230\u6700\u5927\u5e8f\u53f7[" + (snRef.getCurSn() - 1) + "]\uff0c\u65e0\u6cd5\u518d\u751f\u6210\uff01");
            }
            String sn = StrUtil.padPre((CharSequence)strCurSN, (int)bizSN.getSnDigit(), (CharSequence)"0");
            String curBizSN = prefix + timeFormat + sn;
            DesBizSnRecord record = new DesBizSnRecord();
            record.setBizSnId(bizSN.getBizSnId());
            record.setSn(curBizSN);
            this.recordService.save(record);
            return curBizSN;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetBizSN(Long bizSnRefId) {
        DesBizSnRef ref = (DesBizSnRef)this.snRefService.getById(bizSnRefId);
        if (null == ref) {
            throw new BizException("\u6d41\u6c34\u53f7\u53c2\u7167[" + bizSnRefId + "]\u4e0d\u5b58\u5728");
        }
        String monitor = "RESET_BIZ_SN_MONITOR_" + ref.getBizSnId() + "_" + ref.getSnTime();
        String string = monitor.intern();
        synchronized (string) {
            ref.setCurSn(0);
            String resetInfo = ref.getResetInfo();
            if (StrUtil.isBlank((CharSequence)resetInfo)) {
                resetInfo = "[]";
            }
            LoginUser loginUser = SecurityUtil.getLoginUser();
            JSONArray resetArray = JSONArray.parse((String)resetInfo, (JSONReader.Feature[])new JSONReader.Feature[0]);
            JSONObject reset = new JSONObject();
            reset.put((Object)"reset_by", (Object)(null != loginUser ? loginUser.getUserId() : null));
            reset.put((Object)"reset_time", (Object)System.currentTimeMillis());
            resetArray.add((Object)reset);
            ref.setResetInfo(resetArray.toJSONString(new JSONWriter.Feature[0]));
            this.snRefService.updateById(ref);
        }
    }

    public DesBizSn findByCode(String templateCode) {
        return (DesBizSn)((DesBizSnMapper)this.baseMapper).selectOne((Wrapper)new QueryWrapper().lambda().eq(DesBizSn::getTemplateCode, (Object)templateCode));
    }
}

