/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.iframe.web.design.pojo;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.kdgcsoft.iframe.web.design.entity.DesMagicApi;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

public class MagicApiInfo
implements Serializable {
    private static final long serialVersionUID = -6032261256691959295L;
    private static final String DIR_POSTFIX = "/group.json";
    private static final String SEPARATOR = "================================";
    private String id;
    private String parentId;
    private String parentName;
    private String fullParentName;
    private List<String> allParentNames;
    private String name;
    private String fullName;
    private boolean isDir;
    private String path;
    private String url;
    private String method;
    private JSONArray params;

    public static MagicApiInfo of(DesMagicApi api) {
        String filePath;
        Object[] parts;
        MagicApiInfo info = new MagicApiInfo();
        String content = api.getFileContent();
        int index = content.indexOf(SEPARATOR);
        if (index > 0) {
            content = content.substring(0, index);
        }
        JSONObject contentJson = JSONObject.parse((String)content, (JSONReader.Feature[])new JSONReader.Feature[0]);
        info.setId(contentJson.getString("id"));
        info.setName(contentJson.getString("name"));
        info.setPath(contentJson.getString("path"));
        if (StrUtil.isNotBlank((CharSequence)info.getPath())) {
            info.setPath(info.getPath().replaceAll("/", ""));
        }
        if ((parts = (filePath = api.getFilePath().replace("magic-api/api/", "").replace(DIR_POSTFIX, "")).split("/")).length >= 2) {
            info.setParentName(parts[parts.length - 2]);
            info.setAllParentNames(Arrays.asList((String[])ArrayUtil.sub((Object[])parts, (int)0, (int)(parts.length - 1))));
            info.setFullParentName(String.join((CharSequence)"/", info.getAllParentNames()));
            info.setFullName(info.getFullParentName() + "/" + info.getName());
        } else {
            info.setParentId(null);
            info.setAllParentNames(null);
        }
        if (api.getFilePath().endsWith(DIR_POSTFIX)) {
            info.setDir(true);
        } else {
            info.setDir(false);
            info.setMethod(contentJson.getString("method"));
            if (contentJson.containsKey("parameters")) {
                info.setParams(contentJson.getJSONArray("parameters"));
            }
        }
        return info;
    }

    public String getId() {
        return this.id;
    }

    public String getParentId() {
        return this.parentId;
    }

    public String getParentName() {
        return this.parentName;
    }

    public String getFullParentName() {
        return this.fullParentName;
    }

    public List<String> getAllParentNames() {
        return this.allParentNames;
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.fullName;
    }

    public boolean isDir() {
        return this.isDir;
    }

    public String getPath() {
        return this.path;
    }

    public String getUrl() {
        return this.url;
    }

    public String getMethod() {
        return this.method;
    }

    public JSONArray getParams() {
        return this.params;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public void setParentName(String parentName) {
        this.parentName = parentName;
    }

    public void setFullParentName(String fullParentName) {
        this.fullParentName = fullParentName;
    }

    public void setAllParentNames(List<String> allParentNames) {
        this.allParentNames = allParentNames;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public void setDir(boolean isDir) {
        this.isDir = isDir;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setParams(JSONArray params) {
        this.params = params;
    }
}

