/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.iframe.web.design.magic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MagicJoined {
    private String leftTable;
    private final String leftColumn;
    private String rightTable;
    private final String rightColumn;
    private final String joinType;

    public MagicJoined(String joinType, String leftTable, String leftColumn, String rightTable, String rightColumn) {
        this.joinType = joinType;
        this.leftTable = leftTable;
        this.leftColumn = leftColumn;
        this.rightTable = rightTable;
        this.rightColumn = rightColumn;
    }

    public static MagicJoined inner(String leftTable, String leftColumn, String rightTable, String rightColumn) {
        return new MagicJoined("INNER JOIN", leftTable, leftColumn, rightTable, rightColumn);
    }

    public static MagicJoined left(String leftTable, String leftColumn, String rightTable, String rightColumn) {
        return new MagicJoined("LEFT JOIN", leftTable, leftColumn, rightTable, rightColumn);
    }

    public static MagicJoined right(String leftTable, String leftColumn, String rightTable, String rightColumn) {
        return new MagicJoined("RIGHT JOIN", leftTable, leftColumn, rightTable, rightColumn);
    }

    public List<String> onSql() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.leftTable + "." + this.leftColumn);
        list.add("=");
        list.add(this.rightTable + "." + this.rightColumn);
        return list;
    }

    public List<String> joinSql() {
        return Arrays.asList(this.joinType, this.rightTable, "ON");
    }

    public String getLeftTable() {
        return this.leftTable;
    }

    public String getLeftColumn() {
        return this.leftColumn;
    }

    public String getRightTable() {
        return this.rightTable;
    }

    public String getRightColumn() {
        return this.rightColumn;
    }

    public String getJoinType() {
        return this.joinType;
    }

    public void setLeftTable(String leftTable) {
        this.leftTable = leftTable;
    }

    public void setRightTable(String rightTable) {
        this.rightTable = rightTable;
    }
}

