/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.iframe.web.design.magic;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.kdgcsoft.iframe.web.design.magic.MagicConditioned;
import com.kdgcsoft.iframe.web.design.magic.MagicJoined;
import com.kdgcsoft.iframe.web.design.magic.MagicTableInfo;
import com.kdgcsoft.iframe.web.design.magic.SubFunction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class MagicJoin {
    private boolean useLogicDelete = true;
    private boolean logicDeleteInWhere = true;
    private boolean logicDeleteInOn;
    private String mainTable;
    private final Map<String, MagicTableInfo> tableInfoMap = new HashMap<String, MagicTableInfo>();
    private final List<MagicJoined> joinedList = new ArrayList<MagicJoined>();
    private final List<String> selectColumns = new ArrayList<String>();
    private final List<MagicConditioned> conditions = new ArrayList<MagicConditioned>();
    private final List<MagicConditioned> ors = new ArrayList<MagicConditioned>();
    private final List<String> orderByAsc = new ArrayList<String>();
    private final List<String> orderByDesc = new ArrayList<String>();

    public static void main(String[] args) {
        Long roleId = 1L;
        Long orgId = 1L;
        String searchKey = "\u738b";
        String sql = new MagicJoin().mainTable("base_user", "u").joinTable("base_org", "o").joinTable("base_dept", "d").select("u.*", "o.org_name", "d.dept_name").leftJoin("o", "org_id").leftJoin("d", "dept_id").notIn("u.user_id", (MagicJoin mj) -> mj.mainTable("base_role_user", false).select("user_id").eq("role_id", roleId)).eq("u.org_id", orgId).or(mj -> mj.like("u.emp_name", searchKey).like("u.user_name", searchKey)).orderBy("u.user_id").toSql();
        System.out.println(sql);
    }

    public String toSql() {
        ArrayList<String> items = new ArrayList<String>();
        items.add("SELECT");
        if (this.selectColumns.size() > 0) {
            items.add(String.join((CharSequence)", ", this.selectColumns));
        }
        items.add("FROM");
        items.add(this.mainTable);
        for (MagicJoined joined : this.joinedList) {
            joined.setLeftTable(this.mainTable);
            if (!this.tableInfoMap.containsKey(joined.getRightTable())) {
                this.tableInfoMap.values().stream().filter(j -> joined.getRightTable().equals(j.getTableAlias())).findFirst().ifPresent(j -> joined.setRightTable(j.getTableName()));
            }
            items.addAll(joined.joinSql());
            items.add("(");
            items.addAll(joined.onSql());
            if (this.useLogicDelete && this.logicDeleteInOn) {
                items.add("AND");
                items.addAll(this.logicDeleteItems(joined.getRightTable()));
            }
            items.add(")");
        }
        List<Object> whereConditions = new ArrayList<String>();
        List realConditions = this.conditions.stream().filter(MagicConditioned::isCondition).collect(Collectors.toList());
        for (MagicConditioned conditioned : realConditions) {
            whereConditions.add(conditioned.toCondition());
        }
        List realOrs = this.ors.stream().filter(MagicConditioned::isCondition).collect(Collectors.toList());
        if (realOrs.size() > 0) {
            ArrayList<String> orCondition = new ArrayList<String>();
            for (MagicConditioned conditioned : realOrs) {
                orCondition.add(conditioned.toCondition());
            }
            whereConditions.add("( " + String.join((CharSequence)" OR ", orCondition) + " )");
        }
        if (this.useLogicDelete) {
            whereConditions.add(String.join((CharSequence)" ", this.joinedList.size() > 0 ? this.logicDeleteItems(this.mainTable) : this.logicDeleteItems()));
            if (this.logicDeleteInWhere) {
                for (MagicJoined joined : this.joinedList) {
                    whereConditions.add(String.join((CharSequence)" ", this.logicDeleteItems(joined.getRightTable())));
                }
            }
        }
        if ((whereConditions = whereConditions.stream().filter(CharSequenceUtil::isNotBlank).collect(Collectors.toList())).size() > 0) {
            items.add("WHERE");
        }
        items.add(String.join((CharSequence)" AND ", whereConditions));
        if (this.orderByAsc.size() > 0 || this.orderByDesc.size() > 0) {
            ArrayList<String> orderBys = new ArrayList<String>();
            items.add("ORDER BY");
            for (String col : this.orderByAsc) {
                orderBys.add(col + " ASC");
            }
            for (String col : this.orderByDesc) {
                orderBys.add(col + " DESC");
            }
            items.add(String.join((CharSequence)", ", orderBys));
        }
        String sql = String.join((CharSequence)" ", items);
        if (this.tableInfoMap.size() > 0) {
            for (MagicTableInfo v : this.tableInfoMap.values()) {
                if (!StrUtil.isNotBlank((CharSequence)v.getTableAlias())) continue;
                String tableName = v.getTableName();
                String alias = v.getTableAlias();
                sql = sql.replaceAll(tableName + "\\.", alias + "\\.");
                sql = sql.replaceAll(tableName, tableName + " AS " + alias);
            }
        }
        return sql;
    }

    private List<String> logicDeleteItems(String table) {
        return this.logicDeleteItems0(table + ".");
    }

    private List<String> logicDeleteItems() {
        return this.logicDeleteItems0("");
    }

    private List<String> logicDeleteItems0(String table) {
        String qt = StrUtil.isBlank((CharSequence)table) ? this.mainTable : table.substring(0, table.length() - 1);
        if (this.tableInfoMap.containsKey(qt) && !this.tableInfoMap.get(qt).isHasLogicDelete()) {
            return Collections.emptyList();
        }
        return Arrays.asList(table + "deleted", "=", "0");
    }

    public MagicJoin mainTable(String mainTable) {
        this.mainTable = mainTable;
        this.tableInfoMap.put(mainTable, new MagicTableInfo(mainTable));
        return this;
    }

    public MagicJoin mainTable(String mainTable, String alias) {
        this.mainTable = mainTable;
        this.tableInfoMap.put(mainTable, new MagicTableInfo(mainTable, alias));
        return this;
    }

    public MagicJoin mainTable(String mainTable, boolean hasLogicDelete) {
        this.mainTable = mainTable;
        this.tableInfoMap.put(mainTable, new MagicTableInfo(mainTable, hasLogicDelete));
        return this;
    }

    public MagicJoin mainTable(String mainTable, String alias, boolean hasLogicDelete) {
        this.mainTable = mainTable;
        this.tableInfoMap.put(mainTable, new MagicTableInfo(mainTable, alias, hasLogicDelete));
        return this;
    }

    public MagicJoin joinTable(String joinTable) {
        this.tableInfoMap.put(joinTable, new MagicTableInfo(joinTable));
        return this;
    }

    public MagicJoin joinTable(String joinTable, String alias) {
        this.tableInfoMap.put(joinTable, new MagicTableInfo(joinTable, alias));
        return this;
    }

    public MagicJoin joinTable(String joinTable, boolean hasLogicDelete) {
        this.tableInfoMap.put(joinTable, new MagicTableInfo(joinTable, hasLogicDelete));
        return this;
    }

    public MagicJoin joinTable(String joinTable, String alias, boolean hasLogicDelete) {
        this.tableInfoMap.put(joinTable, new MagicTableInfo(joinTable, alias, hasLogicDelete));
        return this;
    }

    public MagicJoin innerJoin(String joinTable, String leftCol, String rightCol) {
        this.joinedList.add(MagicJoined.inner(this.mainTable, leftCol, joinTable, rightCol));
        return this;
    }

    public MagicJoin innerJoin(String joinTable, String col) {
        this.joinedList.add(MagicJoined.inner(this.mainTable, col, joinTable, col));
        return this;
    }

    public MagicJoin leftJoin(String joinTable, String leftCol, String rightCol) {
        this.joinedList.add(MagicJoined.left(this.mainTable, leftCol, joinTable, rightCol));
        return this;
    }

    public MagicJoin leftJoin(String joinTable, String col) {
        this.joinedList.add(MagicJoined.left(this.mainTable, col, joinTable, col));
        return this;
    }

    public MagicJoin rightJoin(String joinTable, String leftCol, String rightCol) {
        this.joinedList.add(MagicJoined.right(this.mainTable, leftCol, joinTable, rightCol));
        return this;
    }

    public MagicJoin rightJoin(String joinTable, String col) {
        this.joinedList.add(MagicJoined.right(this.mainTable, col, joinTable, col));
        return this;
    }

    public MagicJoin select(String ... columns) {
        this.selectColumns.addAll(Arrays.asList(columns));
        return this;
    }

    public MagicJoin or(SubFunction function) {
        MagicJoin mj = new MagicJoin();
        function.sub(mj);
        this.ors.addAll(mj.conditions);
        return this;
    }

    public MagicJoin in(String column, Collection<?> range) {
        this.conditions.add(MagicConditioned.in(column, range, true));
        return this;
    }

    public MagicJoin in(String column, Collection<?> range, boolean checkEmpty) {
        this.conditions.add(MagicConditioned.in(column, range, checkEmpty));
        return this;
    }

    public MagicJoin in(String column, Object[] range) {
        this.conditions.add(MagicConditioned.in(column, range, true));
        return this;
    }

    public MagicJoin in(String column, Object[] range, boolean checkEmpty) {
        this.conditions.add(MagicConditioned.in(column, range, checkEmpty));
        return this;
    }

    public MagicJoin in(String column, SubFunction func) {
        MagicJoin mj = new MagicJoin();
        func.sub(mj);
        this.conditions.add(MagicConditioned.in(column, mj.toSql()));
        return this;
    }

    public MagicJoin notIn(String column, SubFunction func) {
        MagicJoin mj = new MagicJoin();
        func.sub(mj);
        this.conditions.add(MagicConditioned.notIn(column, mj.toSql()));
        return this;
    }

    public MagicJoin notIn(String column, Collection<?> range) {
        this.conditions.add(MagicConditioned.notIn(column, range, true));
        return this;
    }

    public MagicJoin notIn(String column, Collection<?> range, boolean checkEmpty) {
        this.conditions.add(MagicConditioned.notIn(column, range, checkEmpty));
        return this;
    }

    public MagicJoin notIn(String column, Object[] range) {
        this.conditions.add(MagicConditioned.notIn(column, range, true));
        return this;
    }

    public MagicJoin notIn(String column, Object[] range, boolean checkEmpty) {
        this.conditions.add(MagicConditioned.notIn(column, range, checkEmpty));
        return this;
    }

    public MagicJoin eq(String column, Object val) {
        this.conditions.add(MagicConditioned.eq(column, val, true));
        return this;
    }

    public MagicJoin eq(String column, Object val, boolean checkEmpty) {
        this.conditions.add(MagicConditioned.eq(column, val, checkEmpty));
        return this;
    }

    public MagicJoin ne(String column, Object val) {
        this.conditions.add(MagicConditioned.ne(column, val, true));
        return this;
    }

    public MagicJoin ne(String column, Object val, boolean checkEmpty) {
        this.conditions.add(MagicConditioned.ne(column, val, checkEmpty));
        return this;
    }

    public MagicJoin gt(String column, Object val) {
        this.conditions.add(MagicConditioned.gt(column, val, true));
        return this;
    }

    public MagicJoin gt(String column, Object val, boolean checkEmpty) {
        this.conditions.add(MagicConditioned.gt(column, val, checkEmpty));
        return this;
    }

    public MagicJoin ge(String column, Object val) {
        this.conditions.add(MagicConditioned.ge(column, val, true));
        return this;
    }

    public MagicJoin ge(String column, Object val, boolean checkEmpty) {
        this.conditions.add(MagicConditioned.ge(column, val, checkEmpty));
        return this;
    }

    public MagicJoin lt(String column, Object val) {
        this.conditions.add(MagicConditioned.lt(column, val, true));
        return this;
    }

    public MagicJoin lt(String column, Object val, boolean checkEmpty) {
        this.conditions.add(MagicConditioned.lt(column, val, checkEmpty));
        return this;
    }

    public MagicJoin le(String column, Object val) {
        this.conditions.add(MagicConditioned.le(column, val, true));
        return this;
    }

    public MagicJoin le(String column, Object val, boolean checkEmpty) {
        this.conditions.add(MagicConditioned.le(column, val, checkEmpty));
        return this;
    }

    public MagicJoin between(String column, Object leftVal, Object rightValue) {
        this.conditions.add(MagicConditioned.between(column, leftVal, rightValue));
        return this;
    }

    public MagicJoin isNull(String column) {
        this.conditions.add(MagicConditioned.isNull(column));
        return this;
    }

    public MagicJoin isNotNull(String column) {
        this.conditions.add(MagicConditioned.isNotNull(column));
        return this;
    }

    public MagicJoin like(String column, String val) {
        this.conditions.add(MagicConditioned.like(column, val, true, true, true));
        return this;
    }

    public MagicJoin like(String column, String val, boolean checkEmpty) {
        this.conditions.add(MagicConditioned.like(column, val, checkEmpty, true, true));
        return this;
    }

    public MagicJoin likeLeft(String column, String val) {
        this.conditions.add(MagicConditioned.like(column, val, true, true, false));
        return this;
    }

    public MagicJoin likeLeft(String column, String val, boolean checkEmpty) {
        this.conditions.add(MagicConditioned.like(column, val, checkEmpty, true, false));
        return this;
    }

    public MagicJoin likeRight(String column, String val) {
        this.conditions.add(MagicConditioned.like(column, val, true, false, true));
        return this;
    }

    public MagicJoin likeRight(String column, String val, boolean checkEmpty) {
        this.conditions.add(MagicConditioned.like(column, val, checkEmpty, false, true));
        return this;
    }

    public MagicJoin orderBy(String ... columns) {
        this.orderByAsc.addAll(Arrays.asList(columns));
        return this;
    }

    public MagicJoin oderByDesc(String ... columns) {
        this.orderByDesc.addAll(Arrays.asList(columns));
        return this;
    }

    public MagicJoin logicDelete() {
        this.useLogicDelete = true;
        return this;
    }

    public MagicJoin noLogicDelete() {
        this.useLogicDelete = false;
        return this;
    }

    public MagicJoin logicDeleteInOn() {
        this.logicDeleteInOn = true;
        this.logicDeleteInWhere = false;
        return this;
    }

    public MagicJoin logicDeleteInWhere() {
        this.logicDeleteInWhere = true;
        this.logicDeleteInOn = false;
        return this;
    }
}

