/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.iframe.web.design.magic;

import cn.hutool.core.util.StrUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class MagicConditioned {
    private static final SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private final List<String> items;

    public MagicConditioned(List<String> items) {
        this.items = items;
    }

    public boolean isCondition() {
        return this.items.size() > 0;
    }

    public String toCondition() {
        return String.join((CharSequence)" ", this.items);
    }

    private static MagicConditioned contains(String column, Collection<?> operand, boolean checkEmpty, String operator) {
        ArrayList<String> items = new ArrayList<String>();
        if (MagicConditioned.meetExists(operand, checkEmpty) && MagicConditioned.meetSize(operand, checkEmpty)) {
            items.add(column);
            items.add(operator);
            items.add("(");
            ArrayList<String> vs = new ArrayList<String>();
            for (Object o : operand) {
                vs.add(MagicConditioned.v(o));
            }
            items.add(String.join((CharSequence)", ", vs));
            items.add(")");
        }
        return new MagicConditioned(items);
    }

    private static MagicConditioned contains(String column, Object[] operand, boolean checkEmpty, String operator) {
        ArrayList<String> items = new ArrayList<String>();
        if (MagicConditioned.meetExists(operand, checkEmpty) && MagicConditioned.meetSize(operand, checkEmpty)) {
            items.add(column);
            items.add(operator);
            items.add("(");
            ArrayList<String> vs = new ArrayList<String>();
            for (Object o : operand) {
                vs.add(MagicConditioned.v(o));
            }
            items.add(String.join((CharSequence)", ", vs));
            items.add(")");
        }
        return new MagicConditioned(items);
    }

    private static MagicConditioned contains(String column, String subQuery, boolean checkEmpty, String operator) {
        ArrayList<String> items = new ArrayList<String>();
        items.add(column);
        items.add(operator);
        items.add("(");
        items.add(subQuery);
        items.add(")");
        return new MagicConditioned(items);
    }

    public static MagicConditioned in(String column, String subQuery) {
        return MagicConditioned.contains(column, subQuery, false, "IN");
    }

    public static MagicConditioned notIn(String column, String subQuery) {
        return MagicConditioned.contains(column, subQuery, false, "NOT IN");
    }

    public static MagicConditioned in(String column, Collection<?> operand, boolean checkEmpty) {
        return MagicConditioned.contains(column, operand, checkEmpty, "IN");
    }

    public static MagicConditioned notIn(String column, Collection<?> operand, boolean checkEmpty) {
        return MagicConditioned.contains(column, operand, checkEmpty, "NOT IN");
    }

    public static MagicConditioned in(String column, Object[] operand, boolean checkEmpty) {
        return MagicConditioned.contains(column, operand, checkEmpty, "IN");
    }

    public static MagicConditioned notIn(String column, Object[] operand, boolean checkEmpty) {
        return MagicConditioned.contains(column, operand, checkEmpty, "NOT IN");
    }

    public static MagicConditioned eq(String column, Object operand, boolean checkEmpty) {
        return MagicConditioned.compare(column, operand, checkEmpty, "=");
    }

    public static MagicConditioned ne(String column, Object operand, boolean checkEmpty) {
        return MagicConditioned.compare(column, operand, checkEmpty, "!=");
    }

    public static MagicConditioned gt(String column, Object operand, boolean checkEmpty) {
        return MagicConditioned.compare(column, operand, checkEmpty, ">");
    }

    public static MagicConditioned ge(String column, Object operand, boolean checkEmpty) {
        return MagicConditioned.compare(column, operand, checkEmpty, ">=");
    }

    public static MagicConditioned lt(String column, Object operand, boolean checkEmpty) {
        return MagicConditioned.compare(column, operand, checkEmpty, "<");
    }

    public static MagicConditioned le(String column, Object operand, boolean checkEmpty) {
        return MagicConditioned.compare(column, operand, checkEmpty, "<=");
    }

    public static MagicConditioned between(String column, Object leftOperand, Object rightOperand) {
        ArrayList<String> items = new ArrayList<String>();
        items.add(column);
        items.add("BETWEEN");
        items.add(MagicConditioned.v(leftOperand));
        items.add("AND");
        items.add(MagicConditioned.v(rightOperand));
        return new MagicConditioned(items);
    }

    public static MagicConditioned isNull(String column) {
        ArrayList<String> items = new ArrayList<String>();
        items.add(column);
        items.add("IS");
        items.add("NULL");
        return new MagicConditioned(items);
    }

    public static MagicConditioned isNotNull(String column) {
        ArrayList<String> items = new ArrayList<String>();
        items.add(column);
        items.add("IS");
        items.add("NOT");
        items.add("NULL");
        return new MagicConditioned(items);
    }

    private static MagicConditioned compare(String column, Object operand, boolean checkEmpty, String operator) {
        ArrayList<String> items = new ArrayList<String>();
        if (MagicConditioned.meetExists(operand, checkEmpty) && MagicConditioned.meetContent(operand, checkEmpty)) {
            items.add(column);
            items.add(operator);
            items.add(MagicConditioned.v(operand));
        }
        return new MagicConditioned(items);
    }

    public static MagicConditioned like(String column, String operand, boolean checkEmpty, boolean likeLeft, boolean likeRight) {
        ArrayList<String> items = new ArrayList<String>();
        if (MagicConditioned.meetExists(operand, checkEmpty) && MagicConditioned.meetContent(operand, checkEmpty)) {
            items.add(column);
            items.add("LIKE");
            items.add((likeRight ? "'%" : "'") + operand + (likeLeft ? "%'" : "'"));
        }
        return new MagicConditioned(items);
    }

    public static String v(Object o) {
        if (o instanceof String) {
            return "'" + o + "'";
        }
        if (o instanceof Date) {
            return "'" + SDF.format((Date)o) + "'";
        }
        return o.toString();
    }

    private static boolean meetExists(Object operand, boolean checkEmpty) {
        return !checkEmpty || operand != null;
    }

    private static boolean meetSize(Collection<?> collection, boolean checkEmpty) {
        return !checkEmpty || collection.size() > 0;
    }

    private static boolean meetSize(Object[] arr, boolean checkEmpty) {
        return !checkEmpty || arr.length > 0;
    }

    private static boolean meetContent(Object v, boolean checkEmpty) {
        return !checkEmpty || !(v instanceof String) || StrUtil.isNotBlank((CharSequence)((String)v));
    }
}

