/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.iframe.web.design.interceptor;

import java.util.ArrayList;
import java.util.List;
import org.anyline.data.interceptor.DDInterceptor;
import org.anyline.data.run.Run;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.metadata.ACTION;
import org.springframework.stereotype.Component;

@Component
public class DesDataModelSyncInterceptor
implements DDInterceptor {
    private final ThreadLocal<List<String>> syncSqls = new ThreadLocal();

    public void startSync() {
        this.syncSqls.set(new ArrayList());
    }

    public List<ACTION.DDL> actions() {
        ArrayList<ACTION.DDL> list = new ArrayList<ACTION.DDL>();
        list.add(ACTION.DDL.TABLE_CREATE);
        list.add(ACTION.DDL.TABLE_ALTER);
        list.add(ACTION.DDL.TABLE_DROP);
        list.add(ACTION.DDL.TABLE_RENAME);
        list.add(ACTION.DDL.TABLE_COMMENT);
        list.add(ACTION.DDL.COLUMN_ADD);
        list.add(ACTION.DDL.COLUMN_ALTER);
        list.add(ACTION.DDL.COLUMN_DROP);
        list.add(ACTION.DDL.COLUMN_RENAME);
        list.add(ACTION.DDL.PRIMARY_ADD);
        list.add(ACTION.DDL.PRIMARY_ALTER);
        list.add(ACTION.DDL.PRIMARY_DROP);
        list.add(ACTION.DDL.PRIMARY_RENAME);
        return list;
    }

    public ACTION.SWITCH before(DataRuntime runtime, String random, ACTION.DDL action, Object metadata, List<Run> runs) {
        for (Run run : runs) {
            String sql = run.getFinalUpdate();
            this.syncSqls.get().add(sql);
        }
        return ACTION.SWITCH.CONTINUE;
    }

    public List<String> endSync() {
        List<String> sqls = this.syncSqls.get();
        this.syncSqls.remove();
        return sqls;
    }
}

