/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.iframe.web.design.func;

import com.kdgcsoft.iframe.web.base.embed.dict.AuthType;
import com.kdgcsoft.iframe.web.base.entity.BaseAuth;
import com.kdgcsoft.iframe.web.base.entity.BaseMenu;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class MenuAuth
implements Serializable {
    private static final long serialVersionUID = -4817760947187744542L;
    private Long id;
    private Long pid;
    private String authName;
    private AuthType authType;
    private String authCode;
    private List<MenuAuth> children;

    public List<MenuAuth> getChildren() {
        if (null == this.children) {
            this.children = new ArrayList<MenuAuth>();
        }
        return this.children;
    }

    public static MenuAuth of(BaseMenu menu) {
        MenuAuth auth = new MenuAuth();
        auth.setId(menu.getMenuId());
        auth.setPid(menu.getMenuPid());
        auth.setAuthName(menu.getMenuName());
        auth.setAuthType(AuthType.MENU);
        auth.setAuthCode(menu.getMenuCode());
        return auth;
    }

    public static MenuAuth of(BaseAuth baseAuth) {
        MenuAuth auth = new MenuAuth();
        auth.setId(baseAuth.getAuthId());
        auth.setPid(baseAuth.getMenuId());
        auth.setAuthName(baseAuth.getAuthName());
        auth.setAuthType(baseAuth.getAuthType());
        auth.setAuthCode(baseAuth.getAuthCode());
        return auth;
    }

    public static MenuAuth systemAuth(String parentCode) {
        MenuAuth auth = new MenuAuth();
        auth.setAuthName("\u7cfb\u7edf\u6743\u9650");
        auth.setAuthType(AuthType.VIRTUALLY);
        auth.setAuthCode(parentCode + "SystemAuth");
        return auth;
    }

    public static MenuAuth dataAuth(String parentCode) {
        MenuAuth auth = new MenuAuth();
        auth.setAuthName("\u6570\u636e\u6743\u9650");
        auth.setAuthType(AuthType.DATA);
        auth.setAuthCode(parentCode + "DataAuth");
        return auth;
    }

    public Long getId() {
        return this.id;
    }

    public Long getPid() {
        return this.pid;
    }

    public String getAuthName() {
        return this.authName;
    }

    public AuthType getAuthType() {
        return this.authType;
    }

    public String getAuthCode() {
        return this.authCode;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }

    public void setAuthName(String authName) {
        this.authName = authName;
    }

    public void setAuthType(AuthType authType) {
        this.authType = authType;
    }

    public void setAuthCode(String authCode) {
        this.authCode = authCode;
    }

    public void setChildren(List<MenuAuth> children) {
        this.children = children;
    }
}

