/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.iframe.web.design.func;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.kdgcsoft.iframe.web.base.embed.dict.AuthType;
import com.kdgcsoft.iframe.web.base.service.BaseAuthService;
import com.kdgcsoft.iframe.web.base.service.BaseDeptService;
import com.kdgcsoft.iframe.web.base.service.BaseMenuService;
import com.kdgcsoft.iframe.web.base.service.BaseOrgService;
import com.kdgcsoft.iframe.web.common.interfaces.IBusinessKeyQueryApi;
import com.kdgcsoft.iframe.web.common.pojo.LoginUser;
import com.kdgcsoft.iframe.web.common.utils.SecurityUtil;
import com.kdgcsoft.iframe.web.design.func.MenuAuth;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;
import org.ssssssss.magicapi.core.config.MagicFunction;
import org.ssssssss.script.annotation.Comment;
import org.ssssssss.script.annotation.Function;

@Component
public class DesMagicCustomFunction
implements MagicFunction {
    @Function
    @Comment(value="\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7528\u6237\u4fe1\u606f")
    public static LoginUser current_user() {
        return SecurityUtil.getLoginUser();
    }

    @Function
    @Comment(value="\u83b7\u53d6\u6240\u6709\u5b50\u90e8\u95e8id")
    public static List<Long> child_dept(@Comment(value="\u90e8\u95e8id") Object deptId) {
        Long id = DesMagicCustomFunction.parseLong(deptId);
        return null == id ? Collections.emptyList() : ((BaseDeptService)SpringUtil.getBean(BaseDeptService.class)).getChildrenDeptIds(id);
    }

    @Function
    @Comment(value="\u83b7\u53d6\u6240\u6709\u5b50\u7ec4\u7ec7\u673a\u6784id")
    public static List<Long> child_org(@Comment(value="\u7ec4\u7ec7\u673a\u6784id") Object orgId) {
        Long id = DesMagicCustomFunction.parseLong(orgId);
        return null == orgId ? Collections.emptyList() : ((BaseOrgService)SpringUtil.getBean(BaseOrgService.class)).getChildrenOrgIds(id);
    }

    private static Long parseLong(Object val) {
        if (null == val) {
            return null;
        }
        if (val instanceof String) {
            String s = (String)val;
            if (StrUtil.isBlank((CharSequence)s)) {
                return null;
            }
            try {
                return Long.valueOf((String)val);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (val instanceof Long) {
            return (Long)val;
        }
        try {
            return Long.parseLong(val.toString());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Function
    @Comment(value="\u83b7\u53d6\u83dc\u5355\u6743\u9650\u6811")
    public static List<MenuAuth> menu_auth_tree() {
        List baseMenus = ((BaseMenuService)SpringUtil.getBean(BaseMenuService.class)).listAllByOrder();
        if (CollUtil.isEmpty((Collection)baseMenus)) {
            return Collections.emptyList();
        }
        HashMap menusMap = new HashMap();
        List menus = baseMenus.stream().map(baseMenu -> {
            MenuAuth auth = MenuAuth.of(baseMenu);
            menusMap.put(auth.getId(), auth);
            return auth;
        }).collect(Collectors.toList());
        List baseAuths = ((BaseAuthService)SpringUtil.getBean(BaseAuthService.class)).listAllByOrder();
        HashMap<Long, List<MenuAuth>> authMaps = new HashMap<Long, List<MenuAuth>>();
        if (CollUtil.isNotEmpty((Collection)baseAuths)) {
            authMaps.putAll(baseAuths.stream().map(MenuAuth::of).collect(Collectors.groupingBy(MenuAuth::getPid)));
        }
        for (MenuAuth menu : menus) {
            Long pid;
            Long id = menu.getId();
            if (authMaps.containsKey(id)) {
                List auths = (List)authMaps.get(id);
                Map<AuthType, List<MenuAuth>> authTypeMaps = auths.stream().collect(Collectors.groupingBy(MenuAuth::getAuthType));
                List<MenuAuth> children = menu.getChildren();
                MenuAuth sysAuth = MenuAuth.systemAuth(menu.getAuthCode());
                if (authTypeMaps.containsKey(AuthType.BUTTON)) {
                    sysAuth.getChildren().addAll((Collection<MenuAuth>)authTypeMaps.get(AuthType.BUTTON));
                }
                if (authTypeMaps.containsKey(AuthType.CUSTOM_BUTTON)) {
                    sysAuth.getChildren().addAll((Collection<MenuAuth>)authTypeMaps.get(AuthType.CUSTOM_BUTTON));
                }
                if (CollUtil.isNotEmpty(sysAuth.getChildren())) {
                    children.add(sysAuth);
                }
                if (authTypeMaps.containsKey(AuthType.DATA)) {
                    MenuAuth dataAuth = MenuAuth.dataAuth(menu.getAuthCode());
                    dataAuth.getChildren().addAll((Collection<MenuAuth>)authTypeMaps.get(AuthType.DATA));
                    children.add(dataAuth);
                }
            }
            if (!menusMap.containsKey(pid = menu.getPid())) continue;
            MenuAuth pMenuAuth = (MenuAuth)menusMap.get(pid);
            pMenuAuth.getChildren().add(menu);
        }
        return menus.stream().filter(menuAuth -> menuAuth.getPid() == 0L).collect(Collectors.toList());
    }

    @Function
    @Comment(value="\u6839\u636e\u6d41\u7a0b\u72b6\u6001\u67e5\u8be2\u5173\u8054\u7684\u4e1a\u52a1\u4e3b\u952e")
    public static List<?> business_key(@Comment(value="\u4e1a\u52a1\u8868") String table, @Comment(value="\u4e3b\u952e\u5217\u540d") String idColumn, @Comment(value="\u6d41\u7a0b\u72b6\u6001") List<String> flowStatus, @Comment(value="\u662f\u5426\u6709\u903b\u8f91\u5220\u9664") boolean logicDelete) {
        return ((IBusinessKeyQueryApi)SpringUtil.getBean(IBusinessKeyQueryApi.class)).query(flowStatus, null, null, table, idColumn, logicDelete, false);
    }

    @Function
    @Comment(value="\u6839\u636e\u6d41\u7a0b\u72b6\u6001\u67e5\u8be2\u5173\u8054\u7684\u4e1a\u52a1\u4e3b\u952e")
    public static List<?> business_key(@Comment(value="\u4e1a\u52a1\u8868") String table, @Comment(value="\u4e3b\u952e\u5217\u540d") String idColumn, @Comment(value="\u6d41\u7a0b\u72b6\u6001") List<String> flowStatus) {
        return ((IBusinessKeyQueryApi)SpringUtil.getBean(IBusinessKeyQueryApi.class)).query(flowStatus, null, null, table, idColumn, true, false);
    }
}

