/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.iframe.web.design.form.config.obj.dto;

import cn.hutool.core.collection.CollUtil;
import com.kdgcsoft.iframe.web.design.entity.DesDataModelColumn;
import com.kdgcsoft.iframe.web.design.form.config.obj.FormRegion;
import com.kdgcsoft.iframe.web.design.form.config.obj.FormRegionComponent;
import com.kdgcsoft.iframe.web.design.form.config.obj.dto.FormRegionComponentDTO;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class FormRegionDTO {
    private String id;
    private String name;
    private String component;
    private List<FormRegionComponentDTO> items;

    public static FormRegionDTO of(FormRegion region, Map<String, DesDataModelColumn> columnMap) {
        FormRegionDTO dto = new FormRegionDTO();
        dto.setId(region.getId());
        dto.setName(region.getName());
        dto.setComponent(region.getComponent());
        List<FormRegionComponent> items = region.getItems();
        if (CollUtil.isNotEmpty(items)) {
            dto.setItems(items.stream().filter(FormRegionComponent::isDataItem).map(component -> {
                FormRegionComponentDTO item = FormRegionComponentDTO.of(component);
                if (columnMap.containsKey(item.getName())) {
                    item.setType(((DesDataModelColumn)columnMap.get(item.getName())).getColumnType());
                }
                return item;
            }).collect(Collectors.toList()));
        }
        return dto;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getComponent() {
        return this.component;
    }

    public List<FormRegionComponentDTO> getItems() {
        return this.items;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setComponent(String component) {
        this.component = component;
    }

    public void setItems(List<FormRegionComponentDTO> items) {
        this.items = items;
    }

    public String toString() {
        return "FormRegionDTO(id=" + this.getId() + ", name=" + this.getName() + ", component=" + this.getComponent() + ", items=" + this.getItems() + ")";
    }
}

