/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.iframe.web.design.form.config.obj;

import cn.hutool.core.collection.CollUtil;
import com.kdgcsoft.iframe.web.design.form.validate.FormAttributeValidator;
import com.kdgcsoft.iframe.web.design.form.validate.ValidateResult;
import com.kdgcsoft.iframe.web.design.form.validate.rule.FormatRule;
import com.kdgcsoft.iframe.web.design.form.validate.rule.PresentRule;
import com.kdgcsoft.iframe.web.design.form.validate.rule.TypeRule;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;

public class FormEntityAttr {
    private String name;
    private String columnName;
    private FormAttributeValidator validator;
    private Supplier<?> valueSupplier;

    public FormEntityAttr(String name, String columnName) {
        this(name, columnName, null);
    }

    public FormEntityAttr(String name, String columnName, Supplier<?> valueSupplier) {
        this.name = name;
        this.columnName = columnName;
        this.valueSupplier = valueSupplier;
    }

    public ValidateResult validateAttrValue(Object value) {
        Optional<ValidateResult> op;
        Optional<ValidateResult> op2;
        Optional<ValidateResult> op3;
        if (null == this.validator) {
            return ValidateResult.passed();
        }
        List<PresentRule> presentRules = this.validator.presentRules();
        if (CollUtil.isNotEmpty(presentRules) && (op3 = presentRules.stream().map(rule -> rule.isPresent(value)).filter(result -> !result.isPassed()).findFirst()).isPresent()) {
            return op3.get();
        }
        if (null == value) {
            return ValidateResult.passed();
        }
        List<TypeRule> typeRules = this.validator.typeRules();
        if (CollUtil.isNotEmpty(typeRules) && (op2 = typeRules.stream().map(rule -> rule.isType(value)).filter(result -> !result.isPassed()).findFirst()).isPresent()) {
            return op2.get();
        }
        List<FormatRule> formatRules = this.validator.formatRules();
        if (CollUtil.isNotEmpty(formatRules) && (op = formatRules.stream().map(rule -> rule.meetFormat(value)).filter(result -> !result.isPassed()).findFirst()).isPresent()) {
            return op.get();
        }
        return ValidateResult.passed();
    }

    public String getName() {
        return this.name;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public FormAttributeValidator getValidator() {
        return this.validator;
    }

    public Supplier<?> getValueSupplier() {
        return this.valueSupplier;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public void setValidator(FormAttributeValidator validator) {
        this.validator = validator;
    }

    public void setValueSupplier(Supplier<?> valueSupplier) {
        this.valueSupplier = valueSupplier;
    }
}

