/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.iframe.web.design.form.config.obj;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.kdgcsoft.iframe.web.common.utils.id.KindId;
import com.kdgcsoft.iframe.web.design.entity.DesDataModel;
import com.kdgcsoft.iframe.web.design.entity.DesDataModelColumn;
import com.kdgcsoft.iframe.web.design.form.config.obj.FileEntity;
import com.kdgcsoft.iframe.web.design.form.config.obj.FormEntity;
import com.kdgcsoft.iframe.web.design.form.config.obj.FormEntityAttr;
import com.kdgcsoft.iframe.web.design.form.config.obj.FormRegion;
import com.kdgcsoft.iframe.web.design.form.config.obj.FormRegionAttr;
import com.kdgcsoft.iframe.web.design.form.config.obj.FormRegionComponent;
import com.kdgcsoft.iframe.web.design.form.config.obj.RegionType;
import com.kdgcsoft.iframe.web.design.service.DesDataModelService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class BizForm {
    private String mainDataModel;
    private List<FormRegion> items;
    private List<FormRegion> mainFormRegions;
    private List<FormRegion> subFormRegions;
    private List<FormRegion> subTableRegions;
    private List<FormRegion> fileListRegions;
    private Long mainModelDataId;

    public Long generateMainModelDataId() {
        this.mainModelDataId = KindId.nextId();
        return this.mainModelDataId;
    }

    public void splitRegions() {
        if (CollUtil.isEmpty(this.items)) {
            return;
        }
        this.mainFormRegions = new ArrayList<FormRegion>();
        this.subFormRegions = new ArrayList<FormRegion>();
        this.subTableRegions = new ArrayList<FormRegion>();
        this.fileListRegions = new ArrayList<FormRegion>();
        this.items.forEach(item -> {
            RegionType regionType = item.getRegionType();
            switch (regionType) {
                case MAIN_FORM: {
                    this.mainFormRegions.add((FormRegion)item);
                    break;
                }
                case SUB_FORM: {
                    this.subFormRegions.add((FormRegion)item);
                    break;
                }
                case SUB_TABLE: {
                    this.subTableRegions.add((FormRegion)item);
                    break;
                }
                case FILE_LIST: {
                    this.fileListRegions.add((FormRegion)item);
                    break;
                }
            }
        });
    }

    public void saveFormEntities(List<FormEntity> entities, JSONObject formData) {
        if (CollUtil.isNotEmpty(entities)) {
            for (FormEntity entity : entities) {
                this.saveFormEntity(entity, formData);
            }
        }
    }

    public void saveFormEntity(FormEntity entity, JSONObject formData) {
        JSONObject obj = formData.getJSONObject(entity.getName());
        if (null != obj) {
            entity.save(obj);
        } else {
            JSONArray arr = formData.getJSONArray(entity.getName());
            if (null != arr) {
                for (int i = 0; i < arr.size(); ++i) {
                    entity.save(arr.getJSONObject(i));
                }
            }
        }
    }

    public FormEntity getMainFormEntity(DesDataModel dataModel) {
        if (CollUtil.isEmpty(this.items)) {
            return null;
        }
        if (CollUtil.isEmpty(this.mainFormRegions)) {
            return null;
        }
        FormEntity entity = new FormEntity();
        entity.setDataModelCode(this.mainDataModel);
        List<DesDataModelColumn> columns = dataModel.getColumns();
        HashMap<String, String> columnMap = new HashMap<String, String>();
        DesDataModelColumn pkColumn = null;
        if (CollUtil.isNotEmpty(columns)) {
            for (DesDataModelColumn column : columns) {
                columnMap.put(column.getColumnCode(), column.getDbColumn());
                if (null == column.getIsPk() || column.getIsPk() != 1) continue;
                pkColumn = column;
                entity.setPkColumn(column.getDbColumn());
                entity.setPkColumnCode(column.getColumnCode());
            }
        }
        Map<String, FormEntityAttr> attrs = this.mainFormRegions.stream().map(region -> {
            List<FormRegionComponent> items = region.getItems();
            ArrayList list = new ArrayList();
            if (CollUtil.isNotEmpty(items)) {
                list.addAll(items.stream().filter(FormRegionComponent::isDataItem).map(item -> {
                    FormEntityAttr attr = new FormEntityAttr(item.getName(), (String)columnMap.get(item.getName()));
                    return attr;
                }).collect(Collectors.toList()));
            }
            return list;
        }).flatMap(Collection::stream).collect(Collectors.toMap(FormEntityAttr::getName, attr -> attr));
        if (null != pkColumn) {
            attrs.put(pkColumn.getColumnCode(), new FormEntityAttr(pkColumn.getColumnCode(), pkColumn.getDbColumn(), () -> this.mainModelDataId));
        }
        entity.setAttrs(attrs);
        entity.setName(RegionType.MAIN_FORM.getText());
        entity.setTableName(dataModel.getDbTable());
        return entity;
    }

    public List<FormEntity> getSubFormEntity() {
        return this.getFormEntity(this.subFormRegions);
    }

    public List<FormEntity> getSubTableEntity() {
        return this.getFormEntity(this.subTableRegions);
    }

    public List<FileEntity> getFileListEntity() {
        if (CollUtil.isEmpty(this.fileListRegions)) {
            return null;
        }
        return this.fileListRegions.stream().map(region -> {
            FileEntity fileEntity = new FileEntity();
            fileEntity.setName(region.getName());
            return fileEntity;
        }).collect(Collectors.toList());
    }

    private List<FormEntity> getFormEntity(List<FormRegion> regions) {
        if (CollUtil.isEmpty(regions)) {
            return null;
        }
        return regions.stream().map(region -> {
            FormRegionAttr regionAttr = region.getAttr();
            String dataModelCode = regionAttr.getDataModelCode();
            FormEntity entity = new FormEntity();
            entity.setName(region.getName());
            entity.setDataModelCode(dataModelCode);
            List<FormRegionComponent> items = region.getItems();
            if (CollUtil.isNotEmpty(items)) {
                DesDataModel subModel = ((DesDataModelService)((Object)((Object)SpringUtil.getBean(DesDataModelService.class)))).getByModelCode(entity.getDataModelCode());
                HashMap<String, String> columnMap = new HashMap<String, String>();
                DesDataModelColumn pkColumn = null;
                DesDataModelColumn fkColumn = null;
                if (null != subModel) {
                    entity.setTableName(subModel.getDbTable());
                    List<DesDataModelColumn> columns = subModel.getColumns();
                    if (CollUtil.isNotEmpty(columns)) {
                        for (DesDataModelColumn column : columns) {
                            columnMap.put(column.getColumnCode(), column.getDbColumn());
                            if (null != column.getIsPk() && column.getIsPk() == 1) {
                                pkColumn = column;
                                entity.setPkColumn(column.getDbColumn());
                                entity.setPkColumnCode(column.getColumnCode());
                            }
                            if (!StrUtil.isNotBlank((CharSequence)column.getLinkModel()) || !StrUtil.isNotBlank((CharSequence)column.getLinkModelColumn())) continue;
                            fkColumn = column;
                        }
                    }
                }
                Map<String, FormEntityAttr> map = items.stream().filter(FormRegionComponent::isDataItem).map(item -> {
                    FormEntityAttr attr = new FormEntityAttr(item.getName(), (String)columnMap.get(item.getName()));
                    return attr;
                }).collect(Collectors.toMap(FormEntityAttr::getName, attr -> attr));
                if (null != pkColumn) {
                    map.put(pkColumn.getColumnCode(), new FormEntityAttr(pkColumn.getColumnCode(), pkColumn.getDbColumn(), KindId::nextId));
                }
                if (null != fkColumn) {
                    map.put(fkColumn.getColumnCode(), new FormEntityAttr(fkColumn.getColumnCode(), fkColumn.getDbColumn(), () -> this.mainModelDataId));
                }
                entity.setAttrs(map);
            }
            return entity;
        }).collect(Collectors.toList());
    }

    public String getMainDataModel() {
        return this.mainDataModel;
    }

    public List<FormRegion> getItems() {
        return this.items;
    }

    public List<FormRegion> getMainFormRegions() {
        return this.mainFormRegions;
    }

    public List<FormRegion> getSubFormRegions() {
        return this.subFormRegions;
    }

    public List<FormRegion> getSubTableRegions() {
        return this.subTableRegions;
    }

    public List<FormRegion> getFileListRegions() {
        return this.fileListRegions;
    }

    public Long getMainModelDataId() {
        return this.mainModelDataId;
    }

    public void setMainDataModel(String mainDataModel) {
        this.mainDataModel = mainDataModel;
    }

    public void setItems(List<FormRegion> items) {
        this.items = items;
    }

    public void setMainFormRegions(List<FormRegion> mainFormRegions) {
        this.mainFormRegions = mainFormRegions;
    }

    public void setSubFormRegions(List<FormRegion> subFormRegions) {
        this.subFormRegions = subFormRegions;
    }

    public void setSubTableRegions(List<FormRegion> subTableRegions) {
        this.subTableRegions = subTableRegions;
    }

    public void setFileListRegions(List<FormRegion> fileListRegions) {
        this.fileListRegions = fileListRegions;
    }

    public void setMainModelDataId(Long mainModelDataId) {
        this.mainModelDataId = mainModelDataId;
    }
}

