/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.iframe.web.design.exp;

import cn.hutool.core.util.StrUtil;
import com.kdgcsoft.iframe.web.design.exp.ExpItem;
import com.kdgcsoft.iframe.web.design.exp.ExpItemType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import java.util.stream.Collectors;

public class SimpleExpressionParser {
    private static final char IDX_BLOCK_START = '[';
    private static final char IDX_BLOCK_END = ']';
    private static final char[] QUALIFIER = new char[]{'(', ')'};
    private static final char[] OPERATORS = new char[]{'!', '=', '>', '<', '&', '|', '+', '-', '*', '/'};

    public static void main(String[] args) {
        String exp = "if([x1] != 0 && [x1] != nil) {return [x1]} else {return [x2]};";
        List<ExpItem> list = SimpleExpressionParser.parse(exp);
        list.forEach(System.out::println);
    }

    private static String stackReversePopOut(Stack<Character> stack) {
        if (stack.size() == 0) {
            return null;
        }
        StringBuilder s = new StringBuilder();
        while (!stack.empty()) {
            s.insert(0, stack.pop());
        }
        return s.toString();
    }

    public static List<ExpItem> parse(String exp) {
        if (StrUtil.isBlank((CharSequence)exp)) {
            return Collections.emptyList();
        }
        Stack<Character> idxStack = new Stack<Character>();
        Stack<Character> operatorStack = new Stack<Character>();
        Stack<Character> operandStack = new Stack<Character>();
        ArrayList<ExpItem> result = new ArrayList<ExpItem>();
        char[] chars = exp.toCharArray();
        boolean inIdx = false;
        for (char ch : chars) {
            if (ch == '[') {
                result.add(new ExpItem(ExpItemType.OPERAND, SimpleExpressionParser.stackReversePopOut(operandStack)));
                result.add(new ExpItem(ExpItemType.OPERATOR, SimpleExpressionParser.stackReversePopOut(operatorStack)));
                inIdx = true;
            }
            if (inIdx) {
                idxStack.push(Character.valueOf(ch));
                if (ch != ']') continue;
                String idx = SimpleExpressionParser.stackReversePopOut(idxStack);
                result.add(new ExpItem(ExpItemType.IDX, idx));
                inIdx = false;
                continue;
            }
            if (SimpleExpressionParser.isOperator(ch)) {
                result.add(new ExpItem(ExpItemType.OPERAND, SimpleExpressionParser.stackReversePopOut(operandStack)));
                operatorStack.push(Character.valueOf(ch));
                continue;
            }
            if (SimpleExpressionParser.isQualifier(ch)) {
                result.add(new ExpItem(ExpItemType.OPERAND, SimpleExpressionParser.stackReversePopOut(operandStack)));
                result.add(new ExpItem(ExpItemType.OPERATOR, SimpleExpressionParser.stackReversePopOut(operatorStack)));
                result.add(new ExpItem(ExpItemType.QUALIFIER, String.valueOf(ch)));
                continue;
            }
            result.add(new ExpItem(ExpItemType.OPERATOR, SimpleExpressionParser.stackReversePopOut(operatorStack)));
            operandStack.push(Character.valueOf(ch));
        }
        result.add(new ExpItem(ExpItemType.OPERAND, SimpleExpressionParser.stackReversePopOut(operandStack)));
        result.add(new ExpItem(ExpItemType.OPERATOR, SimpleExpressionParser.stackReversePopOut(operatorStack)));
        result.add(new ExpItem(ExpItemType.IDX, SimpleExpressionParser.stackReversePopOut(idxStack)));
        return result.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getValue())).collect(Collectors.toList());
    }

    private static boolean isOperator(char ch) {
        for (char operator : OPERATORS) {
            if (operator != ch) continue;
            return true;
        }
        return false;
    }

    private static boolean isQualifier(char ch) {
        for (char operator : QUALIFIER) {
            if (operator != ch) continue;
            return true;
        }
        return false;
    }
}

