/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.iframe.web.design.exp;

import com.googlecode.aviator.AviatorEvaluator;
import com.googlecode.aviator.AviatorEvaluatorInstance;
import com.googlecode.aviator.Expression;
import com.googlecode.aviator.runtime.function.AbstractFunction;
import com.googlecode.aviator.runtime.type.AviatorFunction;
import com.kdgcsoft.iframe.web.common.exception.BizException;
import com.kdgcsoft.iframe.web.design.exp.ExpItem;
import com.kdgcsoft.iframe.web.design.exp.ExpItemType;
import com.kdgcsoft.iframe.web.design.exp.SimpleExpressionParser;
import com.kdgcsoft.iframe.web.design.exp.func.AvgFunction;
import com.kdgcsoft.iframe.web.design.exp.func.SumFunction;
import java.util.HashMap;
import java.util.List;
import java.util.ServiceLoader;

public class ExpUtil {
    public static boolean isLegal(String exp) {
        try {
            exp = exp.replace("\u00a0", "");
            List<ExpItem> items = SimpleExpressionParser.parse(exp);
            StringBuilder builder = new StringBuilder();
            for (ExpItem item : items) {
                if (item.getType() == ExpItemType.IDX) {
                    builder.append("1");
                    continue;
                }
                builder.append(item.getValue());
                if (item.getType() != ExpItemType.OPERATOR || item.getValue().length() <= 1 || item.getValue().charAt(1) == '&' || item.getValue().charAt(1) == '|' || item.getValue().length() <= 1 || item.getValue().charAt(1) == '=') continue;
                return false;
            }
            AviatorEvaluatorInstance evaluator = AviatorEvaluator.newInstance();
            evaluator.addFunction((AviatorFunction)new SumFunction());
            evaluator.addFunction((AviatorFunction)new AvgFunction());
            ServiceLoader<AbstractFunction> serviceLoader = ServiceLoader.load(AbstractFunction.class);
            for (AbstractFunction function : serviceLoader) {
                evaluator.addFunction((AviatorFunction)function);
            }
            Expression expression = evaluator.compile(builder.toString());
            HashMap<String, String> test = new HashMap<String, String>();
            test.put("x", "1");
            System.out.println(expression.execute(test));
            return true;
        }
        catch (BizException e) {
            System.out.println(e.getMessage());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void main(String[] args) {
        System.out.println(ExpUtil.isLegal("sum([\u7528\u6237\u7ba1\u7406]+[\u7ec4\u4ef6\u7ba1\u7406]"));
    }
}

