/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.iframe.web.design.controller;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONObject;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.kdgcsoft.iframe.web.common.anno.OptLog;
import com.kdgcsoft.iframe.web.common.controller.BaseController;
import com.kdgcsoft.iframe.web.common.embed.dict.OptType;
import com.kdgcsoft.iframe.web.common.pojo.JsonResult;
import com.kdgcsoft.iframe.web.common.pojo.PageRequest;
import com.kdgcsoft.iframe.web.common.utils.CommonDownloadUtil;
import com.kdgcsoft.iframe.web.design.entity.DesPageModel;
import com.kdgcsoft.iframe.web.design.enums.DesCodeEnum;
import com.kdgcsoft.iframe.web.design.service.DesPageModelService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u9875\u9762\u6a21\u578b\u7ba1\u7406"})
@RestController
@Validated
@RequestMapping(value={"/des/desPageModel"})
public class DesPageModelController
extends BaseController {
    @Autowired
    DesPageModelService desPageModelService;

    @ApiOperation(value="\u4fdd\u5b58\u9875\u9762\u6a21\u578b")
    @PostMapping(value={"/save"})
    @OptLog(type=OptType.SAVE, title="\u4fdd\u5b58\u9875\u9762\u6a21\u578b")
    public JsonResult<?> save(@Validated @RequestBody DesPageModel entity) {
        if (entity.getEmbed() == 1) {
            return JsonResult.ERROR((String)"\u5185\u7f6e\u9875\u9762[{}]\u4e0d\u53ef\u4fee\u6539", (Object[])new Object[]{entity.getPageName()});
        }
        entity.setEmbed(0);
        if (this.desPageModelService.hasRepeat(entity)) {
            return JsonResult.ERROR((String)"\u9875\u9762\u540d\u79f0[{}]\u5df2\u5b58\u5728,\u4e0d\u5141\u8bb8\u540d\u79f0\u91cd\u590d\u7684\u9875\u9762\u540d\u79f0", (Object[])new Object[]{entity.getPageName()});
        }
        if (StrUtil.isBlank((CharSequence)entity.getPageCode())) {
            entity.setPageCode(DesCodeEnum.PAGE.newCode());
        }
        this.desPageModelService.saveEntity(entity);
        return JsonResult.OK();
    }

    @ApiOperation(value="\u83b7\u53d6\u9875\u9762\u6a21\u578b")
    @GetMapping(value={"/getById"})
    @OptLog(type=OptType.SELECT, title="\u83b7\u53d6\u9875\u9762\u6a21\u578b\u4fe1\u606f")
    public JsonResult<DesPageModel> getById(@ApiParam(value="\u9875\u9762\u6a21\u578bID", required=true) @NotNull(message="\u9875\u9762\u6a21\u578bID\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u9875\u9762\u6a21\u578bID\u4e0d\u80fd\u4e3a\u7a7a") Long id) {
        DesPageModel entity = this.desPageModelService.getByPageId(id);
        return JsonResult.OK().data((Object)entity);
    }

    @ApiOperation(value="\u83b7\u53d6\u9875\u9762\u6a21\u578b")
    @GetMapping(value={"/getByCode"})
    @OptLog(type=OptType.SELECT, title="\u83b7\u53d6\u9875\u9762\u6a21\u578b\u4fe1\u606f")
    public JsonResult<DesPageModel> getByCode(@ApiParam(value="\u9875\u9762\u6a21\u578bID", required=true) @NotNull(message="\u9875\u9762\u6a21\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u9875\u9762\u6a21\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a") String pageCode) {
        DesPageModel entity = this.desPageModelService.getByPageCode(pageCode);
        return JsonResult.OK().data((Object)entity);
    }

    @ApiOperation(value="\u5206\u9875\u83b7\u53d6\u6a21\u5757\u914d\u7f6e\u5217\u8868")
    @GetMapping(value={"/page"})
    @OptLog(type=OptType.SELECT, title="\u5206\u9875\u83b7\u53d6\u6a21\u5757\u914d\u7f6e\u5217\u8868")
    public JsonResult<PageRequest> page(@ApiParam(value="\u6a21\u7cca\u641c\u7d22") String searchKey, PageRequest pageRequest) {
        return JsonResult.OK().data((Object)this.desPageModelService.pagePageModel(pageRequest, searchKey));
    }

    @ApiOperation(value="\u6839\u636eID\u5220\u9664\u9875\u9762\u914d\u7f6e")
    @GetMapping(value={"/deleteById"})
    @OptLog(type=OptType.DELETE, title="\u6839\u636eID\u5220\u9664\u9875\u9762\u914d\u7f6e")
    public JsonResult deleteById(@ApiParam(value="\u9875\u9762\u914d\u7f6eID", required=true) @NotNull(message="\u9875\u9762\u914d\u7f6eID\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u9875\u9762\u914d\u7f6eID\u4e0d\u80fd\u4e3a\u7a7a") Long id) {
        this.desPageModelService.removeByPageId(id);
        return JsonResult.OK();
    }

    @ApiOperation(value="\u5bfc\u51fa\u8868\u5355\u6a21\u578b")
    @GetMapping(value={"/export"})
    @OptLog(type=OptType.EXPORT, title="\u5bfc\u51fa\u8868\u5355\u6a21\u578b")
    public void export(@ApiParam(value="\u8868\u5355\u6a21\u578bID", required=true) @NotNull(message="\u8868\u5355\u6a21\u578bID\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u8868\u5355\u6a21\u578bID\u4e0d\u80fd\u4e3a\u7a7a") HttpServletResponse response, String ids) {
        List pageModelList = this.desPageModelService.list((Wrapper)new QueryWrapper().lambda().in(DesPageModel::getPageId, (Collection)Arrays.stream(StrUtil.splitToLong((CharSequence)ids, (char)',')).boxed().collect(Collectors.toList())));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date currentDate = new Date();
        String currentDateStr = sdf.format(currentDate);
        for (DesPageModel model : pageModelList) {
            if (pageModelList == null) continue;
            String json = JSON.toJSONString((Object)pageModelList);
            String fileName = "formModel-" + currentDateStr + ".json";
            CommonDownloadUtil.download((String)fileName, (byte[])json.getBytes(), (HttpServletResponse)response);
        }
    }

    @ApiOperation(value="\u5bfc\u5165\u8868\u5355\u6a21\u578b")
    @PostMapping(value={"/import"})
    @OptLog(type=OptType.IMPORT, title="\u5bfc\u5165\u8868\u5355\u6a21\u578b")
    public JsonResult<?> importModel(@RequestBody JSONObject file) {
        String fileText = file.getStr((Object)"fileContent");
        List list = JSON.parseArray((String)fileText, JSONObject.class);
        for (JSONObject object : list) {
            DesPageModel pageModel = (DesPageModel)((Object)JSON.parseObject((String)object.toString(), DesPageModel.class));
            if (!this.desPageModelService.isRepeat(pageModel)) {
                pageModel.setPageId(null);
                pageModel.setPageCode(DesCodeEnum.FORM.newCode());
            }
            this.desPageModelService.saveEntity(pageModel);
        }
        return JsonResult.OK();
    }

    @ApiOperation(value="\u590d\u5236\u9875\u9762\u6a21\u578b")
    @GetMapping(value={"/copy"})
    @OptLog(type=OptType.OTHER, title="\u590d\u5236\u9875\u9762\u6a21\u578b")
    public JsonResult<DesPageModel> copyModel(@ApiParam(value="\u9875\u9762\u6a21\u578bID", required=true) @NotNull(message="\u9875\u9762\u6a21\u578bID\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u9875\u9762\u6a21\u578bID\u4e0d\u80fd\u4e3a\u7a7a") Long id) {
        DesPageModel pageModel = this.desPageModelService.getByPageId(id);
        pageModel.setPageId(null);
        pageModel.setPageName(pageModel.getPageName() + "_copy");
        pageModel.setPageCode(DesCodeEnum.FORM.newCode());
        this.desPageModelService.saveEntity(pageModel);
        return JsonResult.OK().data((Object)pageModel);
    }
}

