/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.iframe.web.design.controller;

import cn.hutool.core.util.StrUtil;
import com.kdgcsoft.iframe.web.common.anno.OptLog;
import com.kdgcsoft.iframe.web.common.controller.BaseController;
import com.kdgcsoft.iframe.web.common.embed.dict.OptType;
import com.kdgcsoft.iframe.web.common.pojo.JsonResult;
import com.kdgcsoft.iframe.web.common.pojo.PageRequest;
import com.kdgcsoft.iframe.web.design.entity.DesModuleConfig;
import com.kdgcsoft.iframe.web.design.service.DesModuleConfigService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u529f\u80fd\u6a21\u5757\u914d\u7f6e"})
@RestController
@Validated
@RequestMapping(value={"/des/desModuleConfig"})
public class DesModuleConfigController
extends BaseController {
    @Autowired
    DesModuleConfigService moduleConfigService;

    @ApiOperation(value="\u4fdd\u5b58\u6a21\u5757\u914d\u7f6e")
    @PostMapping(value={"/save"})
    @OptLog(type=OptType.SAVE, title="\u4fdd\u5b58\u6570\u636e\u6a21\u578b")
    public JsonResult<?> save(@Validated @RequestBody DesModuleConfig entity) {
        try {
            if (0 == entity.getCustom()) {
                entity.setCustomPath(null);
            }
            if (StrUtil.isBlank((CharSequence)entity.getModuleCode()) || null == entity.getId()) {
                this.moduleConfigService.saveDesModuleConfig(entity);
            } else {
                if (entity.getEmbed() == 1) {
                    return JsonResult.ERROR((String)("\u5185\u7f6e\u6a21\u5757[" + entity.getModuleName() + "]\u4e0d\u5141\u8bb8\u4fee\u6539\uff01"));
                }
                this.moduleConfigService.updateDesModuleConfig(entity);
            }
            return JsonResult.OK((String)"\u4fdd\u5b58\u6210\u529f");
        }
        catch (Exception e) {
            return JsonResult.ERROR((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u6a21\u5757\u914d\u7f6e")
    @GetMapping(value={"/getByCode"})
    @OptLog(type=OptType.SELECT, title="\u83b7\u53d6\u6a21\u5757\u914d\u7f6e\u4fe1\u606f")
    public JsonResult<DesModuleConfig> getByCode(@ApiParam(value="\u6a21\u5757\u914d\u7f6eID", required=true) @NotNull(message="\u6a21\u5757\u914d\u7f6eID\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u6a21\u5757\u914d\u7f6eID\u4e0d\u80fd\u4e3a\u7a7a") Long id) {
        DesModuleConfig entity = (DesModuleConfig)((Object)this.moduleConfigService.getById(id));
        return JsonResult.OK().data((Object)entity);
    }

    @ApiOperation(value="\u5206\u9875\u83b7\u53d6\u6a21\u5757\u914d\u7f6e\u5217\u8868")
    @GetMapping(value={"/page"})
    @OptLog(type=OptType.SELECT, title="\u5206\u9875\u83b7\u53d6\u6a21\u5757\u914d\u7f6e\u5217\u8868")
    public JsonResult<PageRequest> page(@ApiParam(value="\u6a21\u7cca\u641c\u7d22") String searchKey, PageRequest pageRequest) {
        this.moduleConfigService.pageModuleConfig(pageRequest, searchKey);
        return JsonResult.OK().data((Object)pageRequest);
    }

    @ApiOperation(value="\u83b7\u53d6\u6a21\u5757\u914d\u7f6e\u5217\u8868")
    @GetMapping(value={"/list"})
    @OptLog(type=OptType.SELECT, title="\u83b7\u53d6\u6a21\u5757\u914d\u7f6e\u5217\u8868")
    public JsonResult<List<DesModuleConfig>> list(@ApiParam(value="\u6a21\u7cca\u641c\u7d22") String searchKey) {
        List<DesModuleConfig> list = this.moduleConfigService.listModuleConfig(searchKey);
        return JsonResult.OK().data(list);
    }

    @ApiOperation(value="\u6839\u636eID\u5220\u9664\u6a21\u5757\u914d\u7f6e")
    @GetMapping(value={"/deleteById"})
    @OptLog(type=OptType.DELETE, title="\u6839\u636eID\u5220\u9664\u6a21\u5757\u914d\u7f6e")
    public JsonResult deleteById(@ApiParam(value="\u6a21\u5757\u914d\u7f6eID", required=true) @NotNull(message="\u6a21\u578bID\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u6a21\u578bID\u4e0d\u80fd\u4e3a\u7a7a") Long id) {
        this.moduleConfigService.removeById(id);
        return JsonResult.OK();
    }
}

