/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.iframe.web.design.controller;

import com.kdgcsoft.iframe.web.common.pojo.JsonResult;
import com.kdgcsoft.iframe.web.common.pojo.PageRequest;
import com.kdgcsoft.iframe.web.design.entity.DesMagicApi;
import com.kdgcsoft.iframe.web.design.pojo.MagicApiInfo;
import com.kdgcsoft.iframe.web.design.service.DesMagicApiService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/des/magic-api"})
public class DesMagicApiController {
    private static final Logger log = LoggerFactory.getLogger(DesMagicApiController.class);
    @Autowired
    private DesMagicApiService magicApiService;

    @RequestMapping(value={"/tree"})
    public JsonResult<?> tree(String search) {
        try {
            List<?> data = this.magicApiService.tree(search);
            return JsonResult.OK((String)"\u67e5\u8be2\u6210\u529f").data(data);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return JsonResult.ERROR((String)("\u67e5\u8be2\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a" + e.getMessage()));
        }
    }

    @RequestMapping(value={"/list"})
    public JsonResult<?> list(String search) {
        try {
            List<?> data = this.magicApiService.list(search);
            return JsonResult.OK((String)"\u67e5\u8be2\u6210\u529f").data(data);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return JsonResult.ERROR((String)("\u67e5\u8be2\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a" + e.getMessage()));
        }
    }

    @RequestMapping(value={"/page"})
    public JsonResult<MagicApiInfo> page(PageRequest<MagicApiInfo> pageRequest, String search) {
        try {
            PageRequest<MagicApiInfo> data = this.magicApiService.pageQuery(pageRequest, search);
            return JsonResult.OK((String)"\u67e5\u8be2\u6210\u529f").data(data);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return JsonResult.ERROR((String)("\u67e5\u8be2\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a" + e.getMessage()));
        }
    }

    @RequestMapping(value={"/getById"})
    public JsonResult<?> getById(String id) {
        try {
            MagicApiInfo data = this.magicApiService.getById(id);
            return JsonResult.OK((String)"\u67e5\u8be2\u6210\u529f").data((Object)data);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return JsonResult.ERROR((String)("\u67e5\u8be2\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a" + e.getMessage()));
        }
    }

    @RequestMapping(value={"/queryApiCategories"})
    public JsonResult<?> queryApiCategories() {
        try {
            List<DesMagicApi> data = this.magicApiService.queryAllApiCategories();
            return JsonResult.OK((String)"\u67e5\u8be2\u6210\u529f").data(data);
        }
        catch (Exception e) {
            return JsonResult.ERROR((String)("\u67e5\u8be2\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a" + e.getMessage()));
        }
    }

    @RequestMapping(value={"/queryCategoryApis"})
    public JsonResult<?> queryCategoryApis(String category) {
        try {
            List<DesMagicApi> data = this.magicApiService.queryAllCategoriesApis(category);
            return JsonResult.OK((String)"\u67e5\u8be2\u6210\u529f").data(data);
        }
        catch (Exception e) {
            return JsonResult.ERROR((String)("\u67e5\u8be2\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a" + e.getMessage()));
        }
    }
}

