/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.iframe.web.design.controller;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONObject;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.kdgcsoft.iframe.web.base.entity.BaseDictItem;
import com.kdgcsoft.iframe.web.base.service.BaseDictItemService;
import com.kdgcsoft.iframe.web.base.service.BaseDictService;
import com.kdgcsoft.iframe.web.common.anno.OptLog;
import com.kdgcsoft.iframe.web.common.controller.BaseController;
import com.kdgcsoft.iframe.web.common.embed.dict.OptType;
import com.kdgcsoft.iframe.web.common.pojo.JsonResult;
import com.kdgcsoft.iframe.web.common.pojo.PageRequest;
import com.kdgcsoft.iframe.web.common.utils.CommonDownloadUtil;
import com.kdgcsoft.iframe.web.design.entity.DesFormModel;
import com.kdgcsoft.iframe.web.design.entity.DesPageModel;
import com.kdgcsoft.iframe.web.design.enums.DesCodeEnum;
import com.kdgcsoft.iframe.web.design.service.DesDataModelService;
import com.kdgcsoft.iframe.web.design.service.DesFormModelService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8868\u5355\u6a21\u578b\u7ba1\u7406"})
@RestController
@Validated
@RequestMapping(value={"/des/desFormModel"})
public class DesFormModelController
extends BaseController {
    @Autowired
    DesFormModelService formModelService;
    @Autowired
    DesDataModelService dataModelService;
    @Autowired
    BaseDictService baseDictService;
    @Resource
    BaseDictItemService baseDictItemService;

    @ApiOperation(value="\u4fdd\u5b58\u8868\u5355\u6a21\u578b")
    @PostMapping(value={"/save"})
    @OptLog(type=OptType.SAVE, title="\u4fdd\u5b58\u8868\u5355\u6a21\u578b")
    public JsonResult<?> save(@Validated @RequestBody DesFormModel entity) {
        if (entity.getEmbed() == 1) {
            return JsonResult.ERROR((String)"\u5185\u7f6e\u8868\u5355[{}]\u4e0d\u53ef\u4fee\u6539", (Object[])new Object[]{entity.getFormName()});
        }
        entity.setEmbed(0);
        if (this.formModelService.hasRepeat(entity)) {
            return JsonResult.ERROR((String)"\u8868\u5355\u540d\u79f0[{}]\u5df2\u5b58\u5728,\u4e0d\u5141\u8bb8\u540d\u79f0\u91cd\u590d\u7684\u8868\u5355", (Object[])new Object[]{entity.getFormName()});
        }
        if (StrUtil.isBlank((CharSequence)entity.getFormCode())) {
            entity.setFormCode(DesCodeEnum.FORM.newCode());
        }
        this.formModelService.saveEntity(entity);
        return JsonResult.OK();
    }

    @ApiOperation(value="\u83b7\u53d6\u8868\u5355\u6a21\u578b")
    @GetMapping(value={"/getById"})
    @OptLog(type=OptType.SELECT, title="\u83b7\u53d6\u8868\u5355\u6a21\u578b\u4fe1\u606f")
    public JsonResult<DesPageModel> GET_BY_ID(@ApiParam(value="\u8868\u5355\u6a21\u578bID", required=true) @NotNull(message="\u8868\u5355\u6a21\u578bID\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u8868\u5355\u6a21\u578bID\u4e0d\u80fd\u4e3a\u7a7a") Long id) {
        DesFormModel entity = this.formModelService.getByFormId(id);
        return JsonResult.OK().data((Object)entity);
    }

    @ApiOperation(value="\u83b7\u53d6\u8868\u5355\u6a21\u578b")
    @GetMapping(value={"/getByCode"})
    @OptLog(type=OptType.SELECT, title="\u83b7\u53d6\u8868\u5355\u6a21\u578b\u4fe1\u606f")
    public JsonResult<DesPageModel> GET_BY_CODE(@ApiParam(value="\u8868\u5355\u6a21\u578b\u7f16\u7801", required=true) @NotNull(message="\u8868\u5355\u6a21\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u8868\u5355\u6a21\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a") String formCode) {
        DesFormModel entity = this.formModelService.getByFormCode(formCode);
        return JsonResult.OK().data((Object)entity);
    }

    @ApiOperation(value="\u5206\u9875\u83b7\u53d6\u6a21\u5757\u914d\u7f6e\u5217\u8868")
    @GetMapping(value={"/page"})
    @OptLog(type=OptType.SELECT, title="\u5206\u9875\u83b7\u53d6\u6a21\u5757\u914d\u7f6e\u5217\u8868")
    public JsonResult<PageRequest> page(@ApiParam(value="\u662f\u5426\u81ea\u5b9a\u4e49\u8868\u5355") Integer custom, @ApiParam(value="\u6a21\u7cca\u641c\u7d22") String searchKey, @ApiParam(value="\u6a21\u578b\u5206\u7ec4id") String modelGroup, PageRequest pageRequest) {
        List srcList = this.baseDictItemService.list((Wrapper)new QueryWrapper().lambda().eq(BaseDictItem::getDictCode, (Object)"DesModelGroup"));
        List<String> childrenValues = new ArrayList<String>();
        if (StrUtil.isNotEmpty((CharSequence)modelGroup)) {
            BaseDictItem dictItem = (BaseDictItem)this.baseDictItemService.getOne((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(BaseDictItem::getDictCode, (Object)"DesModelGroup")).eq(BaseDictItem::getValue, (Object)modelGroup));
            childrenValues = this.baseDictItemService.getChildrenIds(dictItem.getDictItemId(), true).stream().map(dictItemId -> srcList.stream().filter(item -> item.getDictItemId().equals(dictItemId)).findFirst().get()).map(BaseDictItem::getValue).collect(Collectors.toList());
        }
        this.formModelService.pageFormModel(pageRequest, custom, searchKey, childrenValues);
        return JsonResult.OK().data((Object)pageRequest);
    }

    @ApiOperation(value="\u6839\u636eID\u5220\u9664\u8868\u5355\u914d\u7f6e")
    @GetMapping(value={"/deleteById"})
    @OptLog(type=OptType.DELETE, title="\u6839\u636eID\u5220\u9664\u8868\u5355\u914d\u7f6e")
    public JsonResult deleteById(@ApiParam(value="\u8868\u5355\u914d\u7f6eID", required=true) @NotNull(message="\u8868\u5355\u914d\u7f6eID\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u8868\u5355\u914d\u7f6eID\u4e0d\u80fd\u4e3a\u7a7a") Long id) {
        this.formModelService.removeByFormId(id);
        return JsonResult.OK();
    }

    @ApiOperation(value="\u6839\u636e\u4e1a\u52a1\u4e3b\u952eid\u5220\u9664\u6570\u636e")
    @GetMapping(value={"delByBusinessKey"})
    @OptLog(type=OptType.DELETE, title="\u6839\u636e\u4e1a\u52a1\u4e3b\u952eid\u5220\u9664\u6570\u636e")
    public JsonResult deleteByBusinessKey(@ApiParam(value="\u4e1a\u52a1\u4e3b\u952eid", required=true) @NotNull(message="\u4e1a\u52a1\u4e3b\u952eid\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u4e1a\u52a1\u4e3b\u952eid\u4e0d\u80fd\u4e3a\u7a7a") Long businessKey, @ApiParam(value="\u6570\u636e\u6a21\u578bid", required=true) @NotNull(message="\u6570\u636e\u6a21\u578bid\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u6570\u636e\u6a21\u578bid\u4e0d\u80fd\u4e3a\u7a7a") Long modelId) {
        try {
            this.formModelService.removeByBusinessKey(businessKey, modelId);
            return JsonResult.OK();
        }
        catch (Exception e) {
            return JsonResult.ERROR((String)"\u5220\u9664\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a", (Object[])new Object[]{e.getMessage()});
        }
    }

    @ApiOperation(value="\u5bfc\u51fa\u8868\u5355\u6a21\u578b")
    @GetMapping(value={"/export"})
    @OptLog(type=OptType.EXPORT, title="\u5bfc\u51fa\u8868\u5355\u6a21\u578b")
    public void export(@ApiParam(value="\u8868\u5355\u6a21\u578bID", required=true) @NotNull(message="\u8868\u5355\u6a21\u578bID\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u8868\u5355\u6a21\u578bID\u4e0d\u80fd\u4e3a\u7a7a") HttpServletResponse response, String ids) {
        List formModelList = this.formModelService.list((Wrapper)new QueryWrapper().lambda().in(DesFormModel::getFormId, (Collection)Arrays.stream(StrUtil.splitToLong((CharSequence)ids, (char)',')).boxed().collect(Collectors.toList())));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date currentDate = new Date();
        String currentDateStr = sdf.format(currentDate);
        for (DesFormModel model : formModelList) {
            if (formModelList == null) continue;
            String json = JSON.toJSONString((Object)formModelList);
            String fileName = "formModel-" + currentDateStr + ".json";
            CommonDownloadUtil.download((String)fileName, (byte[])json.getBytes(), (HttpServletResponse)response);
        }
    }

    @ApiOperation(value="\u5bfc\u5165\u8868\u5355\u6a21\u578b")
    @PostMapping(value={"/import"})
    @OptLog(type=OptType.IMPORT, title="\u5bfc\u5165\u8868\u5355\u6a21\u578b")
    public JsonResult<?> importModel(@RequestBody JSONObject file) {
        String fileText = file.getStr((Object)"fileContent");
        List list = JSON.parseArray((String)fileText, JSONObject.class);
        for (JSONObject object : list) {
            DesFormModel formModel = (DesFormModel)((Object)JSON.parseObject((String)object.toString(), DesFormModel.class));
            this.formModelService.saveEntity(formModel);
        }
        return JsonResult.OK();
    }

    @ApiOperation(value="\u590d\u5236\u8868\u5355\u6a21\u578b")
    @GetMapping(value={"/copy"})
    @OptLog(type=OptType.OTHER, title="\u590d\u5236\u8868\u5355\u6a21\u578b")
    public JsonResult<DesFormModel> copyModel(@ApiParam(value="\u8868\u5355\u6a21\u578bID", required=true) @NotNull(message="\u8868\u5355\u6a21\u578bID\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u8868\u5355\u6a21\u578bID\u4e0d\u80fd\u4e3a\u7a7a") Long id) {
        DesFormModel formModel = this.formModelService.getByFormId(id);
        formModel.setFormId(null);
        formModel.setFormName(formModel.getFormName() + "_copy");
        formModel.setFormCode(DesCodeEnum.FORM.newCode());
        this.formModelService.saveEntity(formModel);
        return JsonResult.OK().data((Object)formModel);
    }
}

