/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.iframe.web.design.controller;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson2.JSONObject;
import com.kdgcsoft.iframe.web.common.anno.OptLog;
import com.kdgcsoft.iframe.web.common.controller.BaseController;
import com.kdgcsoft.iframe.web.common.embed.dict.OptType;
import com.kdgcsoft.iframe.web.common.pojo.JsonResult;
import com.kdgcsoft.iframe.web.design.entity.DesFormModel;
import com.kdgcsoft.iframe.web.design.form.config.obj.dto.FormRegionDTO;
import com.kdgcsoft.iframe.web.design.service.DesFormModelService;
import com.kdgcsoft.iframe.web.design.service.DesFormService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Collections;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8868\u5355\u5f15\u64ce"})
@RestController
@Validated
@RequestMapping(value={"/des/form"})
public class DesFormController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(DesFormController.class);
    @Autowired
    private DesFormService formService;
    @Autowired
    private DesFormModelService formModelService;

    @ApiOperation(value="\u8868\u5355\u67e5\u8be2")
    @RequestMapping(value={"/query/{formCode}"})
    @OptLog(type=OptType.SELECT, title="\u67e5\u8be2\u8868\u5355")
    public JsonResult<?> queryForm(@PathVariable String formCode, @NotNull Long id) {
        DesFormModel formModel = this.formModelService.getByFormCode(formCode);
        if (formModel == null) {
            return JsonResult.ERROR((String)"\u8868\u5355\u4e0d\u5b58\u5728,\u8868\u5355\u7f16\u7801[{}]", (Object[])new Object[]{formCode});
        }
        if (formModel.getCustom() == 1) {
            return JsonResult.OK().data(Collections.emptyList());
        }
        try {
            JSONObject r = this.formService.queryForm(formModel, id);
            return JsonResult.OK((String)"\u67e5\u8be2\u6210\u529f").data((Object)r);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return JsonResult.ERROR((String)("\u67e5\u8be2\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a" + e.getMessage()));
        }
    }

    @PostMapping(value={"/save/{formCode}"})
    @OptLog(type=OptType.SAVE, title="\u4fdd\u5b58\u8868\u5355")
    public JsonResult<?> saveForm(@PathVariable(value="formCode") String formCode, @RequestBody JSONObject formData) {
        DesFormModel formModel = this.formModelService.getByFormCode(formCode);
        if (formModel == null) {
            return JsonResult.ERROR((String)"\u8868\u5355\u4e0d\u5b58\u5728,\u8868\u5355\u7f16\u7801[{}]", (Object[])new Object[]{formCode});
        }
        if (formModel.getModelId() == null) {
            return JsonResult.ERROR((String)"\u8868\u5355\u5c1a\u672a\u5173\u8054\u6570\u636e\u6a21\u578b,\u8868\u5355\u7f16\u7801[{}]", (Object[])new Object[]{formCode});
        }
        if (formModel.getCustom() == 0 && StrUtil.isBlank((CharSequence)formModel.getConfigJson())) {
            return JsonResult.ERROR((String)"\u8868\u5355\u5c1a\u672a\u8fdb\u884c\u4efb\u4f55\u914d\u7f6e:\u7f16\u7801[{}]", (Object[])new Object[]{formCode});
        }
        if (formModel.getCustom() == 1) {
            return JsonResult.OK().data(Collections.emptyList());
        }
        JsonResult<?> validateResult = this.formService.validateForm(formModel, formData);
        if (!validateResult.getSuccess().booleanValue()) {
            return validateResult;
        }
        try {
            this.formService.saveForm(formModel, formData);
            return JsonResult.OK((String)"\u4fdd\u5b58\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return JsonResult.ERROR((String)("\u4fdd\u5b58\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a" + e.getMessage()));
        }
    }

    @GetMapping(value={"/getById/{formCode}"})
    public JsonResult getById(@PathVariable String formCode, @ApiParam(value="\u8868\u5355\u5bf9\u5e94\u7684\u4e3b\u8868\u7684\u4e3b\u952eId", required=true) @NotNull(message="\u8868\u5355\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u8868\u5355\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a") Long id) {
        DesFormModel formModel = this.formModelService.getByFormCode(formCode);
        if (formModel == null) {
            return JsonResult.ERROR((String)"\u8868\u5355\u4e0d\u5b58\u5728:\u7f16\u7801[{}]", (Object[])new Object[]{formCode});
        }
        if (formModel.getModelId() != null) {
            return JsonResult.ERROR((String)"\u8868\u5355\u5c1a\u672a\u5173\u8054\u6570\u636e\u6a21\u578b,\u8868\u5355\u7f16\u7801[{}]", (Object[])new Object[]{formCode});
        }
        return JsonResult.OK();
    }

    @GetMapping(value={"/echo"})
    public JsonResult echoItem(@ApiParam(value="\u56de\u663e\u7684\u6570\u636e\u6a21\u578b\u7684\u7f16\u7801", required=true) @NotNull(message="\u56de\u663e\u7684\u6570\u636e\u6a21\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u56de\u663e\u7684\u6570\u636e\u6a21\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a") String echoCode, @ApiParam(value="\u6570\u636e\u6a21\u578b\u7f13\u5b58\u7c7b\u578b") @RequestParam(defaultValue="false") boolean echoCascade, String value) {
        return JsonResult.OK().data((Object)this.formService.transItem(echoCode, value, echoCascade));
    }

    @RequestMapping(value={"/getFormItems/{formCode}"})
    public JsonResult<?> getFormItems(@PathVariable(value="formCode") String formCode, boolean mainForm) {
        DesFormModel formModel = this.formModelService.getByFormCode(formCode);
        if (formModel == null) {
            return JsonResult.ERROR((String)"\u8868\u5355\u4e0d\u5b58\u5728,\u8868\u5355\u7f16\u7801[{}]", (Object[])new Object[]{formCode});
        }
        try {
            List<FormRegionDTO> list = formModel.getCustom() == 1 ? this.formService.getFormItems(formModel) : this.formService.getFormItems(formModel, mainForm);
            return JsonResult.OK((String)"\u67e5\u8be2\u6210\u529f").data(list);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return JsonResult.ERROR((String)("\u67e5\u8be2\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a" + e.getMessage()));
        }
    }
}

