/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.iframe.web.design.controller;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.kdgcsoft.iframe.web.base.entity.BaseDictItem;
import com.kdgcsoft.iframe.web.base.service.BaseDictItemService;
import com.kdgcsoft.iframe.web.common.anno.OptLog;
import com.kdgcsoft.iframe.web.common.controller.BaseController;
import com.kdgcsoft.iframe.web.common.embed.dict.OptType;
import com.kdgcsoft.iframe.web.common.pojo.JsonResult;
import com.kdgcsoft.iframe.web.common.pojo.PageRequest;
import com.kdgcsoft.iframe.web.design.entity.DesExportTemplate;
import com.kdgcsoft.iframe.web.design.enums.DesCodeEnum;
import com.kdgcsoft.iframe.web.design.service.DesExportTemplateService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5bfc\u51fa\u6a21\u677f\u7ba1\u7406"})
@RestController
@Validated
@RequestMapping(value={"/des/desExportTemplate"})
public class DesExportTemplateController
extends BaseController {
    @Autowired
    DesExportTemplateService desExportTemplateService;
    @Autowired
    BaseDictItemService baseDictItemService;

    @ApiOperation(value="\u4fdd\u5b58\u5bfc\u51fa\u6a21\u677f")
    @PostMapping(value={"/save"})
    @OptLog(type=OptType.SAVE, title="\u4fdd\u5b58\u5bfc\u51fa\u6a21\u677f")
    public JsonResult<?> save(@Validated @RequestBody DesExportTemplate entity) {
        if (StrUtil.isBlank((CharSequence)entity.getTemplateCode())) {
            entity.setTemplateCode(DesCodeEnum.TEMPLATE.newCode());
        }
        this.desExportTemplateService.saveOrUpdate((Object)entity);
        return JsonResult.OK();
    }

    @ApiOperation(value="\u83b7\u53d6\u5bfc\u51fa\u6a21\u677f\u4fe1\u606f")
    @GetMapping(value={"/getById"})
    @OptLog(type=OptType.SELECT, title="\u83b7\u53d6\u5bfc\u51fa\u6a21\u677f\u4fe1\u606f")
    public JsonResult<DesExportTemplate> getById(@ApiParam(value="\u5bfc\u51fa\u6a21\u677fID", required=true) @NotNull(message="\u5bfc\u51fa\u6a21\u677fID\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u5bfc\u51fa\u6a21\u677fID\u4e0d\u80fd\u4e3a\u7a7a") Long id) {
        DesExportTemplate entity = this.desExportTemplateService.getByTemplateId(id);
        return JsonResult.OK().data((Object)entity);
    }

    @ApiOperation(value="\u83b7\u53d6\u9875\u9762\u6a21\u578b")
    @GetMapping(value={"/getByCode"})
    @OptLog(type=OptType.SELECT, title="\u83b7\u53d6\u9875\u9762\u6a21\u578b\u4fe1\u606f")
    public JsonResult<DesExportTemplate> getByCode(@ApiParam(value="\u5bfc\u51fa\u6a21\u677f\u7f16\u7801", required=true) @NotNull(message="\u5bfc\u51fa\u6a21\u677f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u5bfc\u51fa\u6a21\u677f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a") String templateCode) {
        DesExportTemplate entity = this.desExportTemplateService.getByTemplateCode(templateCode);
        return JsonResult.OK().data((Object)entity);
    }

    @ApiOperation(value="\u5206\u9875\u83b7\u53d6\u5bfc\u51fa\u6a21\u677f\u5217\u8868")
    @GetMapping(value={"/page"})
    @OptLog(type=OptType.SELECT, title="\u5206\u9875\u83b7\u53d6\u5bfc\u51fa\u6a21\u677f\u5217\u8868")
    public JsonResult<PageRequest> page(PageRequest pageRequest, @ApiParam(value="\u6a21\u7cca\u641c\u7d22") String searchKey, @ApiParam(value="\u6a21\u578b\u5206\u7ec4id") String modelGroup) {
        List srcList = this.baseDictItemService.list((Wrapper)new QueryWrapper().lambda().eq(BaseDictItem::getDictCode, (Object)"DesModelGroup"));
        List<String> childrenValues = new ArrayList<String>();
        if (StrUtil.isNotEmpty((CharSequence)modelGroup)) {
            BaseDictItem dictItem = (BaseDictItem)this.baseDictItemService.getOne((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(BaseDictItem::getDictCode, (Object)"DesModelGroup")).eq(BaseDictItem::getValue, (Object)modelGroup));
            childrenValues = this.baseDictItemService.getChildrenIds(dictItem.getDictItemId(), true).stream().map(dictItemId -> srcList.stream().filter(item -> item.getDictItemId().equals(dictItemId)).findFirst().get()).map(BaseDictItem::getValue).collect(Collectors.toList());
        }
        return JsonResult.OK().data((Object)this.desExportTemplateService.pageExportTemplate(pageRequest, searchKey, childrenValues));
    }

    @ApiOperation(value="\u83b7\u53d6\u5bfc\u51fa\u6a21\u677f\u5217\u8868")
    @GetMapping(value={"/list"})
    @OptLog(type=OptType.SELECT, title="\u83b7\u53d6\u6a21\u5757\u914d\u7f6e\u5217\u8868")
    public JsonResult list() {
        return JsonResult.OK().data((Object)this.desExportTemplateService.list());
    }

    @ApiOperation(value="\u6839\u636eID\u5220\u9664\u5bfc\u51fa\u6a21\u677f")
    @GetMapping(value={"/deleteById"})
    @OptLog(type=OptType.DELETE, title="\u6839\u636eID\u5220\u9664\u5bfc\u51fa\u6a21\u677f")
    public JsonResult deleteById(@ApiParam(value="\u5bfc\u51fa\u6a21\u677fID", required=true) @NotNull(message="\u5bfc\u51fa\u6a21\u677fID\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u5bfc\u51fa\u6a21\u677fID\u4e0d\u80fd\u4e3a\u7a7a") Long id) {
        this.desExportTemplateService.removeByTemplateId(id);
        return JsonResult.OK();
    }

    @ApiOperation(value="\u5bfc\u51fa\u6a21\u677f\u6570\u636e")
    @RequestMapping(value={"/exportTemplate"})
    public void exportTemplate(@ApiParam(value="\u4e1a\u52a1\u4e3b\u952e", required=true) @NotNull(message="\u4e1a\u52a1\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u4e1a\u52a1\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a") Long primaryKey, @ApiParam(value="\u8868\u5355\u7f16\u7801", required=true) @NotNull(message="\u8868\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u8868\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a") String formCode, HttpServletResponse resp) {
        this.desExportTemplateService.exportTemplate(primaryKey, formCode, resp);
    }

    @ApiOperation(value="\u6279\u91cf\u5bfc\u51fa\u6a21\u677f\u6570\u636e")
    @RequestMapping(value={"/exportTemplateBatch"})
    public void exportTemplateBatch(@ApiParam(value="\u4e1a\u52a1\u4e3b\u952eList", required=true) @NotNull(message="\u4e1a\u52a1\u4e3b\u952eList\u4e0d\u80fd\u4e3a\u7a7a") @RequestBody @NotNull(message="\u4e1a\u52a1\u4e3b\u952eList\u4e0d\u80fd\u4e3a\u7a7a") List<Long> primaryKeyList, @ApiParam(value="\u8868\u5355\u7f16\u7801", required=true) @NotNull(message="\u8868\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u8868\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a") String formCode, @ApiParam(value="\u6587\u4ef6\u540d\u79f0", required=true) @NotNull(message="\u6587\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u6587\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a") String fileName, HttpServletResponse resp) throws IOException {
        this.desExportTemplateService.exportZipByFormCode(primaryKeyList, formCode, fileName, resp);
    }

    @ApiOperation(value="\u901a\u8fc7\u6a21\u677f\u7f16\u7801\u5bfc\u51fa\u6a21\u677f\u6570\u636e")
    @RequestMapping(value={"/exportTemplateByTemplateCode"})
    public void exportTemplateByTemplateCode(@ApiParam(value="\u4e1a\u52a1\u4e3b\u952e", required=true) @NotNull(message="\u4e1a\u52a1\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u4e1a\u52a1\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a") Long primaryKey, @ApiParam(value="\u6a21\u677f\u7f16\u7801", required=true) @NotNull(message="\u6a21\u677f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u6a21\u677f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a") String templateCode, HttpServletResponse resp) {
        this.desExportTemplateService.exportTemplateByTemplateCode(primaryKey, templateCode, resp);
    }

    @ApiOperation(value="\u901a\u8fc7\u6a21\u677f\u7f16\u7801\u6279\u91cf\u5bfc\u51fa\u6a21\u677f\u6570\u636e")
    @RequestMapping(value={"/exportTemplateBatchByTemplateCode"})
    public void exportTemplateBatchByTemplateCode(@ApiParam(value="\u4e1a\u52a1\u4e3b\u952e\u53ca\u6a21\u677f\u7f16\u7801List", required=true) @NotNull(message="\u4e1a\u52a1\u4e3b\u952e\u53ca\u6a21\u677f\u7f16\u7801List\u4e0d\u80fd\u4e3a\u7a7a") @RequestBody @NotNull(message="\u4e1a\u52a1\u4e3b\u952e\u53ca\u6a21\u677f\u7f16\u7801List\u4e0d\u80fd\u4e3a\u7a7a") List<Map<String, Object>> list, @ApiParam(value="\u6587\u4ef6\u540d\u79f0", required=true) @NotNull(message="\u6587\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u6587\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a") String fileName, HttpServletResponse resp) throws IOException {
        this.desExportTemplateService.exportZipByTemplateCode(list, fileName, resp);
    }

    @ApiOperation(value="\u9884\u89c8SQL")
    @RequestMapping(value={"/previewSql"})
    public JsonResult previewSql(String sql) {
        return JsonResult.OK().data(this.desExportTemplateService.previewSql(sql));
    }
}

