/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.iframe.web.design.controller;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.github.yulichang.toolkit.MPJStringUtils;
import com.kdgcsoft.iframe.web.base.entity.BaseDictItem;
import com.kdgcsoft.iframe.web.base.service.BaseDictItemService;
import com.kdgcsoft.iframe.web.common.anno.OptLog;
import com.kdgcsoft.iframe.web.common.embed.dict.OptType;
import com.kdgcsoft.iframe.web.common.pojo.JsonResult;
import com.kdgcsoft.iframe.web.common.pojo.PageRequest;
import com.kdgcsoft.iframe.web.common.utils.CommonDownloadUtil;
import com.kdgcsoft.iframe.web.design.entity.DesDatagridModel;
import com.kdgcsoft.iframe.web.design.entity.DesFormModel;
import com.kdgcsoft.iframe.web.design.enums.DesCodeEnum;
import com.kdgcsoft.iframe.web.design.service.DesDataModelService;
import com.kdgcsoft.iframe.web.design.service.DesDatagridModelService;
import com.kdgcsoft.iframe.web.design.service.DesFormModelService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6570\u636e\u8868\u683c\u6a21\u578b\u63a7\u5236\u5668"})
@RestController
@Validated
@RequestMapping(value={"/des/desDatagridModel"})
public class DesDatagridModelController {
    @Resource
    private DesDatagridModelService desDatagridModelService;
    @Resource
    private DesDataModelService dataModelService;
    @Resource
    private DesFormModelService formModelService;
    @Autowired
    BaseDictItemService baseDictItemService;

    @ApiOperation(value="\u83b7\u53d6\u6570\u636e\u8868\u683c\u6a21\u578b\u5206\u9875")
    @GetMapping(value={"/page"})
    @OptLog(type=OptType.SELECT, title="\u5206\u9875\u83b7\u53d6\u6570\u636e\u8868\u683c\u6a21\u578b")
    public JsonResult<PageRequest> page(PageRequest pageRequest, @ApiParam(value="\u6a21\u7cca\u641c\u7d22") String searchKey, @ApiParam(value="\u6a21\u578b\u5206\u7ec4id") String modelGroup) {
        List srcList = this.baseDictItemService.list((Wrapper)new QueryWrapper().lambda().eq(BaseDictItem::getDictCode, (Object)"DesModelGroup"));
        List<String> childrenValues = new ArrayList<String>();
        if (StrUtil.isNotEmpty((CharSequence)modelGroup)) {
            BaseDictItem dictItem = (BaseDictItem)this.baseDictItemService.getOne((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(BaseDictItem::getDictCode, (Object)"DesModelGroup")).eq(BaseDictItem::getValue, (Object)modelGroup));
            childrenValues = this.baseDictItemService.getChildrenIds(dictItem.getDictItemId(), true).stream().map(dictItemId -> srcList.stream().filter(item -> item.getDictItemId().equals(dictItemId)).findFirst().get()).map(BaseDictItem::getValue).collect(Collectors.toList());
        }
        this.desDatagridModelService.pageDesDatagridModel(pageRequest, searchKey, childrenValues);
        return JsonResult.OK().data((Object)pageRequest);
    }

    @ApiOperation(value="\u83b7\u53d6\u6570\u636e\u8868\u683c\u6a21\u578b\u4fe1\u606f")
    @GetMapping(value={"/getById"})
    @OptLog(type=OptType.SELECT, title="\u83b7\u53d6\u6570\u636e\u8868\u683c\u6a21\u578b\u4fe1\u606f")
    public JsonResult<DesDatagridModel> getById(@ApiParam(value="\u6570\u636e\u8868\u683c\u6a21\u578bdatagridId", required=true) @NotNull(message="\u6570\u636e\u8868\u683c\u6a21\u578bdatagridId\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u6570\u636e\u8868\u683c\u6a21\u578bdatagridId\u4e0d\u80fd\u4e3a\u7a7a") Long datagridId) {
        DesDatagridModel entity = (DesDatagridModel)this.desDatagridModelService.getById(datagridId);
        return JsonResult.OK().data((Object)entity);
    }

    @ApiOperation(value="\u4fdd\u5b58")
    @PostMapping(value={"/save"})
    @OptLog(type=OptType.SAVE, title="\u4fdd\u5b58\u6570\u636e\u8868\u683c\u6a21\u578b\u4fe1\u606f")
    public JsonResult<DesDatagridModel> save(@Validated @RequestBody DesDatagridModel entity) {
        if (this.desDatagridModelService.hasRepeat(entity)) {
            return JsonResult.ERROR((String)"\u6570\u636e\u8868\u683c\u6a21\u578b\u91cd\u590d");
        }
        if (StrUtil.isBlank((CharSequence)entity.getDatagridCode())) {
            entity.setDatagridCode(DesCodeEnum.TABLE.newCode());
        }
        Long formId = entity.getFormId();
        boolean hasFlow = true;
        JSONObject cfg = new JSONObject((Object)entity.getConfigJson());
        String primaryKey = this.dataModelService.getPrimaryKey(entity.getModelId());
        cfg.set("keyField", (Object)MPJStringUtils.underlineToCamel((String)primaryKey));
        if (Objects.nonNull(formId)) {
            DesFormModel formModel = this.formModelService.getByFormId(formId);
            if (Objects.nonNull(formId)) {
                if (StrUtil.isNotBlank((CharSequence)primaryKey)) {
                    cfg.set("formCode", (Object)formModel.getFormCode());
                    cfg.set("buttons", (Object)new JSONArray());
                } else {
                    hasFlow = false;
                }
            }
        } else {
            cfg.set("modelId", (Object)entity.getModelId());
            hasFlow = false;
        }
        if (!hasFlow) {
            cfg.remove((Object)"formCode");
        }
        entity.setConfigJson(cfg.toString());
        this.desDatagridModelService.saveOrUpdate(entity);
        if (!Objects.nonNull(entity.getFormId())) {
            this.desDatagridModelService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(DesDatagridModel::getFormId, null)).eq(DesDatagridModel::getDatagridId, (Object)entity.getDatagridId()));
        }
        return JsonResult.OK((String)"\u4fdd\u5b58\u6210\u529f").data((Object)entity);
    }

    @ApiOperation(value="\u6839\u636edatagridId\u5220\u9664\u6570\u636e\u8868\u683c\u6a21\u578b")
    @GetMapping(value={"/deleteById"})
    @OptLog(type=OptType.DELETE, title="\u6839\u636edatagridId\u5220\u9664\u6570\u636e\u8868\u683c\u6a21\u578b")
    public JsonResult deleteById(@ApiParam(value="\u6570\u636e\u8868\u683c\u6a21\u578bdatagridId", required=true) @NotNull(message="\u6570\u636e\u8868\u683c\u6a21\u578bdatagridId\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u6570\u636e\u8868\u683c\u6a21\u578bdatagridId\u4e0d\u80fd\u4e3a\u7a7a") Long datagridId) {
        this.desDatagridModelService.removeById(datagridId);
        return JsonResult.OK();
    }

    @ApiOperation(value="\u5bfc\u51fa\u8868\u5355\u6a21\u578b")
    @GetMapping(value={"/export"})
    @OptLog(type=OptType.EXPORT, title="\u5bfc\u51fa\u8868\u5355\u6a21\u578b")
    public void export(@ApiParam(value="\u8868\u5355\u6a21\u578bID", required=true) @NotNull(message="\u8868\u5355\u6a21\u578bID\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u8868\u5355\u6a21\u578bID\u4e0d\u80fd\u4e3a\u7a7a") HttpServletResponse response, String ids) {
        List desDatagridModelList = this.desDatagridModelService.list((Wrapper)new QueryWrapper().lambda().in(DesDatagridModel::getDatagridId, (Collection)Arrays.stream(StrUtil.splitToLong((CharSequence)ids, (char)',')).boxed().collect(Collectors.toList())));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date currentDate = new Date();
        String currentDateStr = sdf.format(currentDate);
        for (DesDatagridModel model : desDatagridModelList) {
            if (model == null) continue;
            String json = JSON.toJSONString((Object)model);
            String fileName = "formModel-" + currentDateStr + ".json";
            CommonDownloadUtil.download((String)fileName, (byte[])json.getBytes(), (HttpServletResponse)response);
        }
    }

    @ApiOperation(value="\u5bfc\u5165\u8868\u5355\u6a21\u578b")
    @PostMapping(value={"/import"})
    @OptLog(type=OptType.IMPORT, title="\u5bfc\u5165\u8868\u5355\u6a21\u578b")
    public JsonResult<?> importModel(@RequestBody JSONObject file) {
        String fileText = file.getStr((Object)"fileContent");
        List list = JSON.parseArray((String)fileText, JSONObject.class);
        for (JSONObject object : list) {
            DesDatagridModel datagridModel = (DesDatagridModel)JSON.parseObject((String)object.toString(), DesDatagridModel.class);
            if (!this.desDatagridModelService.hasRepeat(datagridModel)) {
                datagridModel.setDatagridId(null);
                datagridModel.setDatagridCode(DesCodeEnum.TABLE.newCode());
            }
            this.desDatagridModelService.hasRepeat(datagridModel);
        }
        return JsonResult.OK();
    }

    @ApiOperation(value="\u590d\u5236\u8868\u5355\u6a21\u578b")
    @GetMapping(value={"/copy"})
    @OptLog(type=OptType.OTHER, title="\u590d\u5236\u8868\u5355\u6a21\u578b")
    public JsonResult<DesDatagridModel> copyModel(@ApiParam(value="\u8868\u5355\u6a21\u578bID", required=true) @NotNull(message="\u8868\u5355\u6a21\u578bID\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u8868\u5355\u6a21\u578bID\u4e0d\u80fd\u4e3a\u7a7a") Long id) {
        DesDatagridModel datagridModel = (DesDatagridModel)this.desDatagridModelService.getById(id);
        datagridModel.setDatagridId(null);
        datagridModel.setDatagridName(datagridModel.getDatagridName() + "_copy");
        datagridModel.setDatagridCode(DesCodeEnum.TABLE.newCode());
        this.desDatagridModelService.save(datagridModel);
        return JsonResult.OK().data((Object)datagridModel);
    }
}

