/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.iframe.web.design.controller;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.spring.SpringUtil;
import cn.hutool.json.JSONObject;
import com.alibaba.fastjson2.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.kdgcsoft.iframe.web.base.entity.BaseDictItem;
import com.kdgcsoft.iframe.web.base.service.BaseDictItemService;
import com.kdgcsoft.iframe.web.base.service.BaseDictService;
import com.kdgcsoft.iframe.web.common.anno.OptLog;
import com.kdgcsoft.iframe.web.common.consts.YesNo;
import com.kdgcsoft.iframe.web.common.controller.BaseController;
import com.kdgcsoft.iframe.web.common.embed.dict.EmbedTableColumn;
import com.kdgcsoft.iframe.web.common.embed.dict.OptType;
import com.kdgcsoft.iframe.web.common.pojo.JsonResult;
import com.kdgcsoft.iframe.web.common.pojo.PageRequest;
import com.kdgcsoft.iframe.web.common.utils.CommonDownloadUtil;
import com.kdgcsoft.iframe.web.config.trans.EasyTransDicCacheService;
import com.kdgcsoft.iframe.web.config.trans.TransCache;
import com.kdgcsoft.iframe.web.config.trans.event.DataModelTransEvent;
import com.kdgcsoft.iframe.web.design.entity.DesDataModel;
import com.kdgcsoft.iframe.web.design.entity.DesDataModelColumn;
import com.kdgcsoft.iframe.web.design.entity.DesGeneratePage;
import com.kdgcsoft.iframe.web.design.pojo.TableInfo;
import com.kdgcsoft.iframe.web.design.service.DesDataModelService;
import com.kdgcsoft.iframe.web.design.service.DesGeneratePageService;
import com.kdgcsoft.iframe.web.design.trans.DesignTransCacheServiceProvider;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6570\u636e\u6a21\u578b\u7ba1\u7406"})
@RestController
@Validated
@RequestMapping(value={"/des/desDataModel"})
public class DesDataModelController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(DesDataModelController.class);
    @Autowired
    DesDataModelService dataModelService;
    @Autowired
    DesGeneratePageService generatePageService;
    @Autowired
    BaseDictService dictService;
    @Autowired
    BaseDictItemService baseDictItemService;
    @Autowired
    private EasyTransDicCacheService easyTransDicCacheService;

    @ApiOperation(value="\u83b7\u53d6\u6570\u636e\u6a21\u578b\u5386\u53f2\u5217\u8868")
    @GetMapping(value={"/listHis"})
    @OptLog(type=OptType.SELECT, title="\u83b7\u53d6\u6570\u636e\u6a21\u578b\u5386\u53f2\u5217\u8868")
    public JsonResult<PageRequest> listDataModelHis(@ApiParam(value="\u6a21\u578b\u7f16\u7801") Long modelId) {
        return JsonResult.OK().data(this.dataModelService.listDataModelHis(modelId));
    }

    @ApiOperation(value="\u83b7\u53d6\u6570\u636e\u6a21\u578b\u540c\u6b65\u5217\u8868")
    @GetMapping(value={"/listSync"})
    @OptLog(type=OptType.SELECT, title="\u83b7\u53d6\u6570\u636e\u6a21\u578b\u540c\u6b65\u5217\u8868")
    public JsonResult<PageRequest> listDataModelSync(@ApiParam(value="\u6a21\u578b\u7f16\u7801") Long modelId) {
        return JsonResult.OK().data(this.dataModelService.listDataModelSync(modelId));
    }

    @ApiOperation(value="\u4fdd\u5b58\u6570\u636e\u6a21\u578b")
    @PostMapping(value={"/save"})
    @OptLog(type=OptType.SAVE, title="\u4fdd\u5b58\u6570\u636e\u6a21\u578b")
    public JsonResult<?> save(@Validated @RequestBody DesDataModel entity) {
        try {
            if (StrUtil.isBlank((CharSequence)entity.getModelCode()) || null == entity.getModelId()) {
                this.dataModelService.saveEntity(entity);
            } else {
                if (entity.getEmbed() == 1) {
                    return JsonResult.ERROR((String)("\u5185\u90e8\u6a21\u578b\u8868[" + entity.getDbTable() + "]\u4e0d\u5141\u8bb8\u4fee\u6539\uff01"));
                }
                this.dataModelService.updateDesDataModel(entity);
            }
            this.reloadTransCache(entity);
            return JsonResult.OK((String)"\u4fdd\u5b58\u6210\u529f");
        }
        catch (Exception e) {
            return JsonResult.ERROR((String)e.getMessage());
        }
    }

    private void reloadTransCache(DesDataModel entity) {
        TransCache transCache = ((DesignTransCacheServiceProvider)SpringUtil.getBean(DesignTransCacheServiceProvider.class)).buildTransCache(entity);
        SpringUtil.publishEvent((ApplicationEvent)DataModelTransEvent.ofUpdate((String)entity.getModelCode(), (TransCache)transCache));
    }

    @ApiOperation(value="\u83b7\u53d6\u6570\u636e\u6a21\u578b\u4fe1\u606f")
    @GetMapping(value={"/getById"})
    @OptLog(type=OptType.SELECT, title="\u83b7\u53d6\u6570\u636e\u6a21\u578b\u4fe1\u606f")
    public JsonResult<DesDataModel> getById(@ApiParam(value="\u6570\u636e\u6a21\u578bID", required=true) @NotNull(message="\u6570\u636e\u6a21\u578bID\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u6570\u636e\u6a21\u578bID\u4e0d\u80fd\u4e3a\u7a7a") Long id) {
        DesDataModel entity = (DesDataModel)((Object)this.dataModelService.getById(id));
        return JsonResult.OK().data((Object)entity);
    }

    @ApiOperation(value="\u5206\u9875\u83b7\u53d6\u6570\u636e\u6a21\u578b\u5217\u8868")
    @GetMapping(value={"/page"})
    @OptLog(type=OptType.SELECT, title="\u5206\u9875\u83b7\u53d6\u6570\u636e\u6a21\u578b\u5217\u8868")
    public JsonResult<PageRequest> pageDataModel(@ApiParam(value="\u6a21\u7cca\u641c\u7d22") String searchKey, @ApiParam(value="\u6a21\u578b\u5206\u7ec4id") String modelGroup, PageRequest pageRequest) {
        List srcList = this.baseDictItemService.list((Wrapper)new QueryWrapper().lambda().eq(BaseDictItem::getDictCode, (Object)"DesModelGroup"));
        List<String> childrenValues = new ArrayList<String>();
        if (StrUtil.isNotEmpty((CharSequence)modelGroup)) {
            BaseDictItem dictItem = (BaseDictItem)this.baseDictItemService.getOne((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(BaseDictItem::getDictCode, (Object)"DesModelGroup")).eq(BaseDictItem::getValue, (Object)modelGroup));
            childrenValues = this.baseDictItemService.getChildrenIds(dictItem.getDictItemId(), true).stream().map(dictItemId -> srcList.stream().filter(item -> item.getDictItemId().equals(dictItemId)).findFirst().get()).map(BaseDictItem::getValue).collect(Collectors.toList());
        }
        this.dataModelService.pageDataModel(pageRequest, searchKey, childrenValues);
        return JsonResult.OK().data((Object)pageRequest);
    }

    @ApiOperation(value="\u83b7\u53d6\u6570\u636e\u6a21\u578b\u5217\u8868")
    @GetMapping(value={"/list"})
    @OptLog(type=OptType.SELECT, title="\u83b7\u53d6\u6570\u636e\u6a21\u578b\u5217\u8868")
    public JsonResult<List<DesDataModel>> listDataModel(@ApiParam(value="\u6a21\u7cca\u641c\u7d22") String searchKey) {
        List<DesDataModel> list = this.dataModelService.listDataModel(searchKey);
        return JsonResult.OK().data(list);
    }

    @ApiOperation(value="\u6839\u636eID\u5220\u9664\u6570\u636e\u6a21\u578b")
    @GetMapping(value={"/deleteById"})
    @OptLog(type=OptType.DELETE, title="\u6839\u636eID\u5220\u9664\u6570\u636e\u6a21\u578b")
    public JsonResult<?> delDataModelById(@ApiParam(value="\u6a21\u578bID", required=true) @NotNull(message="\u6a21\u578bID\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u6a21\u578bID\u4e0d\u80fd\u4e3a\u7a7a") Long id, @ApiParam(value="\u662f\u5426\u5220\u9664\u6570\u636e\u8868") String removeTable) {
        DesDataModel model = (DesDataModel)((Object)this.dataModelService.getById(id));
        if (null != model) {
            if (model.getEmbed() == 1) {
                return JsonResult.ERROR((String)("\u5185\u7f6e\u6a21\u578b\u8868[" + model.getDbTable() + "]\u4e0d\u5141\u8bb8\u5220\u9664"));
            }
            this.dataModelService.removeById(id);
            if (StrUtil.isNotBlank((CharSequence)removeTable) && YesNo.valueOf((String)removeTable) == 1) {
                this.dataModelService.delete(model);
            }
            SpringUtil.publishEvent((ApplicationEvent)DataModelTransEvent.ofRemove((String)model.getModelCode()));
        }
        return JsonResult.OK();
    }

    @ApiOperation(value="\u6839\u636eID\u6279\u91cf\u5220\u9664\u6570\u636e\u6a21\u578b")
    @GetMapping(value={"/deleteByIds"})
    @OptLog(type=OptType.DELETE, title="\u6839\u636eID\u6279\u91cf\u5220\u9664\u6570\u636e\u6a21\u578b")
    public JsonResult<?> delDataModelByIds(@ApiParam(value="\u6a21\u578bID", required=true) @NotBlank(message="\u6a21\u578bID\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="\u6a21\u578bID\u4e0d\u80fd\u4e3a\u7a7a") String ids, @ApiParam(value="\u662f\u5426\u5220\u9664\u6570\u636e\u8868") String removeTable) {
        boolean dropTable = StrUtil.isNotBlank((CharSequence)removeTable) && YesNo.valueOf((String)removeTable) == 1;
        List list = this.dataModelService.list((Wrapper)new QueryWrapper().lambda().in(DesDataModel::getModelId, (Collection)Arrays.stream(StrUtil.splitToLong((CharSequence)ids, (char)',')).boxed().collect(Collectors.toList())));
        if (CollUtil.isNotEmpty((Collection)list)) {
            List embedModels = list.stream().filter(model -> model.getEmbed() == 1).collect(Collectors.toList());
            if (CollUtil.isNotEmpty(embedModels)) {
                return JsonResult.ERROR((String)("\u5185\u7f6e\u6a21\u578b\u8868[" + embedModels.stream().map(DesDataModel::getDbTable).collect(Collectors.joining(",")) + "]\u4e0d\u5141\u8bb8\u5220\u9664"));
            }
            for (DesDataModel model2 : list) {
                this.dataModelService.removeById((Object)model2);
                if (dropTable) {
                    this.dataModelService.delete(model2);
                }
                this.easyTransDicCacheService.removeGroupTransCache(model2.getModelCode());
            }
        }
        return JsonResult.OK();
    }

    @ApiOperation(value="\u83b7\u53d6\u5185\u7f6e\u5b57\u6bb5")
    @GetMapping(value={"/getEmbedColumns"})
    public JsonResult getEmbedColumns() {
        ArrayList<DesDataModelColumn> list = new ArrayList<DesDataModelColumn>();
        for (EmbedTableColumn col : EmbedTableColumn.values()) {
            DesDataModelColumn column = new DesDataModelColumn();
            column.setEmbed(1);
            column.setColumnName(col.text());
            column.setColumnType(col.getColumnType());
            column.setDbColumn(col.name().toLowerCase());
            column.setColumnCode(StrUtil.toCamelCase((CharSequence)col.name().toLowerCase()));
            list.add(column);
        }
        return JsonResult.OK().data(list);
    }

    @ApiOperation(value="\u6a21\u578b\u540c\u6b65")
    @GetMapping(value={"/sync"})
    public JsonResult<?> sync(@ApiParam(value="\u6a21\u578b\u7f16\u7801", required=true) @NotBlank(message="\u6a21\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="\u6a21\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a") String modelCode) {
        DesDataModel model = this.dataModelService.getByModelCode(modelCode);
        if (null == model) {
            return JsonResult.ERROR((String)("\u6a21\u578b\u7f16\u7801\u4e0d\u5b58\u5728: " + modelCode));
        }
        if (model.getEmbed() == 1) {
            return JsonResult.ERROR((String)"\u5185\u90e8\u6a21\u578b\u8868\u4e0d\u5141\u8bb8\u540c\u6b65\uff01");
        }
        if (model.getSynced() == 1) {
            return JsonResult.ERROR((String)"\u6a21\u578b\u5df2\u7ecf\u540c\u6b65\uff0c\u65e0\u9700\u518d\u6b21\u540c\u6b65");
        }
        try {
            this.dataModelService.sync(model, model1 -> {
                model1.setSynced(1);
                this.dataModelService.updateById((Object)model1);
            });
            return JsonResult.OK((String)"\u540c\u6b65\u6210\u529f");
        }
        catch (Exception e) {
            return JsonResult.ERROR((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u751f\u6210\u4ee3\u7801")
    @PostMapping(value={"/generate"})
    public void generate(@Validated @RequestBody DesGeneratePage desGeneratePage, HttpServletResponse response) throws IOException {
        this.generatePageService.generateZip(desGeneratePage, response);
    }

    @ApiOperation(value="\u901a\u8fc7\u6a21\u578b\u7f16\u7801\u83b7\u53d6\u5f53\u524d\u6570\u636e\u6a21\u578b\u7684\u6240\u6709\u5217\u4fe1\u606f")
    @GetMapping(value={"/getDataModelColumnByModelCode"})
    @OptLog(type=OptType.SELECT, title="\u901a\u8fc7\u6a21\u578b\u7f16\u7801\u83b7\u53d6\u5f53\u524d\u6570\u636e\u6a21\u578b\u7684\u6240\u6709\u5217\u4fe1\u606f")
    public JsonResult getDataModelColumnByModelCode(@ApiParam(value="\u6570\u636e\u6a21\u578b\u7f16\u7801", required=true) @NotNull(message="\u6570\u636e\u6a21\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u6570\u636e\u6a21\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a") String modelCode) {
        List list = this.dataModelService.getByModelCode(modelCode).getColumns().stream().filter(item -> item.getEmbed() == 0).collect(Collectors.toList());
        return JsonResult.OK().data(list);
    }

    @ApiOperation(value="\u901a\u8fc7\u6a21\u578bId\u83b7\u53d6\u5f53\u524d\u6570\u636e\u6a21\u578b\u7684\u6240\u6709\u5217\u4fe1\u606f")
    @GetMapping(value={"/getDataModelColumnByModelId"})
    @OptLog(type=OptType.SELECT, title="\u901a\u8fc7\u6a21\u578bId\u83b7\u53d6\u5f53\u524d\u6570\u636e\u6a21\u578b\u7684\u6240\u6709\u5217\u4fe1\u606f")
    public JsonResult getDataModelColumnByModelId(@ApiParam(value="\u6570\u636e\u6a21\u578b\u7f16\u7801", required=true) @NotNull(message="\u6570\u636e\u6a21\u578bId\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u6570\u636e\u6a21\u578bId\u4e0d\u80fd\u4e3a\u7a7a") Long modelId) {
        List list = ((DesDataModel)((Object)this.dataModelService.getById(modelId))).getColumns().stream().filter(item -> item.getEmbed() == 0).collect(Collectors.toList());
        return JsonResult.OK().data(list);
    }

    @ApiOperation(value="\u901a\u8fc7\u6a21\u578b\u7f16\u7801\u83b7\u53d6\u5f53\u524d\u6a21\u578b\u4e2d\u6d89\u53ca\u7684\u5916\u952e\u7684\u6570\u636e\u6a21\u578b")
    @GetMapping(value={"/getLinkModelByModelCode"})
    @OptLog(type=OptType.SELECT, title="\u901a\u8fc7\u6a21\u578b\u7f16\u7801\u83b7\u53d6\u5f53\u524d\u6a21\u578b\u4e2d\u6d89\u53ca\u7684\u5916\u952e\u7684\u6570\u636e\u6a21\u578b")
    public JsonResult getLinkModelByModelCode(@ApiParam(value="\u6570\u636e\u6a21\u578b\u7f16\u7801", required=true) @NotNull(message="\u6570\u636e\u6a21\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u6570\u636e\u6a21\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a") String modelCode) {
        return JsonResult.OK().data(this.dataModelService.getLinkModelByModelCode(modelCode));
    }

    @ApiOperation(value="\u901a\u8fc7\u6a21\u578b\u7f16\u7801\u83b7\u53d6\u5f53\u524d\u6a21\u578b\u4e2d\u6d89\u53ca\u7684\u6570\u636e\u5b57\u5178\u5217\u8868")
    @GetMapping(value={"/getDictListByModelCode"})
    @OptLog(type=OptType.SELECT, title="\u901a\u8fc7\u6a21\u578b\u7f16\u7801\u83b7\u53d6\u5f53\u524d\u6a21\u578b\u4e2d\u6d89\u53ca\u7684\u6570\u636e\u5b57\u5178\u5217\u8868")
    public JsonResult getDictListByModelCode(@ApiParam(value="\u6570\u636e\u6a21\u578b\u7f16\u7801", required=true) @NotNull(message="\u6570\u636e\u6a21\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u6570\u636e\u6a21\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a") String modelCode) {
        DesDataModel desDataModel = this.dataModelService.getByModelCode(modelCode);
        List dictList = desDataModel.getColumns().stream().filter(item -> item.getColumnType().text().equals("\u5b57\u5178")).map(DesDataModelColumn::getDictCode).collect(Collectors.toList());
        List list = dictList.stream().map(item -> this.dictService.getDictByCode(item)).collect(Collectors.toList());
        return JsonResult.OK().data(list);
    }

    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u5e93\u6240\u6709\u7684\u8868\u548c\u89c6\u56fe")
    @RequestMapping(value={"/listQueryDBTableAndView"})
    @OptLog(type=OptType.SELECT, title="\u67e5\u8be2\u5f53\u524d\u5e93\u6240\u6709\u7684\u8868\u548c\u89c6\u56fe")
    public JsonResult<TableInfo> listQueryDBTableAndView() {
        try {
            List<TableInfo> lists = this.dataModelService.listQueryDBTableAndView();
            return JsonResult.OK((String)"\u67e5\u8be2\u6210\u529f").data(lists);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return JsonResult.ERROR((String)("\u67e5\u8be2\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a" + e.getMessage()));
        }
    }

    @ApiOperation(value="\u5bfc\u5165\u6570\u636e\u6a21\u578b")
    @RequestMapping(value={"/import"})
    @OptLog(type=OptType.SAVE, title="\u5bfc\u5165\u6570\u636e\u6a21\u578b")
    public JsonResult<?> importDataModel(@NotNull(message="\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a") String type, @NotNull(message="\u8868\u540d/\u89c6\u56fe\u540d\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u8868\u540d/\u89c6\u56fe\u540d\u4e0d\u80fd\u4e3a\u7a7a") String name, @NotNull(message="\u6a21\u578b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u6a21\u578b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a") String modelName, @ApiParam(value="\u6a21\u578b\u5206\u7ec4id") String modelGroup) {
        try {
            this.dataModelService.importDataModel(type, name, modelName, modelGroup);
            return JsonResult.OK((String)"\u5bfc\u5165\u6210\u529f");
        }
        catch (Exception e) {
            return JsonResult.ERROR((String)("\u5bfc\u5165\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a" + e.getMessage()));
        }
    }

    @ApiOperation(value="\u5bfc\u51fa\u6570\u636e\u6a21\u578b")
    @RequestMapping(value={"/export"})
    @OptLog(type=OptType.EXPORT, title="\u5bfc\u51fa\u6570\u636e\u6a21\u578b")
    public void export(@ApiParam(value="\u6570\u636e\u6a21\u578bID", required=true) @NotNull(message="\u6570\u636e\u6a21\u578bID\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u6570\u636e\u6a21\u578bID\u4e0d\u80fd\u4e3a\u7a7a") HttpServletResponse response, String ids) {
        List dataModelList = this.dataModelService.list((Wrapper)new QueryWrapper().lambda().in(DesDataModel::getModelId, (Collection)Arrays.stream(StrUtil.splitToLong((CharSequence)ids, (char)',')).boxed().collect(Collectors.toList())));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date currentDate = new Date();
        String currentDateStr = sdf.format(currentDate);
        for (DesDataModel model : dataModelList) {
            if (dataModelList == null) continue;
            String json = JSON.toJSONString((Object)dataModelList);
            String fileName = "dataModel-" + currentDateStr + ".json";
            CommonDownloadUtil.download((String)fileName, (byte[])json.getBytes(), (HttpServletResponse)response);
        }
    }

    @ApiOperation(value="\u4ece\u6587\u4ef6\u5bfc\u5165\u6570\u636e\u6a21\u578b")
    @PostMapping(value={"/importFromFile"})
    @OptLog(type=OptType.IMPORT, title="\u4ece\u6587\u4ef6\u5bfc\u5165\u6570\u636e\u6a21\u578b")
    public JsonResult<?> importFromFile(@RequestBody JSONObject file) {
        String fileText = file.getStr((Object)"fileContent");
        List list = JSON.parseArray((String)fileText, JSONObject.class);
        for (JSONObject object : list) {
            DesDataModel dataModel = (DesDataModel)((Object)JSON.parseObject((String)object.toString(), DesDataModel.class));
            this.dataModelService.saveEntity(dataModel);
        }
        return JsonResult.OK();
    }
}

