/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.iframe.web.design.controller;

import com.kdgcsoft.iframe.web.common.controller.BaseController;
import com.kdgcsoft.iframe.web.common.pojo.JsonResult;
import com.kdgcsoft.iframe.web.design.exp.ExpItem;
import com.kdgcsoft.iframe.web.design.exp.ExpUtil;
import com.kdgcsoft.iframe.web.design.exp.SimpleExpressionParser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.net.URLDecoder;
import java.util.List;
import javax.validation.constraints.NotBlank;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u516c\u5171\u6a21\u5757")
@RestController
@RequestMapping(value={"/des/comm"})
public class DesCommController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(DesCommController.class);

    @ApiOperation(value="\u8868\u8fbe\u5f0f\u89e3\u6790")
    @RequestMapping(value={"/exp/parse"}, method={RequestMethod.GET})
    public JsonResult<?> parseExp(@NotBlank(message="\u8868\u8fbe\u5f0f\u4e0d\u80fd\u4e3a\u7a7a") @RequestParam(value="exp") @NotBlank(message="\u8868\u8fbe\u5f0f\u4e0d\u80fd\u4e3a\u7a7a") String exp) {
        try {
            exp = URLDecoder.decode(exp, "UTF-8");
            List<ExpItem> list = SimpleExpressionParser.parse(exp);
            return JsonResult.OK().data(list);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return JsonResult.ERROR((String)("\u8868\u8fbe\u5f0f\u89e3\u6790\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a" + e.getMessage()));
        }
    }

    @ApiOperation(value="\u8868\u8fbe\u5f0f\u6821\u9a8c")
    @RequestMapping(value={"/exp/validate"}, method={RequestMethod.GET})
    public JsonResult<?> validateExp(@NotBlank(message="\u8868\u8fbe\u5f0f\u4e0d\u80fd\u4e3a\u7a7a") @RequestParam(value="exp") @NotBlank(message="\u8868\u8fbe\u5f0f\u4e0d\u80fd\u4e3a\u7a7a") String exp) {
        try {
            exp = URLDecoder.decode(exp, "UTF-8");
            boolean isLegal = ExpUtil.isLegal(exp);
            return JsonResult.OK().data((Object)isLegal);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return JsonResult.ERROR((String)("\u8868\u8fbe\u5f0f\u6821\u9a8c\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a" + e.getMessage()));
        }
    }
}

