/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.iframe.web.design.controller;

import com.kdgcsoft.iframe.web.common.pojo.JsonResult;
import com.kdgcsoft.iframe.web.common.pojo.PageRequest;
import com.kdgcsoft.iframe.web.design.entity.DesBizSn;
import com.kdgcsoft.iframe.web.design.entity.DesBizSnRecord;
import com.kdgcsoft.iframe.web.design.entity.DesBizSnRef;
import com.kdgcsoft.iframe.web.design.service.DesBizSnRecordService;
import com.kdgcsoft.iframe.web.design.service.DesBizSnRefService;
import com.kdgcsoft.iframe.web.design.service.DesBizSnService;
import java.util.HashMap;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/des/bizSn"})
public class DesBizSnController {
    @Autowired
    private DesBizSnService bizSNService;
    @Autowired
    private DesBizSnRefService refService;
    @Autowired
    private DesBizSnRecordService recordService;

    @GetMapping(value={"queryBizSNList"})
    public JsonResult<List<DesBizSn>> listDic() {
        List lists = this.bizSNService.list();
        return JsonResult.OK().data((Object)lists);
    }

    @PostMapping(value={"/saveBizSN"})
    public JsonResult<?> save(@RequestBody DesBizSn bizSN) {
        try {
            this.bizSNService.saveBizSN(bizSN);
            return JsonResult.OK((String)"\u4fdd\u5b58\u6210\u529f");
        }
        catch (Exception e) {
            return JsonResult.ERROR((String)("\u4fdd\u5b58\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a" + e.getMessage()));
        }
    }

    @RequestMapping(value={"/pageQueryBizSN"})
    public JsonResult<DesBizSn> pageQueryBizSN(PageRequest<DesBizSn> pageRequest, String search) {
        try {
            PageRequest<DesBizSn> data = this.bizSNService.pageQuery(pageRequest, search);
            return JsonResult.OK((String)"\u67e5\u8be2\u6210\u529f").data(data);
        }
        catch (Exception e) {
            return JsonResult.ERROR((String)("\u67e5\u8be2\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a" + e.getMessage()));
        }
    }

    @RequestMapping(value={"/deleteBizSN"})
    public JsonResult<?> deleteBizSn(@NotNull Long bizSNId) {
        try {
            this.bizSNService.removeById(bizSNId);
            return JsonResult.OK((String)"\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            return JsonResult.ERROR((String)("\u5220\u9664\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a" + e.getMessage()));
        }
    }

    @RequestMapping(value={"/generate"})
    public String generateBizSN(String code, String param, String param1, String param2) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("param", param);
        params.put("param1", param1);
        params.put("param2", param2);
        return this.bizSNService.generateBizSN(code, params);
    }

    @RequestMapping(value={"/pageQueryRef"})
    public JsonResult<?> pageQueryBizSnRef(PageRequest<DesBizSnRef> pageRequest, Long bizSnId, String search) {
        try {
            PageRequest<DesBizSnRef> page = this.refService.pageQuery(pageRequest, bizSnId, search);
            return JsonResult.OK((String)"\u67e5\u8be2\u6210\u529f").data(page);
        }
        catch (Exception e) {
            return JsonResult.ERROR((String)("\u67e5\u8be2\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a" + e.getMessage()));
        }
    }

    @RequestMapping(value={"/pageQueryRecord"})
    public JsonResult<?> pageQueryBizSnRecord(PageRequest<DesBizSnRecord> pageRequest, Long bizSnId, String search) {
        try {
            PageRequest<DesBizSnRecord> page = this.recordService.pageQuery(pageRequest, bizSnId, search);
            return JsonResult.OK((String)"\u67e5\u8be2\u6210\u529f").data(page);
        }
        catch (Exception e) {
            return JsonResult.ERROR((String)("\u67e5\u8be2\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a" + e.getMessage()));
        }
    }

    @RequestMapping(value={"/reset"})
    public JsonResult<?> resetBizSN(@NotNull Long bizSnRefId) {
        try {
            this.bizSNService.resetBizSN(bizSnRefId);
            return JsonResult.OK((String)"\u91cd\u7f6e\u6210\u529f");
        }
        catch (Exception e) {
            return JsonResult.ERROR((String)("\u91cd\u7f6e\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a" + e.getMessage()));
        }
    }
}

