/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.iframe.web.design.config.magic;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.fhs.core.trans.vo.TransPojo;
import com.fhs.core.trans.vo.VO;
import com.fhs.trans.service.impl.DictionaryTransService;
import com.kdgcsoft.iframe.web.common.interfaces.IWfStatusTransApi;
import com.kdgcsoft.iframe.web.config.trans.EasyTransDicCacheService;
import com.kdgcsoft.iframe.web.design.trans.DynamicTransPojoClassGenerator;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.ssssssss.magicapi.core.interceptor.RequestInterceptor;
import org.ssssssss.magicapi.core.model.ApiInfo;
import org.ssssssss.magicapi.core.servlet.MagicHttpServletRequest;
import org.ssssssss.magicapi.core.servlet.MagicHttpServletResponse;
import org.ssssssss.magicapi.modules.db.SQLModule;
import org.ssssssss.script.MagicScriptContext;

@Component
public class MagicApiRequestInterceptor
implements RequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger(MagicApiRequestInterceptor.class);
    @Autowired
    private DictionaryTransService dictionaryTransService;
    @Autowired
    private EasyTransDicCacheService easyTransDicCacheService;
    @Autowired
    private IWfStatusTransApi wfStatusTransApi;

    public Object preHandle(ApiInfo info, MagicScriptContext context, MagicHttpServletRequest request, MagicHttpServletResponse response) throws Exception {
        return null;
    }

    public Object postHandle(ApiInfo info, MagicScriptContext context, Object value, MagicHttpServletRequest request, MagicHttpServletResponse response) throws Exception {
        Map vars = context.getRootVariables();
        Object returnVal = value;
        if (CollUtil.isNotEmpty((Map)vars) && vars.containsKey("db") && vars.get("db") instanceof SQLModule) {
            SQLModule sqlModule = (SQLModule)vars.get("db");
            this.transDict(sqlModule, value);
            returnVal = this.transFlowStatus(sqlModule, value);
        }
        return returnVal;
    }

    private Object transFlowStatus(SQLModule sqlModule, Object value) {
        if (StrUtil.isNotBlank((CharSequence)sqlModule.getTransFlowStatusField())) {
            return this.wfStatusTransApi.trans(sqlModule.getTransFlowStatusField(), value);
        }
        return value;
    }

    private void transDict(SQLModule sqlModule, Object value) throws Exception {
        Map<String, String> transMap = sqlModule.getTransMap();
        Map<String, String> transNameMap = sqlModule.getTransNameMap();
        if (CollUtil.isNotEmpty(transMap)) {
            HashMap page;
            List rs = null;
            if (value instanceof HashMap && (page = (HashMap)value).containsKey("rows")) {
                rs = (List)page.get("rows");
            }
            if (value instanceof List) {
                rs = (List)value;
            }
            if (CollUtil.isNotEmpty(rs)) {
                this.completeDictCodeIfNeed(transMap);
                DynamicTransPojoClassGenerator generator = new DynamicTransPojoClassGenerator(transMap, transNameMap);
                generator.generate();
                List<Field> fields = generator.getAnnoFields();
                for (Map row : rs) {
                    TransPojo transPojo = generator.instance(row);
                    this.dictionaryTransService.transOne((VO)transPojo, fields);
                    Map transResult = transPojo.getTransMap();
                    if (!CollUtil.isNotEmpty((Map)transResult)) continue;
                    row.putAll(transResult);
                }
            }
        }
    }

    private void completeDictCodeIfNeed(Map<String, String> transMap) {
        for (String key : transMap.keySet()) {
            String dictCode = transMap.get(key);
            if (!this.easyTransDicCacheService.isTableCache(dictCode)) continue;
            transMap.put(key, "GROUP::" + dictCode);
        }
    }
}

