/*
 * Decompiled with CFR 0.152.
 */
package com.kdgc.framework.web.service.admin.impl;

import com.kdgc.framework.dao.support.Filter;
import com.kdgc.framework.dao.support.Order;
import com.kdgc.framework.dao.support.StatusEnum;
import com.kdgc.framework.service.jpa.impl.BaseServiceImpl;
import com.kdgc.framework.web.dao.admin.IFwStationDao;
import com.kdgc.framework.web.entity.admin.FwStation;
import com.kdgc.framework.web.service.admin.IFwStationService;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service(value="FwStationServiceImpl")
public class FwStationServiceImpl
extends BaseServiceImpl<FwStation, Long>
implements IFwStationService {
    @Resource(name="FwStationDaoImpl")
    private IFwStationDao fwStationDao;

    @Resource(name="FwStationDaoImpl")
    public void setBaseDao(IFwStationDao fwStationDao) {
        super.setBaseDao(fwStationDao);
    }

    @Override
    @Transactional(readOnly=true)
    public List<FwStation> findStationList(Long orgId) {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        if (orgId != null) {
            filters.add(Filter.eq("orgId", orgId));
        }
        filters.add(Filter.eq("status", (Object)StatusEnum.Y));
        ArrayList<Order> orders = new ArrayList<Order>();
        orders.add(Order.asc("orgId"));
        orders.add(Order.asc("orderNo"));
        return this.fwStationDao.findList(null, null, filters, orders);
    }

    @Override
    public void deleteStation(List<Long> ids) {
        this.fwStationDao.deleteStation(ids);
    }

    @Override
    @Transactional(readOnly=true)
    public List<FwStation> findChildStations(Long parentId, String orgName) {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        ArrayList<Order> orders = new ArrayList<Order>();
        filters.add(Filter.eq("pId", parentId));
        filters.add(Filter.eq("status", (Object)StatusEnum.Y));
        if (StringUtils.isNotBlank((String)orgName)) {
            filters.add(Filter.like("orgName", "%" + orgName + "%"));
        }
        orders.add(Order.asc("orderNo"));
        List<FwStation> fwStations = super.findList(null, filters, orders);
        return fwStations;
    }
}

