/*
 * Decompiled with CFR 0.152.
 */
package com.kdgc.framework.web.service.admin.impl;

import com.kdgc.framework.dao.support.Filter;
import com.kdgc.framework.dao.support.Order;
import com.kdgc.framework.service.jpa.impl.BaseServiceImpl;
import com.kdgc.framework.web.dao.admin.IFwPendingMessageDao;
import com.kdgc.framework.web.entity.admin.FwPendingDetails;
import com.kdgc.framework.web.entity.admin.FwPendingMessage;
import com.kdgc.framework.web.service.admin.IFwPendingMessageService;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service(value="FwPendingMessageServiceImpl")
public class FwPendingMessageServiceImpl
extends BaseServiceImpl<FwPendingMessage, Long>
implements IFwPendingMessageService {
    @Resource(name="FwPendingMessageDaoImpl")
    private IFwPendingMessageDao fwPendingMessageDao;

    @Resource(name="FwPendingMessageDaoImpl")
    public void setBaseDao(IFwPendingMessageDao fwPendingMessageDao) {
        super.setBaseDao(fwPendingMessageDao);
    }

    @Override
    public void updateMsgStatus(Long processInstId, Long userId, boolean isColse) {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        ArrayList<Order> orderList = new ArrayList<Order>();
        Order order = new Order("createDate", Order.Direction.desc);
        orderList.add(order);
        filters.add(new Filter("processInstId", Filter.Operator.eq, processInstId));
        List fwPendingMessages = this.fwPendingMessageDao.findList(null, null, filters, orderList);
        if (fwPendingMessages != null && fwPendingMessages.size() > 0) {
            FwPendingMessage fwPendingMessage = (FwPendingMessage)fwPendingMessages.get(0);
            boolean isAllDeal = true;
            for (FwPendingDetails fwPendingDetail : fwPendingMessage.getFwPendingDetails()) {
                if (userId.equals(fwPendingDetail.getReceiverId()) && !fwPendingDetail.getIsDeal()) {
                    fwPendingDetail.setIsDeal(true);
                    fwPendingDetail.setRead(true);
                    fwPendingDetail.setReadTime(new Date());
                    continue;
                }
                isAllDeal = isAllDeal && fwPendingDetail.getIsDeal();
            }
            if (isAllDeal || isColse) {
                fwPendingMessage.setIsdeal(true);
            }
            super.update(fwPendingMessage);
        }
    }

    @Override
    @Transactional(readOnly=true)
    public List<FwPendingMessage> queryUserPendingMsg(Long userId) {
        return this.fwPendingMessageDao.queryUserPendingMsg(userId);
    }

    @Override
    @Transactional(readOnly=true)
    public List<FwPendingMessage> findFwMessageByBusiness(Long business) {
        return this.fwPendingMessageDao.findFwMessageByBusiness(business);
    }

    @Override
    public void updateQueryFwMessageByBusiness(Long msgId, Long userId) {
        FwPendingMessage fwPendingMessage = (FwPendingMessage)this.fwPendingMessageDao.find(msgId);
        if (fwPendingMessage != null) {
            for (FwPendingDetails fwPendingDetail : fwPendingMessage.getFwPendingDetails()) {
                if (!userId.equals(fwPendingDetail.getReceiverId())) continue;
                if (FwPendingMessage.MessageType.message.equals((Object)fwPendingMessage.getBusiType())) {
                    fwPendingDetail.setIsDeal(true);
                    fwPendingDetail.setRead(true);
                } else {
                    fwPendingDetail.setRead(true);
                }
                fwPendingDetail.setReadTime(new Date());
            }
            if (FwPendingMessage.MessageType.message.equals((Object)fwPendingMessage.getBusiType())) {
                fwPendingMessage.setIsdeal(true);
            }
            super.update(fwPendingMessage);
        }
    }

    @Override
    public void updateMsgStatus(Long business, Long processInstId, Long recieveId, boolean isColse) {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        ArrayList<Order> orderList = new ArrayList<Order>();
        Order order = new Order("createDate", Order.Direction.desc);
        orderList.add(order);
        filters.add(new Filter("businessId", Filter.Operator.eq, business));
        filters.add(new Filter("processInstId", Filter.Operator.eq, processInstId));
        filters.add(new Filter("busiType", Filter.Operator.eq, (Object)FwPendingMessage.MessageType.pending));
        filters.add(new Filter("isdeal", Filter.Operator.eq, false));
        List fwPendingMessages = this.fwPendingMessageDao.findList(null, null, filters, orderList);
        if (fwPendingMessages != null && fwPendingMessages.size() > 0) {
            FwPendingMessage fwPendingMessage = (FwPendingMessage)fwPendingMessages.get(0);
            boolean isAllDeal = true;
            for (FwPendingDetails fwPendingDetail : fwPendingMessage.getFwPendingDetails()) {
                if (recieveId.equals(fwPendingDetail.getReceiverId()) && !fwPendingDetail.getIsDeal()) {
                    fwPendingDetail.setIsDeal(true);
                    fwPendingDetail.setRead(true);
                    fwPendingDetail.setReadTime(new Date());
                    continue;
                }
                isAllDeal = isAllDeal && fwPendingDetail.getIsDeal();
            }
            if (isAllDeal || isColse) {
                fwPendingMessage.setIsdeal(true);
            }
            super.update(fwPendingMessage);
        }
    }

    @Override
    @Transactional(readOnly=true)
    public List<FwPendingMessage> queryUserAlreadyPendingMsg(Long id) throws ParseException {
        return this.fwPendingMessageDao.queryUserAlreadyPendingMsg(id);
    }
}

